/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.selectors;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.command.checkout.ModuleListInformation;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.BinaryMessageEvent;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileAddedEvent;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.event.FileRemovedEvent;
import org.netbeans.lib.cvsclient.event.FileToRemoveEvent;
import org.netbeans.lib.cvsclient.event.FileUpdatedEvent;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.AliasesNode;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.BranchSelector;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.Kit;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.NodeOperation2;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.RepositoryPathNode;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.VirtualAdminHandler;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;

public final class ModuleSelector {
    private static final String MAGIC_START = ": New directory `";
    private static final String MAGIC_END = "' -- ignored";

    public Set selectModules(CVSRoot root) {
        Children.Array kids = new Children.Array();
        Client.Factory clientFactory = Kit.createClientFactory(root);
        AliasesNode aliasesNode = AliasesNode.create(clientFactory, root);
        RepositoryPathNode pathsNode = RepositoryPathNode.create(clientFactory, root, "");
        kids.add(new Node[]{aliasesNode, pathsNode});
        AbstractNode rootNode = new AbstractNode((Children)kids);
        try {
            NodeOperation2 op = new NodeOperation2();
            op.setRootVisible(false);
            op.setHelpCtx(new HelpCtx(ModuleSelector.class));
            Node[] selected = op.select(NbBundle.getMessage(ModuleSelector.class, (String)"BK2019"), NbBundle.getMessage(ModuleSelector.class, (String)"BK2020"), NbBundle.getMessage(BranchSelector.class, (String)"ACSD_ModuleSelect"), (Node)rootNode, NbBundle.getMessage(BranchSelector.class, (String)"ACSN_ModulesTree"), NbBundle.getMessage(BranchSelector.class, (String)"ACSD_ModulesTree"), new NodeAcceptor(){

                public boolean acceptNodes(Node[] nodes) {
                    boolean ret = nodes.length > 0;
                    for (int i = 0; i < nodes.length; ++i) {
                        Node node = nodes[i];
                        String path = (String)node.getLookup().lookup(String.class);
                        ret &= path != null;
                    }
                    return ret;
                }
            });
            LinkedHashSet<String> modules = new LinkedHashSet<String>();
            for (int i = 0; i < selected.length; ++i) {
                Node node = selected[i];
                String path = (String)node.getLookup().lookup(String.class);
                modules.add(path);
            }
            return modules;
        }
        catch (UserCancelException e) {
            return Collections.EMPTY_SET;
        }
    }

    public String selectRepositoryPath(CVSRoot root) {
        Client.Factory clientFactory = Kit.createClientFactory(root);
        RepositoryPathNode pathsNode = RepositoryPathNode.create(clientFactory, root, "");
        try {
            Node[] selected = NodeOperation.getDefault().select(NbBundle.getMessage(ModuleSelector.class, (String)"BK2021"), NbBundle.getMessage(ModuleSelector.class, (String)"BK2022"), (Node)pathsNode, new NodeAcceptor(){

                public boolean acceptNodes(Node[] nodes) {
                    if (nodes.length == 1) {
                        String path = (String)nodes[0].getLookup().lookup(String.class);
                        return path != null;
                    }
                    return false;
                }
            });
            String path = null;
            if (selected.length == 1) {
                path = (String)selected[0].getLookup().lookup(String.class);
            }
            return path;
        }
        catch (UserCancelException e) {
            return null;
        }
    }

    public static List listRepositoryPath(Client client, CVSRoot root, String path) throws CommandException, AuthenticationException {
        final ArrayList list = new ArrayList();
        GlobalOptions gtx = CvsVersioningSystem.createGlobalOptions();
        gtx.setCVSRoot(root.toString());
        gtx.setDoNoChanges(true);
        UpdateCommand blindUpdate = new UpdateCommand();
        blindUpdate.setBuildDirectories(true);
        VirtualAdminHandler localEnv = new VirtualAdminHandler(root, path);
        client.setAdminHandler((AdminHandler)localEnv);
        String tmpDir = System.getProperty("java.io.tmpdir");
        File tmp = new File(tmpDir);
        tmp = FileUtil.normalizeFile((File)tmp);
        client.setLocalPath(tmp.getAbsolutePath());
        EventManager mgr = client.getEventManager();
        mgr.addCVSListener(new CVSListener(){

            public void messageSent(MessageEvent e) {
                int start;
                String message;
                if (e.isError() && (message = e.getMessage()).endsWith(ModuleSelector.MAGIC_END) && (start = message.indexOf(ModuleSelector.MAGIC_START)) != -1) {
                    int pathStart = start + ModuleSelector.MAGIC_START.length();
                    int pathEnd = message.length() - ModuleSelector.MAGIC_END.length();
                    String path = message.substring(pathStart, pathEnd);
                    list.add(path);
                }
            }

            public void messageSent(BinaryMessageEvent e) {
            }

            public void fileAdded(FileAddedEvent e) {
            }

            public void fileToRemove(FileToRemoveEvent e) {
            }

            public void fileRemoved(FileRemovedEvent e) {
            }

            public void fileUpdated(FileUpdatedEvent e) {
            }

            public void fileInfoGenerated(FileInfoEvent e) {
            }

            public void commandTerminated(TerminationEvent e) {
            }

            public void moduleExpanded(ModuleExpansionEvent e) {
            }
        });
        client.executeCommand((Command)blindUpdate, gtx);
        return list;
    }

    public static List listAliases(Client client, CVSRoot root) throws CommandException, AuthenticationException {
        CheckoutCommand checkout = new CheckoutCommand();
        checkout.setShowModules(true);
        final LinkedList modules = new LinkedList();
        EventManager mgr = client.getEventManager();
        mgr.addCVSListener(new CVSListener(){

            public void messageSent(MessageEvent e) {
            }

            public void messageSent(BinaryMessageEvent e) {
            }

            public void fileAdded(FileAddedEvent e) {
            }

            public void fileToRemove(FileToRemoveEvent e) {
            }

            public void fileRemoved(FileRemovedEvent e) {
            }

            public void fileUpdated(FileUpdatedEvent e) {
            }

            public void fileInfoGenerated(FileInfoEvent e) {
                ModuleListInformation moduleList = (ModuleListInformation)e.getInfoContainer();
                modules.add(moduleList);
            }

            public void commandTerminated(TerminationEvent e) {
            }

            public void moduleExpanded(ModuleExpansionEvent e) {
            }
        });
        GlobalOptions gtx = CvsVersioningSystem.createGlobalOptions();
        gtx.setCVSRoot(root.toString());
        client.executeCommand((Command)checkout, gtx);
        return modules;
    }
}

