/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.util;

import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.commit.CommitCommand;
import org.netbeans.lib.cvsclient.command.log.RlogCommand;
import org.netbeans.lib.cvsclient.command.remove.RemoveCommand;
import org.netbeans.lib.cvsclient.command.tag.RtagCommand;
import org.netbeans.lib.cvsclient.command.tag.TagCommand;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;

public abstract class CommandDuplicator {
    public static CommandDuplicator getDuplicator(Command src) {
        if (src instanceof CommitCommand) {
            return new CommitCloner((CommitCommand)src);
        }
        if (src instanceof UpdateCommand) {
            return new UpdateCloner((UpdateCommand)src);
        }
        if (src instanceof RemoveCommand) {
            return new RemoveCloner((RemoveCommand)src);
        }
        if (src instanceof RtagCommand) {
            return new RtagCloner((RtagCommand)src);
        }
        if (src instanceof RlogCommand) {
            return new RlogCloner((RlogCommand)src);
        }
        if (src instanceof TagCommand) {
            return new TagCloner((TagCommand)src);
        }
        throw new IllegalArgumentException("Clone not supported for command type: " + src.getClass().getName());
    }

    public abstract Command duplicate();

    private static class CommitCloner
    extends CommandDuplicator {
        private final CommitCommand sample;

        public CommitCloner(CommitCommand sample) {
            this.sample = sample;
        }

        public Command duplicate() {
            CommitCommand c = new CommitCommand();
            c.setForceCommit(this.sample.isForceCommit());
            c.setLogMessageFromFile(this.sample.getLogMessageFromFile());
            c.setMessage(this.sample.getMessage());
            c.setNoModuleProgram(this.sample.isNoModuleProgram());
            c.setRecursive(this.sample.isRecursive());
            c.setToRevisionOrBranch(this.sample.getToRevisionOrBranch());
            return c;
        }
    }

    private static class RemoveCloner
    extends CommandDuplicator {
        private final RemoveCommand sample;

        public RemoveCloner(RemoveCommand sample) {
            this.sample = sample;
        }

        public Command duplicate() {
            RemoveCommand c = new RemoveCommand();
            c.setDeleteBeforeRemove(this.sample.isDeleteBeforeRemove());
            c.setIgnoreLocallyExistingFiles(this.sample.isIgnoreLocallyExistingFiles());
            c.setRecursive(this.sample.isRecursive());
            return c;
        }
    }

    private static class RlogCloner
    extends CommandDuplicator {
        private final RlogCommand sample;

        public RlogCloner(RlogCommand sample) {
            this.sample = sample;
        }

        public Command duplicate() {
            RlogCommand c = new RlogCommand();
            c.setDateFilter(this.sample.getDateFilter());
            c.setDefaultBranch(this.sample.isDefaultBranch());
            c.setHeaderAndDescOnly(this.sample.isHeaderAndDescOnly());
            c.setHeaderOnly(this.sample.isHeaderOnly());
            c.setNoTags(this.sample.isNoTags());
            c.setRevisionFilter(this.sample.getRevisionFilter());
            c.setStateFilter(this.sample.getStateFilter());
            c.setSuppressHeader(this.sample.isSuppressHeader());
            c.setUserFilter(this.sample.getUserFilter());
            c.setModules(this.sample.getModules());
            c.setRecursive(this.sample.isRecursive());
            return c;
        }
    }

    private static class RtagCloner
    extends CommandDuplicator {
        private final RtagCommand sample;

        public RtagCloner(RtagCommand sample) {
            this.sample = sample;
        }

        public Command duplicate() {
            RtagCommand c = new RtagCommand();
            c.setClearFromRemoved(this.sample.isClearFromRemoved());
            c.setDeleteTag(this.sample.isDeleteTag());
            c.setMakeBranchTag(this.sample.isMakeBranchTag());
            c.setMatchHeadIfRevisionNotFound(this.sample.isMatchHeadIfRevisionNotFound());
            c.setModules(this.sample.getModules());
            c.setNoExecTagProgram(this.sample.isNoExecTagProgram());
            c.setOverrideExistingTag(this.sample.isOverrideExistingTag());
            c.setTag(this.sample.getTag());
            c.setTagByDate(this.sample.getTagByDate());
            c.setTagByRevision(this.sample.getTagByRevision());
            c.setRecursive(this.sample.isRecursive());
            return c;
        }
    }

    private static class TagCloner
    extends CommandDuplicator {
        private final TagCommand sample;

        public TagCloner(TagCommand sample) {
            this.sample = sample;
        }

        public Command duplicate() {
            TagCommand c = new TagCommand();
            c.setDeleteTag(this.sample.isDeleteTag());
            c.setMakeBranchTag(this.sample.isMakeBranchTag());
            c.setMatchHeadIfRevisionNotFound(this.sample.isMatchHeadIfRevisionNotFound());
            c.setOverrideExistingTag(this.sample.isOverrideExistingTag());
            c.setTag(this.sample.getTag());
            c.setTagByDate(this.sample.getTagByDate());
            c.setTagByRevision(this.sample.getTagByRevision());
            c.setRecursive(this.sample.isRecursive());
            c.setCheckThatUnmodified(this.sample.isCheckThatUnmodified());
            return c;
        }
    }

    private static class UpdateCloner
    extends CommandDuplicator {
        private final UpdateCommand sample;

        public UpdateCloner(UpdateCommand sample) {
            this.sample = sample;
        }

        public Command duplicate() {
            UpdateCommand c = new UpdateCommand();
            c.setBuildDirectories(this.sample.isBuildDirectories());
            c.setCleanCopy(this.sample.isCleanCopy());
            c.setKeywordSubst(this.sample.getKeywordSubst());
            c.setMergeRevision1(this.sample.getMergeRevision1());
            c.setMergeRevision2(this.sample.getMergeRevision2());
            c.setPipeToOutput(this.sample.isPipeToOutput());
            c.setPruneDirectories(this.sample.isPruneDirectories());
            c.setResetStickyOnes(this.sample.isResetStickyOnes());
            c.setUpdateByDate(this.sample.getUpdateByDate());
            c.setUpdateByRevision(this.sample.getUpdateByRevision());
            c.setUseHeadIfNotFound(this.sample.isUseHeadIfNotFound());
            c.setRecursive(this.sample.isRecursive());
            return c;
        }
    }
}

