/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.queries;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.queries.VisibilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VisibilityQuery {
    private static final VisibilityQuery INSTANCE = new VisibilityQuery();
    private final ResultListener resultListener = new ResultListener();
    private final VqiChangedListener vqiListener = new VqiChangedListener();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private Lookup.Result<VisibilityQueryImplementation> vqiResult = null;
    private Set<VisibilityQueryImplementation> cachedVqiInstances = null;

    public static final VisibilityQuery getDefault() {
        return INSTANCE;
    }

    private VisibilityQuery() {
    }

    public boolean isVisible(FileObject file) {
        VisibilityQueryImplementation vqi;
        boolean retVal = true;
        Iterator<VisibilityQueryImplementation> i$ = this.getVqiInstances().iterator();
        while (i$.hasNext() && (retVal = (vqi = i$.next()).isVisible(file))) {
        }
        return retVal;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    private synchronized Set<VisibilityQueryImplementation> getVqiInstances() {
        if (this.cachedVqiInstances == null) {
            this.vqiResult = Lookup.getDefault().lookupResult(VisibilityQueryImplementation.class);
            this.vqiResult.addLookupListener((LookupListener)this.resultListener);
            this.setupChangeListeners(this.cachedVqiInstances, new LinkedHashSet<VisibilityQueryImplementation>(this.vqiResult.allInstances()));
        }
        return this.cachedVqiInstances;
    }

    private synchronized void setupChangeListeners(Set<VisibilityQueryImplementation> oldVqiInstances, Set<VisibilityQueryImplementation> newVqiInstances) {
        if (oldVqiInstances != null) {
            HashSet<VisibilityQueryImplementation> removed = new HashSet<VisibilityQueryImplementation>(oldVqiInstances);
            removed.removeAll(newVqiInstances);
            for (VisibilityQueryImplementation vqi : removed) {
                vqi.removeChangeListener(this.vqiListener);
            }
        }
        HashSet<VisibilityQueryImplementation> added = new HashSet<VisibilityQueryImplementation>(newVqiInstances);
        if (oldVqiInstances != null) {
            added.removeAll(oldVqiInstances);
        }
        for (VisibilityQueryImplementation vqi : added) {
            vqi.addChangeListener(this.vqiListener);
        }
        this.cachedVqiInstances = newVqiInstances;
    }

    private class ResultListener
    implements LookupListener {
        private ResultListener() {
        }

        public void resultChanged(LookupEvent ev) {
            VisibilityQuery.this.setupChangeListeners(VisibilityQuery.this.cachedVqiInstances, new LinkedHashSet(VisibilityQuery.this.vqiResult.allInstances()));
            VisibilityQuery.this.changeSupport.fireChange();
        }
    }

    private class VqiChangedListener
    implements ChangeListener {
        private VqiChangedListener() {
        }

        public void stateChanged(ChangeEvent e) {
            VisibilityQuery.this.changeSupport.fireChange();
        }
    }
}

