/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.queries;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.spi.queries.CollocationQueryImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlwaysRelativeCollocationQuery
implements CollocationQueryImplementation {
    private File[] roots;

    @Override
    public File findRoot(File file) {
        File[] roots = this.getFileSystemRoots();
        if (roots.length == 0) {
            assert (false) : "Cannot find filesystem roots";
            return null;
        }
        if (roots.length == 1) {
            return roots[0];
        }
        HashSet<File> rootsSet = new HashSet<File>(Arrays.asList(this.roots != null ? this.roots : roots));
        return this.getRoot(file, rootsSet);
    }

    @Override
    public boolean areCollocated(File file1, File file2) {
        File root1 = this.findRoot(file1);
        File root2 = this.findRoot(file2);
        return root1 != null && root1.equals(root2);
    }

    private File[] getFileSystemRoots() {
        if (this.roots != null) {
            return this.roots;
        }
        return File.listRoots();
    }

    private File getRoot(File f, Set<File> roots) {
        while (f != null && !roots.contains(f)) {
            f = f.getParentFile();
        }
        return f;
    }

    final void setFileSystemRoots(File[] roots) {
        this.roots = roots;
    }
}

