/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.BadLocationException;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImplementAllAbstractMethodsCreator
implements ErrorRule<Void> {
    @Override
    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.abstract.cant.be.instantiated", "compiler.err.does.not.override.abstract", "compiler.err.abstract.cant.be.instantiated"));
    }

    @Override
    public List<Fix> run(final CompilationInfo info, String diagnosticKey, final int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        final ArrayList<Fix> result = new ArrayList<Fix>();
        ImplementAllAbstractMethodsCreator.analyze(info.getJavaSource(), offset, info, new Performer(){

            public void fixAllAbstractMethods(TreePath pathToModify, Tree toModify) {
                result.add(new FixImpl(info.getJavaSource(), offset, null));
            }

            public void makeClassAbstract(Tree toModify, String className) {
                result.add(new FixImpl(info.getJavaSource(), offset, className));
            }
        });
        return result;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return ImplementAllAbstractMethodsCreator.class.getName();
    }

    @Override
    public String getDisplayName() {
        return "Implement All Abstract Methods Fix";
    }

    @Override
    public String getDescription() {
        return "Implement All Abstract Methods Fix";
    }

    private static void analyze(JavaSource js, int offset, CompilationInfo info, Performer performer) {
        boolean isUsableElement;
        final TreePath path = info.getTreeUtilities().pathFor(offset + 1);
        Element e = info.getTrees().getElement(path);
        boolean bl = isUsableElement = e != null && (e.getKind().isClass() || e.getKind().isInterface());
        if (isUsableElement) {
            for (ExecutableElement ee : ElementFilter.methodsIn(e.getEnclosedElements())) {
                if (!ee.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                performer.makeClassAbstract(path.getLeaf(), e.getSimpleName().toString());
                return;
            }
            performer.fixAllAbstractMethods(path, path.getLeaf());
        } else if (path.getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
            final boolean[] parentError = new boolean[]{false};
            new TreePathScanner(){

                public Object visitNewClass(NewClassTree nct, Object o) {
                    if (path.getLeaf() == nct) {
                        parentError[0] = this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.ERRONEOUS;
                    }
                    return super.visitNewClass(nct, o);
                }
            }.scan(path.getParentPath(), null);
            if (!parentError[0]) {
                performer.fixAllAbstractMethods(path, path.getLeaf());
            }
        }
    }

    private static final class FixImpl
    implements Fix {
        private JavaSource js;
        private int offset;
        private String makeClassAbstractName;

        public FixImpl(JavaSource js, int offset, String makeClassAbstractName) {
            this.js = js;
            this.offset = offset;
            this.makeClassAbstractName = makeClassAbstractName;
        }

        public String getText() {
            return this.makeClassAbstractName == null ? "Implement all abstract methods" : "Make class " + this.makeClassAbstractName + " abstract";
        }

        public ChangeInfo implement() {
            try {
                final boolean[] repeat = new boolean[]{true};
                while (repeat[0]) {
                    repeat[0] = false;
                    this.js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                        public void cancel() {
                        }

                        public void run(final WorkingCopy copy) throws IOException {
                            copy.toPhase(JavaSource.Phase.RESOLVED);
                            ImplementAllAbstractMethodsCreator.analyze(FixImpl.this.js, FixImpl.this.offset, (CompilationInfo)copy, new Performer(){

                                public void fixAllAbstractMethods(TreePath pathToModify, Tree toModify) {
                                    if (toModify.getKind() == Tree.Kind.NEW_CLASS) {
                                        int insertOffset = (int)copy.getTrees().getSourcePositions().getEndPosition(copy.getCompilationUnit(), toModify);
                                        if (insertOffset != -1) {
                                            try {
                                                copy.getDocument().insertString(insertOffset, " {}", null);
                                                FixImpl.this.offset = insertOffset + 1;
                                                repeat[0] = true;
                                            }
                                            catch (BadLocationException e) {
                                                Exceptions.printStackTrace((Throwable)e);
                                            }
                                            catch (IOException e) {
                                                Exceptions.printStackTrace((Throwable)e);
                                            }
                                        }
                                    } else {
                                        GeneratorUtils.generateAllAbstractMethodImplementations((WorkingCopy)copy, (TreePath)pathToModify);
                                    }
                                }

                                public void makeClassAbstract(Tree toModify, String className) {
                                    if (toModify.getKind() == Tree.Kind.CLASS) {
                                        ClassTree clazz = (ClassTree)toModify;
                                        ModifiersTree modifiers = clazz.getModifiers();
                                        HashSet<Modifier> newModifiersSet = new HashSet<Modifier>(modifiers.getFlags());
                                        newModifiersSet.add(Modifier.ABSTRACT);
                                        copy.rewrite((Tree)modifiers, (Tree)copy.getTreeMaker().Modifiers(newModifiersSet, modifiers.getAnnotations()));
                                    }
                                }
                            });
                        }
                    }).commit();
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            return null;
        }
    }

    private static interface Performer {
        public void fixAllAbstractMethods(TreePath var1, Tree var2);

        public void makeClassAbstract(Tree var1, String var2);
    }
}

