/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.Token;
import org.netbeans.modules.java.editor.imports.ComputeImports;
import org.netbeans.modules.java.hints.JavaHintsProvider;
import org.netbeans.modules.java.hints.Pair;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImportClassEnabler
implements ErrorRule<ImportCandidatesHolder> {
    static RequestProcessor WORKER = new RequestProcessor("ImportClassEnabler", 1);
    private boolean cancelled;
    private ComputeImports compImports;

    @Override
    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.cant.resolve", "compiler.err.cant.resolve.location", "compiler.err.doesnt.exist", "compiler.err.not.stmt"));
    }

    @Override
    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<ImportCandidatesHolder> data) {
        MethodInvocationTree mit;
        this.resume();
        int errorPosition = offset + 1;
        if (errorPosition == -1) {
            JavaHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.create errorPosition=-1");
            return Collections.emptyList();
        }
        TreePath path = info.getTreeUtilities().pathFor(errorPosition);
        if (path.getParentPath() != null && path.getParentPath().getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION && !(mit = (MethodInvocationTree)path.getParentPath().getLeaf()).getTypeArguments().contains(path.getLeaf())) {
            return Collections.emptyList();
        }
        Token ident = JavaHintsProvider.findUnresolvedElementToken(info, offset);
        JavaHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.create ident={0}", ident);
        if (ident == null) {
            return Collections.emptyList();
        }
        FileObject file = info.getFileObject();
        String simpleName = ((Object)ident.text()).toString();
        Pair<List<String>, List<String>> candidates = this.getCandidateFQNs(info, file, simpleName, data);
        if (this.isCancelled()) {
            JavaHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.cancelled.");
            return Collections.emptyList();
        }
        List<String> filtered = candidates.getA();
        List<String> unfiltered = candidates.getB();
        ArrayList<Fix> fixes = new ArrayList<Fix>();
        if (unfiltered != null && filtered != null) {
            for (String fqn : filtered) {
                fixes.add(new FixImport(file, fqn, true));
            }
            for (String fqn : unfiltered) {
                if (filtered.contains(fqn)) continue;
                fixes.add(new FixImport(file, fqn, false));
            }
        }
        JavaHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.create finished.");
        return fixes;
    }

    @Override
    public synchronized void cancel() {
        JavaHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.cancel called.");
        this.cancelled = true;
        if (this.compImports != null) {
            this.compImports.cancel();
        }
    }

    @Override
    public String getId() {
        return ImportClassEnabler.class.getName();
    }

    @Override
    public String getDisplayName() {
        return "Add Import Fix";
    }

    @Override
    public String getDescription() {
        return "Add Import Fix";
    }

    private synchronized void resume() {
        JavaHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.resume called.");
        this.cancelled = false;
    }

    private synchronized boolean isCancelled() {
        return this.cancelled;
    }

    private synchronized void setComputeImports(ComputeImports compImports) {
        this.compImports = compImports;
    }

    public Pair<List<String>, List<String>> getCandidateFQNs(CompilationInfo info, FileObject file, String simpleName, ErrorRule.Data<ImportCandidatesHolder> data) {
        Pair<Map<String, List<String>>, Map<String, List<String>>> result;
        ImportCandidatesHolder holder = data.getData();
        if (holder == null) {
            holder = new ImportCandidatesHolder();
            data.setData(holder);
        }
        if ((result = holder.getCandidates()) == null || result.getA() == null || result.getB() == null) {
            HashMap candidates = new HashMap();
            ComputeImports imp = new ComputeImports();
            this.setComputeImports(imp);
            ComputeImports.Pair rawCandidates = imp.computeCandidates(info);
            this.setComputeImports(null);
            if (this.isCancelled()) {
                JavaHintsProvider.LOG.log(Level.FINE, "ImportClassEnabler.getCandidateFQNs cancelled, returning.");
                return null;
            }
            for (String sn : ((Map)rawCandidates.a).keySet()) {
                ArrayList<String> c = new ArrayList<String>();
                for (TypeElement te : (List)((Map)rawCandidates.a).get(sn)) {
                    c.add(te.getQualifiedName().toString());
                }
                candidates.put(sn, c);
            }
            HashMap notFilteredCandidates = new HashMap();
            for (String sn : ((Map)rawCandidates.b).keySet()) {
                ArrayList<String> c = new ArrayList<String>();
                for (TypeElement te : (List)((Map)rawCandidates.b).get(sn)) {
                    c.add(te.getQualifiedName().toString());
                }
                notFilteredCandidates.put(sn, c);
            }
            result = new Pair(candidates, notFilteredCandidates);
            holder.setCandidates(result);
        }
        List<String> candList = result.getA().get(simpleName);
        List<String> notFilteredCandList = result.getB().get(simpleName);
        return new Pair<List<String>, List<String>>(candList, notFilteredCandList);
    }

    static final class FixImport
    implements Fix {
        private FileObject file;
        private String fqn;
        private boolean isValid;

        public FixImport(FileObject file, String fqn, boolean isValid) {
            this.file = file;
            this.fqn = fqn;
            this.isValid = isValid;
        }

        public String getText() {
            if (this.isValid) {
                return NbBundle.getMessage(ImportClassEnabler.class, (String)"Add_import_for_X", (Object[])new Object[]{this.fqn});
            }
            return "<html><font color='#808080'><s>" + NbBundle.getMessage(ImportClassEnabler.class, (String)"Add_import_for_X", (Object[])new Object[]{this.fqn});
        }

        public ChangeInfo implement() {
            JavaSource js = JavaSource.forFileObject((FileObject)this.file);
            CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

                public void run(WorkingCopy copy) throws Exception {
                    if (copy.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    TypeElement te = copy.getElements().getTypeElement(FixImport.this.fqn);
                    if (te == null) {
                        Logger.getAnonymousLogger().warning(String.format("Attempt to fix import for FQN: %s, which does not have a TypeElement in currect context", FixImport.this.fqn));
                        return;
                    }
                    CompilationUnitTree cut = SourceUtils.addImports((CompilationUnitTree)copy.getCompilationUnit(), Collections.singletonList(te.getQualifiedName().toString()), (TreeMaker)copy.getTreeMaker());
                    copy.rewrite((Tree)copy.getCompilationUnit(), (Tree)cut);
                }

                public void cancel() {
                }
            };
            try {
                js.runModificationTask((CancellableTask)task).commit();
                return null;
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
                return null;
            }
        }

        public int hashCode() {
            return this.fqn.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof FixImport) {
                return this.fqn.equals(((FixImport)o).fqn);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImportCandidatesHolder {
        private Pair<Map<String, List<String>>, Map<String, List<String>>> candidates;

        public Pair<Map<String, List<String>>, Map<String, List<String>>> getCandidates() {
            return this.candidates;
        }

        public void setCandidates(Pair<Map<String, List<String>>, Map<String, List<String>>> candidates) {
            this.candidates = candidates;
        }
    }
}

