/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.TypeKind;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.tools.Diagnostic;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.timers.TimesCollector;
import org.netbeans.modules.java.hints.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.LazyHintComputationFactory;
import org.netbeans.modules.java.hints.infrastructure.RulesManager;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaHintsProvider
implements CancellableTask<CompilationInfo> {
    public static ErrorManager ERR = ErrorManager.getDefault().getInstance("org.netbeans.modules.java.hints");
    public static Logger LOG = Logger.getLogger("org.netbeans.modules.java.hints");
    private FileObject file;
    private static final Map<Diagnostic.Kind, Severity> errorKind2Severity = new EnumMap<Diagnostic.Kind, Severity>(Diagnostic.Kind.class);
    private static final Set<String> CANNOT_RESOLVE;
    private static final Set<String> UNDERLINE_IDENTIFIER;
    private boolean cancel;

    JavaHintsProvider(FileObject file) {
        this.file = file;
    }

    List<ErrorDescription> computeErrors(CompilationInfo info, Document doc) {
        JavaSource js = JavaSource.forFileObject((FileObject)this.file);
        List errors = info.getDiagnostics();
        ArrayList<ErrorDescription> descs = new ArrayList<ErrorDescription>();
        if (ERR.isLoggable(1)) {
            ERR.log(1, "errors = " + errors);
        }
        HashMap<Class, ErrorRule.Data> data = new HashMap<Class, ErrorRule.Data>();
        for (Diagnostic d : errors) {
            if (this.isCanceled()) {
                return null;
            }
            if (ERR.isLoggable(1)) {
                ERR.log(1, "d = " + d);
            }
            Map<String, List<ErrorRule>> code2Rules = RulesManager.getInstance().getErrors();
            List<ErrorRule> rules = code2Rules.get(d.getCode());
            if (ERR.isLoggable(1)) {
                ERR.log(1, "code= " + d.getCode());
                ERR.log(1, "rules = " + rules);
            }
            LazyFixList ehm = rules != null ? new CreatorBasedLazyFixList(info.getFileObject(), d.getCode(), (int)this.getPrefferedPosition(info, d), rules, data) : ErrorDescriptionFactory.lazyListForFixes(Collections.emptyList());
            if (ERR.isLoggable(1)) {
                ERR.log(1, "ehm=" + ehm);
            }
            String desc = d.getMessage(null);
            Position[] range = this.getLine(info, d, doc, (int)d.getStartPosition(), (int)d.getEndPosition());
            if (this.isCanceled()) {
                return null;
            }
            if (range[0] == null || range[1] == null) continue;
            descs.add(ErrorDescriptionFactory.createErrorDescription((Severity)errorKind2Severity.get((Object)d.getKind()), (String)desc, (LazyFixList)ehm, (Document)doc, (Position)range[0], (Position)range[1]));
        }
        if (this.isCanceled()) {
            return null;
        }
        LazyHintComputationFactory.getAndClearToCompute(this.file);
        return descs;
    }

    public Document getDocument() {
        try {
            DataObject d = DataObject.find((FileObject)this.file);
            EditorCookie ec = (EditorCookie)d.getCookie(EditorCookie.class);
            if (ec == null) {
                return null;
            }
            return ec.getDocument();
        }
        catch (IOException e) {
            Logger.getLogger(JavaHintsProvider.class.getName()).log(Level.INFO, "SemanticHighlighter: Cannot find DataObject for file: " + FileUtil.getFileDisplayName((FileObject)this.file), e);
            return null;
        }
    }

    public static Token findUnresolvedElementToken(CompilationInfo info, int offset) {
        TokenSequence ts = info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        ts.move(offset);
        if (ts.moveNext()) {
            Token t = ts.token();
            if (t.id() == JavaTokenId.DOT) {
                ts.moveNext();
                t = ts.token();
            } else if (t.id() == JavaTokenId.LT) {
                ts.moveNext();
                t = ts.token();
            }
            if (t.id() == JavaTokenId.IDENTIFIER) {
                return ts.offsetToken();
            }
        }
        return null;
    }

    private static int[] findUnresolvedElementSpan(CompilationInfo info, int offset) {
        TokenHierarchy th = info.getTokenHierarchy();
        Token t = JavaHintsProvider.findUnresolvedElementToken(info, offset);
        if (t != null) {
            return new int[]{t.offset(th), t.offset(th) + t.length()};
        }
        return null;
    }

    static TreePath findUnresolvedElement(CompilationInfo info, int offset) {
        int[] span = JavaHintsProvider.findUnresolvedElementSpan(info, offset);
        if (span != null) {
            return info.getTreeUtilities().pathFor(span[0] + 1);
        }
        return null;
    }

    private Position[] getLine(CompilationInfo info, Diagnostic d, final Document doc, int startOffset, int endOffset) {
        int[] span;
        StyledDocument sdoc = (StyledDocument)doc;
        DataObject dObj = (DataObject)doc.getProperty("stream");
        LineCookie lc = (LineCookie)dObj.getCookie(LineCookie.class);
        int lineNumber = NbDocument.findLineNumber((StyledDocument)sdoc, (int)startOffset);
        int lineOffset = NbDocument.findLineOffset((StyledDocument)sdoc, (int)lineNumber);
        Line line = lc.getLineSet().getCurrent(lineNumber);
        boolean rangePrepared = false;
        if (CANNOT_RESOLVE.contains(d.getCode()) && (span = JavaHintsProvider.findUnresolvedElementSpan(info, (int)this.getPrefferedPosition(info, d))) != null && span[0] != -1 && span[1] != -1) {
            startOffset = span[0];
            endOffset = span[1];
            rangePrepared = true;
        }
        if (UNDERLINE_IDENTIFIER.contains(d.getCode())) {
            Token t;
            TokenSequence ts = info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
            int diff = ts.move((int)this.getPrefferedPosition(info, d));
            if (ts.moveNext() && diff >= 0 && diff < ts.token().length() && (t = ts.token()).id() == JavaTokenId.IDENTIFIER) {
                startOffset = ts.offset();
                endOffset = startOffset + t.length();
                rangePrepared = true;
            }
        }
        if (!rangePrepared) {
            int column;
            String text = line.getText();
            int length = text.length();
            for (column = 0; column < text.length() && Character.isWhitespace(text.charAt(column)); ++column) {
            }
            while (length > 0 && Character.isWhitespace(text.charAt(length - 1))) {
                --length;
            }
            startOffset = lineOffset + column;
            endOffset = lineOffset + length;
        }
        if (ERR.isLoggable(1)) {
            ERR.log(1, "startOffset = " + startOffset);
            ERR.log(1, "endOffset = " + endOffset);
        }
        final int startOffsetFinal = startOffset;
        final int endOffsetFinal = endOffset;
        final Position[] result = new Position[2];
        doc.render(new Runnable(){

            public void run() {
                if (JavaHintsProvider.this.isCanceled()) {
                    return;
                }
                int len = doc.getLength();
                if (startOffsetFinal >= len || endOffsetFinal >= len) {
                    if (!JavaHintsProvider.this.isCanceled() && ERR.isLoggable(16)) {
                        ERR.log(16, "document changed, but not canceled?");
                        ERR.log(16, "len = " + len);
                        ERR.log(16, "startOffset = " + startOffsetFinal);
                        ERR.log(16, "endOffset = " + endOffsetFinal);
                    }
                    JavaHintsProvider.this.cancel();
                    return;
                }
                try {
                    result[0] = NbDocument.createPosition((Document)doc, (int)startOffsetFinal, (Position.Bias)Position.Bias.Forward);
                    result[1] = NbDocument.createPosition((Document)doc, (int)endOffsetFinal, (Position.Bias)Position.Bias.Backward);
                }
                catch (BadLocationException e) {
                    ERR.notify(65536, (Throwable)e);
                }
            }
        });
        return result;
    }

    synchronized boolean isCanceled() {
        return this.cancel;
    }

    public synchronized void cancel() {
        this.cancel = true;
    }

    synchronized void resume() {
        this.cancel = false;
    }

    public void run(CompilationInfo info) {
        this.resume();
        Document doc = this.getDocument();
        if (doc == null) {
            Logger.getLogger(JavaHintsProvider.class.getName()).log(Level.INFO, "SemanticHighlighter: Cannot get document!");
            return;
        }
        long start = System.currentTimeMillis();
        List<ErrorDescription> errors = this.computeErrors(info, doc);
        if (errors == null) {
            return;
        }
        HintsController.setErrors((Document)doc, (String)"java-hints", errors);
        long end = System.currentTimeMillis();
        TimesCollector.getDefault().reportTime(info.getFileObject(), "java-hints", "Java Hints", end - start);
    }

    private long getPrefferedPosition(CompilationInfo info, Diagnostic d) {
        if ("compiler.err.doesnt.exist".equals(d.getCode())) {
            return d.getStartPosition();
        }
        if ("compiler.err.not.stmt".equals(d.getCode())) {
            Element el;
            TreePath path = JavaHintsProvider.findUnresolvedElement(info, (int)d.getStartPosition() - 1);
            Element element = el = path != null ? info.getTrees().getElement(path) : null;
            if (el == null || el.asType().getKind() == TypeKind.ERROR) {
                return d.getStartPosition() - 1L;
            }
            if (el.asType().getKind() == TypeKind.PACKAGE) {
                String s = ((PackageElement)el).getQualifiedName().toString();
                if (info.getElements().getPackageElement(s) == null) {
                    return d.getStartPosition() - 1L;
                }
            }
            return d.getStartPosition();
        }
        return d.getPosition();
    }

    static {
        errorKind2Severity.put(Diagnostic.Kind.ERROR, Severity.ERROR);
        errorKind2Severity.put(Diagnostic.Kind.MANDATORY_WARNING, Severity.WARNING);
        errorKind2Severity.put(Diagnostic.Kind.WARNING, Severity.WARNING);
        errorKind2Severity.put(Diagnostic.Kind.NOTE, Severity.WARNING);
        errorKind2Severity.put(Diagnostic.Kind.OTHER, Severity.WARNING);
        CANNOT_RESOLVE = new HashSet<String>(Arrays.asList("compiler.err.cant.resolve", "compiler.err.cant.resolve.location", "compiler.err.doesnt.exist"));
        UNDERLINE_IDENTIFIER = new HashSet<String>(Arrays.asList("compiler.err.local.var.accessed.from.icls.needs.final", "compiler.err.var.might.not.have.been.initialized"));
    }
}

