/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.hints.MagicSurroundWithTryCatch;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UncaughtExceptionCreator
implements ErrorRule<Void> {
    private static final Set<ElementKind> EXECUTABLE_ELEMENTS = EnumSet.of(ElementKind.CONSTRUCTOR, ElementKind.METHOD);
    static final Set<Tree.Kind> STATEMENT_KINDS;

    private List<? extends TypeMirror> findUncauchedExceptions(CompilationInfo info, TreePath path, List<? extends TypeMirror> exceptions) {
        ArrayList<? extends TypeMirror> result = new ArrayList<TypeMirror>();
        result.addAll(exceptions);
        while (path != null) {
            Element currentElement = info.getTrees().getElement(path);
            if (currentElement != null && EXECUTABLE_ELEMENTS.contains((Object)currentElement.getKind())) {
                ExecutableElement ee = (ExecutableElement)currentElement;
                result.removeAll(ee.getThrownTypes());
                break;
            }
            Tree currentTree = path.getLeaf();
            if (currentTree.getKind() == Tree.Kind.TRY) {
                TryTree tt = (TryTree)currentTree;
                for (CatchTree catchTree : tt.getCatches()) {
                    TreePath catchPath = new TreePath(new TreePath(path, catchTree), catchTree.getParameter());
                    VariableElement variable = (VariableElement)info.getTrees().getElement(catchPath);
                    result.remove(variable.asType());
                }
            }
            path = path.getParentPath();
        }
        return result;
    }

    @Override
    public Set<String> getCodes() {
        return Collections.singleton("compiler.err.unreported.exception.need.to.catch.or.throw");
    }

    @Override
    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        TreePath path;
        ArrayList<Fix> result = new ArrayList<Fix>();
        List<? extends TypeMirror> uncauched = null;
        block4: for (path = info.getTreeUtilities().pathFor(offset + 1); path != null; path = path.getParentPath()) {
            Tree leaf = path.getLeaf();
            switch (leaf.getKind()) {
                case NEW_CLASS: 
                case METHOD_INVOCATION: {
                    Element el = info.getTrees().getElement(path);
                    if (el != null && EXECUTABLE_ELEMENTS.contains((Object)el.getKind())) {
                        uncauched = ((ExecutableElement)el).getThrownTypes();
                    }
                    path = path.getParentPath();
                    break block4;
                }
                case THROW: {
                    TypeMirror uncaughtException = info.getTrees().getTypeMirror(new TreePath(path, ((ThrowTree)leaf).getExpression()));
                    uncauched = Collections.singletonList(uncaughtException);
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        if (uncauched != null) {
            ExecutableElement method;
            TreePath pathRec;
            uncauched = this.findUncauchedExceptions(info, path, uncauched);
            for (pathRec = path; pathRec != null && pathRec.getLeaf().getKind() != Tree.Kind.METHOD; pathRec = pathRec.getParentPath()) {
            }
            ExecutableElement executableElement = method = pathRec != null ? (ExecutableElement)info.getTrees().getElement(pathRec) : null;
            if (method != null) {
                for (TypeMirror typeMirror : uncauched) {
                    if (typeMirror.getKind() == TypeKind.ERROR) continue;
                    result.add(new AddThrowsClauseHintImpl(info.getJavaSource(), ((Object)Utilities.getTypeName((TypeMirror)typeMirror, (boolean)true)).toString(), TypeMirrorHandle.create((TypeMirror)typeMirror), (ElementHandle<ExecutableElement>)ElementHandle.create((Element)method)));
                }
            }
            if (!uncauched.isEmpty()) {
                ArrayList<TypeMirrorHandle> thandles = new ArrayList<TypeMirrorHandle>();
                for (TypeMirror typeMirror : uncauched) {
                    if (typeMirror.getKind() == TypeKind.ERROR) continue;
                    thandles.add(TypeMirrorHandle.create((TypeMirror)typeMirror));
                }
                result.add(new MagicSurroundWithTryCatch(info.getJavaSource(), thandles, offset));
            }
        }
        return result;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return UncaughtExceptionCreator.class.getName();
    }

    @Override
    public String getDisplayName() {
        return "Add Throws Clause and Surround With try-catch Fixes";
    }

    @Override
    public String getDescription() {
        return "Add Throws Clause and Surround With try-catch Fixes";
    }

    static {
        HashSet<Tree.Kind> kinds = new HashSet<Tree.Kind>();
        for (Tree.Kind k : Tree.Kind.values()) {
            Class<? extends Tree> c = k.asInterface();
            if (c == null || !StatementTree.class.isAssignableFrom(c)) continue;
            kinds.add(k);
        }
        STATEMENT_KINDS = Collections.unmodifiableSet(EnumSet.copyOf(kinds));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AddThrowsClauseHintImpl
    implements Fix {
        private JavaSource js;
        private String fqn;
        private TypeMirrorHandle thandle;
        private ElementHandle<ExecutableElement> method;

        public AddThrowsClauseHintImpl(JavaSource js, String fqn, TypeMirrorHandle thandle, ElementHandle<ExecutableElement> method) {
            this.js = js;
            this.fqn = fqn;
            this.thandle = thandle;
            this.method = method;
        }

        public String getText() {
            return "Add throws clause for " + this.fqn;
        }

        public ChangeInfo implement() {
            try {
                this.js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy wc) throws Exception {
                        wc.toPhase(JavaSource.Phase.RESOLVED);
                        MethodTree tree = wc.getTrees().getTree((ExecutableElement)AddThrowsClauseHintImpl.this.method.resolve((CompilationInfo)wc));
                        assert (tree != null);
                        assert (tree.getKind() == Tree.Kind.METHOD);
                        MethodTree nue = wc.getTreeMaker().addMethodThrows(tree, (ExpressionTree)wc.getTreeMaker().Type(AddThrowsClauseHintImpl.this.thandle.resolve((CompilationInfo)wc)));
                        wc.rewrite((Tree)tree, (Tree)nue);
                    }
                }).commit();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SurroundWithTryCatch
    implements Fix {
        private JavaSource js;
        private List<TypeMirrorHandle> thandles;
        private int offset;

        public SurroundWithTryCatch(JavaSource js, List<TypeMirrorHandle> thandles, int offset) {
            this.js = js;
            this.thandles = thandles;
            this.offset = offset;
        }

        public String getText() {
            return "Surround with try-catch";
        }

        public ChangeInfo implement() {
            try {
                this.js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy wc) throws Exception {
                        TreePath currentPath;
                        wc.toPhase(JavaSource.Phase.RESOLVED);
                        for (currentPath = wc.getTreeUtilities().pathFor(SurroundWithTryCatch.this.offset + 1); currentPath != null && !STATEMENT_KINDS.contains((Object)currentPath.getLeaf().getKind()); currentPath = currentPath.getParentPath()) {
                        }
                        TreeMaker make = wc.getTreeMaker();
                        Tree t = currentPath.getLeaf();
                        BlockTree bt = make.Block(Collections.singletonList((StatementTree)t), false);
                        ArrayList<CatchTree> catches = new ArrayList<CatchTree>();
                        for (TypeMirrorHandle th : SurroundWithTryCatch.this.thandles) {
                            catches.add(make.Catch(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"ex", make.Type(th.resolve((CompilationInfo)wc)), null), make.Block(Collections.emptyList(), false)));
                        }
                        wc.rewrite(t, (Tree)make.Try(bt, catches, null));
                    }
                }).commit();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            return null;
        }
    }
}

