/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.modules.java.editor.semantic.ScanningCancellableTask;
import org.netbeans.modules.java.hints.infrastructure.RulesManager;
import org.netbeans.modules.java.hints.spi.TreeRule;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HintsTask
extends ScanningCancellableTask<CompilationInfo> {
    public void run(CompilationInfo info) throws Exception {
        this.resume();
        Map<Tree.Kind, List<TreeRule>> hints = RulesManager.getInstance().getHints(false);
        if (hints.isEmpty()) {
            HintsController.setErrors((FileObject)info.getFileObject(), (String)HintsTask.class.getName(), Collections.emptyList());
            return;
        }
        ArrayList result = new ArrayList();
        this.scan(new ScannerImpl(info, hints), info.getCompilationUnit(), result);
        if (this.isCancelled()) {
            return;
        }
        HintsController.setErrors((FileObject)info.getFileObject(), (String)HintsTask.class.getName(), result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ScannerImpl
    extends CancellableTreePathScanner<Void, List<ErrorDescription>> {
        private CompilationInfo info;
        private Map<Tree.Kind, List<TreeRule>> hints;

        public ScannerImpl(CompilationInfo info, Map<Tree.Kind, List<TreeRule>> hints) {
            this.info = info;
            this.hints = hints;
        }

        private void runAndAdd(TreePath path, List<TreeRule> rules, List<ErrorDescription> d) {
            if (rules != null) {
                for (TreeRule tr : rules) {
                    if (this.isCanceled()) {
                        return;
                    }
                    List<ErrorDescription> errors = tr.run(this.info, path);
                    if (errors == null) continue;
                    d.addAll(errors);
                }
            }
        }

        public Void scan(Tree tree, List<ErrorDescription> p) {
            if (tree == null) {
                return null;
            }
            TreePath tp = new TreePath(this.getCurrentPath(), tree);
            Tree.Kind k = tree.getKind();
            this.runAndAdd(tp, this.hints.get((Object)k), p);
            if (this.isCanceled()) {
                return null;
            }
            return (Void)super.scan(tree, p);
        }

        public Void scan(TreePath path, List<ErrorDescription> p) {
            Tree.Kind k = path.getLeaf().getKind();
            this.runAndAdd(path, this.hints.get((Object)k), p);
            if (this.isCanceled()) {
                return null;
            }
            return (Void)super.scan(path, p);
        }
    }
}

