/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.options;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

class HintsPanelLogic
implements MouseListener,
KeyListener,
TreeSelectionListener,
ChangeListener,
ActionListener {
    private static final String HINTS = "hints";
    private static final String DEFAULT_PROFILE = "default";
    private static final JPanel EMPTY_PANEL = new JPanel();
    private Map<AbstractHint, ModifiedPreferences> changes = new HashMap<AbstractHint, ModifiedPreferences>();
    private static Map<Integer, Integer> severity2index = new HashMap<Integer, Integer>();
    private JTree errorTree;
    private JComboBox severityComboBox;
    private JCheckBox tasklistCheckBox;
    private JPanel customizerPanel;
    private JTextArea descriptionTextArea;

    HintsPanelLogic() {
    }

    void connect(JTree errorTree, JComboBox severityComboBox, JCheckBox tasklistCheckBox, JPanel customizerPanel, JTextArea descriptionTextArea) {
        this.errorTree = errorTree;
        this.severityComboBox = severityComboBox;
        this.tasklistCheckBox = tasklistCheckBox;
        this.customizerPanel = customizerPanel;
        this.descriptionTextArea = descriptionTextArea;
        errorTree.addKeyListener(this);
        errorTree.addMouseListener(this);
        errorTree.getSelectionModel().addTreeSelectionListener(this);
        severityComboBox.addActionListener(this);
        tasklistCheckBox.addChangeListener(this);
    }

    void disconnect() {
        this.errorTree.removeKeyListener(this);
        this.errorTree.removeMouseListener(this);
        this.errorTree.getSelectionModel().removeTreeSelectionListener(this);
        this.severityComboBox.removeActionListener(this);
        this.tasklistCheckBox.removeChangeListener(this);
    }

    synchronized void applyChanges() {
        for (AbstractHint hint : this.changes.keySet()) {
            ModifiedPreferences mn = this.changes.get(hint);
            mn.store(this.getPreferences(hint));
        }
    }

    boolean isChanged() {
        return !this.changes.isEmpty();
    }

    synchronized Preferences getCurrentPrefernces(AbstractHint hint) {
        Preferences node = this.changes.get(hint);
        return node == null ? this.getPreferences(hint) : node;
    }

    synchronized Preferences getPreferences4Modification(AbstractHint hint) {
        Preferences node = this.changes.get(hint);
        if (node == null) {
            node = new ModifiedPreferences(this.getPreferences(hint));
            this.changes.put(hint, (ModifiedPreferences)node);
        }
        return node;
    }

    static Object getUserObject(TreePath path) {
        DefaultMutableTreeNode tn = (DefaultMutableTreeNode)path.getLastPathComponent();
        return tn.getUserObject();
    }

    static Object getUserObject(DefaultMutableTreeNode node) {
        return node.getUserObject();
    }

    boolean isSelected(DefaultMutableTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            AbstractHint hint;
            DefaultMutableTreeNode ch = (DefaultMutableTreeNode)node.getChildAt(i);
            Object o = ch.getUserObject();
            if (!(o instanceof AbstractHint) || !this.getCurrentPrefernces(hint = (AbstractHint)o).getBoolean("enabled", true)) continue;
            return true;
        }
        return false;
    }

    public void mouseClicked(MouseEvent e) {
        Rectangle r;
        Point p = e.getPoint();
        TreePath path = this.errorTree.getPathForLocation(e.getPoint().x, e.getPoint().y);
        if (path != null && (r = this.errorTree.getPathBounds(path)) != null) {
            r.width = r.height;
            if (r.contains(p)) {
                this.toggle(path);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        JTree tree;
        TreePath path;
        if ((e.getKeyCode() == 32 || e.getKeyCode() == 10) && e.getSource() instanceof JTree && this.toggle(path = (tree = (JTree)e.getSource()).getSelectionPath())) {
            e.consume();
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object o = HintsPanelLogic.getUserObject(e.getPath());
        this.customizerPanel.setVisible(false);
        if (o instanceof AbstractHint) {
            AbstractHint hint = (AbstractHint)o;
            this.componentsSetEnabled(true);
            Preferences p = this.getCurrentPrefernces(hint);
            int severity = p.getInt("severity", AbstractHint.SEVERITY_DEFAULT.ordinal());
            this.severityComboBox.setSelectedIndex(severity2index.get(severity));
            boolean toTasklist = p.getBoolean("inTaskList", true);
            this.tasklistCheckBox.setSelected(toTasklist);
            String description = hint.getDescription();
            this.descriptionTextArea.setText(description == null ? "" : description);
            this.customizerPanel.removeAll();
            JComponent c = hint.getCustomizer(this.getPreferences4Modification(hint));
            if (c == null) {
                this.customizerPanel.add((Component)EMPTY_PANEL, "Center");
            } else {
                this.customizerPanel.add((Component)c, "Center");
            }
        } else {
            this.componentsSetEnabled(false);
        }
        this.customizerPanel.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object o = HintsPanelLogic.getUserObject(this.errorTree.getSelectionPath());
        this.customizerPanel.setVisible(false);
        if (o instanceof AbstractHint) {
            AbstractHint hint = (AbstractHint)o;
            Preferences p = this.getPreferences4Modification(hint);
            p.putInt("severity", this.severityComboBox.getSelectedIndex());
        }
    }

    public void stateChanged(ChangeEvent e) {
    }

    private synchronized Preferences getPreferences(AbstractHint hint) {
        Preferences node = hint.getPreferences();
        if (node == null) {
            Preferences preferences = NbPreferences.forModule(hint.getClass());
            node = preferences.node(HINTS).node(HintsPanelLogic.getCurrentProfileId()).node(hint.getId());
        }
        return node;
    }

    private static String getCurrentProfileId() {
        return DEFAULT_PROFILE;
    }

    private boolean toggle(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Object o = HintsPanelLogic.getUserObject(treePath);
        DefaultTreeModel model = (DefaultTreeModel)this.errorTree.getModel();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (o instanceof AbstractHint) {
            AbstractHint hint = (AbstractHint)o;
            boolean value = this.getCurrentPrefernces(hint).getBoolean("enabled", true);
            Preferences mn = this.getPreferences4Modification(hint);
            mn.putBoolean("enabled", !value);
            model.nodeChanged(node);
            model.nodeChanged(node.getParent());
        } else if (o instanceof FileObject) {
            boolean value = !this.isSelected(node);
            for (int i = 0; i < node.getChildCount(); ++i) {
                AbstractHint hint;
                boolean cv;
                DefaultMutableTreeNode ch = (DefaultMutableTreeNode)node.getChildAt(i);
                Object cho = ch.getUserObject();
                if (!(cho instanceof AbstractHint) || (cv = this.getCurrentPrefernces(hint = (AbstractHint)cho).getBoolean("enabled", true)) == value) continue;
                Preferences mn = this.getPreferences4Modification(hint);
                mn.putBoolean("enabled", value);
                model.nodeChanged(ch);
            }
            model.nodeChanged(node);
        }
        return false;
    }

    private void toggleHint(AbstractHint hint) {
    }

    private void componentsSetEnabled(boolean enabled) {
        if (!enabled) {
            this.customizerPanel.removeAll();
            this.customizerPanel.add((Component)EMPTY_PANEL, "Center");
            this.severityComboBox.setSelectedIndex(severity2index.get(AbstractHint.SEVERITY_DEFAULT.ordinal()));
            this.tasklistCheckBox.setSelected(true);
            this.descriptionTextArea.setText("");
        }
        this.severityComboBox.setEnabled(enabled);
        this.tasklistCheckBox.setEnabled(enabled);
        this.descriptionTextArea.setEnabled(enabled);
    }

    static {
        severity2index.put(AbstractHint.HintSeverity.ERROR.ordinal(), 0);
        severity2index.put(AbstractHint.HintSeverity.WARNING.ordinal(), 1);
        severity2index.put(AbstractHint.HintSeverity.CURRENT_LINE_WARNING.ordinal(), 2);
    }

    private static class ModifiedPreferences
    extends AbstractPreferences {
        private Map<String, Object> map = new HashMap<String, Object>();

        public ModifiedPreferences(Preferences node) {
            super(null, "");
            try {
                for (String key : node.keys()) {
                    this.put(key, node.get(key, null));
                }
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void store(Preferences target) {
            try {
                for (String key : this.keys()) {
                    target.put(key, this.get(key, null));
                }
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        protected void putSpi(String key, String value) {
            this.map.put(key, value);
        }

        protected String getSpi(String key) {
            return (String)this.map.get(key);
        }

        protected void removeSpi(String key) {
            this.map.remove(key);
        }

        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected String[] keysSpi() throws BackingStoreException {
            String[] array = new String[this.map.keySet().size()];
            return this.map.keySet().toArray(array);
        }

        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected AbstractPreferences childSpi(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

