/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.ant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.ant.AntBuildExtenderAccessorImpl;
import org.netbeans.modules.project.ant.AntBuildExtenderAccessor;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ant.AntBuildExtenderImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AntBuildExtender {
    private HashMap<String, Extension> extensions;
    private AntBuildExtenderImplementation implementation;
    private static final DocumentBuilder db;

    AntBuildExtender(AntBuildExtenderImplementation implementation) {
        this.implementation = implementation;
    }

    public List<String> getExtensibleTargets() {
        ArrayList<String> targets = new ArrayList<String>();
        targets.addAll(this.implementation.getExtensibleTargets());
        targets = Collections.unmodifiableList(targets);
        return targets;
    }

    public synchronized Extension addExtension(String id, FileObject extensionXml) {
        assert (extensionXml != null);
        assert (extensionXml.isValid() && extensionXml.isData());
        assert (FileOwnerQuery.getOwner((FileObject)extensionXml) == this.implementation.getOwningProject());
        FileObject nbproj = this.implementation.getOwningProject().getProjectDirectory().getFileObject("nbproject/project.xml").getParent();
        assert (FileUtil.isParentOf((FileObject)nbproj, (FileObject)extensionXml));
        if (this.extensions == null) {
            this.readProjectMetadata();
        }
        if (this.extensions.get(id) != null) {
            throw new IllegalStateException("Extension with id '" + id + "' already exists.");
        }
        Extension ex = new Extension(id, extensionXml, FileUtil.getRelativePath((FileObject)nbproj, (FileObject)extensionXml));
        this.extensions.put(id, ex);
        this.updateProjectMetadata();
        return ex;
    }

    public synchronized void removeExtension(String id) {
        if (this.extensions == null) {
            this.readProjectMetadata();
        }
        if (this.extensions.get(id) == null) {
            return;
        }
        this.extensions.remove(id);
        this.updateProjectMetadata();
    }

    public synchronized Extension getExtension(String id) {
        if (this.extensions == null) {
            this.readProjectMetadata();
        }
        return this.extensions.get(id);
    }

    synchronized Set<Extension> getExtensions() {
        HashSet<Extension> ext = new HashSet<Extension>();
        if (this.extensions == null) {
            this.readProjectMetadata();
        }
        ext.addAll(this.extensions.values());
        return ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document createNewDocument() {
        DocumentBuilder documentBuilder = db;
        synchronized (documentBuilder) {
            return db.newDocument();
        }
    }

    private void updateProjectMetadata() {
        Document doc = AntBuildExtender.createNewDocument();
        Element root = doc.createElementNS(AntBuildExtenderAccessor.AUX_NAMESPACE, AntBuildExtenderAccessor.ELEMENT_ROOT);
        if (this.extensions != null) {
            FileObject nbproj = this.implementation.getOwningProject().getProjectDirectory().getFileObject("nbproject/project.xml").getParent();
            for (Extension ext : this.extensions.values()) {
                Element child = doc.createElement(AntBuildExtenderAccessor.ELEMENT_EXTENSION);
                child.setAttribute(AntBuildExtenderAccessor.ATTR_ID, ext.id);
                String relPath = FileUtil.getRelativePath((FileObject)nbproj, (FileObject)ext.file);
                assert (relPath != null);
                child.setAttribute(AntBuildExtenderAccessor.ATTR_FILE, relPath);
                root.appendChild(child);
                for (String target : ext.dependencies.keySet()) {
                    for (String depTarget : ext.dependencies.get(target)) {
                        Element dep = doc.createElement(AntBuildExtenderAccessor.ELEMENT_DEPENDENCY);
                        dep.setAttribute(AntBuildExtenderAccessor.ATTR_TARGET, target);
                        dep.setAttribute(AntBuildExtenderAccessor.ATTR_DEPENDSON, depTarget);
                        child.appendChild(dep);
                    }
                }
            }
        }
        AuxiliaryConfiguration config = (AuxiliaryConfiguration)this.implementation.getOwningProject().getLookup().lookup(AuxiliaryConfiguration.class);
        config.putConfigurationFragment(root, true);
    }

    private void readProjectMetadata() {
        AuxiliaryConfiguration config = (AuxiliaryConfiguration)this.implementation.getOwningProject().getLookup().lookup(AuxiliaryConfiguration.class);
        Element cfgEl = config.getConfigurationFragment(AntBuildExtenderAccessor.ELEMENT_ROOT, AntBuildExtenderAccessor.AUX_NAMESPACE, true);
        FileObject nbproj = this.implementation.getOwningProject().getProjectDirectory().getFileObject("nbproject/project.xml").getParent();
        this.extensions = new HashMap();
        if (cfgEl != null) {
            String namespace = cfgEl.getNamespaceURI();
            NodeList roots = cfgEl.getElementsByTagNameNS(namespace, AntBuildExtenderAccessor.ELEMENT_EXTENSION);
            for (int i = 0; i < roots.getLength(); ++i) {
                Element root = (Element)roots.item(i);
                String id = root.getAttribute(AntBuildExtenderAccessor.ATTR_ID);
                assert (id.length() > 0) : "Illegal project.xml";
                String value = root.getAttribute(AntBuildExtenderAccessor.ATTR_FILE);
                FileObject script = nbproj.getFileObject(value);
                assert (script != null) : "Missing file " + script;
                Extension ext = new Extension(id, script, value);
                this.extensions.put(id, ext);
                NodeList deps = root.getElementsByTagNameNS(namespace, AntBuildExtenderAccessor.ELEMENT_DEPENDENCY);
                for (int j = 0; j < deps.getLength(); ++j) {
                    Element dep = (Element)deps.item(j);
                    String target = dep.getAttribute(AntBuildExtenderAccessor.ATTR_TARGET);
                    String dependsOn = dep.getAttribute(AntBuildExtenderAccessor.ATTR_DEPENDSON);
                    assert (target != null);
                    assert (dependsOn != null);
                    ext.loadDependency(target, dependsOn);
                }
            }
        }
    }

    static {
        AntBuildExtenderAccessorImpl.createAccesor();
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Extension {
        String id;
        FileObject file;
        String path;
        TreeMap<String, Collection<String>> dependencies;

        Extension(String id, FileObject script, String relPath) {
            this.id = id;
            this.file = script;
            this.path = relPath;
            this.dependencies = new TreeMap();
        }

        String getPath() {
            return this.path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDependency(String mainBuildTarget, String extensionTarget) {
            assert (AntBuildExtender.this.implementation.getExtensibleTargets().contains(mainBuildTarget)) : "The target '" + mainBuildTarget + "' is not designated by the project type as extensible.";
            Class<AntBuildExtender> clazz = AntBuildExtender.class;
            synchronized (AntBuildExtender.class) {
                this.loadDependency(mainBuildTarget, extensionTarget);
                AntBuildExtender.this.updateProjectMetadata();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadDependency(String mainBuildTarget, String extensionTarget) {
            Class<AntBuildExtender> clazz = AntBuildExtender.class;
            synchronized (AntBuildExtender.class) {
                Collection<String> tars = this.dependencies.get(mainBuildTarget);
                if (tars == null) {
                    tars = new ArrayList<String>();
                    this.dependencies.put(mainBuildTarget, tars);
                }
                if (!tars.contains(extensionTarget)) {
                    tars.add(extensionTarget);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        public void removeDependency(String mainBuildTarget, String extensionTarget) {
            Collection<String> str = this.dependencies.get(mainBuildTarget);
            if (str != null) {
                str.remove(extensionTarget);
                AntBuildExtender.this.updateProjectMetadata();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Map<String, Collection<String>> getDependencies() {
            TreeMap<String, Collection<String>> toRet = new TreeMap<String, Collection<String>>();
            Class<AntBuildExtender> clazz = AntBuildExtender.class;
            synchronized (AntBuildExtender.class) {
                for (String str : this.dependencies.keySet()) {
                    ArrayList<String> col = new ArrayList<String>();
                    col.addAll(this.dependencies.get(str));
                    toRet.put(str, col);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return toRet;
            }
        }
    }
}

