/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ant.Util;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AntBasedProjectFactorySingleton
implements ProjectFactory {
    public static final String PROJECT_XML_PATH = "nbproject/project.xml";
    public static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    private static final Map<Project, Reference<AntProjectHelper>> project2Helper;
    private static final Map<AntProjectHelper, Reference<Project>> helper2Project;
    private static final Map<AntBasedProjectType, List<Reference<AntProjectHelper>>> type2Projects;
    private static final Lookup.Result<AntBasedProjectType> antBasedProjectTypes;
    private static Map<String, AntBasedProjectType> antBasedProjectTypesByType;
    public static AntProjectHelperCallback HELPER_CALLBACK;

    private static void antBasedProjectTypesRemoved(Set<AntBasedProjectType> removed) {
        for (AntBasedProjectType type : removed) {
            List<Reference<AntProjectHelper>> projects = type2Projects.get(type);
            if (projects != null) {
                for (Reference<AntProjectHelper> r : projects) {
                    AntProjectHelper helper = r.get();
                    if (helper == null) continue;
                    helper.notifyDeleted();
                }
            }
            type2Projects.remove(type);
        }
    }

    private static synchronized AntBasedProjectType findAntBasedProjectType(String type) {
        if (antBasedProjectTypesByType == null) {
            antBasedProjectTypesByType = new HashMap<String, AntBasedProjectType>();
            for (AntBasedProjectType abpt : antBasedProjectTypes.allInstances()) {
                antBasedProjectTypesByType.put(abpt.getType(), abpt);
            }
        }
        return antBasedProjectTypesByType.get(type);
    }

    public boolean isProject(FileObject dir) {
        File dirF = FileUtil.toFile((FileObject)dir);
        if (dirF == null) {
            return false;
        }
        File projectXmlF = new File(new File(dirF, "nbproject"), "project.xml");
        return projectXmlF.isFile();
    }

    public Project loadProject(FileObject projectDirectory, ProjectState state) throws IOException {
        Document projectXml;
        if (FileUtil.toFile((FileObject)projectDirectory) == null) {
            return null;
        }
        FileObject projectFile = projectDirectory.getFileObject(PROJECT_XML_PATH);
        if (projectFile == null || !projectFile.isData() || projectFile.isVirtual()) {
            return null;
        }
        File projectDiskFile = FileUtil.toFile((FileObject)projectFile);
        if (projectDiskFile == null) {
            return null;
        }
        try {
            projectXml = XMLUtil.parse((InputSource)new InputSource(projectDiskFile.toURI().toString()), (boolean)false, (boolean)true, (ErrorHandler)Util.defaultErrorHandler(), null);
        }
        catch (SAXException e) {
            IOException ioe = (IOException)new IOException(projectDiskFile + ": " + e.toString()).initCause(e);
            Exceptions.attachLocalizedMessage((Throwable)ioe, (String)NbBundle.getMessage(AntBasedProjectFactorySingleton.class, (String)"AntBasedProjectFactorySingleton.parseError", (Object)projectDiskFile.getAbsolutePath(), (Object)e.getMessage()));
            throw ioe;
        }
        Element projectEl = projectXml.getDocumentElement();
        if (!"project".equals(projectEl.getLocalName()) || !PROJECT_NS.equals(projectEl.getNamespaceURI())) {
            return null;
        }
        Element typeEl = Util.findElement(projectEl, "type", PROJECT_NS);
        if (typeEl == null) {
            return null;
        }
        String type = Util.findText(typeEl);
        if (type == null) {
            return null;
        }
        AntBasedProjectType provider = AntBasedProjectFactorySingleton.findAntBasedProjectType(type);
        if (provider == null) {
            return null;
        }
        AntProjectHelper helper = HELPER_CALLBACK.createHelper(projectDirectory, projectXml, state, provider);
        Project project = provider.createProject(helper);
        project2Helper.put(project, new WeakReference<AntProjectHelper>(helper));
        helper2Project.put(helper, new WeakReference<Project>(project));
        List<Reference<AntProjectHelper>> l = type2Projects.get(provider);
        if (l == null) {
            l = new ArrayList<Reference<AntProjectHelper>>();
            type2Projects.put(provider, l);
        }
        l.add(new WeakReference<AntProjectHelper>(helper));
        return project;
    }

    public void saveProject(Project project) throws IOException, ClassCastException {
        Reference<AntProjectHelper> helperRef = project2Helper.get(project);
        if (helperRef == null) {
            throw new ClassCastException(project.getClass().getName());
        }
        AntProjectHelper helper = helperRef.get();
        assert (helper != null) : "AntProjectHelper collected for " + project;
        HELPER_CALLBACK.save(helper);
    }

    public static Project getProjectFor(AntProjectHelper helper) {
        Reference<Project> projectRef = helper2Project.get(helper);
        assert (projectRef != null) : "Found a Project reference for " + helper;
        Project p = projectRef.get();
        assert (p != null) : "Found a non-null Project for " + helper;
        return p;
    }

    public static AntProjectHelper getHelperFor(Project p) {
        Reference<AntProjectHelper> helperRef = project2Helper.get(p);
        return helperRef != null ? helperRef.get() : null;
    }

    static {
        block3: {
            project2Helper = new WeakHashMap<Project, Reference<AntProjectHelper>>();
            helper2Project = new WeakHashMap<AntProjectHelper, Reference<Project>>();
            type2Projects = new HashMap<AntBasedProjectType, List<Reference<AntProjectHelper>>>();
            antBasedProjectTypesByType = null;
            antBasedProjectTypes = Lookup.getDefault().lookupResult(AntBasedProjectType.class);
            antBasedProjectTypes.addLookupListener(new LookupListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultChanged(LookupEvent ev) {
                    Class<AntBasedProjectFactorySingleton> clazz = AntBasedProjectFactorySingleton.class;
                    synchronized (AntBasedProjectFactorySingleton.class) {
                        Set oldTypes = type2Projects.keySet();
                        HashSet removed = new HashSet(oldTypes);
                        removed.removeAll(antBasedProjectTypes.allInstances());
                        AntBasedProjectFactorySingleton.antBasedProjectTypesRemoved(removed);
                        antBasedProjectTypesByType = null;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
            Class<AntProjectHelper> c = AntProjectHelper.class;
            try {
                Class.forName(c.getName(), true, c.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)e);
            }
        }
        assert (HELPER_CALLBACK != null);
    }

    public static interface AntProjectHelperCallback {
        public AntProjectHelper createHelper(FileObject var1, Document var2, ProjectState var3, AntBasedProjectType var4);

        public void save(AntProjectHelper var1) throws IOException;
    }
}

