/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PathMatcher {
    private final String includes;
    private final String excludes;
    private final Pattern includePattern;
    private final Pattern excludePattern;
    private final File base;
    private final Set<String> knownIncludes;

    public PathMatcher(String includes, String excludes, File base) {
        this.includes = includes;
        this.excludes = excludes;
        this.includePattern = this.computePattern(includes);
        this.excludePattern = this.computePattern(excludes);
        this.base = base;
        this.knownIncludes = this.computeKnownIncludes();
    }

    private Pattern computePattern(String patterns) {
        if (patterns == null) {
            return null;
        }
        StringBuilder rx = new StringBuilder();
        StringTokenizer patternstok = new StringTokenizer(patterns, ", ");
        if (!patternstok.hasMoreTokens()) {
            return Pattern.compile("<cannot match>");
        }
        while (patternstok.hasMoreTokens()) {
            String pattern = patternstok.nextToken().replace('\\', '/');
            if (rx.length() > 0) {
                rx.append('|');
            }
            if (pattern.endsWith("/")) {
                pattern = pattern + "**";
            }
            if (pattern.equals("**")) {
                rx.append(".*");
                break;
            }
            Matcher m = Pattern.compile("/\\*\\*/|/\\*\\*|\\*\\*/|\\*|/|[^*/]+").matcher(pattern);
            while (m.find()) {
                String t = m.group();
                if (t.equals("/**")) {
                    rx.append("/.*");
                    continue;
                }
                if (t.equals("**/")) {
                    rx.append("(.*/|)");
                    continue;
                }
                if (t.equals("/**/")) {
                    rx.append("(/.*/|/)");
                    continue;
                }
                if (t.equals("*")) {
                    rx.append("[^/]*");
                    continue;
                }
                rx.append(Pattern.quote(t));
            }
        }
        String rxs = rx.toString();
        return Pattern.compile(rxs);
    }

    public boolean matches(String path, boolean useKnownIncludes) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (this.excludePattern != null && this.excludePattern.matcher(path).matches()) {
            return false;
        }
        if (this.includePattern != null) {
            if (this.includePattern.matcher(path).matches()) {
                return true;
            }
            if (useKnownIncludes && (path.length() == 0 || path.endsWith("/"))) {
                for (String incl : this.knownIncludes) {
                    if (!incl.startsWith(path)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public Set<File> findIncludedRoots() throws IllegalArgumentException {
        if (this.includes == null) {
            return Collections.singleton(this.base);
        }
        HashSet<File> roots = new HashSet<File>();
        if (this.base != null) {
            for (String incl : this.knownIncludes) {
                roots.add(new File(this.base, incl.replace('/', File.separatorChar)));
            }
        }
        return roots;
    }

    private Set<String> computeKnownIncludes() {
        if (this.includes == null) {
            return Collections.emptySet();
        }
        TreeSet<String> roots = new TreeSet<String>();
        StringTokenizer patternstok = new StringTokenizer(this.includes, ", ");
        boolean search = false;
        while (patternstok.hasMoreTokens()) {
            String pattern = patternstok.nextToken().replace('\\', '/').replaceFirst("/\\*\\*$", "/");
            if (pattern.equals("**")) {
                roots.add("");
                continue;
            }
            if (pattern.indexOf(42) == -1 && pattern.endsWith("/")) {
                String parent;
                if (this.excludePattern != null && this.excludePattern.matcher(pattern).matches() || this.includePattern.matcher(parent = pattern.substring(0, pattern.lastIndexOf(47, pattern.length() - 2) + 1)).matches()) continue;
                roots.add(pattern);
                continue;
            }
            if (this.base == null) continue;
            search = true;
        }
        if (this.base != null && this.base.isDirectory()) {
            Iterator it = roots.iterator();
            while (it.hasNext()) {
                if (new File(this.base, ((String)it.next()).replace('/', File.separatorChar)).isDirectory()) continue;
                it.remove();
            }
        }
        if (search) {
            this.findMatches(this.base, "", roots);
        }
        return roots;
    }

    private void findMatches(File dir, String prefix, Set<String> roots) {
        assert (prefix.length() == 0 || prefix.endsWith("/"));
        assert (this.includes != null);
        String[] childnames = dir.list();
        if (childnames == null) {
            return;
        }
        for (String childname : childnames) {
            File child = new File(dir, childname);
            boolean isdir = child.isDirectory();
            String path = prefix + childname;
            if (isdir) {
                path = path + "/";
            }
            if (this.excludePattern != null && this.excludePattern.matcher(path).matches()) continue;
            if (this.includePattern.matcher(path).matches()) {
                if (isdir) {
                    roots.add(path);
                    continue;
                }
                roots.add(prefix);
                continue;
            }
            if (!isdir) continue;
            this.findMatches(child, path, roots);
        }
    }

    public String toString() {
        return "PathMatcher[includes=" + this.includes + ",excludes=" + this.excludes + "]";
    }
}

