/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilesystemInterceptor
extends ProvidedExtensions
implements FileChangeListener {
    private VersioningManager master;
    private final DelegatingInterceptor nullDelegatingInterceptor = new DelegatingInterceptor(){

        public boolean beforeDelete() {
            return false;
        }

        public void doDelete() throws IOException {
        }

        public void afterDelete() {
        }

        public boolean beforeMove() {
            return false;
        }

        public void doMove() throws IOException {
        }

        public boolean beforeCreate() {
            return false;
        }

        public void doCreate() throws IOException {
        }

        public void afterCreate() {
        }

        public void beforeChange() {
        }

        public void afterChange() {
        }

        public void afterMove() {
        }

        public void handle() throws IOException {
        }

        public boolean delete(File file) {
            throw new UnsupportedOperationException();
        }
    };
    private final VCSInterceptor nullVCSInterceptor = new VCSInterceptor(){};
    private final Set<File> deletedFiles = new HashSet<File>(5);

    FilesystemInterceptor() {
    }

    void init(VersioningManager versioningManager) {
        assert (this.master == null);
        this.master = versioningManager;
        Set<FileSystem> filesystems = this.getRootFilesystems();
        for (FileSystem fileSystem : filesystems) {
            fileSystem.addFileChangeListener((FileChangeListener)this);
        }
    }

    void shutdown() {
        Set<FileSystem> filesystems = this.getRootFilesystems();
        for (FileSystem fileSystem : filesystems) {
            fileSystem.removeFileChangeListener((FileChangeListener)this);
        }
    }

    private Set<FileSystem> getRootFilesystems() {
        HashSet<FileSystem> filesystems = new HashSet<FileSystem>();
        File[] roots = File.listRoots();
        for (int i = 0; i < roots.length; ++i) {
            File root = roots[i];
            FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)root));
            if (fo == null) continue;
            try {
                filesystems.add(fo.getFileSystem());
                continue;
            }
            catch (FileStateInvalidException e) {
                // empty catch block
            }
        }
        return filesystems;
    }

    public void fileChanged(FileEvent fe) {
        this.removeFromDeletedFiles(fe.getFile());
        this.getInterceptor(fe).afterChange();
    }

    public void beforeChange(FileObject fo) {
        this.getInterceptor(FileUtil.toFile((FileObject)fo), fo.isFolder()).beforeChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromDeletedFiles(File file) {
        Set<File> set = this.deletedFiles;
        synchronized (set) {
            this.deletedFiles.remove(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromDeletedFiles(FileObject fo) {
        Set<File> set = this.deletedFiles;
        synchronized (set) {
            if (this.deletedFiles.size() > 0) {
                this.deletedFiles.remove(FileUtil.toFile((FileObject)fo));
            }
        }
    }

    public ProvidedExtensions.DeleteHandler getDeleteHandler(File file) {
        this.removeFromDeletedFiles(file);
        DelegatingInterceptor dic = this.getInterceptor(file, false);
        return dic.beforeDelete() ? dic : null;
    }

    public void fileDeleted(FileEvent fe) {
        this.removeFromDeletedFiles(fe.getFile());
        this.getInterceptor(fe).afterDelete();
    }

    public void beforeCreate(FileObject parent, String name, boolean isFolder) {
        File file = FileUtil.toFile((FileObject)parent);
        if (file == null) {
            return;
        }
        file = new File(file, name);
        DelegatingInterceptor dic = this.getInterceptor(file, isFolder);
        dic.beforeCreate();
    }

    public void fileFolderCreated(FileEvent fe) {
        this.removeFromDeletedFiles(fe.getFile());
        this.getInterceptor(fe).afterCreate();
    }

    public void fileDataCreated(FileEvent fe) {
        this.removeFromDeletedFiles(fe.getFile());
        this.getInterceptor(fe).afterCreate();
    }

    public ProvidedExtensions.IOHandler getMoveHandler(File from, File to) {
        DelegatingInterceptor dic = this.getInterceptor(from, to);
        return dic.beforeMove() ? dic : null;
    }

    public ProvidedExtensions.IOHandler getRenameHandler(File from, String newName) {
        File to = new File(from.getParentFile(), newName);
        return this.getMoveHandler(from, to);
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.removeFromDeletedFiles(fe.getFile());
        this.getInterceptor((FileEvent)fe).afterMove();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    private DelegatingInterceptor getInterceptor(FileEvent fe) {
        VCSInterceptor lhInterceptor;
        FileObject fo = fe.getFile();
        if (fo == null) {
            return this.nullDelegatingInterceptor;
        }
        File file = FileUtil.toFile((FileObject)fo);
        if (file == null) {
            return this.nullDelegatingInterceptor;
        }
        VersioningSystem lh = this.master.getLocalHistory(file);
        VersioningSystem vs = this.master.getOwner(file);
        VCSInterceptor vsInterceptor = vs != null ? vs.getVCSInterceptor() : null;
        VCSInterceptor vCSInterceptor = lhInterceptor = lh != null ? lh.getVCSInterceptor() : null;
        if (vsInterceptor == null && lhInterceptor == null) {
            return this.nullDelegatingInterceptor;
        }
        if (fe instanceof FileRenameEvent) {
            FileRenameEvent fre = (FileRenameEvent)fe;
            File parent = file.getParentFile();
            if (parent != null) {
                String name = fre.getName();
                String ext = fre.getExt();
                if (ext != null && ext.length() > 0) {
                    name = name + "." + ext;
                }
                File from = new File(parent, name);
                return new DelegatingInterceptor(vsInterceptor, lhInterceptor, from, file, false);
            }
            return this.nullDelegatingInterceptor;
        }
        return new DelegatingInterceptor(vsInterceptor, lhInterceptor, file, null, false);
    }

    private DelegatingInterceptor getInterceptor(File file, boolean isDirectory) {
        if (file == null) {
            return this.nullDelegatingInterceptor;
        }
        VersioningSystem vs = this.master.getOwner(file);
        VCSInterceptor vsInterceptor = vs != null ? vs.getVCSInterceptor() : this.nullVCSInterceptor;
        VersioningSystem lhvs = this.master.getLocalHistory(file);
        VCSInterceptor localHistoryInterceptor = lhvs != null ? lhvs.getVCSInterceptor() : this.nullVCSInterceptor;
        return new DelegatingInterceptor(vsInterceptor, localHistoryInterceptor, file, null, isDirectory);
    }

    private DelegatingInterceptor getInterceptor(File from, File to) {
        if (from == null || to == null) {
            return this.nullDelegatingInterceptor;
        }
        VersioningSystem vs = this.master.getOwner(from);
        VCSInterceptor vsInterceptor = vs != null ? vs.getVCSInterceptor() : this.nullVCSInterceptor;
        VersioningSystem lhvs = this.master.getLocalHistory(from);
        VCSInterceptor localHistoryInterceptor = lhvs != null ? lhvs.getVCSInterceptor() : this.nullVCSInterceptor;
        return new DelegatingInterceptor(vsInterceptor, localHistoryInterceptor, from, to, false);
    }

    private class DelegatingInterceptor
    implements ProvidedExtensions.IOHandler,
    ProvidedExtensions.DeleteHandler {
        final VCSInterceptor interceptor;
        final VCSInterceptor lhInterceptor;
        final File file;
        final File to;
        private final boolean isDirectory;

        private DelegatingInterceptor() {
            this(null, null, null, null, false);
        }

        public DelegatingInterceptor(VCSInterceptor interceptor, VCSInterceptor lhInterceptor, File file, File to, boolean isDirectory) {
            this.interceptor = interceptor != null ? interceptor : FilesystemInterceptor.this.nullVCSInterceptor;
            this.lhInterceptor = lhInterceptor != null ? lhInterceptor : FilesystemInterceptor.this.nullVCSInterceptor;
            this.file = file;
            this.to = to;
            this.isDirectory = isDirectory;
        }

        public boolean beforeDelete() {
            this.lhInterceptor.beforeDelete(this.file);
            return this.interceptor.beforeDelete(this.file);
        }

        public void doDelete() throws IOException {
            this.lhInterceptor.doDelete(this.file);
            this.interceptor.doDelete(this.file);
        }

        public void afterDelete() {
            this.lhInterceptor.afterDelete(this.file);
            this.interceptor.afterDelete(this.file);
        }

        public boolean beforeMove() {
            this.lhInterceptor.beforeMove(this.file, this.to);
            return this.interceptor.beforeMove(this.file, this.to);
        }

        public void doMove() throws IOException {
            this.lhInterceptor.doMove(this.file, this.to);
            this.interceptor.doMove(this.file, this.to);
        }

        public void afterMove() {
            this.lhInterceptor.afterMove(this.file, this.to);
            this.interceptor.afterMove(this.file, this.to);
        }

        public boolean beforeCreate() {
            this.lhInterceptor.beforeCreate(this.file, this.isDirectory);
            return this.interceptor.beforeCreate(this.file, this.isDirectory);
        }

        public void doCreate() throws IOException {
            this.lhInterceptor.doCreate(this.file, this.isDirectory);
            this.interceptor.doCreate(this.file, this.isDirectory);
        }

        public void afterCreate() {
            this.lhInterceptor.afterCreate(this.file);
            this.interceptor.afterCreate(this.file);
        }

        public void afterChange() {
            this.lhInterceptor.afterChange(this.file);
            this.interceptor.afterChange(this.file);
        }

        public void beforeChange() {
            this.lhInterceptor.beforeChange(this.file);
            this.interceptor.beforeChange(this.file);
        }

        public void handle() throws IOException {
            this.lhInterceptor.doMove(this.file, this.to);
            this.interceptor.doMove(this.file, this.to);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean delete(File file) {
            Set set;
            File[] children = file.listFiles();
            if (children != null) {
                set = FilesystemInterceptor.this.deletedFiles;
                synchronized (set) {
                    for (File child : children) {
                        if (FilesystemInterceptor.this.deletedFiles.contains(child)) continue;
                        return false;
                    }
                }
            }
            try {
                this.lhInterceptor.doDelete(file);
                this.interceptor.doDelete(file);
                set = FilesystemInterceptor.this.deletedFiles;
                synchronized (set) {
                    if (file.isDirectory()) {
                        Iterator i = FilesystemInterceptor.this.deletedFiles.iterator();
                        while (i.hasNext()) {
                            File fakedFile = (File)i.next();
                            if (!file.equals(fakedFile.getParentFile())) continue;
                            i.remove();
                        }
                    }
                    if (file.exists()) {
                        FilesystemInterceptor.this.deletedFiles.add(file);
                    } else {
                        FilesystemInterceptor.this.deletedFiles.remove(file);
                    }
                }
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
    }
}

