/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.modules.versioning.FlatFolder;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final RequestProcessor vcsBlockingRequestProcessor = new RequestProcessor("Versioning long tasks", 1);

    public static VCSContext contextForLookup(Lookup lookup) {
        Lookup.Result result = lookup.lookup(new Lookup.Template(Node.class));
        Collection nodes = result.allInstances();
        return VCSContext.forNodes(nodes.toArray(new Node[nodes.size()]));
    }

    public static VCSContext contextForFileObjects(Set<FileObject> files) {
        HashSet<File> roots = new HashSet<File>(files.size());
        if (files instanceof NonRecursiveFolder) {
            FileObject folder = ((NonRecursiveFolder)files).getFolder();
            roots.add(new FlatFolder(FileUtil.toFile((FileObject)folder).getAbsolutePath()));
        } else {
            for (FileObject fo : files) {
                roots.add(FileUtil.toFile((FileObject)fo));
            }
        }
        return VCSContext.forFiles(roots);
    }

    public static boolean isAncestorOrEqual(File ancestor, File file) {
        if (VersioningSupport.isFlat(ancestor)) {
            return ancestor.equals(file) || ancestor.equals(file.getParentFile()) && !file.isDirectory();
        }
        while (file != null) {
            if (file.equals(ancestor)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    public static JMenuItem toMenuItem(Action action) {
        JMenuItem item;
        if (action instanceof Presenter.Menu) {
            item = ((Presenter.Menu)action).getMenuPresenter();
        } else {
            item = new JMenuItem();
            Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
        }
        return item;
    }

    public static File getTempFolder() {
        File dir;
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        while ((dir = new File(tmpDir, "vcs-" + Long.toString(System.currentTimeMillis()))).exists() || !dir.mkdirs()) {
        }
        dir.deleteOnExit();
        return FileUtil.normalizeFile((File)dir);
    }

    public static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Utils.deleteRecursively(files[i]);
            }
        }
        file.delete();
    }

    public static boolean isLocalHistory(VersioningSystem system) {
        return system.getProperty("Boolean VCS.LocalHistory") != null;
    }

    public static Reader getDocumentReader(final Document doc) {
        final String[] str = new String[1];
        Runnable run = new Runnable(){

            public void run() {
                try {
                    str[0] = doc.getText(0, doc.getLength());
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        };
        doc.render(run);
        return new StringReader(str[0]);
    }

    public static RequestProcessor.Task createTask(Runnable runnable) {
        return vcsBlockingRequestProcessor.create(runnable);
    }

    public static String getDisplayName(VersioningSystem system) {
        return (String)system.getProperty("String VCS.DisplayName");
    }

    public static String getMenuLabel(VersioningSystem system) {
        return (String)system.getProperty("String VCS.MenuLabel");
    }
}

