/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningMainMenu
extends AbstractAction
implements DynamicMenuContent {
    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public JComponent[] getMenuPresenters() {
        return this.createMenu();
    }

    public JComponent[] synchMenuPresenters(JComponent[] items) {
        return this.createMenu();
    }

    private JComponent[] createMenu() {
        ArrayList<JComponent> items = new ArrayList<JComponent>(20);
        VCSContext ctx = VCSContext.forNodes(TopComponent.getRegistry().getActivatedNodes());
        List<VersioningSystem> systems = Arrays.asList(VersioningManager.getInstance().getVersioningSystems());
        VersioningSystem[] vs = VersioningManager.getInstance().getOwners(ctx);
        VersioningSystem ownerVS = null;
        if (vs.length == 1) {
            if (vs[0].getVCSAnnotator() != null) {
                ownerVS = vs[0];
                List<JComponent> systemItems = VersioningMainMenu.actionsToItems(vs[0].getVCSAnnotator().getActions(ctx, VCSAnnotator.ActionDestination.MainMenu));
                items.addAll(systemItems);
            }
            items.add(new JSeparator());
        } else if (vs.length > 1) {
            JMenuItem dummy = new JMenuItem("<multiple systems>");
            dummy.setEnabled(false);
            items.add(dummy);
            items.add(new JSeparator());
        }
        Collections.sort(systems, new Comparator<VersioningSystem>(){

            @Override
            public int compare(VersioningSystem a, VersioningSystem b) {
                return Utils.getDisplayName(a).compareTo(Utils.getDisplayName(b));
            }
        });
        VersioningSystem localHistory = null;
        for (VersioningSystem system : systems) {
            if (Utils.isLocalHistory(system)) {
                localHistory = system;
                continue;
            }
            JMenu menu = this.createVersioningSystemMenu(system, ctx);
            if (system == ownerVS) {
                menu.setEnabled(false);
            }
            items.add(menu);
        }
        if (localHistory != null) {
            items.add(new JSeparator());
            items.add(this.createVersioningSystemMenu(localHistory, ctx));
        }
        return items.toArray(new JComponent[items.size()]);
    }

    private JMenu createVersioningSystemMenu(final VersioningSystem system, final VCSContext ctx) {
        final JMenu menu = new JMenu();
        Mnemonics.setLocalizedText((AbstractButton)menu, (String)Utils.getMenuLabel(system));
        menu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                if (menu.getItemCount() != 0) {
                    return;
                }
                VersioningMainMenu.this.constructMenu(menu, system, ctx);
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
        return menu;
    }

    private void constructMenu(JMenu menu, VersioningSystem system, VCSContext ctx) {
        if (system.getVCSAnnotator() != null) {
            List<JComponent> systemItems = VersioningMainMenu.actionsToItems(system.getVCSAnnotator().getActions(ctx, VCSAnnotator.ActionDestination.MainMenu));
            for (JComponent systemItem : systemItems) {
                menu.add(systemItem);
            }
        }
    }

    private static List<JComponent> actionsToItems(Action[] actions) {
        ArrayList<JComponent> items = new ArrayList<JComponent>(actions.length);
        for (Action action : actions) {
            if (action == null) {
                items.add(new JSeparator());
                continue;
            }
            if (action instanceof DynamicMenuContent) {
                DynamicMenuContent dmc = (DynamicMenuContent)action;
                JComponent[] components = dmc.getMenuPresenters();
                items.addAll(Arrays.asList(components));
                continue;
            }
            JMenuItem item = Utils.toMenuItem(action);
            items.add(item);
        }
        return items;
    }
}

