/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.netbeans.modules.versioning.FilesystemInterceptor;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningAnnotationProvider;
import org.netbeans.modules.versioning.diff.DiffSidebarManager;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningManager
implements PropertyChangeListener,
LookupListener {
    public static final String EVENT_VERSIONED_ROOTS = "null VCS.VersionedFilesChanged";
    public static final String EVENT_STATUS_CHANGED = "Set<File> VCS.StatusChanged";
    public static final String EVENT_ANNOTATIONS_CHANGED = "Set<File> VCS.AnnotationsChanged";
    private static VersioningManager instance;
    private final FilesystemInterceptor filesystemInterceptor;
    private final Collection<VersioningSystem> versioningSystems = new ArrayList<VersioningSystem>(2);
    private final Map<File, VersioningSystem> folderOwners = new WeakHashMap<File, VersioningSystem>(100);
    private VersioningSystem localHistory;
    private Map<File, Boolean> localHistoryFolders = new WeakHashMap<File, Boolean>(100);
    private final VersioningSystem NULL_OWNER = new VersioningSystem(){

        public String getDisplayName() {
            return null;
        }
    };

    public static synchronized VersioningManager getInstance() {
        if (instance == null) {
            instance = new VersioningManager();
            instance.init();
        }
        return instance;
    }

    private VersioningManager() {
        this.filesystemInterceptor = new FilesystemInterceptor();
    }

    private void init() {
        this.initVersioningSystems();
        this.filesystemInterceptor.init(this);
    }

    private void initVersioningSystems() {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(VersioningSystem.class));
        this.refreshVersioningSystems(result.allInstances());
        result.addLookupListener((LookupListener)this);
    }

    private synchronized void refreshVersioningSystems(Collection<? extends VersioningSystem> systems) {
        this.unloadVersioningSystems();
        this.loadVersioningSystems(systems);
    }

    private void loadVersioningSystems(Collection<? extends VersioningSystem> systems) {
        assert (this.versioningSystems.size() == 0);
        assert (this.localHistory == null);
        this.versioningSystems.addAll(systems);
        for (VersioningSystem system : this.versioningSystems) {
            if (this.localHistory == null && Utils.isLocalHistory(system)) {
                this.localHistory = system;
            }
            system.addPropertyChangeListener(this);
        }
    }

    private void unloadVersioningSystems() {
        for (VersioningSystem system : this.versioningSystems) {
            system.removePropertyChangeListener(this);
        }
        this.versioningSystems.clear();
        this.localHistory = null;
    }

    InterceptionListener getInterceptionListener() {
        return this.filesystemInterceptor;
    }

    private void refreshDiffSidebars(Set<File> files) {
        DiffSidebarManager.getInstance().refreshSidebars(files);
    }

    private synchronized void flushFileOwnerCache() {
        this.folderOwners.clear();
        this.localHistoryFolders.clear();
    }

    synchronized VersioningSystem[] getVersioningSystems() {
        return this.versioningSystems.toArray(new VersioningSystem[this.versioningSystems.size()]);
    }

    VersioningSystem[] getOwners(VCSContext ctx) {
        Set<File> files = ctx.getRootFiles();
        HashSet<VersioningSystem> owners = new HashSet<VersioningSystem>();
        for (File file : files) {
            VersioningSystem vs = this.getOwner(file);
            if (vs == null) continue;
            owners.add(vs);
        }
        return owners.toArray(new VersioningSystem[owners.size()]);
    }

    public synchronized VersioningSystem getOwner(File file) {
        File folder = file;
        if (file.isFile() && (folder = file.getParentFile()) == null) {
            return null;
        }
        VersioningSystem owner = this.folderOwners.get(folder);
        if (owner == this.NULL_OWNER) {
            return null;
        }
        if (owner != null) {
            return owner;
        }
        File closestParent = null;
        for (VersioningSystem system : this.versioningSystems) {
            File topmost;
            if (system == this.localHistory || (topmost = system.getTopmostManagedAncestor(folder)) == null || closestParent != null && !Utils.isAncestorOrEqual(closestParent, topmost)) continue;
            owner = system;
            closestParent = topmost;
        }
        if (owner != null) {
            this.folderOwners.put(folder, owner);
        } else {
            this.folderOwners.put(folder, this.NULL_OWNER);
        }
        return owner;
    }

    synchronized VersioningSystem getLocalHistory(File file) {
        boolean isManaged;
        if (this.localHistory == null) {
            return null;
        }
        File folder = file;
        if (file.isFile() && (folder = file.getParentFile()) == null) {
            return null;
        }
        Boolean isManagedByLocalHistory = this.localHistoryFolders.get(folder);
        if (isManagedByLocalHistory != null) {
            return isManagedByLocalHistory != false ? this.localHistory : null;
        }
        boolean bl = isManaged = this.localHistory.getTopmostManagedAncestor(folder) != null;
        if (isManaged) {
            this.localHistoryFolders.put(folder, Boolean.TRUE);
            return this.localHistory;
        }
        this.localHistoryFolders.put(folder, Boolean.FALSE);
        return null;
    }

    public void resultChanged(LookupEvent ev) {
        Lookup.Result result = (Lookup.Result)ev.getSource();
        this.refreshVersioningSystems(result.allInstances());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (EVENT_STATUS_CHANGED.equals(evt.getPropertyName())) {
            Set files = (Set)evt.getNewValue();
            VersioningAnnotationProvider.instance.refreshAnnotations(files);
            this.refreshDiffSidebars(files);
        } else if (EVENT_ANNOTATIONS_CHANGED.equals(evt.getPropertyName())) {
            Set files = (Set)evt.getNewValue();
            VersioningAnnotationProvider.instance.refreshAnnotations(files);
        } else if (EVENT_VERSIONED_ROOTS.equals(evt.getPropertyName())) {
            this.flushFileOwnerCache();
            this.refreshDiffSidebars(null);
        }
    }
}

