/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProvider;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningConfig;
import org.netbeans.modules.versioning.diff.DiffSidebar;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffSidebarManager
implements PreferenceChangeListener {
    static final String SIDEBAR_ENABLED = "diff.sidebarEnabled";
    private static DiffSidebarManager instance;
    private boolean sidebarEnabled;
    private final Map<DiffSidebar, Object> sideBars = new WeakHashMap<DiffSidebar, Object>();

    public static synchronized DiffSidebarManager getInstance() {
        if (instance == null) {
            instance = new DiffSidebarManager();
        }
        return instance;
    }

    private DiffSidebarManager() {
        this.sidebarEnabled = VersioningConfig.getDefault().getPreferences().getBoolean(SIDEBAR_ENABLED, true);
        VersioningConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
    }

    public void refreshSidebars(final Set<File> files) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HashSet<FileObject> fileObjects = null;
                if (files != null) {
                    fileObjects = new HashSet<FileObject>(files.size());
                    for (File file : files) {
                        fileObjects.add(FileUtil.toFileObject((File)file));
                    }
                    fileObjects.remove(null);
                }
                Map map = DiffSidebarManager.this.sideBars;
                synchronized (map) {
                    for (DiffSidebar bar : DiffSidebarManager.this.sideBars.keySet()) {
                        if (!DiffSidebarManager.this.matches(bar, fileObjects)) continue;
                        bar.refresh();
                    }
                }
            }
        });
    }

    private boolean matches(DiffSidebar sidebar, Set<FileObject> fileObjects) {
        if (fileObjects == null) {
            return true;
        }
        for (FileObject fileObject : fileObjects) {
            if (!sidebar.getFileObject().equals(fileObject)) continue;
            return true;
        }
        return false;
    }

    RequestProcessor.Task createDiffSidebarTask(Runnable runnable) {
        return Utils.createTask(runnable);
    }

    JComponent createSideBar(JTextComponent target) {
        return this.getSideBar(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiffSidebar getSideBar(JTextComponent target) {
        Map<DiffSidebar, Object> map = this.sideBars;
        synchronized (map) {
            DiffSidebar sideBar = null;
            for (DiffSidebar bar : this.sideBars.keySet()) {
                if (bar.getTextComponent() != target) continue;
                sideBar = bar;
                break;
            }
            if (sideBar == null) {
                File file = null;
                Document doc = target.getDocument();
                DataObject dobj = (DataObject)doc.getProperty("stream");
                if (dobj != null) {
                    FileObject fo = dobj.getPrimaryFile();
                    file = FileUtil.toFile((FileObject)fo);
                }
                if (file == null) {
                    return null;
                }
                sideBar = new DiffSidebar(target, file);
                this.sideBars.put(sideBar, null);
                sideBar.setSidebarVisible(this.sidebarEnabled);
            }
            return sideBar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSidebarEnabled(boolean enable) {
        Map<DiffSidebar, Object> map = this.sideBars;
        synchronized (map) {
            for (DiffSidebar sideBar : this.sideBars.keySet()) {
                sideBar.setSidebarVisible(enable);
            }
            this.sidebarEnabled = enable;
        }
    }

    MarkProvider createMarkProvider(JTextComponent target) {
        DiffSidebar sideBar = this.getSideBar(target);
        return sideBar != null ? sideBar.getMarkProvider() : null;
    }

    DiffSidebar t9y_getSidebar() {
        return this.sideBars.keySet().iterator().next();
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().equals(SIDEBAR_ENABLED)) {
            this.setSidebarEnabled(Boolean.valueOf(evt.getNewValue()));
        }
    }
}

