/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import org.netbeans.api.diff.Difference;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;

class DiffTooltipContentPanel
extends JComponent {
    public DiffTooltipContentPanel(JTextComponent parentPane, String mimeType, Difference diff) {
        JEditorPane originalTextPane = new JEditorPane();
        EditorKit kit = CloneableEditorSupport.getEditorKit((String)mimeType);
        originalTextPane.setEditorKit(kit);
        Document xdoc = kit.createDefaultDocument();
        if (!(xdoc instanceof StyledDocument)) {
            xdoc = new DefaultStyledDocument(new StyleContext());
            kit = new StyledEditorKit();
            originalTextPane.setEditorKit(kit);
        }
        StyledDocument doc = (StyledDocument)xdoc;
        try {
            kit.read(new StringReader(diff.getFirstText()), (Document)doc, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        originalTextPane.setDocument(doc);
        originalTextPane.setEditable(false);
        Color color = diff.getType() == 0 ? new Color(255, 225, 232) : new Color(233, 241, 255);
        originalTextPane.setBackground(color);
        EditorUI eui = Utilities.getEditorUI((JTextComponent)originalTextPane);
        Element rootElement = NbDocument.findLineRootElement((StyledDocument)doc);
        int lineCount = rootElement.getElementCount();
        int height = eui.getLineHeight() * lineCount;
        int maxWidth = 0;
        for (int line = 0; line < lineCount; ++line) {
            Element lineElement = rootElement.getElement(line);
            String text = null;
            try {
                text = doc.getText(lineElement.getStartOffset(), lineElement.getEndOffset() - lineElement.getStartOffset());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            int lineLength = parentPane.getFontMetrics(parentPane.getFont()).stringWidth(text);
            if (lineLength <= maxWidth) continue;
            maxWidth = lineLength;
        }
        if (maxWidth < 50) {
            maxWidth = 50;
        }
        originalTextPane.setPreferredSize(new Dimension(maxWidth * 7 / 6, height));
        if (!originalTextPane.isEditable()) {
            originalTextPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
        }
        JScrollPane jsp = new JScrollPane(originalTextPane);
        jsp.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK));
        this.setLayout(new BorderLayout());
        this.add(jsp);
    }
}

