/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.modules.editor.settings.storage.ColoringStorage;
import org.netbeans.modules.editor.settings.storage.FontColorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.KeyBindingSettingsImpl;
import org.netbeans.modules.editor.settings.storage.MimeTypesTracker;
import org.netbeans.modules.editor.settings.storage.ProfilesTracker;
import org.netbeans.modules.editor.settings.storage.SettingsType;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.FontColorSettingsFactory;
import org.netbeans.modules.editor.settings.storage.api.KeyBindingSettingsFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorSettingsImpl
extends EditorSettings {
    private static final Logger LOG = Logger.getLogger(EditorSettingsImpl.class.getName());
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public static final String PROP_HIGHLIGHT_COLORINGS = "editorFontColors";
    public static final String PROP_TOKEN_COLORINGS = "fontColors";
    public static final String DEFAULT_PROFILE = "NetBeans";
    private static final String FATTR_CURRENT_FONT_COLOR_PROFILE = "currentFontColorProfile";
    private static final String FATTR_CURRENT_KEYMAP_PROFILE = "currentKeymap";
    private static final String EDITORS_FOLDER = "Editors";
    private static final String KEYMAPS_FOLDER = "Keymaps";
    public static final String TEXT_BASE_MIME_TYPE = "text/base";
    private static final String[] EMPTY = new String[0];
    private static EditorSettingsImpl instance = null;
    private final MimeTypesTracker topLevelMimeTypes = new MimeTypesTracker("Editors", null);
    private final HashMap<SettingsType, MimeTypesTracker> settingMimeTypes = new HashMap();
    private final HashMap<SettingsType, ProfilesTracker> settingProfiles = new HashMap();
    private String currentFontColorProfile;
    private Map<String, Map<String, AttributeSet>> highlightings = new HashMap<String, Map<String, AttributeSet>>();
    private Map<String, Map<String, AttributeSet>> highlightingDefaults = new HashMap<String, Map<String, AttributeSet>>();
    private String currentKeyMapProfile;

    public static synchronized EditorSettingsImpl getInstance() {
        if (instance == null) {
            instance = new EditorSettingsImpl();
        }
        return instance;
    }

    @Override
    public Set<String> getAllMimeTypes() {
        return this.topLevelMimeTypes.getMimeTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimeTypesTracker getMimeTypesTracker(Class settingApiClass) {
        SettingsType type = SettingsType.get(settingApiClass);
        assert (type != null) : "Invalid editor settings API class: " + settingApiClass;
        HashMap<SettingsType, MimeTypesTracker> hashMap = this.settingMimeTypes;
        synchronized (hashMap) {
            MimeTypesTracker tracker = this.settingMimeTypes.get((Object)type);
            if (tracker == null) {
                tracker = new MimeTypesTracker(EDITORS_FOLDER, type);
                this.settingMimeTypes.put(type, tracker);
            }
            return tracker;
        }
    }

    @Override
    public Set<String> getMimeTypes() {
        return this.getMimeTypesTracker(FontColorSettings.class).getMimeTypes();
    }

    @Override
    public String getLanguageName(String mimeType) {
        return this.topLevelMimeTypes.getMimeTypeDisplayName(mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfilesTracker getProfilesTracker(Class settingApiClass) {
        SettingsType type = SettingsType.get(settingApiClass);
        assert (type != null) : "Invalid editor settings API class: " + settingApiClass;
        HashMap<SettingsType, ProfilesTracker> hashMap = this.settingProfiles;
        synchronized (hashMap) {
            ProfilesTracker tracker = this.settingProfiles.get((Object)type);
            if (tracker == null) {
                tracker = new ProfilesTracker(type, this.topLevelMimeTypes);
                this.settingProfiles.put(type, tracker);
            }
            return tracker;
        }
    }

    String getInternalFontColorProfile(String profile) {
        ProfilesTracker tracker = this.getProfilesTracker(FontColorSettings.class);
        ProfilesTracker.ProfileDescription pd = tracker.getProfileByDisplayName(profile);
        return pd == null ? profile : pd.getId();
    }

    String getInternalKeymapProfile(String profile) {
        ProfilesTracker tracker = this.getProfilesTracker(KeyBindingSettings.class);
        ProfilesTracker.ProfileDescription pd = tracker.getProfileByDisplayName(profile);
        return pd == null ? profile : pd.getId();
    }

    void notifyTokenFontColorChange(MimePath mimePath, String profile) {
        this.pcs.firePropertyChange(PROP_TOKEN_COLORINGS, mimePath, profile);
    }

    @Override
    public Set<String> getFontColorProfiles() {
        return this.getProfilesTracker(FontColorSettings.class).getProfilesDisplayNames();
    }

    @Override
    public boolean isCustomFontColorProfile(String profile) {
        ProfilesTracker tracker = this.getProfilesTracker(FontColorSettings.class);
        ProfilesTracker.ProfileDescription pd = tracker.getProfileByDisplayName(profile);
        return pd != null && !pd.isRollbackAllowed();
    }

    @Override
    public String getCurrentFontColorProfile() {
        if (this.currentFontColorProfile == null) {
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            FileObject fo = fs.findResource(EDITORS_FOLDER);
            if (fo != null) {
                this.currentFontColorProfile = (String)fo.getAttribute(FATTR_CURRENT_FONT_COLOR_PROFILE);
            }
            if (this.currentFontColorProfile == null) {
                this.currentFontColorProfile = DEFAULT_PROFILE;
            }
        }
        if (!this.getFontColorProfiles().contains(this.currentFontColorProfile)) {
            this.currentFontColorProfile = DEFAULT_PROFILE;
        }
        return this.currentFontColorProfile;
    }

    @Override
    public void setCurrentFontColorProfile(String profile) {
        String oldProfile = this.getCurrentFontColorProfile();
        if (oldProfile.equals(profile)) {
            return;
        }
        this.currentFontColorProfile = profile;
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject fo = fs.findResource(EDITORS_FOLDER);
        if (fo != null) {
            try {
                fo.setAttribute(FATTR_CURRENT_FONT_COLOR_PROFILE, (Object)profile);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Can't persist change in current font&colors profile.", ex);
            }
        }
        this.pcs.firePropertyChange(FATTR_CURRENT_FONT_COLOR_PROFILE, oldProfile, this.currentFontColorProfile);
    }

    @Override
    public Collection<AttributeSet> getDefaultFontColors(String profile) {
        return this.getFontColorSettings(new String[0]).getAllFontColors(profile);
    }

    @Override
    public Collection<AttributeSet> getDefaultFontColorDefaults(String profile) {
        return this.getFontColorSettings(new String[0]).getAllFontColorDefaults(profile);
    }

    @Override
    public void setDefaultFontColors(String profile, Collection<AttributeSet> fontColors) {
        this.getFontColorSettings(new String[0]).setAllFontColors(profile, fontColors);
    }

    @Override
    public Map<String, AttributeSet> getHighlightings(String profile) {
        if (!this.highlightings.containsKey(profile = this.getInternalFontColorProfile(profile))) {
            if (profile.startsWith("test")) {
                this.highlightings.put(profile, this.getHighlightings(DEFAULT_PROFILE));
            } else {
                Map<String, AttributeSet> m = ColoringStorage.loadColorings(MimePath.EMPTY, profile, false, false);
                this.highlightings.put(profile, m);
            }
        }
        if (this.highlightings.get(profile) == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.highlightings.get(profile));
    }

    @Override
    public Map<String, AttributeSet> getHighlightingDefaults(String profile) {
        if (!this.highlightingDefaults.containsKey(profile = this.getInternalFontColorProfile(profile))) {
            Map<String, AttributeSet> m = ColoringStorage.loadColorings(MimePath.EMPTY, profile, false, true);
            this.highlightingDefaults.put(profile, m);
        }
        if (this.highlightingDefaults.get(profile) == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.highlightingDefaults.get(profile));
    }

    @Override
    public void setHighlightings(String profile, Map<String, AttributeSet> fontColors) {
        String internalProfile = this.getInternalFontColorProfile(profile);
        if (fontColors == null) {
            ColoringStorage.deleteColorings(MimePath.EMPTY, internalProfile, false, false);
            this.highlightings.remove(internalProfile);
        } else {
            if (((Object)fontColors).equals(this.highlightings.get(internalProfile))) {
                return;
            }
            fontColors = Utils.immutize(fontColors);
            this.highlightings.put(internalProfile, fontColors);
            if (!internalProfile.startsWith("test")) {
                ColoringStorage.saveColorings(MimePath.EMPTY, internalProfile, false, false, fontColors.values());
            }
        }
        this.pcs.firePropertyChange(PROP_HIGHLIGHT_COLORINGS, MimePath.EMPTY, internalProfile);
    }

    @Override
    public Set<String> getKeyMapProfiles() {
        return this.getProfilesTracker(KeyBindingSettings.class).getProfilesDisplayNames();
    }

    @Override
    public boolean isCustomKeymapProfile(String profile) {
        ProfilesTracker tracker = this.getProfilesTracker(KeyBindingSettings.class);
        ProfilesTracker.ProfileDescription pd = tracker.getProfileByDisplayName(profile);
        return pd == null || !pd.isRollbackAllowed();
    }

    @Override
    public String getCurrentKeyMapProfile() {
        if (this.currentKeyMapProfile == null) {
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            FileObject fo = fs.findResource(KEYMAPS_FOLDER);
            String string = this.currentKeyMapProfile = fo == null ? null : (String)fo.getAttribute(FATTR_CURRENT_KEYMAP_PROFILE);
            if (this.currentKeyMapProfile == null) {
                this.currentKeyMapProfile = DEFAULT_PROFILE;
            }
        }
        return this.currentKeyMapProfile;
    }

    @Override
    public void setCurrentKeyMapProfile(String keyMapName) {
        String oldKeyMap = this.getCurrentKeyMapProfile();
        if (oldKeyMap.equals(keyMapName)) {
            return;
        }
        this.currentKeyMapProfile = keyMapName;
        try {
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            FileObject fo = fs.findResource(KEYMAPS_FOLDER);
            if (fo == null) {
                fo = fs.getRoot().createFolder(KEYMAPS_FOLDER);
            }
            fo.setAttribute(FATTR_CURRENT_KEYMAP_PROFILE, (Object)keyMapName);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Can't persist change in current keybindings profile.", ex);
        }
        this.pcs.firePropertyChange("currentKeyMapProfile", oldKeyMap, this.currentKeyMapProfile);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(propertyName, l);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(propertyName, l);
    }

    private EditorSettingsImpl() {
    }

    @Override
    public KeyBindingSettingsFactory getKeyBindingSettings(String[] mimeTypes) {
        mimeTypes = this.filter(mimeTypes);
        return KeyBindingSettingsImpl.get(Utils.mimeTypes2mimePath(mimeTypes));
    }

    @Override
    public FontColorSettingsFactory getFontColorSettings(String[] mimeTypes) {
        mimeTypes = this.filter(mimeTypes);
        return FontColorSettingsImpl.get(Utils.mimeTypes2mimePath(mimeTypes));
    }

    private String[] filter(String[] mimeTypes) {
        if (mimeTypes.length > 0) {
            String[] filtered = mimeTypes;
            if (mimeTypes[0].contains(TEXT_BASE_MIME_TYPE)) {
                if (mimeTypes.length == 1) {
                    filtered = EMPTY;
                } else {
                    filtered = new String[mimeTypes.length - 1];
                    System.arraycopy(mimeTypes, 1, filtered, 0, mimeTypes.length - 1);
                }
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "text/base has been deprecated, use MimePath.EMPTY instead.");
                }
            } else if (mimeTypes[0].startsWith("test")) {
                filtered = new String[mimeTypes.length];
                System.arraycopy(mimeTypes, 0, filtered, 0, mimeTypes.length);
                filtered[0] = mimeTypes[0].substring(mimeTypes[0].indexOf(95) + 1);
                LOG.log(Level.INFO, "Don't use 'test' mime type to access settings through the editor/settings/storage API!", new Throwable("Stacktrace"));
            }
            return filtered;
        }
        return mimeTypes;
    }
}

