/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.settings.storage.ColoringStorage;
import org.netbeans.modules.editor.settings.storage.EditorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.api.FontColorSettingsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FontColorSettingsImpl
extends FontColorSettingsFactory {
    private static final Logger LOG = Logger.getLogger(FontColorSettingsImpl.class.getName());
    private static final Map<MimePath, WeakReference<FontColorSettingsImpl>> INSTANCES = new WeakHashMap<MimePath, WeakReference<FontColorSettingsImpl>>();
    private final MimePath mimePath;
    private final Map<String, Map<String, AttributeSet>> colorings = new HashMap<String, Map<String, AttributeSet>>();
    private final Map<String, Map<String, AttributeSet>> defaults = new HashMap<String, Map<String, AttributeSet>>();

    public static synchronized FontColorSettingsImpl get(MimePath mimePath) {
        FontColorSettingsImpl result;
        WeakReference<FontColorSettingsImpl> reference = INSTANCES.get(mimePath);
        FontColorSettingsImpl fontColorSettingsImpl = result = reference == null ? null : (FontColorSettingsImpl)reference.get();
        if (result == null) {
            result = new FontColorSettingsImpl(mimePath);
            INSTANCES.put(mimePath, new WeakReference<FontColorSettingsImpl>(result));
        }
        return result;
    }

    private FontColorSettingsImpl(MimePath mimePath) {
        this.mimePath = mimePath;
    }

    public MimePath getMimePath() {
        return this.mimePath;
    }

    @Override
    public Collection<AttributeSet> getAllFontColors(String profile) {
        profile = EditorSettingsImpl.getInstance().getInternalFontColorProfile(profile);
        Map<String, AttributeSet> m = this.getColorings(profile);
        return Collections.unmodifiableCollection(m.values());
    }

    @Override
    public Collection<AttributeSet> getAllFontColorDefaults(String profile) {
        profile = EditorSettingsImpl.getInstance().getInternalFontColorProfile(profile);
        Map<String, AttributeSet> m = this.getDefaultColorings(profile);
        return Collections.unmodifiableCollection(m.values());
    }

    @Override
    public void setAllFontColors(String profile, Collection<AttributeSet> fontColors) {
        LOG.fine("set " + profile);
        boolean specialProfile = profile.startsWith("test");
        profile = EditorSettingsImpl.getInstance().getInternalFontColorProfile(profile);
        if (fontColors == null) {
            ColoringStorage.deleteColorings(this.mimePath, profile, true, false);
            this.colorings.remove(profile);
        } else {
            Map<String, AttributeSet> map = Utils.immutize(fontColors);
            if (!specialProfile) {
                ColoringStorage.saveColorings(this.mimePath, profile, true, false, map.values());
            }
            this.colorings.put(profile, map);
        }
        EditorSettingsImpl.getInstance().notifyTokenFontColorChange(this.mimePath, profile);
    }

    @Override
    public void setAllFontColorsDefaults(String profile, Collection<AttributeSet> fontColors) {
        LOG.fine("set defaults " + profile);
        boolean specialProfile = profile.startsWith("test");
        profile = EditorSettingsImpl.getInstance().getInternalFontColorProfile(profile);
        if (fontColors == null) {
            ColoringStorage.deleteColorings(this.mimePath, profile, true, true);
            this.defaults.remove(profile);
        } else {
            Map<String, AttributeSet> map = Utils.immutize(fontColors);
            if (!specialProfile) {
                ColoringStorage.saveColorings(this.mimePath, profile, true, true, map.values());
            }
            this.defaults.put(profile, map);
        }
        EditorSettingsImpl.getInstance().notifyTokenFontColorChange(this.mimePath, profile);
    }

    Map<String, AttributeSet> getColorings(String profile) {
        Map<String, AttributeSet> c;
        if (!this.colorings.containsKey(profile)) {
            boolean specialProfile = profile.startsWith("test");
            Map<String, AttributeSet> m = ColoringStorage.loadColorings(this.mimePath, specialProfile ? "NetBeans" : profile, true, false);
            if (m == null) {
                m = ColoringStorage.loadColorings(this.mimePath, "NetBeans", true, false);
            }
            this.colorings.put(profile, m);
        }
        return (c = this.colorings.get(profile)) == null ? Collections.emptyMap() : c;
    }

    Map<String, AttributeSet> getDefaultColorings(String profile) {
        Map<String, AttributeSet> c;
        if (!this.defaults.containsKey(profile)) {
            Map<String, AttributeSet> m = ColoringStorage.loadColorings(this.mimePath, profile, true, true);
            this.defaults.put(profile, m);
        }
        return (c = this.defaults.get(profile)) == null ? Collections.emptyMap() : c;
    }
}

