/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.editor.settings.storage.SettingsType;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MimeTypesTracker {
    private static final Logger LOG = Logger.getLogger(MimeTypesTracker.class.getName());
    private static final Pattern REG_NAME_PATTERN = Pattern.compile("^[[\\p{Alnum}][!#$&.+\\-^_]]{1,127}$");
    private static final Set<String> WELL_KNOWN_TYPES = new HashSet<String>(Arrays.asList("application", "audio", "image", "message", "model", "multipart", "text", "video"));
    private static final String ATTR_MIME_TYPE_FOLDER_MARKER = "org-netbeans-editor-MimeTypeDefinition";
    public static final String PROP_MIME_TYPES = "mime-types";
    private final String LOCK = new String("MimeTypesTracker.LOCK");
    private final String basePath;
    private final String[] basePathElements;
    private final SettingsType.Locator locator;
    private FileObject folder;
    private boolean isBaseFolder;
    private Map<String, String> mimeTypes = Collections.emptyMap();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final FileChangeListener listener;

    public MimeTypesTracker(String basePath, SettingsType settingsType) {
        this.basePath = basePath;
        this.basePathElements = basePath.split("/");
        this.locator = settingsType == null ? null : settingsType.getLocator();
        this.rebuild();
        this.listener = new Listener();
        FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
        sfs.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.listener, (Object)sfs));
    }

    public String getBasePath() {
        return this.basePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getMimeTypes() {
        String string = this.LOCK;
        synchronized (string) {
            return this.mimeTypes.keySet();
        }
    }

    public String getMimeTypeDisplayName(String mimeType) {
        String displayName = this.mimeTypes.get(mimeType);
        return displayName == null ? mimeType : displayName;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuild() {
        PropertyChangeEvent event = null;
        String string = this.LOCK;
        synchronized (string) {
            Object[] ret = MimeTypesTracker.findTarget(this.basePathElements);
            FileObject f = (FileObject)ret[0];
            boolean isBase = (Boolean)ret[1];
            if (f != this.folder) {
                this.folder = f;
                this.isBaseFolder = isBase;
                LOG.finest("folder = '" + this.folder.getPath() + "'");
                LOG.finest("isBaseFolder = '" + this.isBaseFolder + "'");
            }
            if (this.isBaseFolder) {
                Map<String, String> newMimeTypes = new HashMap();
                FileObject[] types = this.folder.getChildren();
                for (int i = 0; i < types.length; ++i) {
                    if (!MimeTypesTracker.isValidType(types[i])) continue;
                    FileObject[] subTypes = types[i].getChildren();
                    for (int j = 0; j < subTypes.length; ++j) {
                        boolean add;
                        if (!MimeTypesTracker.isValidSubtype(subTypes[j])) continue;
                        String mimeType = types[i].getNameExt() + "/" + subTypes[j].getNameExt();
                        if (this.locator != null) {
                            HashMap<String, List<Object[]>> scan = new HashMap<String, List<Object[]>>();
                            this.locator.scan(this.folder, mimeType, null, false, true, true, scan);
                            add = !scan.isEmpty();
                        } else {
                            add = true;
                        }
                        if (!add) continue;
                        String displayName = Utils.getLocalizedName(subTypes[j], null);
                        if (displayName == null) {
                            displayName = Utils.getLocalizedName(subTypes[j], mimeType, mimeType);
                        }
                        newMimeTypes.put(mimeType, displayName);
                    }
                }
                if (!((Object)this.mimeTypes).equals(newMimeTypes = Collections.unmodifiableMap(newMimeTypes))) {
                    event = new PropertyChangeEvent(this, PROP_MIME_TYPES, this.mimeTypes, newMimeTypes);
                    this.mimeTypes = newMimeTypes;
                }
            }
        }
        if (event != null) {
            this.pcs.firePropertyChange(event);
        }
    }

    private static boolean isValidType(FileObject typeFile) {
        if (!typeFile.isFolder()) {
            return false;
        }
        String typeName = typeFile.getNameExt();
        if (!MimeTypesTracker.isValidRegName(typeName)) {
            return false;
        }
        if (WELL_KNOWN_TYPES.contains(typeName)) {
            return true;
        }
        Object marker = typeFile.getAttribute(ATTR_MIME_TYPE_FOLDER_MARKER);
        return marker instanceof Boolean && (Boolean)marker != false;
    }

    private static boolean isValidSubtype(FileObject subtypeFile) {
        if (!subtypeFile.isFolder()) {
            return false;
        }
        String typeName = subtypeFile.getNameExt();
        return MimeTypesTracker.isValidRegName(typeName) && !typeName.equals("base");
    }

    private static boolean isValidRegName(String name) {
        Matcher m = REG_NAME_PATTERN.matcher(name);
        return m.matches();
    }

    private static Object[] findTarget(String[] path) {
        FileObject f;
        FileObject target = Repository.getDefault().getDefaultFileSystem().getRoot();
        boolean isTarget = 0 == path.length;
        for (int i = 0; i < path.length && (f = target.getFileObject(path[i])) != null && f.isFolder() && f.isValid() && !f.isVirtual(); ++i) {
            target = f;
            isTarget = i + 1 == path.length;
        }
        return new Object[]{target, isTarget};
    }

    private final class Listener
    extends FileChangeAdapter {
        public void fileFolderCreated(FileEvent fe) {
            this.notifyRebuild(fe.getFile());
        }

        public void fileDeleted(FileEvent fe) {
            this.notifyRebuild(fe.getFile());
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.notifyRebuild(fe.getFile());
        }

        private void notifyRebuild(FileObject f) {
            String path = f.getPath();
            if (path.startsWith(MimeTypesTracker.this.basePath)) {
                MimeTypesTracker.this.rebuild();
            }
        }
    }
}

