/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLStorage {
    private static final Logger LOG = Logger.getLogger(XMLStorage.class.getName());

    private XMLStorage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(FileObject fo, Document doc) {
        assert (fo != null) : "FileObject can't be null";
        assert (doc != null) : "Document can't be null";
        try {
            FileLock lock = fo.lock();
            try {
                OutputStream os = fo.getOutputStream(lock);
                try {
                    XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
                }
                finally {
                    os.close();
                }
            }
            finally {
                lock.releaseLock();
            }
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Can't save editor settings to " + fo.getPath(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object load(FileObject fo, Handler handler) {
        assert (fo != null) : "Settings file must not be null";
        handler.setProcessedFile(fo);
        try {
            XMLReader reader = XMLUtil.createXMLReader((boolean)true);
            reader.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
            reader.setContentHandler(handler);
            reader.setErrorHandler(handler);
            InputStream is = fo.getInputStream();
            try {
                reader.parse(new InputSource(is));
            }
            finally {
                is.close();
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Invalid or corrupted file: " + fo.getPath(), ex);
        }
        finally {
            handler.setProcessedFile(null);
        }
        return handler.getResult();
    }

    public static class Handler
    extends DefaultHandler {
        private FileObject file;
        private boolean isModuleFile;
        private Object result;

        public void setResult(Object result) {
            this.result = result;
        }

        public Object getResult() {
            return this.result;
        }

        public void warning(SAXParseException e) throws SAXException {
            this.log("warning", e);
        }

        public void error(SAXParseException e) throws SAXException {
            this.log("error", e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            this.log("fatal error", e);
            throw e;
        }

        private void log(String errorType, SAXParseException e) {
            if (this.file == null) {
                LOG.log(Level.FINE, "XML parser " + errorType, e);
            } else {
                Level level = this.isModuleFile() ? Level.WARNING : Level.FINE;
                LOG.log(level, "XML parser " + errorType + " in file " + this.file.getPath(), e);
            }
        }

        protected final FileObject getProcessedFile() {
            return this.file;
        }

        protected final boolean isModuleFile() {
            return this.isModuleFile;
        }

        private void setProcessedFile(FileObject f) {
            FileObject parent;
            this.file = f;
            this.isModuleFile = this.file != null ? (parent = this.file.getParent()) != null && parent.getNameExt().contains("Default") : false;
        }
    }
}

