/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.extbrowser.DelegatingWebBrowserImpl;
import org.netbeans.modules.extbrowser.NbBrowserException;
import org.netbeans.modules.extbrowser.NbDdeBrowserImpl;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ExtWebBrowser
implements HtmlBrowser.Factory,
Serializable,
PropertyChangeListener {
    private static final long serialVersionUID = -3021027901671504127L;
    public static final String PROP_NAME = "name";
    public static final String PROP_BROWSER_EXECUTABLE = "browserExecutable";
    public static final String PROP_DDESERVER = "dDEServer";
    public static final String PROP_DDE_ACTIVATE_TIMEOUT = "activateTimeout";
    public static final String PROP_DDE_OPENURL_TIMEOUT = "openurlTimeout";
    public static final String NETSCAPE = "NETSCAPE";
    public static final String IEXPLORE = "IEXPLORE";
    public static final String MOZILLA = "MOZILLA";
    public static final String FIREFOX = "FIREFOX";
    public static final String NETSCAPE6 = "NETSCAPE6";
    protected static final int DEFAULT_ACTIVATE_TIMEOUT = 2000;
    protected static final int DEFAULT_OPENURL_TIMEOUT = 3000;
    protected String ddeServer;
    protected int activateTimeout = 2000;
    protected int openurlTimeout = 3000;
    private static ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.extbrowser");
    protected String name;
    protected NbProcessDescriptor browserExecutable;
    protected transient PropertyChangeSupport pcs;

    public static ErrorManager getEM() {
        return err;
    }

    public ExtWebBrowser() {
        this.init();
    }

    private void init() {
        if (err.isLoggable(1)) {
            err.log(1, this.getClass().getName() + " " + System.currentTimeMillis() + "> init");
        }
        this.pcs = new PropertyChangeSupport(this);
        if (Utilities.isWindows()) {
            this.pcs.addPropertyChangeListener(this);
        }
    }

    public String getDDEServer() {
        return this.ddeServer;
    }

    public void setDDEServer(String ddeServer) {
        if (ddeServer != null && !ddeServer.equals(this.ddeServer)) {
            String old = this.ddeServer;
            this.ddeServer = ddeServer;
            this.pcs.firePropertyChange(PROP_DDESERVER, old, ddeServer);
            ExtWebBrowser.getEM().log("DDEServer changed to: " + ddeServer);
        }
    }

    public int getOpenurlTimeout() {
        return this.openurlTimeout;
    }

    public void setOpenurlTimeout(int openurlTimeout) {
        if (openurlTimeout != this.openurlTimeout) {
            int oldVal = this.openurlTimeout;
            this.openurlTimeout = openurlTimeout;
            this.pcs.firePropertyChange(PROP_DDE_OPENURL_TIMEOUT, oldVal, openurlTimeout);
        }
    }

    public int getActivateTimeout() {
        return this.activateTimeout;
    }

    public void setActivateTimeout(int activateTimeout) {
        if (activateTimeout != this.activateTimeout) {
            int oldVal = this.activateTimeout;
            this.activateTimeout = activateTimeout;
            this.pcs.firePropertyChange(PROP_DDE_ACTIVATE_TIMEOUT, oldVal, activateTimeout);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null && !name.equals(this.name)) {
            String oldVal = this.name;
            this.name = name;
            this.pcs.firePropertyChange(PROP_NAME, oldVal, name);
        }
    }

    public NbProcessDescriptor getBrowserExecutable() {
        if (this.browserExecutable == null || "".equals(this.browserExecutable.getProcessName())) {
            return this.defaultBrowserExecutable();
        }
        return this.browserExecutable;
    }

    public void setBrowserExecutable(NbProcessDescriptor browserExecutable) {
        NbProcessDescriptor oldVal;
        if (browserExecutable != null && !browserExecutable.equals((Object)this.browserExecutable)) {
            oldVal = this.browserExecutable;
            this.browserExecutable = browserExecutable;
            this.pcs.firePropertyChange(PROP_BROWSER_EXECUTABLE, oldVal, browserExecutable);
        }
        if (browserExecutable == null) {
            oldVal = this.browserExecutable;
            this.browserExecutable = this.defaultBrowserExecutable();
            this.pcs.firePropertyChange(PROP_BROWSER_EXECUTABLE, oldVal, browserExecutable);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Object np;
        if (evt.getPropertyName().equals(PROP_BROWSER_EXECUTABLE) && (np = evt.getNewValue()) != null && np instanceof NbProcessDescriptor) {
            String processName = ((NbProcessDescriptor)np).getProcessName();
            if (err.isLoggable(1)) {
                err.log(1, "" + System.currentTimeMillis() + "> propertychange: " + processName);
            }
            if (processName != null && processName.trim().length() > 0) {
                if (processName.toUpperCase().indexOf("IEXPLORE.EXE") > -1) {
                    this.setDDEServer(IEXPLORE);
                } else if (processName.toUpperCase().indexOf("MOZILLA.EXE") > -1) {
                    this.setDDEServer(MOZILLA);
                } else if (processName.toUpperCase().indexOf("FIREFOX.EXE") > -1) {
                    this.setDDEServer(FIREFOX);
                } else if (processName.toUpperCase().indexOf("NETSCP6.EXE") > -1) {
                    this.setDDEServer(NETSCAPE6);
                } else if (processName.toUpperCase().indexOf("NETSCP.EXE") > -1) {
                    this.setDDEServer(NETSCAPE6);
                } else if (processName.toUpperCase().indexOf("NETSCAPE.EXE") > -1) {
                    this.setDDEServer(NETSCAPE);
                } else {
                    this.setDDEServer(null);
                }
            }
        }
    }

    protected NbProcessDescriptor defaultBrowserExecutable() {
        String b = "netscape";
        if (err.isLoggable(1)) {
            err.log(1, "" + System.currentTimeMillis() + "> ExtBrowser: defaultBrowserExecutable: ");
        }
        if (Utilities.isWindows()) {
            b = "iexplore";
            String params = "";
            try {
                b = NbDdeBrowserImpl.getDefaultOpenCommand();
                String[] args = Utilities.parseParameters((String)b);
                if (args == null || args.length == 0) {
                    throw new NbBrowserException();
                }
                b = args[0];
                if (args[0].toUpperCase().indexOf("IEXPLORE.EXE") > -1) {
                    this.setDDEServer(IEXPLORE);
                    params = "-nohome ";
                } else if (args[0].toUpperCase().indexOf("MOZILLA.EXE") > -1) {
                    this.setDDEServer(MOZILLA);
                } else if (args[0].toUpperCase().indexOf("FIREFOX.EXE") > -1) {
                    this.setDDEServer(FIREFOX);
                } else if (args[0].toUpperCase().indexOf("NETSCP6.EXE") > -1) {
                    this.setDDEServer(NETSCAPE6);
                } else if (args[0].toUpperCase().indexOf("NETSCP.EXE") > -1) {
                    this.setDDEServer(NETSCAPE6);
                } else if (args[0].toUpperCase().indexOf("NETSCAPE.EXE") > -1) {
                    this.setDDEServer(NETSCAPE);
                }
                params = params + "{URL}";
                return new NbProcessDescriptor(b, params);
            }
            catch (NbBrowserException e) {
                try {
                    b = NbDdeBrowserImpl.getBrowserPath(IEXPLORE);
                    if (b != null && b.trim().length() > 0) {
                        this.setDDEServer(IEXPLORE);
                        params = params + "{URL}";
                        return new NbProcessDescriptor(b, params);
                    }
                    b = NbDdeBrowserImpl.getBrowserPath(MOZILLA);
                    if (b != null && b.trim().length() > 0) {
                        this.setDDEServer(MOZILLA);
                        params = params + "{URL}";
                        return new NbProcessDescriptor(b, params);
                    }
                    b = NbDdeBrowserImpl.getBrowserPath(FIREFOX);
                    if (b != null && b.trim().length() > 0) {
                        this.setDDEServer(FIREFOX);
                        params = params + "{URL}";
                        return new NbProcessDescriptor(b, params);
                    }
                    b = NbDdeBrowserImpl.getBrowserPath("Netscp");
                    if (b != null && b.trim().length() > 0) {
                        this.setDDEServer(NETSCAPE6);
                        params = params + "{URL}";
                        return new NbProcessDescriptor(b, params);
                    }
                    b = NbDdeBrowserImpl.getBrowserPath("Netscp6");
                    if (b != null && b.trim().length() > 0) {
                        this.setDDEServer(NETSCAPE6);
                        params = params + "{URL}";
                        return new NbProcessDescriptor(b, params);
                    }
                    b = NbDdeBrowserImpl.getBrowserPath("Netscape");
                    if (b != null && b.trim().length() > 0) {
                        this.setDDEServer(NETSCAPE);
                        params = params + "{URL}";
                        return new NbProcessDescriptor(b, params);
                    }
                }
                catch (NbBrowserException e2) {
                    this.setDDEServer(IEXPLORE);
                    b = "C:\\Program Files\\Internet Explorer\\iexplore.exe";
                }
            }
            catch (UnsatisfiedLinkError e) {
                b = "iexplore";
            }
            params = params + "{URL}";
            return new NbProcessDescriptor(b, params);
        }
        if (Utilities.isUnix() && !Utilities.isMac()) {
            if (Utilities.getOperatingSystem() == 16) {
                b = "mozilla";
                File f = new File("/usr/local/mozilla/mozilla");
                if (f.exists()) {
                    b = f.getAbsolutePath();
                } else {
                    f = new File("/usr/bin/firefox");
                    if (f.exists()) {
                        b = f.getAbsolutePath();
                    }
                }
            } else if (Utilities.getOperatingSystem() == 8) {
                b = "netscape";
                File f = new File("/usr/dt/bin/sun_netscape");
                if (f.exists()) {
                    b = f.getAbsolutePath();
                }
            }
            return new NbProcessDescriptor(b, "-remote \"openURL({URL})\"", NbBundle.getMessage((Class)ExtWebBrowser.class, (String)"MSG_BrowserExecutorHint"));
        }
        if (Utilities.getOperatingSystem() == 2048) {
            return new NbProcessDescriptor("Netscape.exe", " {URL}", NbBundle.getBundle((Class)ExtWebBrowser.class).getString("MSG_BrowserExecutorHint"));
        }
        if (Utilities.isMac()) {
            return new NbProcessDescriptor("/usr/bin/open", " {URL}", NbBundle.getBundle((Class)ExtWebBrowser.class).getString("MSG_BrowserExecutorHint"));
        }
        return new NbProcessDescriptor("", " {URL}", NbBundle.getBundle((Class)ExtWebBrowser.class).getString("MSG_BrowserExecutorHint"));
    }

    public HtmlBrowser.Impl createHtmlBrowserImpl() {
        return new DelegatingWebBrowserImpl(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(l);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        String args;
        int idx;
        ois.defaultReadObject();
        if (this.browserExecutable != null && this.browserExecutable.getArguments() != null && (idx = (args = this.browserExecutable.getArguments()).indexOf("{params}")) >= 0) {
            this.browserExecutable = new NbProcessDescriptor(this.browserExecutable.getProcessName(), args.substring(0, idx) + "-remote \"openURL({URL})" + args.substring(idx + 8), NbBundle.getMessage((Class)ExtWebBrowser.class, (String)"MSG_BrowserExecutorHint"));
        }
        this.init();
    }

    public static class UnixBrowserFormat
    extends MapFormat {
        private static final long serialVersionUID = -699340388834127437L;
        public static final String TAG_URL = "URL";

        public UnixBrowserFormat(String url) {
            super(new HashMap());
            Map map = this.getMap();
            map.put(TAG_URL, url);
        }
    }
}

