/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.NbBrowserException;
import org.netbeans.modules.extbrowser.NbDdeBrowserImpl;
import org.netbeans.modules.extbrowser.URLUtil;
import org.openide.awt.HtmlBrowser;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class SystemDefaultBrowser
extends ExtWebBrowser {
    private static final long serialVersionUID = -7317179197254112564L;
    private static final Logger logger = Logger.getLogger(SystemDefaultBrowser.class.getName());
    private static BrowseInvoker JDK_6_DESKTOP_BROWSE;

    public static Boolean isHidden() {
        return !Utilities.isWindows() && JDK_6_DESKTOP_BROWSE == null;
    }

    public HtmlBrowser.Impl createHtmlBrowserImpl() {
        if (JDK_6_DESKTOP_BROWSE != null) {
            return new Jdk6BrowserImpl();
        }
        if (Utilities.isWindows()) {
            return new NbDdeBrowserImpl(this);
        }
        throw new UnsupportedOperationException(NbBundle.getMessage((Class)SystemDefaultBrowser.class, (String)"MSG_CannotUseBrowser"));
    }

    public String getName() {
        if (this.name == null) {
            this.name = NbBundle.getMessage((Class)SystemDefaultBrowser.class, (String)"CTL_SystemDefaultBrowserName");
        }
        return this.name;
    }

    public void setName(String name) {
    }

    protected NbProcessDescriptor defaultBrowserExecutable() {
        String b;
        if (!Utilities.isWindows() || JDK_6_DESKTOP_BROWSE != null) {
            return new NbProcessDescriptor("", "");
        }
        String params = "";
        try {
            b = NbDdeBrowserImpl.getDefaultOpenCommand();
            String[] args = Utilities.parseParameters((String)b);
            if (args == null || args.length == 0) {
                throw new NbBrowserException();
            }
            b = args[0];
            params = params + " {URL}";
        }
        catch (NbBrowserException e) {
            b = "";
        }
        catch (UnsatisfiedLinkError e) {
            b = "iexplore";
        }
        NbProcessDescriptor p = new NbProcessDescriptor(b, params);
        return p;
    }

    static {
        try {
            if (Boolean.getBoolean("java.net.useSystemProxies") && Utilities.isUnix()) {
                logger.log(Level.FINE, "Ignoring java.awt.Desktop.browse support to avoid hang from #89540");
            } else {
                Class<?> desktop = Class.forName("java.awt.Desktop");
                Method isDesktopSupported = desktop.getMethod("isDesktopSupported", null);
                Boolean b = (Boolean)isDesktopSupported.invoke(null, null);
                logger.log(Level.FINE, "java.awt.Desktop found, isDesktopSupported returned " + b);
                if (b.booleanValue()) {
                    final Object desktopInstance = desktop.getMethod("getDesktop", null).invoke(null, null);
                    Class<?> desktopAction = Class.forName("java.awt.Desktop$Action");
                    Method isSupported = desktop.getMethod("isSupported", desktopAction);
                    Object browseConst = desktopAction.getField("BROWSE").get(null);
                    b = (Boolean)isSupported.invoke(desktopInstance, browseConst);
                    logger.log(Level.FINE, "java.awt.Desktop found, isSupported(Action.BROWSE) returned " + b);
                    if (b.booleanValue()) {
                        final Method browse = desktop.getMethod("browse", URI.class);
                        JDK_6_DESKTOP_BROWSE = new BrowseInvoker(){

                            public void browse(URI uri) throws IOException {
                                try {
                                    browse.invoke(desktopInstance, uri);
                                }
                                catch (InvocationTargetException e) {
                                    throw (IOException)e.getTargetException();
                                }
                                catch (Exception e) {
                                    Logger.getLogger((class$org$netbeans$modules$extbrowser$SystemDefaultBrowser == null ? (class$org$netbeans$modules$extbrowser$SystemDefaultBrowser = SystemDefaultBrowser.class$("org.netbeans.modules.extbrowser.SystemDefaultBrowser")) : class$org$netbeans$modules$extbrowser$SystemDefaultBrowser).getName()).log(Level.WARNING, null, e);
                                }
                            }
                        };
                        logger.log(Level.FINE, "java.awt.Desktop.browse support");
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "java.awt.Desktop class not found, disabling JDK 6 browse functionality");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, null, e);
        }
    }

    private static interface BrowseInvoker {
        public void browse(URI var1) throws IOException;
    }

    private static final class Jdk6BrowserImpl
    extends ExtBrowserImpl {
        static final /* synthetic */ boolean $assertionsDisabled;

        public Jdk6BrowserImpl() {
            if (!$assertionsDisabled && JDK_6_DESKTOP_BROWSE == null) {
                throw new AssertionError();
            }
        }

        public void setURL(URL url) {
            URL extURL = URLUtil.createExternalURL(url, false);
            try {
                extURL = this.getFullyRFC2396CompliantURL(extURL);
                URI uri = extURL.toURI();
                logger.fine("Calling java.awt.Desktop.browse(" + uri + ")");
                JDK_6_DESKTOP_BROWSE.browse(uri);
            }
            catch (URISyntaxException e) {
                logger.severe("The URL:\n" + extURL + "\nis not fully RFC 2396 compliant and cannot " + "be used with Desktop.browse().");
            }
            catch (IOException e) {
                logger.log(Level.WARNING, null, e);
            }
        }

        private URL getFullyRFC2396CompliantURL(URL url) {
            String urlStr = url.toString();
            int ind = urlStr.indexOf(35);
            if (ind > -1) {
                String urlWithoutRef = urlStr.substring(0, ind);
                String anchorOrg = url.getRef();
                try {
                    String anchorEscaped = URLEncoder.encode(anchorOrg, "UTF8");
                    anchorEscaped = anchorEscaped.replaceAll("\\+", "%20");
                    if (!anchorOrg.equals(anchorEscaped)) {
                        URL escapedURL = new URL(urlWithoutRef + '#' + anchorEscaped);
                        logger.warning("The URL:\n" + urlStr + "\nis not fully RFC 2396 compliant and cannot " + "be used with Desktop.browse(). Instead using URL:" + escapedURL);
                        return escapedURL;
                    }
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            return url;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$extbrowser$SystemDefaultBrowser == null ? (class$org$netbeans$modules$extbrowser$SystemDefaultBrowser = SystemDefaultBrowser.class$("org.netbeans.modules.extbrowser.SystemDefaultBrowser")) : class$org$netbeans$modules$extbrowser$SystemDefaultBrowser).desiredAssertionStatus();
        }
    }
}

