/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;

public class URLUtil {
    private static Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(URLMapper.class));

    public static URL createExternalURL(URL url, boolean allowJar) {
        if (url == null) {
            return null;
        }
        if (URLUtil.isAcceptableProtocol(url, allowJar)) {
            return url;
        }
        String anchor = url.getRef();
        String urlString = url.toString();
        int ind = urlString.indexOf(35);
        if (ind >= 0) {
            urlString = urlString.substring(0, ind);
        }
        try {
            URL newUrl;
            FileObject fo = URLMapper.findFileObject((URL)new URL(urlString));
            if (fo != null && (newUrl = URLUtil.getURLOfAppropriateType(fo, allowJar)) != null) {
                urlString = newUrl.toString();
                if (ind >= 0) {
                    urlString = urlString + "#" + anchor;
                }
                return new URL(urlString);
            }
        }
        catch (MalformedURLException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return url;
    }

    private static URL getURLOfAppropriateType(FileObject fo, boolean allowJar) {
        URL suitable = null;
        Iterator instances = result.allInstances().iterator();
        while (instances.hasNext()) {
            URLMapper mapper = (URLMapper)instances.next();
            URL retVal = mapper.getURL(fo, 1);
            if (retVal == null || !URLUtil.isAcceptableProtocol(retVal, allowJar)) continue;
            String p = retVal.getProtocol().toLowerCase();
            if ("file".equals(p) || "jar".equals(p)) {
                return retVal;
            }
            suitable = retVal;
        }
        if (suitable != null) {
            return suitable;
        }
        URL url = URLMapper.findURL((FileObject)fo, (int)2);
        if (url == null) {
            ErrorManager.getDefault().log(65536, "URLMapper.findURL() failed for " + fo);
            return null;
        }
        return URLUtil.makeURLLocal(url);
    }

    private static URL makeURLLocal(URL input) {
        String host = input.getHost();
        try {
            if (host.equals(InetAddress.getLocalHost().getHostName())) {
                host = "127.0.0.1";
                return new URL(input.getProtocol(), host, input.getPort(), input.getFile());
            }
            return input;
        }
        catch (UnknownHostException e) {
            return input;
        }
        catch (MalformedURLException e) {
            return input;
        }
    }

    private static boolean isAcceptableProtocol(URL url, boolean allowJar) {
        String urlString;
        String protocol = url.getProtocol().toLowerCase();
        if ("http".equals(protocol) || "ftp".equals(protocol) || "file".equals(protocol)) {
            return true;
        }
        return allowJar && "jar".equals(protocol) && !(urlString = url.toString()).toLowerCase().startsWith("jar:nbinst:");
    }

    public static boolean browserHandlesJarURLs(String browser) {
        return "MOZILLA".equals(browser) || "FIREFOX".equals(browser);
    }
}

