/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.javadoc.Doc;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.javadoc.hints.JavadocUtilities;

public final class JavadocGenerator {
    private final SourceVersion srcVersion;

    public JavadocGenerator(SourceVersion version) {
        this.srcVersion = version;
    }

    public String generateComment(TypeElement clazz, CompilationInfo javac) {
        StringBuilder builder = new StringBuilder("/**\n * \n");
        if (clazz.getNestingKind() == NestingKind.TOP_LEVEL) {
            builder.append(" * @author " + System.getProperty("user.name") + "\n");
        }
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0) {
            for (TypeParameterElement typeParameterElement : clazz.getTypeParameters()) {
                builder.append(" * @param " + typeParameterElement.getSimpleName().toString() + " \n");
            }
        }
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0 && JavadocUtilities.isDeprecated(javac, clazz)) {
            builder.append(" * @deprecated\n");
        }
        builder.append(" */\n");
        return builder.toString();
    }

    public String generateComment(ExecutableElement method, CompilationInfo javac) {
        StringBuilder builder = new StringBuilder("/**\n * \n");
        for (VariableElement variableElement : method.getParameters()) {
            builder.append(" * @param ").append(variableElement.getSimpleName().toString()).append(" \n");
        }
        if (method.getReturnType().getKind() != TypeKind.VOID) {
            builder.append(" * @return \n");
        }
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            TypeElement exception = (TypeElement)((DeclaredType)typeMirror).asElement();
            builder.append(" * @throws ").append(exception.getQualifiedName().toString()).append(" \n");
        }
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0 && JavadocUtilities.isDeprecated(javac, method)) {
            builder.append(" * @deprecated\n");
        }
        builder.append(" */\n");
        return builder.toString();
    }

    public String generateComment(VariableElement field, CompilationInfo javac) {
        StringBuilder builder = new StringBuilder("/**\n * \n");
        if (SourceVersion.RELEASE_5.compareTo(this.srcVersion) <= 0 && JavadocUtilities.isDeprecated(javac, field)) {
            builder.append(" * @deprecated\n");
        }
        builder.append(" */\n");
        return builder.toString();
    }

    public String generateComment(Element elm, CompilationInfo javac) {
        switch (elm.getKind()) {
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: {
                return this.generateComment((TypeElement)elm, javac);
            }
            case CONSTRUCTOR: 
            case METHOD: {
                return this.generateComment((ExecutableElement)elm, javac);
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                return this.generateComment((VariableElement)elm, javac);
            }
        }
        throw new UnsupportedOperationException((Object)((Object)elm.getKind()) + ", " + elm.getClass() + ": " + elm.toString());
    }

    public String generateInheritComment() {
        return "/** {@inheritDoc} */";
    }

    public static String indentJavadoc(String jdoc, String tab) {
        return jdoc.replace("\n *", "\n" + tab + " *") + tab;
    }

    public static String guessIndentation(Document doc, Position pos) throws BadLocationException {
        int offset;
        String content = doc.getText(0, doc.getLength());
        for (offset = pos.getOffset(); offset >= 0 && content.charAt(offset) != '\n'; --offset) {
        }
        return content.substring(offset + 1, pos.getOffset());
    }

    public static String guessJavadocIndentation(CompilationInfo javac, Document doc, Doc jdoc) throws BadLocationException {
        Position[] jdBounds = JavadocUtilities.findDocBounds(javac, doc, jdoc);
        if (jdBounds == null) {
            return "";
        }
        String txt = doc.getText(0, doc.getLength());
        int count = 0;
        for (int offset = jdBounds[0].getOffset() - 1; offset >= 0; --offset) {
            char c = txt.charAt(offset);
            if (c != '\n' && Character.isWhitespace(c)) continue;
            count = jdBounds[0].getOffset() - offset;
            break;
        }
        char[] indent = new char[count];
        for (int i = 0; i < indent.length; ++i) {
            indent[i] = 32;
        }
        return String.valueOf(indent);
    }
}

