/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.windows.TopComponent;

final class GetJavaWord {
    GetJavaWord() {
    }

    static String getCurrentJavaWord() {
        EditorCookie ec;
        Node[] n = TopComponent.getRegistry().getActivatedNodes();
        if (n.length == 1 && (ec = (EditorCookie)n[0].getCookie(EditorCookie.class)) != null) {
            JEditorPane[] panes = ec.getOpenedPanes();
            if (panes == null) {
                return null;
            }
            if (panes.length > 0) {
                return GetJavaWord.forPane(panes[0]);
            }
        }
        return null;
    }

    static String forPane(JEditorPane p) {
        int eix;
        int bix;
        int dot;
        if (p == null) {
            return null;
        }
        String selection = p.getSelectedText();
        if (selection != null && selection.length() > 0) {
            return selection;
        }
        Document doc = p.getDocument();
        Element lineRoot = doc instanceof StyledDocument ? NbDocument.findLineRootElement((StyledDocument)((StyledDocument)doc)) : doc.getDefaultRootElement();
        Element line = lineRoot.getElement(lineRoot.getElementIndex(dot = p.getCaret().getDot()));
        if (line == null) {
            return null;
        }
        String text = null;
        try {
            text = doc.getText(line.getStartOffset(), line.getEndOffset() - line.getStartOffset());
        }
        catch (BadLocationException e) {
            return null;
        }
        if (text == null) {
            return null;
        }
        int pos = dot - line.getStartOffset();
        if (pos < 0 || pos >= text.length()) {
            return null;
        }
        int n = bix = Character.isJavaIdentifierPart(text.charAt(pos)) ? pos : pos - 1;
        while (bix >= 0 && Character.isJavaIdentifierPart(text.charAt(bix))) {
            --bix;
        }
        for (eix = pos; eix < text.length() && Character.isJavaIdentifierPart(text.charAt(eix)); ++eix) {
        }
        return bix == eix ? null : text.substring(bix + 1, eix);
    }
}

