/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.modules.javadoc.search.JavadocSearchType;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class JavadocRegistry
implements GlobalPathRegistryListener,
ChangeListener,
PropertyChangeListener {
    private static JavadocRegistry INSTANCE;
    private GlobalPathRegistry regs = GlobalPathRegistry.getDefault();
    private ArrayList listeners;
    private Set results;
    private ClassPath docRoots;
    private Set classpaths;

    private JavadocRegistry() {
        this.regs.addGlobalPathRegistryListener((GlobalPathRegistryListener)this);
    }

    public static synchronized JavadocRegistry getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new JavadocRegistry();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject[] getDocRoots() {
        JavadocRegistry javadocRegistry = this;
        synchronized (javadocRegistry) {
            if (this.docRoots != null) {
                return this.docRoots.getRoots();
            }
        }
        HashSet _classpaths = new HashSet();
        HashSet _results = new HashSet();
        Set s = JavadocRegistry.readRoots(this, _classpaths, _results);
        JavadocRegistry javadocRegistry2 = this;
        synchronized (javadocRegistry2) {
            if (this.docRoots == null) {
                this.docRoots = ClassPathSupport.createClassPath((URL[])s.toArray(new URL[s.size()]));
                this.classpaths = _classpaths;
                this.results = _results;
                JavadocRegistry.registerListeners(this, _classpaths, _results, this.docRoots);
            }
            return this.docRoots.getRoots();
        }
    }

    public JavadocSearchType findSearchType(FileObject apidocRoot) {
        String encoding = this.getDocEncoding(apidocRoot);
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(JavadocSearchType.class));
        for (JavadocSearchType jdst : result.allInstances()) {
            if (!jdst.accepts(apidocRoot, encoding)) continue;
            return jdst;
        }
        return null;
    }

    private static Set readRoots(JavadocRegistry jdr, Set classpaths, Set results) {
        HashSet<URL> roots = new HashSet<URL>();
        LinkedList paths = new LinkedList();
        paths.addAll(jdr.regs.getPaths("classpath/compile"));
        paths.addAll(jdr.regs.getPaths("classpath/boot"));
        for (ClassPath ccp : paths) {
            classpaths.add(ccp);
            List ccpRoots = ccp.entries();
            for (ClassPath.Entry ccpRoot : ccpRoots) {
                JavadocForBinaryQuery.Result result = JavadocForBinaryQuery.findJavadoc((URL)ccpRoot.getURL());
                results.add(result);
                URL[] jdRoots = result.getRoots();
                roots.addAll(Arrays.asList(jdRoots));
            }
        }
        return roots;
    }

    private static void registerListeners(JavadocRegistry jdr, Set classpaths, Set results, ClassPath docRoots) {
        for (ClassPath cpath : classpaths) {
            cpath.addPropertyChangeListener((PropertyChangeListener)jdr);
        }
        for (JavadocForBinaryQuery.Result result : results) {
            result.addChangeListener((ChangeListener)jdr);
        }
        docRoots.addPropertyChangeListener((PropertyChangeListener)jdr);
    }

    public void pathsAdded(GlobalPathRegistryEvent event) {
        this.throwCache();
        this.fireChange();
    }

    public void pathsRemoved(GlobalPathRegistryEvent event) {
        this.throwCache();
        this.fireChange();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("entries".equals(event.getPropertyName()) || event.getSource() == this.docRoots) {
            this.throwCache();
            this.fireChange();
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.throwCache();
        this.fireChange();
    }

    public synchronized void addChangeListener(ChangeListener l) {
        assert (l != null) : "Listener can not be null.";
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        assert (l != null) : "Listener can not be null.";
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        Iterator it = null;
        JavadocRegistry javadocRegistry = this;
        synchronized (javadocRegistry) {
            if (this.listeners == null) {
                return;
            }
            it = ((ArrayList)this.listeners.clone()).iterator();
        }
        ChangeEvent event = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(event);
        }
    }

    private synchronized void throwCache() {
        Iterator it;
        if (this.classpaths != null) {
            it = this.classpaths.iterator();
            while (it.hasNext()) {
                ClassPath cp = (ClassPath)it.next();
                cp.removePropertyChangeListener((PropertyChangeListener)this);
                it.remove();
            }
        }
        if (this.results != null) {
            it = this.results.iterator();
            while (it.hasNext()) {
                JavadocForBinaryQuery.Result result = (JavadocForBinaryQuery.Result)it.next();
                result.removeChangeListener((ChangeListener)this);
                it.remove();
            }
        }
        if (this.docRoots != null) {
            this.docRoots.removePropertyChangeListener((PropertyChangeListener)this);
            this.docRoots = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDocEncoding(FileObject root) {
        assert (root != null && root.isFolder());
        FileObject fo = root.getFileObject("index-all.html");
        if (fo == null) {
            fo = root.getFileObject("index-files");
            if (fo == null) {
                return null;
            }
            if ((fo = fo.getFileObject("index-1.html")) == null) {
                return null;
            }
        }
        ParserDelegator pd = new ParserDelegator();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(fo.getInputStream()));
            EncodingCallback ecb = new EncodingCallback(in);
            try {
                pd.parse(in, ecb, true);
            }
            catch (IOException ioe) {
            }
            finally {
                in.close();
            }
            return ecb.getEncoding();
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().annotate((Throwable)ioe, fo.toString());
            ErrorManager.getDefault().notify((Throwable)ioe);
            return null;
        }
    }

    private static class EncodingCallback
    extends HTMLEditorKit.ParserCallback {
        private Reader in;
        private String encoding;

        public EncodingCallback(Reader in) {
            this.in = in;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            String value;
            if (t == HTML.Tag.META && (value = (String)a.getAttribute(HTML.Attribute.CONTENT)) != null) {
                StringTokenizer tk = new StringTokenizer(value, ";");
                while (tk.hasMoreTokens()) {
                    String str = tk.nextToken().trim();
                    if (!str.startsWith("charset") || (str = str.substring(7).trim()).charAt(0) != '=') continue;
                    this.encoding = str.substring(1).trim();
                    try {
                        this.in.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    return;
                }
            }
        }

        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            if (t == HTML.Tag.BODY) {
                try {
                    this.in.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }
}

