/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ChicletWrapper;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.openide.awt.HtmlRenderer;

public final class AquaViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final int TXT_X_PAD = 5;
    private static final int ICON_X_PAD = 2;
    private static Map<Integer, String[]> buttonIconPaths;
    private Dimension prefSize;
    private Rectangle tempRect = new Rectangle();
    private static final ChicletWrapper chiclet;
    private boolean containsMouse = false;

    private AquaViewTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
        this.prefSize = new Dimension(100, 19);
    }

    public static ComponentUI createUI(JComponent c) {
        return new AquaViewTabDisplayerUI((TabDisplayer)c);
    }

    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    public Dimension getPreferredSize(JComponent c) {
        FontMetrics fm = this.getTxtFontMetrics();
        int height = fm == null ? 21 : fm.getAscent() + 2 * fm.getDescent() + 3;
        Insets insets = c.getInsets();
        this.prefSize.height = height + insets.bottom + insets.top;
        return this.prefSize;
    }

    public void paint(Graphics g, JComponent c) {
        ColorUtil.setupAntialiasing(g);
        super.paint(g, c);
        this.paintBottomBorder(g, c);
    }

    protected Font getTxtFont() {
        return this.getDisplayer().getFont();
    }

    private void paintBottomBorder(Graphics g, JComponent c) {
    }

    protected void paintTabContent(Graphics g, int index, String text, int x, int y, int width, int height) {
        FontMetrics fm = this.getTxtFontMetrics();
        g.setFont(this.getTxtFont());
        int textW = width;
        if (this.isSelected(index)) {
            Component buttons = this.getControlButtons();
            if (null != buttons) {
                Dimension buttonsSize = buttons.getPreferredSize();
                textW = width - (buttonsSize.width + 2 + 10);
                if (index == this.getDataModel().size() - 1) {
                    textW -= 3;
                }
                buttons.setLocation(x + textW + 10, y + (height - buttonsSize.height) / 2);
            }
        } else {
            textW = width - 10;
        }
        if (text.length() == 0) {
            return;
        }
        int textHeight = fm.getHeight();
        int textX = x + 5;
        if (index == 0) {
            textX = x + 5;
        }
        int textY = textHeight > height ? -1 * ((textHeight - height) / 2) + fm.getAscent() - 1 : height / 2 - textHeight / 2 + fm.getAscent();
        HtmlRenderer.renderString((String)text, (Graphics)g, (int)textX, (int)textY, (int)textW, (int)height, (Font)this.getTxtFont(), (Color)UIManager.getColor("textText"), (int)1, (boolean)true);
    }

    protected void paintTabBorder(Graphics g, int index, int x, int y, int width, int height) {
    }

    protected void paintTabBackground(Graphics g, int index, int x, int y, int width, int height) {
        boolean first = index == 0;
        boolean last = index == this.getDataModel().size() - 1;
        int state = 0;
        if (this.isActive()) {
            state |= 4;
        }
        if (this.isSelected(index)) {
            state |= 2;
        }
        if (this.isAttention(index)) {
            state |= 0x10;
        }
        chiclet.setState(state);
        chiclet.setBounds(x, ++y, width, height);
        chiclet.setArcs(first ? 0.5f : 0.0f, last ? 0.5f : 0.0f, first ? 0.0f : 0.0f, last ? 0.0f : 0.0f);
        chiclet.setNotch(false, false);
        g.translate(x, y);
        chiclet.draw((Graphics2D)g);
        g.translate(-x, -y);
    }

    private void setContainsMouse(boolean val) {
        if (val != this.containsMouse) {
            this.containsMouse = val;
            this.getDisplayer().repaint();
        }
    }

    private boolean isContainsMouse() {
        return this.containsMouse;
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            String[] iconPaths;
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            iconPaths = new String[]{"org/netbeans/swing/tabcontrol/resources/mac_bigclose_enabled.png", "org/netbeans/swing/tabcontrol/resources/mac_bigclose_pressed.png", iconPaths[0], "org/netbeans/swing/tabcontrol/resources/mac_bigclose_rollover.png"};
            buttonIconPaths.put(1, iconPaths);
            iconPaths = new String[]{"org/netbeans/swing/tabcontrol/resources/mac_slideright_enabled.png", "org/netbeans/swing/tabcontrol/resources/mac_slideright_pressed.png", iconPaths[0], "org/netbeans/swing/tabcontrol/resources/mac_slideright_rollover.png"};
            buttonIconPaths.put(6, iconPaths);
            iconPaths = new String[]{"org/netbeans/swing/tabcontrol/resources/mac_slideleft_enabled.png", "org/netbeans/swing/tabcontrol/resources/mac_slideleft_pressed.png", iconPaths[0], "org/netbeans/swing/tabcontrol/resources/mac_slideleft_rollover.png"};
            buttonIconPaths.put(5, iconPaths);
            iconPaths = new String[]{"org/netbeans/swing/tabcontrol/resources/mac_slidebottom_enabled.png", "org/netbeans/swing/tabcontrol/resources/mac_slidebottom_pressed.png", iconPaths[0], "org/netbeans/swing/tabcontrol/resources/mac_slidebottom_rollover.png"};
            buttonIconPaths.put(7, iconPaths);
            iconPaths = new String[]{"org/netbeans/swing/tabcontrol/resources/mac_pin_enabled.png", "org/netbeans/swing/tabcontrol/resources/mac_pin_pressed.png", iconPaths[0], "org/netbeans/swing/tabcontrol/resources/mac_pin_rollover.png"};
            buttonIconPaths.put(2, iconPaths);
        }
    }

    public Icon getButtonIcon(int buttonId, int buttonState) {
        Icon res = null;
        AquaViewTabDisplayerUI.initIcons();
        String[] paths = buttonIconPaths.get(buttonId);
        if (null != paths && buttonState >= 0 && buttonState < paths.length) {
            res = TabControlButtonFactory.getIcon(paths[buttonState]);
        }
        return res;
    }

    static {
        chiclet = new ChicletWrapper();
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private OwnController() {
        }

        public void mouseEntered(MouseEvent me) {
            super.mouseEntered(me);
            AquaViewTabDisplayerUI.this.setContainsMouse(true);
        }

        public void mouseExited(MouseEvent me) {
            super.mouseExited(me);
            AquaViewTabDisplayerUI.this.setContainsMouse(false);
        }
    }
}

