/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.GtkEditorTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;

public final class GtkEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private static Map<Integer, String[]> buttonIconPaths;

    public GtkEditorTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
    }

    public static ComponentUI createUI(JComponent c) {
        return new GtkEditorTabDisplayerUI((TabDisplayer)c);
    }

    public Rectangle getTabRect(int idx, Rectangle rect) {
        Rectangle r = super.getTabRect(idx, rect);
        r.y = 0;
        r.height = this.displayer.getHeight();
        return r;
    }

    public void install() {
        super.install();
    }

    public Dimension getPreferredSize(JComponent c) {
        int prefHeight = 28;
        Graphics2D g = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (g != null) {
            FontMetrics fm = g.getFontMetrics(this.displayer.getFont());
            Insets ins = this.getTabAreaInsets();
            prefHeight = fm.getHeight() + ins.top + ins.bottom + 12;
        }
        return new Dimension(this.displayer.getWidth(), prefHeight);
    }

    protected void paintAfterTabs(Graphics g) {
    }

    protected TabCellRenderer createDefaultRenderer() {
        return new GtkEditorTabCellRenderer();
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            String[] iconPaths = new String[4];
            iconPaths[0] = "org/netbeans/swing/tabcontrol/resources/gtk_scrollleft_enabled.png";
            iconPaths[2] = "org/netbeans/swing/tabcontrol/resources/gtk_scrollleft_disabled.png";
            iconPaths[3] = "org/netbeans/swing/tabcontrol/resources/gtk_scrollleft_rollover.png";
            iconPaths[1] = "org/netbeans/swing/tabcontrol/resources/gtk_scrollleft_pressed.png";
            buttonIconPaths.put(9, iconPaths);
            iconPaths = new String[4];
            iconPaths[0] = "org/netbeans/swing/tabcontrol/resources/gtk_scrollright_enabled.png";
            iconPaths[2] = "org/netbeans/swing/tabcontrol/resources/gtk_scrollright_disabled.png";
            iconPaths[3] = "org/netbeans/swing/tabcontrol/resources/gtk_scrollright_rollover.png";
            iconPaths[1] = "org/netbeans/swing/tabcontrol/resources/gtk_scrollright_pressed.png";
            buttonIconPaths.put(10, iconPaths);
            iconPaths = new String[4];
            iconPaths[0] = "org/netbeans/swing/tabcontrol/resources/gtk_popup_enabled.png";
            iconPaths[2] = "org/netbeans/swing/tabcontrol/resources/gtk_popup_disabled.png";
            iconPaths[3] = "org/netbeans/swing/tabcontrol/resources/gtk_popup_rollover.png";
            iconPaths[1] = "org/netbeans/swing/tabcontrol/resources/gtk_popup_pressed.png";
            buttonIconPaths.put(8, iconPaths);
            iconPaths = new String[4];
            iconPaths[0] = "org/netbeans/swing/tabcontrol/resources/gtk_maximize_enabled.png";
            iconPaths[2] = "org/netbeans/swing/tabcontrol/resources/gtk_maximize_disabled.png";
            iconPaths[3] = "org/netbeans/swing/tabcontrol/resources/gtk_maximize_rollover.png";
            iconPaths[1] = "org/netbeans/swing/tabcontrol/resources/gtk_maximize_pressed.png";
            buttonIconPaths.put(3, iconPaths);
            iconPaths = new String[4];
            iconPaths[0] = "org/netbeans/swing/tabcontrol/resources/gtk_restore_enabled.png";
            iconPaths[2] = "org/netbeans/swing/tabcontrol/resources/gtk_restore_disabled.png";
            iconPaths[3] = "org/netbeans/swing/tabcontrol/resources/gtk_restore_rollover.png";
            iconPaths[1] = "org/netbeans/swing/tabcontrol/resources/gtk_restore_pressed.png";
            buttonIconPaths.put(4, iconPaths);
        }
    }

    public Icon getButtonIcon(int buttonId, int buttonState) {
        Icon res = null;
        GtkEditorTabDisplayerUI.initIcons();
        String[] paths = buttonIconPaths.get(buttonId);
        if (null != paths && buttonState >= 0 && buttonState < paths.length) {
            res = TabControlButtonFactory.getIcon(paths[buttonState]);
        }
        return res;
    }

    protected Rectangle getControlButtonsRectangle(Container parent) {
        Component c = this.getControlButtons();
        return new Rectangle(parent.getWidth() - c.getWidth() - 4, 4, c.getWidth(), c.getHeight());
    }

    public Insets getTabAreaInsets() {
        Insets retValue = super.getTabAreaInsets();
        retValue.right += 4;
        return retValue;
    }
}

