/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;

abstract class TabControlButton
extends JButton {
    public static final int ID_CLOSE_BUTTON = 1;
    public static final int ID_PIN_BUTTON = 2;
    public static final int ID_MAXIMIZE_BUTTON = 3;
    public static final int ID_RESTORE_BUTTON = 4;
    public static final int ID_SLIDE_LEFT_BUTTON = 5;
    public static final int ID_SLIDE_RIGHT_BUTTON = 6;
    public static final int ID_SLIDE_DOWN_BUTTON = 7;
    public static final int ID_DROP_DOWN_BUTTON = 8;
    public static final int ID_SCROLL_LEFT_BUTTON = 9;
    public static final int ID_SCROLL_RIGHT_BUTTON = 10;
    public static final int STATE_DEFAULT = 0;
    public static final int STATE_PRESSED = 1;
    public static final int STATE_DISABLED = 2;
    public static final int STATE_ROLLOVER = 3;
    private int buttonId;
    private TabDisplayer displayer;
    private String tabActionCommand;

    TabControlButton(TabDisplayer displayer) {
        this(-1, displayer);
    }

    TabControlButton(int buttonId, TabDisplayer displayer) {
        this.buttonId = buttonId;
        this.displayer = displayer;
        this.configureButton();
    }

    protected abstract String getTabActionCommand(ActionEvent var1);

    protected int getButtonId() {
        return this.buttonId;
    }

    public Icon getIcon() {
        if (null != this.displayer) {
            return this.displayer.getUI().getButtonIcon(this.getButtonId(), 0);
        }
        return null;
    }

    public Icon getPressedIcon() {
        if (null != this.displayer) {
            return this.displayer.getUI().getButtonIcon(this.getButtonId(), 1);
        }
        return null;
    }

    public Icon getRolloverIcon() {
        if (null != this.displayer) {
            return this.displayer.getUI().getButtonIcon(this.getButtonId(), 3);
        }
        return null;
    }

    public Icon getRolloverSelectedIcon() {
        return this.getRolloverIcon();
    }

    public Icon getDisabledIcon() {
        if (null != this.displayer) {
            return this.displayer.getUI().getButtonIcon(this.getButtonId(), 2);
        }
        return null;
    }

    public Icon getDisabledSelectedIcon() {
        return this.getDisabledIcon();
    }

    public void updateUI() {
        super.updateUI();
        this.configureButton();
    }

    protected void configureButton() {
        this.setFocusable(false);
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setRolloverEnabled(this.getRolloverIcon() != null);
    }

    protected void fireActionPerformed(ActionEvent event) {
        super.fireActionPerformed(event);
        this.performAction(event);
        this.getModel().setRollover(false);
    }

    void performAction(ActionEvent e) {
        this.displayer.getUI().postTabAction(this.createTabActionEvent(e));
    }

    protected TabActionEvent createTabActionEvent(ActionEvent e) {
        return new TabActionEvent((Object)this, this.getTabActionCommand(e), this.displayer.getSelectionModel().getSelectedIndex());
    }

    protected TabDisplayer getTabDisplayer() {
        return this.displayer;
    }
}

