/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabListPopupAction;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbed;
import org.netbeans.swing.tabcontrol.plaf.TabControlButton;

class TabControlButtonFactory {
    private static IconLoader iconCache;

    private TabControlButtonFactory() {
    }

    public static Icon getIcon(String iconPath) {
        if (null == iconCache) {
            iconCache = new IconLoader();
        }
        return iconCache.obtainIcon(iconPath);
    }

    public static TabControlButton createCloseButton(TabDisplayer displayer) {
        return new CloseButton(displayer);
    }

    public static TabControlButton createSlidePinButton(TabDisplayer displayer) {
        return new SlidePinButton(displayer);
    }

    public static TabControlButton createMaximizeRestoreButton(TabDisplayer displayer) {
        return new MaximizeRestoreButton(displayer);
    }

    public static TabControlButton createScrollLeftButton(TabDisplayer displayer, Action scrollAction) {
        TimerButton button = new TimerButton(9, displayer, scrollAction);
        button.setToolTipText(ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Scroll_Documents_Left"));
        return button;
    }

    public static TabControlButton createScrollRightButton(TabDisplayer displayer, Action scrollAction) {
        TimerButton button = new TimerButton(10, displayer, scrollAction);
        button.setToolTipText(ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Scroll_Documents_Right"));
        return button;
    }

    public static TabControlButton createDropDownButton(TabDisplayer displayer) {
        return new DropDownButton(displayer);
    }

    private static Component getActiveTab(TabDisplayer displayer) {
        Component res = null;
        int selIndex = displayer.getSelectionModel().getSelectedIndex();
        if (selIndex >= 0) {
            TabData tab = displayer.getModel().getTab(selIndex);
            res = tab.getComponent();
        }
        return res;
    }

    private static Image loadImage(String path) {
        try {
            URL url = TabControlButtonFactory.class.getResource("/" + path);
            return ImageIO.read(url);
        }
        catch (Exception e) {
            Logger.getLogger(TabControlButtonFactory.class.getName()).log(Level.WARNING, "Cannot load image", e);
            return null;
        }
    }

    private static class CloseButton
    extends TabControlButton {
        public CloseButton(TabDisplayer displayer) {
            super(1, displayer);
            this.setToolTipText(ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Close_Window"));
        }

        protected String getTabActionCommand(ActionEvent e) {
            return "close";
        }
    }

    private static class DropDownButton
    extends TabControlButton {
        private boolean forcePressedIcon = false;

        public DropDownButton(TabDisplayer displayer) {
            super(8, displayer);
            this.setAction(new TabListPopupAction(displayer));
            this.setToolTipText(ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Show_Opened_Documents_List"));
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void processMouseEvent(MouseEvent me) {
            super.processMouseEvent(me);
            if (this.isEnabled()) {
                if (me.getID() == 501) {
                    this.forcePressedIcon = true;
                    this.repaint();
                    this.getAction().actionPerformed(new ActionEvent(this, 1001, "pressed"));
                    return;
                }
            }
            if (!this.isEnabled()) return;
            if (me.getID() != 502) return;
            this.forcePressedIcon = false;
            this.repaint();
        }

        protected String getTabActionCommand(ActionEvent e) {
            return null;
        }

        void performAction(ActionEvent e) {
        }

        public Icon getRolloverIcon() {
            if (this.forcePressedIcon) {
                return this.getPressedIcon();
            }
            return super.getRolloverIcon();
        }

        public Icon getIcon() {
            if (this.forcePressedIcon) {
                return this.getPressedIcon();
            }
            return super.getIcon();
        }
    }

    private static final class IconLoader {
        private Map<String, Icon> paths2Icons;

        private IconLoader() {
        }

        public Icon obtainIcon(String iconPath) {
            Icon icon;
            if (this.paths2Icons == null) {
                this.paths2Icons = new HashMap<String, Icon>(6);
            }
            if ((icon = this.paths2Icons.get(iconPath)) == null) {
                Image image = TabControlButtonFactory.loadImage(iconPath);
                if (image == null) {
                    throw new IllegalArgumentException("Icon with resource path: " + iconPath + " can't be loaded, probably wrong path.");
                }
                icon = new ImageIcon(image);
                this.paths2Icons.put(iconPath, icon);
            }
            return icon;
        }
    }

    private static class MaximizeRestoreButton
    extends TabControlButton {
        public MaximizeRestoreButton(TabDisplayer displayer) {
            super(displayer);
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.registerComponent(this);
        }

        protected String getTabActionCommand(ActionEvent e) {
            return "maximize";
        }

        protected int getButtonId() {
            WinsysInfoForTabbed winsysInfo;
            int retValue = 3;
            Component currentTab = TabControlButtonFactory.getActiveTab(this.getTabDisplayer());
            if (null != currentTab && null != (winsysInfo = this.getTabDisplayer().getWinsysInfo()) && winsysInfo.inMaximizedMode(currentTab)) {
                retValue = 4;
            }
            return retValue;
        }

        public String getToolTipText() {
            if (this.getButtonId() == 3) {
                return ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Maximize_Window");
            }
            return ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Restore_Window");
        }
    }

    private static class SlidePinButton
    extends TabControlButton {
        public SlidePinButton(TabDisplayer displayer) {
            super(displayer);
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.registerComponent(this);
        }

        protected String getTabActionCommand(ActionEvent e) {
            if (this.getButtonId() == 2) {
                return "disableAutoHide";
            }
            return "enableAutoHide";
        }

        protected int getButtonId() {
            WinsysInfoForTabbed winsysInfo;
            int retValue = 2;
            Component currentTab = TabControlButtonFactory.getActiveTab(this.getTabDisplayer());
            if (null != currentTab && null != (winsysInfo = this.getTabDisplayer().getWinsysInfo())) {
                Object orientation = winsysInfo.getOrientation(currentTab);
                if (TabDisplayer.ORIENTATION_EAST.equals(orientation)) {
                    retValue = 6;
                } else if (TabDisplayer.ORIENTATION_WEST.equals(orientation)) {
                    retValue = 5;
                } else if (TabDisplayer.ORIENTATION_SOUTH.equals(orientation)) {
                    retValue = 7;
                }
            }
            return retValue;
        }

        public String getToolTipText() {
            if (this.getButtonId() == 2) {
                return ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Pin");
            }
            return ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Minimize_Window");
        }
    }

    private static class TimerButton
    extends TabControlButton
    implements ActionListener {
        Timer timer = null;
        int count = 0;

        public TimerButton(int buttonId, TabDisplayer displayer, Action a) {
            super(buttonId, displayer);
            this.setAction(a);
        }

        private Timer getTimer() {
            if (this.timer == null) {
                this.timer = new Timer(400, this);
                this.timer.setRepeats(true);
            }
            return this.timer;
        }

        public void actionPerformed(ActionEvent e) {
            ++this.count;
            if (this.count > 2) {
                if (this.count > 5) {
                    this.timer.setDelay(75);
                } else {
                    this.timer.setDelay(200);
                }
            }
            this.performAction();
        }

        private void performAction() {
            if (!this.isEnabled()) {
                this.stopTimer();
                return;
            }
            this.getAction().actionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }

        private void startTimer() {
            Timer t = this.getTimer();
            if (t.isRunning()) {
                return;
            }
            this.repaint();
            t.setDelay(400);
            t.start();
        }

        private void stopTimer() {
            if (this.timer != null) {
                this.timer.stop();
            }
            this.repaint();
            this.count = 0;
        }

        /*
         * Unable to fully structure code
         */
        protected void processMouseEvent(MouseEvent me) {
            if (!this.isEnabled()) ** GOTO lbl-1000
            if (me.getID() == 501) {
                this.startTimer();
            } else if (me.getID() == 502) {
                this.stopTimer();
            }
            super.processMouseEvent(me);
        }

        protected void processFocusEvent(FocusEvent fe) {
            super.processFocusEvent(fe);
            if (fe.getID() == 1005) {
                this.stopTimer();
            }
        }

        protected String getTabActionCommand(ActionEvent e) {
            return null;
        }
    }
}

