/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.uiapi;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.uiapi.CustomizerPane;
import org.netbeans.modules.project.uiapi.Utilities;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class CustomizerDialog {
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = 1;
    private static final String COMMAND_OK = "OK";
    private static final String COMMAND_CANCEL = "CANCEL";

    private CustomizerDialog() {
    }

    public static Dialog createDialog(ActionListener okOptionListener, final CustomizerPane innerPane, HelpCtx helpCtx, final ProjectCustomizer.Category[] categories, ProjectCustomizer.CategoryComponentProvider componentProvider) {
        ListeningButton okButton = new ListeningButton(NbBundle.getMessage(CustomizerDialog.class, (String)"LBL_Customizer_Ok_Option"), categories);
        okButton.setEnabled(CustomizerDialog.checkValidity(categories));
        Object[] options = new JButton[]{okButton, new JButton(NbBundle.getMessage(CustomizerDialog.class, (String)"LBL_Customizer_Cancel_Option"))};
        options[0].setActionCommand(COMMAND_OK);
        options[1].setActionCommand(COMMAND_CANCEL);
        options[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerDialog.class, (String)"AD_Customizer_Ok_Option"));
        options[1].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerDialog.class, (String)"AD_Customizer_Cancel_Option"));
        OptionListener optionsListener = new OptionListener(okOptionListener, categories, componentProvider);
        options[0].addActionListener(optionsListener);
        options[1].addActionListener(optionsListener);
        innerPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerDialog.class, (String)"AN_ProjectCustomizer"));
        innerPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerDialog.class, (String)"AD_ProjectCustomizer"));
        if (helpCtx == null) {
            helpCtx = HelpCtx.DEFAULT_HELP;
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)innerPane, NbBundle.getMessage(CustomizerDialog.class, (String)"LBL_Customizer_Title"), false, options, (Object)options[0], 0, helpCtx, null);
        innerPane.addPropertyChangeListener(new HelpCtxChangeListener(dialogDescriptor, helpCtx));
        if (innerPane instanceof HelpCtx.Provider) {
            dialogDescriptor.setHelpCtx(innerPane.getHelpCtx());
        }
        dialogDescriptor.setClosingOptions(new Object[]{options[0], options[1]});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                innerPane.clearPanelComponentCache();
                LinkedList<ProjectCustomizer.Category> queue = new LinkedList<ProjectCustomizer.Category>(Arrays.asList(categories));
                while (!queue.isEmpty()) {
                    ProjectCustomizer.Category category = (ProjectCustomizer.Category)queue.remove(0);
                    Utilities.removeCategoryChangeSupport(category);
                    if (category.getSubcategories() == null) continue;
                    queue.addAll(Arrays.asList(category.getSubcategories()));
                }
            }
        });
        return dialog;
    }

    private static boolean checkValidity(ProjectCustomizer.Category[] categories) {
        for (ProjectCustomizer.Category c : categories) {
            if (!c.isValid()) {
                return false;
            }
            ProjectCustomizer.Category[] subCategories = c.getSubcategories();
            if (subCategories == null || CustomizerDialog.checkValidity(subCategories)) continue;
            return false;
        }
        return true;
    }

    private static class HelpCtxChangeListener
    implements PropertyChangeListener {
        DialogDescriptor dialogDescriptor;
        HelpCtx defaultHelpCtx;

        HelpCtxChangeListener(DialogDescriptor dialogDescriptor, HelpCtx defaultHelpCtx) {
            this.dialogDescriptor = dialogDescriptor;
            this.defaultHelpCtx = defaultHelpCtx;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("helpCtxProperty".equals(evt.getPropertyName())) {
                HelpCtx newHelp = (HelpCtx)evt.getNewValue();
                this.dialogDescriptor.setHelpCtx(newHelp == null || newHelp == HelpCtx.DEFAULT_HELP ? this.defaultHelpCtx : newHelp);
            }
        }
    }

    private static class ListeningButton
    extends JButton
    implements PropertyChangeListener {
        private ProjectCustomizer.Category[] categories;

        public ListeningButton(String label, ProjectCustomizer.Category[] categories) {
            super(label);
            this.categories = categories;
            for (ProjectCustomizer.Category c : categories) {
                Utilities.getCategoryChangeSupport(c).addPropertyChangeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "isCategoryValid") {
                boolean valid = (Boolean)evt.getNewValue();
                this.setEnabled(valid && CustomizerDialog.checkValidity(this.categories));
            }
        }
    }

    private static class OptionListener
    implements ActionListener {
        private ActionListener okOptionListener;
        private ProjectCustomizer.Category[] categories;
        private Lookup.Provider prov;

        OptionListener(ActionListener okOptionListener, ProjectCustomizer.Category[] categs, ProjectCustomizer.CategoryComponentProvider componentProvider) {
            this.okOptionListener = okOptionListener;
            this.categories = categs;
            if (componentProvider instanceof Lookup.Provider) {
                this.prov = (Lookup.Provider)componentProvider;
            }
        }

        public void actionPerformed(final ActionEvent e) {
            String command = e.getActionCommand();
            if (CustomizerDialog.COMMAND_OK.equals(command)) {
                ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Object>(){

                    public Object run() {
                        OptionListener.this.okOptionListener.actionPerformed(e);
                        OptionListener.this.actionPerformed(e, OptionListener.this.categories);
                        if (OptionListener.this.prov != null) {
                            Project prj = (Project)OptionListener.this.prov.getLookup().lookup(Project.class);
                            if (ProjectManager.getDefault().isModified(prj)) {
                                try {
                                    ProjectManager.getDefault().saveProject(prj);
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                                catch (IllegalArgumentException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                        }
                        return null;
                    }
                });
            }
        }

        private void actionPerformed(ActionEvent e, ProjectCustomizer.Category[] categs) {
            for (int i = 0; i < categs.length; ++i) {
                ActionListener list = categs[i].getOkButtonListener();
                if (list != null) {
                    list.actionPerformed(e);
                }
                if (categs[i].getSubcategories() == null) continue;
                this.actionPerformed(e, categs[i].getSubcategories());
            }
        }
    }
}

