/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.ui.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class NodeFactorySupport {
    private NodeFactorySupport() {
    }

    public static Children createCompositeChildren(Project project, String folderPath) {
        return new DelegateChildren(project, folderPath);
    }

    public static NodeList fixedNodeList(Node ... nodes) {
        return new FixedNodeList(nodes);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DelegateChildren
    extends Children.Keys<NodeListKeyWrapper>
    implements LookupListener,
    ChangeListener {
        private String folderPath;
        private Project project;
        private List<NodeList<?>> nodeLists = new ArrayList();
        private List<NodeFactory> factories = new ArrayList<NodeFactory>();
        private Lookup.Result<NodeFactory> result;
        private HashMap<NodeList<?>, List<NodeListKeyWrapper>> keys;

        public DelegateChildren(Project proj, String path) {
            this.folderPath = path;
            this.project = proj;
        }

        protected Lookup createLookup() {
            FileObject root = Repository.getDefault().getDefaultFileSystem().findResource(this.folderPath);
            assert (root != null) : "Cannot find path " + this.folderPath + " in layers";
            DataFolder folder = DataFolder.findFolder((FileObject)root);
            return new FolderLookup((DataObject.Container)folder).getLookup();
        }

        protected Node[] createNodes(NodeListKeyWrapper key) {
            Node nd = key.nodeList.node(key.object);
            if (nd != null) {
                return new Node[]{nd};
            }
            return new Node[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection<NodeListKeyWrapper> createKeys() {
            ArrayList<NodeListKeyWrapper> col = new ArrayList<NodeListKeyWrapper>();
            HashMap<NodeList<?>, List<NodeListKeyWrapper>> hashMap = this.keys;
            synchronized (hashMap) {
                for (NodeList<?> lst : this.nodeLists) {
                    List<NodeListKeyWrapper> x = this.keys.get(lst);
                    if (x == null) continue;
                    col.addAll(x);
                }
            }
            return col;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addNotify() {
            super.addNotify();
            this.keys = new HashMap();
            this.result = this.createLookup().lookup(new Lookup.Template(NodeFactory.class));
            for (NodeFactory factory : this.result.allInstances()) {
                NodeList<?> lst = factory.createNodes(this.project);
                assert (lst != null) : "Factory " + factory.getClass() + " has broken the NodeFactory contract.";
                lst.addNotify();
                HashMap<NodeList<?>, List<NodeListKeyWrapper>> hashMap = this.keys;
                synchronized (hashMap) {
                    this.nodeLists.add(lst);
                    this.addKeys(lst);
                }
                lst.addChangeListener(this);
                this.factories.add(factory);
            }
            this.result.addLookupListener((LookupListener)this);
            this.setKeys(this.createKeys());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeNotify() {
            super.removeNotify();
            this.setKeys(Collections.emptySet());
            for (NodeList<?> elem : this.nodeLists) {
                elem.removeChangeListener(this);
                elem.removeNotify();
            }
            HashMap<NodeList<?>, List<NodeListKeyWrapper>> hashMap = this.keys;
            synchronized (hashMap) {
                this.keys.clear();
                this.nodeLists.clear();
            }
            this.factories.clear();
            if (this.result != null) {
                this.result.removeLookupListener((LookupListener)this);
                this.result = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            NodeList list = (NodeList)e.getSource();
            HashMap<NodeList<?>, List<NodeListKeyWrapper>> hashMap = this.keys;
            synchronized (hashMap) {
                this.removeKeys(list);
                this.addKeys(list);
            }
            this.setKeys(this.createKeys());
        }

        private void addKeys(NodeList list) {
            ArrayList<NodeListKeyWrapper> wrps = new ArrayList<NodeListKeyWrapper>();
            for (Object key : list.keys()) {
                wrps.add(new NodeListKeyWrapper(key, list));
            }
            this.keys.put(list, wrps);
        }

        private void removeKeys(NodeList list) {
            this.keys.remove(list);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent ev) {
            int index = 0;
            for (NodeFactory factory : this.result.allInstances()) {
                if (!this.factories.contains(factory)) {
                    this.factories.add(index, factory);
                    NodeList<?> lst = factory.createNodes(this.project);
                    assert (lst != null);
                    HashMap<NodeList<?>, List<NodeListKeyWrapper>> hashMap = this.keys;
                    synchronized (hashMap) {
                        this.nodeLists.add(index, lst);
                        this.addKeys(lst);
                    }
                    lst.addNotify();
                    lst.addChangeListener(this);
                } else {
                    while (!factory.equals(this.factories.get(index))) {
                        this.factories.remove(index);
                        HashMap<NodeList<?>, List<NodeListKeyWrapper>> hashMap = this.keys;
                        synchronized (hashMap) {
                            NodeList<?> lst = this.nodeLists.remove(index);
                            this.removeKeys(lst);
                            lst.removeNotify();
                            lst.removeChangeListener(this);
                        }
                    }
                }
                ++index;
            }
            this.setKeys(this.createKeys());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedNodeList
    implements NodeList<Node> {
        private List<Node> nodes;

        FixedNodeList(Node ... nds) {
            this.nodes = Arrays.asList(nds);
        }

        @Override
        public List<Node> keys() {
            return this.nodes;
        }

        @Override
        public void addChangeListener(ChangeListener l) {
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
        }

        @Override
        public void addNotify() {
        }

        @Override
        public void removeNotify() {
        }

        @Override
        public Node node(Node key) {
            return key;
        }
    }

    private static class NodeListKeyWrapper {
        NodeList nodeList;
        Object object;

        NodeListKeyWrapper(Object obj, NodeList list) {
            this.nodeList = list;
            this.object = obj;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NodeListKeyWrapper)) {
                return false;
            }
            NodeListKeyWrapper other = (NodeListKeyWrapper)obj;
            if (!this.nodeList.equals(other.nodeList)) {
                return false;
            }
            return this.object.equals(other.object);
        }

        public int hashCode() {
            return (629 + this.nodeList.hashCode()) * 37 + this.object.hashCode();
        }
    }
}

