/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.ui.support;

import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.project.uiapi.CategoryChangeSupport;
import org.netbeans.modules.project.uiapi.CategoryModel;
import org.netbeans.modules.project.uiapi.CategoryView;
import org.netbeans.modules.project.uiapi.CustomizerDialog;
import org.netbeans.modules.project.uiapi.CustomizerPane;
import org.netbeans.modules.project.uiapi.Utilities;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public final class ProjectCustomizer {
    private ProjectCustomizer() {
    }

    public static Dialog createCustomizerDialog(Category[] categories, CategoryComponentProvider componentProvider, String preselectedCategory, ActionListener okOptionListener, HelpCtx helpCtx) {
        CustomizerPane innerPane = ProjectCustomizer.createCustomizerPane(categories, componentProvider, preselectedCategory);
        Dialog dialog = CustomizerDialog.createDialog(okOptionListener, innerPane, helpCtx, categories, componentProvider);
        return dialog;
    }

    public static Dialog createCustomizerDialog(String folderPath, Lookup context, String preselectedCategory, ActionListener okOptionListener, HelpCtx helpCtx) {
        FileObject root = Repository.getDefault().getDefaultFileSystem().findResource(folderPath);
        if (root == null) {
            throw new IllegalArgumentException("The designated path " + folderPath + " doesn't exist. Cannot create customizer.");
        }
        DataFolder def = DataFolder.findFolder((FileObject)root);
        assert (def != null) : "Cannot find DataFolder for " + folderPath;
        DelegateCategoryProvider prov = new DelegateCategoryProvider(def, context);
        return ProjectCustomizer.createCustomizerDialog(prov.getSubCategories(), prov, preselectedCategory, okOptionListener, helpCtx);
    }

    private static CustomizerPane createCustomizerPane(Category[] categories, CategoryComponentProvider componentProvider, String preselectedCategory) {
        Category c;
        CategoryChangeSupport changeSupport = new CategoryChangeSupport();
        ProjectCustomizer.registerCategoryChangeSupport(changeSupport, categories);
        CategoryModel categoryModel = new CategoryModel(categories);
        CategoryView categoryView = new CategoryView(categoryModel);
        CustomizerPane customizerPane = new CustomizerPane(categoryView, categoryModel, componentProvider);
        if (preselectedCategory == null) {
            preselectedCategory = categories[0].getName();
        }
        if ((c = categoryModel.getCategory(preselectedCategory)) != null) {
            categoryModel.setCurrentCategory(c);
        }
        return customizerPane;
    }

    private static void registerCategoryChangeSupport(CategoryChangeSupport changeSupport, Category[] categories) {
        for (int i = 0; i < categories.length; ++i) {
            Utilities.putCategoryChangeSupport(categories[i], changeSupport);
            Category[] subCategories = categories[i].getSubcategories();
            if (subCategories == null) continue;
            ProjectCustomizer.registerCategoryChangeSupport(changeSupport, subCategories);
        }
    }

    public static final class Category {
        private String name;
        private String displayName;
        private Image icon;
        private Category[] subcategories;
        private boolean valid;
        private String errorMessage;
        private ActionListener okListener;

        private Category(String name, String displayName, Image icon, Category[] subcategories) {
            this.name = name;
            this.displayName = displayName;
            this.icon = icon;
            this.subcategories = subcategories;
            this.valid = true;
        }

        public static Category create(String name, String displayName, Image icon, Category ... subcategories) {
            return new Category(name, displayName, icon, subcategories);
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Image getIcon() {
            return this.icon;
        }

        public Category[] getSubcategories() {
            return this.subcategories;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            if (this.valid != valid) {
                this.valid = valid;
                Utilities.getCategoryChangeSupport(this).firePropertyChange("isCategoryValid", !valid, valid);
            }
        }

        public void setErrorMessage(String message) {
            if (message == null) {
                message = "";
            }
            if (!message.equals(this.errorMessage)) {
                String oldMessage = this.errorMessage;
                this.errorMessage = message;
                Utilities.getCategoryChangeSupport(this).firePropertyChange("categoryErrorMessage", oldMessage, message);
            }
        }

        public void setOkButtonListener(ActionListener okButtonListener) {
            this.okListener = okButtonListener;
        }

        public ActionListener getOkButtonListener() {
            return this.okListener;
        }
    }

    public static interface CategoryComponentProvider {
        public JComponent create(Category var1);
    }

    public static interface CompositeCategoryProvider {
        public Category createCategory(Lookup var1);

        public JComponent createComponent(Category var1, Lookup var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DelegateCategoryProvider
    implements CategoryComponentProvider,
    CompositeCategoryProvider,
    Lookup.Provider {
        private final Lookup context;
        private final Map<Category, CompositeCategoryProvider> category2provider;
        private final DataFolder folder;
        private final CompositeCategoryProvider selfProvider;

        public DelegateCategoryProvider(DataFolder folder, Lookup context) {
            this(folder, context, new HashMap<Category, CompositeCategoryProvider>());
        }

        private DelegateCategoryProvider(DataFolder folder, Lookup context, Map<Category, CompositeCategoryProvider> cat2Provider) {
            this(folder, context, cat2Provider, null);
        }

        private DelegateCategoryProvider(DataFolder folder, Lookup context, Map<Category, CompositeCategoryProvider> cat2Provider, CompositeCategoryProvider sProv) {
            this.context = context;
            this.folder = folder;
            this.category2provider = cat2Provider;
            this.selfProvider = sProv;
        }

        @Override
        public JComponent create(Category category) {
            CompositeCategoryProvider prov = this.category2provider.get(category);
            assert (prov != null) : "Category doesn't have a provider associated.";
            return prov.createComponent(category, this.context);
        }

        public Category[] getSubCategories() {
            try {
                return this.readCategories(this.folder);
            }
            catch (IOException exc) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Cannot construct Project UI panels", exc);
                return new Category[0];
            }
            catch (ClassNotFoundException ex) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Cannot construct Project UI panels", ex);
                return new Category[0];
            }
        }

        Category[] readCategories(DataFolder folder) throws IOException, ClassNotFoundException {
            ArrayList<Category> toRet = new ArrayList<Category>();
            for (DataObject dob : folder.getChildren()) {
                CompositeCategoryProvider provider;
                Category cat;
                InstanceCookie cook;
                if (dob instanceof DataFolder) {
                    DataObject[] subDobs;
                    CompositeCategoryProvider sProvider = null;
                    for (DataObject subDob : subDobs = ((DataFolder)dob).getChildren()) {
                        InstanceCookie cookie;
                        if (!subDob.getName().equals("Self") || (cookie = (InstanceCookie)subDob.getCookie(InstanceCookie.class)) == null || !CompositeCategoryProvider.class.isAssignableFrom(cookie.instanceClass())) continue;
                        sProvider = (CompositeCategoryProvider)cookie.instanceCreate();
                    }
                    DelegateCategoryProvider prov = null;
                    prov = sProvider != null ? new DelegateCategoryProvider((DataFolder)dob, this.context, this.category2provider, sProvider) : new DelegateCategoryProvider((DataFolder)dob, this.context, this.category2provider);
                    Category cat2 = prov.createCategory(this.context);
                    toRet.add(cat2);
                    this.category2provider.put(cat2, prov);
                }
                if (dob.getName().equals("Self") || (cook = (InstanceCookie)dob.getCookie(InstanceCookie.class)) == null || !CompositeCategoryProvider.class.isAssignableFrom(cook.instanceClass()) || (cat = (provider = (CompositeCategoryProvider)cook.instanceCreate()).createCategory(this.context)) == null) continue;
                toRet.add(cat);
                this.category2provider.put(cat, provider);
                this.includeSubcats(cat.getSubcategories(), provider);
            }
            return toRet.toArray(new Category[toRet.size()]);
        }

        private void includeSubcats(Category[] cats, CompositeCategoryProvider provider) {
            if (cats != null) {
                for (Category cat : cats) {
                    this.category2provider.put(cat, provider);
                    this.includeSubcats(cat.getSubcategories(), provider);
                }
            }
        }

        @Override
        public Category createCategory(Lookup context) {
            FileObject fo = this.folder.getPrimaryFile();
            String dn = fo.getNameExt();
            try {
                dn = fo.getFileSystem().getStatus().annotateName(fo.getNameExt(), Collections.singleton(fo));
            }
            catch (FileStateInvalidException ex) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Cannot retrieve display name for folder " + fo.getPath(), ex);
            }
            return Category.create(this.folder.getName(), dn, null, this.getSubCategories());
        }

        @Override
        public JComponent createComponent(Category category, Lookup context) {
            if (this.selfProvider != null) {
                return this.selfProvider.createComponent(category, context);
            }
            return new JPanel();
        }

        public Lookup getLookup() {
            return this.context;
        }
    }
}

