/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax.io;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDTDContentModelHandler;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLDTDContentModelSource;
import org.apache.xerces.xni.parser.XMLDTDSource;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.netbeans.tax.TreeAttlistDecl;
import org.netbeans.tax.TreeAttlistDeclAttributeDef;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeCDATASection;
import org.netbeans.tax.TreeCharacterReference;
import org.netbeans.tax.TreeComment;
import org.netbeans.tax.TreeConditionalSection;
import org.netbeans.tax.TreeDTD;
import org.netbeans.tax.TreeDTDFragment;
import org.netbeans.tax.TreeDocument;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeDocumentType;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeElementDecl;
import org.netbeans.tax.TreeEntityDecl;
import org.netbeans.tax.TreeEntityReference;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeGeneralEntityReference;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeNotationDecl;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.TreeParameterEntityReference;
import org.netbeans.tax.TreeParentNode;
import org.netbeans.tax.TreeProcessingInstruction;
import org.netbeans.tax.TreeText;
import org.netbeans.tax.decl.ANYType;
import org.netbeans.tax.decl.ChildrenType;
import org.netbeans.tax.decl.ChoiceType;
import org.netbeans.tax.decl.EMPTYType;
import org.netbeans.tax.decl.MixedType;
import org.netbeans.tax.decl.NameType;
import org.netbeans.tax.decl.SequenceType;
import org.netbeans.tax.io.RememberingReader;
import org.netbeans.tax.io.StringUtil;
import org.netbeans.tax.io.TreeBuilder;
import org.netbeans.tax.io.TreeStreamBuilderErrorHandler;
import org.netbeans.tax.io.Util;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XNIBuilder
implements TreeBuilder {
    private static final boolean ASSERT = false;
    private static final String DTD_WRAPPER = "<!DOCTYPE DTD PUBLIC \"{0}\" \"{1}\">";
    private Class buildClass;
    private InputSource inputSource;
    private TreeStreamBuilderErrorHandler errorHandler;
    private EntityResolver entityResolver;
    static /* synthetic */ Class class$org$netbeans$tax$TreeObject;

    public XNIBuilder(Class buildClass, InputSource inputSource, EntityResolver entityResolver, TreeStreamBuilderErrorHandler errorHandler) {
        this.init(buildClass, inputSource, entityResolver, errorHandler);
    }

    private void init(Class buildClass, InputSource inputSource, EntityResolver entityResolver, TreeStreamBuilderErrorHandler errorHandler) {
        this.inputSource = inputSource;
        this.buildClass = buildClass;
        this.errorHandler = errorHandler;
        this.entityResolver = entityResolver;
    }

    public TreeDocumentRoot buildDocument() throws TreeException {
        boolean buildXML = true;
        InputSource builderSource = this.inputSource;
        EntityResolver builderResolver = this.entityResolver;
        if (this.buildClass == TreeDTD.class) {
            String src = MessageFormat.format(DTD_WRAPPER, "PRIVATE//AUXILIARY DTD ID//PRIVATE", this.inputSource.getSystemId());
            builderSource = new InputSource(this.inputSource.getSystemId());
            builderSource.setCharacterStream(new StringReader(src));
            builderResolver = new DTDEntityResolver();
            buildXML = false;
        }
        XMLBuilder builder = new XMLBuilder(buildXML);
        try {
            String SAX_FEATURE = "http://xml.org/sax/features/";
            String XERCES_FEATURE = "http://apache.org/xml/features/";
            builder.setFeature("http://xml.org/sax/features/namespaces", false);
            builder.setFeature("http://xml.org/sax/features/validation", false);
            builder.setFeature("http://xml.org/sax/features/external-general-entities", true);
            builder.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
            builder.setFeature("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", true);
            builder.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            builder.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            builder.setFeature("http://apache.org/xml/features/scanner/notify-builtin-refs", true);
            builder.setEntityResolver(builderResolver);
            builder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException e) {
                }

                public void warning(SAXParseException e) {
                }

                public void fatalError(SAXParseException e) {
                }
            });
            builder.parse(builderSource);
        }
        catch (DTDStopException stop) {
        }
        catch (SAXException sax) {
            Exception exception = sax.getException();
            if (!(exception instanceof DTDStopException)) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("sax", sax);
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("exception", exception);
                }
                if (exception instanceof XNIException) {
                    exception = ((XNIException)exception).getException();
                }
                if (exception != null) {
                    if (!(exception instanceof TreeException)) {
                        exception = new TreeException(sax);
                    }
                } else {
                    exception = new TreeException(sax);
                }
                throw (TreeException)exception;
            }
        }
        catch (IOException exc) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("exc", exc);
            }
            throw new TreeException(exc);
        }
        return builder.getDocumentRoot();
    }

    private class DTDEntityResolver
    implements EntityResolver {
        static final String DTD_ID = "PRIVATE//AUXILIARY DTD ID//PRIVATE";

        private DTDEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (DTD_ID.equals(publicId)) {
                return XNIBuilder.this.inputSource;
            }
            return XNIBuilder.this.entityResolver.resolveEntity(publicId, systemId);
        }
    }

    private class DTDStopException
    extends XNIException {
        private static final long serialVersionUID = 4994054007367982021L;

        public DTDStopException() {
            super("This exception is used to signal end of DTD.");
        }

        public Exception getException() {
            return this;
        }

        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private class XMLBuilder
    extends SAXParser
    implements XMLDTDContentModelHandler,
    XMLDocumentHandler,
    XMLDTDHandler {
        private TreeDocumentRoot returnDocument;
        private TreeDocumentRoot document;
        private TreeDocumentType doctype;
        private TreeNode tempNode;
        private Stack parentObjectListStack;
        private TreeObjectList parentObjectList;
        private Stack parentNodeStack;
        private Stack elementStack;
        private int entityCounter;
        private boolean isXMLDocument;
        private boolean inCDATASection;
        private boolean inDTD;
        private boolean isCorrect;
        private boolean inCharacterRef;
        private StringBuffer cdataSectionBuffer;
        private QName tmpQName = new QName();
        private TreeAttlistDecl attlistDecl = null;
        private int errors = 0;
        private final String XML_ENTITY = "[xml]";
        private final String DTD_ENTITY = "[dtd]";
        private XMLLocator locator;
        private boolean hasExternalDTD = false;
        private RememberingReader rememberingReader;
        private XMLDTDSource xmldtdSource;
        private XMLDTDContentModelSource xmldtdContentModelSource;
        private XMLDocumentSource xmlDocumentSource;
        private TreeElementDecl.ContentType lastType;
        private TreeElementDecl.ContentType contentModel;
        private Stack contentModelMembersStack;

        public XMLBuilder(boolean xmlDocument) {
            this.isXMLDocument = xmlDocument;
            this.entityCounter = 0;
            this.isCorrect = false;
            this.inCDATASection = false;
            this.inDTD = false;
            this.parentObjectListStack = new Stack();
            this.parentNodeStack = new Stack();
            this.elementStack = new Stack();
            this.cdataSectionBuffer = new StringBuffer();
            this.inCharacterRef = false;
        }

        public void parse(InputSource in) throws IOException, SAXException {
            Reader reader = in.getCharacterStream();
            if (reader != null) {
                this.rememberingReader = new RememberingReader(reader);
                in.setCharacterStream(this.rememberingReader);
                this.rememberingReader.startRemembering();
            }
            super.parse(in);
        }

        public XMLDocumentSource getDocumentSource() {
            return this.xmlDocumentSource;
        }

        public void setDocumentSource(XMLDocumentSource src) {
            this.xmlDocumentSource = src;
        }

        public void startDocument(XMLLocator locator, String encoding, NamespaceContext nsCtx, Augmentations a) {
            this.startDocument(locator, encoding, a);
        }

        public void startDocument(XMLLocator locator, String encoding, Augmentations a) {
            this.trace("startDocument()");
            this.locator = locator;
            try {
                this.returnDocument = this.document = new TreeDocument(null, null, null);
                this.pushParentNode((TreeDocument)this.document);
            }
            catch (TreeException exc) {
                throw new XNIException((Exception)exc);
            }
        }

        public void xmlDecl(String version, String encoding, String standalone, Augmentations a) {
            this.trace("xmlDecl()");
            try {
                ((TreeDocument)this.document).setHeader(version, encoding, standalone);
            }
            catch (TreeException exc) {
                throw new XNIException((Exception)exc);
            }
        }

        public void textDecl(String version, String encoding, Augmentations a) {
            this.trace("textDecl()");
            if (!this.isXMLDocument && this.inDTD && !this.inEntity()) {
                try {
                    ((TreeDTD)this.document).setHeader(version, encoding);
                }
                catch (TreeException ex) {
                    throw new XNIException((Exception)ex);
                }
            }
        }

        public void textDecl(String version, String encoding) {
            this.textDecl(version, encoding, null);
        }

        public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations a) {
            this.trace("doctypeDecl(" + rootElement + "," + publicId + ")");
            try {
                TreeDocumentType _doctype = new TreeDocumentType(rootElement, publicId, systemId);
                this.setBeginPosition(_doctype);
                ((TreeDocument)this.document).setDocumentType(_doctype);
                this.doctype = _doctype;
            }
            catch (TreeException exc) {
                throw new XNIException((Exception)exc);
            }
        }

        public void startElement(QName element, XMLAttributes attributes, Augmentations a) {
            this.trace("startElement(" + element + ")");
            try {
                this.tempNode = new TreeElement(element.rawname);
                this.startElementImpl((TreeElement)this.tempNode, attributes);
                this.pushParentNode((TreeElement)this.tempNode);
                this.elementStack.push(this.tempNode);
            }
            catch (TreeException exc) {
                throw new XNIException((Exception)exc);
            }
        }

        public void emptyElement(QName qName, XMLAttributes attributes, Augmentations a) {
            this.trace("emptyElement(" + qName + ")");
            try {
                this.tempNode = new TreeElement(qName.rawname, true);
                this.startElementImpl((TreeElement)this.tempNode, attributes);
            }
            catch (TreeException exc) {
                throw new XNIException((Exception)exc);
            }
        }

        private void startElementImpl(TreeElement elem, XMLAttributes attributes) throws TreeException {
            block55: {
                char delimiter;
                this.setBeginPosition(elem);
                if (this.currentParentNode() instanceof TreeDocument) {
                    ((TreeDocument)this.currentParentNode()).setDocumentElement(elem);
                } else {
                    this.appendChild(elem);
                }
                int attrCount = attributes.getLength();
                for (int i = 0; i < attrCount; ++i) {
                    TreeAttribute attr;
                    boolean specified = attributes.isSpecified(i);
                    if (!specified) continue;
                    attributes.getName(i, this.tmpQName);
                    String val = attributes.getNonNormalizedValue(i);
                    if (val.indexOf(38) < 0) {
                        attr = new TreeAttribute(this.tmpQName.rawname, val, specified);
                    } else {
                        attr = new TreeAttribute(this.tmpQName.rawname, "", specified);
                        TreeObjectList list = attr.getValueList();
                        list.clear();
                        int lastOffset = 0;
                        int offset = val.indexOf(38);
                        while (offset >= 0) {
                            int endOffset = val.indexOf(59, offset);
                            String name = val.substring(offset + 1, endOffset);
                            if (offset > lastOffset) {
                                TreeText text = new TreeText(val.substring(lastOffset, offset));
                                list.add(text);
                            }
                            if (name.startsWith("#")) {
                                TreeCharacterReference chref = new TreeCharacterReference(name);
                                list.add(chref);
                            } else {
                                TreeGeneralEntityReference gref = new TreeGeneralEntityReference(name);
                                list.add(gref);
                            }
                            lastOffset = endOffset + 1;
                            offset = val.indexOf(38, offset + 1);
                        }
                        if (val.length() > lastOffset) {
                            String lastText = val.substring(lastOffset);
                            list.add(new TreeText(lastText));
                        }
                    }
                    if (!specified) {
                        this.setReadOnly(attr);
                    }
                    elem.addAttribute(attr);
                }
                if (this.rememberingReader == null) {
                    return;
                }
                StringBuffer mem = this.rememberingReader.stopRemembering();
                if (mem == null) {
                    return;
                }
                String idtd = mem.toString();
                int start = -1;
                int end = -1;
                int last = -1;
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("TreeStreamBuilderXercesImpl: going to inspect:\n" + idtd);
                }
                String DOCTYPE = "<!DOCTYPE";
                int pos = -1;
                block5: while (true) {
                    ++pos;
                    if ((pos = idtd.indexOf("<!DOCTYPE", pos)) == -1) {
                        Util.THIS.debug("XNIBuilder: no DOCTYPE detected.");
                        return;
                    }
                    int comment = -1;
                    do {
                        ++comment;
                        if ((comment = idtd.indexOf("<!--", comment)) == -1 || comment >= pos) break block5;
                    } while (idtd.indexOf("-->", comment) <= pos);
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("\nlast index = " + pos);
                }
                pos += "<!DOCTYPE".length();
                while (StringUtil.isWS(idtd.charAt(pos))) {
                    ++pos;
                }
                while (!StringUtil.isWS(idtd.charAt(pos))) {
                    ++pos;
                }
                while (StringUtil.isWS(idtd.charAt(pos))) {
                    ++pos;
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("\nafter process index = " + pos);
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("\nTesting DOCTYPE kind-----\n" + idtd.substring(pos));
                }
                if (idtd.charAt(pos) == '[') {
                    start = ++pos;
                } else if (idtd.charAt(pos) == 'S') {
                    while (!StringUtil.isWS(idtd.charAt(pos))) {
                        ++pos;
                    }
                    while (StringUtil.isWS(idtd.charAt(pos))) {
                        ++pos;
                    }
                    delimiter = idtd.charAt(pos++);
                    while (idtd.charAt(pos) != delimiter) {
                        ++pos;
                    }
                    ++pos;
                    while (StringUtil.isWS(idtd.charAt(pos))) {
                        ++pos;
                    }
                    if (idtd.charAt(pos) == '[') {
                        start = ++pos;
                    }
                } else if (idtd.charAt(pos) == 'P') {
                    while (!StringUtil.isWS(idtd.charAt(pos))) {
                        ++pos;
                    }
                    while (StringUtil.isWS(idtd.charAt(pos))) {
                        ++pos;
                    }
                    delimiter = idtd.charAt(pos++);
                    while (idtd.charAt(pos) != delimiter) {
                        ++pos;
                    }
                    ++pos;
                    while (StringUtil.isWS(idtd.charAt(pos))) {
                        ++pos;
                    }
                    delimiter = idtd.charAt(pos++);
                    while (idtd.charAt(pos) != delimiter) {
                        ++pos;
                    }
                    ++pos;
                    while (StringUtil.isWS(idtd.charAt(pos))) {
                        ++pos;
                    }
                    if (idtd.charAt(pos) == '[') {
                        start = ++pos;
                    }
                }
                if (start == -1) {
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("TreeStreamBuilderXercesImpl: it does not have internal DTD.");
                    }
                    return;
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("\n---Analyzing internal DTD:\n" + idtd.substring(start));
                }
                last = pos - 1;
                while (!idtd.startsWith("]>", pos) && last < pos) {
                    last = pos;
                    while (StringUtil.isWS(idtd.charAt(pos))) {
                        ++pos;
                    }
                    int now = StringUtil.skipDelimited(idtd, pos, "<!--", "-->");
                    if (now != -1) {
                        pos = now;
                        continue;
                    }
                    now = StringUtil.skipDelimited(idtd, pos, "<?", "?>");
                    if (now != -1) {
                        pos = now;
                        continue;
                    }
                    now = StringUtil.skipDelimited(idtd, pos, '<', '>', "\"'");
                    if (now != -1) {
                        pos = now;
                        continue;
                    }
                    now = StringUtil.skipDelimited(idtd, pos, '%', ';', "");
                    if (now == -1) continue;
                    pos = now;
                }
                if (last == pos) {
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("TreeStreamBuilderXercesImpl: end not reached");
                    }
                    return;
                }
                String internalDTDText = idtd.substring(start, pos);
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("Internal DTD:" + internalDTDText + "\n--");
                }
                try {
                    if (this.doctype == null) {
                        return;
                    }
                    Class<?> klass = this.doctype.getClass();
                    Field field = klass.getDeclaredField("internalDTDText");
                    field.setAccessible(true);
                    field.set(this.doctype, internalDTDText);
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    if (!Util.THIS.isLoggable()) break block55;
                    Util.THIS.debug("TreeStreamBuilderXercesImpl.settingInternaDTDText", ex);
                }
            }
        }

        public void characters(XMLString text, Augmentations a) {
            try {
                if (this.inCharacterRef) {
                    return;
                }
                if (this.inDTD) {
                    if (this.currentParentNode() instanceof TreeConditionalSection) {
                        if (Util.THIS.isLoggable()) {
                            Util.THIS.debug("\n*** TreeStreamBuilderXercesImpl::characters: XMLString = '" + text + "'");
                        }
                        ((TreeConditionalSection)this.currentParentNode()).setIgnoredContent(text.toString());
                    }
                } else if (this.inCDATASection) {
                    this.cdataSectionBuffer.append(text.toString());
                } else {
                    this.tempNode = new TreeText(text.toString());
                    this.setBeginPosition(this.tempNode);
                    this.appendChild((TreeText)this.tempNode);
                }
            }
            catch (TreeException exc) {
                throw new XNIException((Exception)exc);
            }
        }

        public void ignoredCharacters(XMLString text, Augmentations a) {
            this.characters(text, null);
        }

        public void characters(XMLString text) {
            this.characters(text, null);
        }

        public void ignorableWhitespace(XMLString text, Augmentations a) {
            try {
                this.tempNode = new TreeText(text.toString());
                this.setBeginPosition(this.tempNode);
                this.appendChild((TreeText)this.tempNode);
            }
            catch (TreeException exc) {
                throw new XNIException((Exception)exc);
            }
        }

        public void endElement(QName element, Augmentations a) {
            this.trace("endElement(" + element + ")");
            try {
                TreeElement el = (TreeElement)this.elementStack.pop();
                el.normalize();
                this.popParentNode();
            }
            catch (TreeException exc) {
                throw new XNIException((Exception)exc);
            }
        }

        public void startCDATA(Augmentations a) {
            this.inCDATASection = true;
            this.cdataSectionBuffer.delete(0, this.cdataSectionBuffer.length());
        }

        public void endCDATA(Augmentations a) {
            this.inCDATASection = false;
            try {
                this.tempNode = new TreeCDATASection(this.cdataSectionBuffer.toString());
                this.setBeginPosition(this.tempNode);
                this.appendChild((TreeCDATASection)this.tempNode);
            }
            catch (TreeException exc) {
                throw new XNIException((Exception)exc);
            }
        }

        public void endDocument(Augmentations a) {
            this.trace("endDocument()");
            if (!this.parentObjectListStack.isEmpty()) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("Inconsistency at parentStack: " + this.parentObjectListStack);
                }
            } else if (!this.elementStack.isEmpty()) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("Inconsistency at elementStack: " + this.parentObjectListStack);
                }
            } else {
                this.isCorrect = true;
            }
        }

        public void endPrefixMapping(String prefix, Augmentations a) {
        }

        public void startPrefixMapping(String prefix, String uri, Augmentations a) {
        }

        public void startExternalSubset(XMLResourceIdentifier entity, Augmentations a) {
            this.startEntity("[dtd]", entity.getPublicId(), entity.getLiteralSystemId(), entity.getBaseSystemId(), null, a);
        }

        public void startGeneralEntity(String name, XMLResourceIdentifier entity, String encoding, Augmentations a) {
            this.startEntity(name, entity.getPublicId(), entity.getLiteralSystemId(), entity.getBaseSystemId(), encoding, a);
        }

        private void startEntity(String name, String publicId, String systemId, String baseSystemId, String encoding, Augmentations a) {
            this.trace("startEntity(" + name + ")");
            try {
                if ("[xml]".equals(name)) {
                    return;
                }
                if (!this.isXMLDocument && "[dtd]".equals(name)) {
                    return;
                }
                if ("[dtd]".equals(name) && this.isXMLDocument) {
                    this.hasExternalDTD = true;
                    TreeObjectList external = this.doctype.getExternalDTD();
                    if (external == null) {
                        TreeDTDFragment entity = new TreeDTDFragment();
                        TreeObjectList holder = entity.getChildNodes();
                        this.pushParentObjectList(holder);
                        this.doctype.setExternalDTD(entity);
                    } else {
                        this.pushParentObjectList(null);
                    }
                } else if (name.startsWith("#")) {
                    this.tempNode = new TreeCharacterReference(name);
                    this.appendChild(this.tempNode);
                    this.setBeginPosition(this.tempNode);
                    this.inCharacterRef = true;
                } else if ("lt".equals(name) || "gt".equals(name) || "amp".equals(name) || "apos".equals(name) || "quot".equals(name)) {
                    this.tempNode = new TreeGeneralEntityReference(name);
                    this.appendChild(this.tempNode);
                    this.setBeginPosition(this.tempNode);
                    this.inCharacterRef = true;
                } else if (name.startsWith("%")) {
                    if ("IGNORE".equals(encoding)) {
                        name = name.substring(1);
                        this.pushParentNode(new TreeParameterEntityReference(name));
                    } else {
                        name = name.substring(1);
                        this.tempNode = new TreeParameterEntityReference(name);
                        this.appendChild((TreeParameterEntityReference)this.tempNode);
                        this.setBeginPosition(this.tempNode);
                        this.pushParentNode((TreeEntityReference)this.tempNode);
                    }
                } else {
                    this.tempNode = new TreeGeneralEntityReference(name);
                    this.appendChild((TreeGeneralEntityReference)this.tempNode);
                    this.setBeginPosition(this.tempNode);
                    this.pushParentNode((TreeEntityReference)this.tempNode);
                }
                this.enterEntity();
            }
            catch (TreeException exc) {
                throw new XNIException((Exception)exc);
            }
        }

        public void startEntity(String name, String publicId, String systemId, String baseSystemId, String encoding) {
            this.startEntity(name, publicId, systemId, baseSystemId, encoding, null);
        }

        public void startParameterEntity(String name, XMLResourceIdentifier entity, String encoding, Augmentations a) {
            String pname = name;
            if (!name.startsWith("%")) {
                pname = "%" + name;
            }
            this.startEntity(pname, entity.getPublicId(), entity.getLiteralSystemId(), entity.getBaseSystemId(), encoding, a);
        }

        public void comment(XMLString text, Augmentations a) {
            this.trace("comment()");
            try {
                this.tempNode = new TreeComment(text.toString());
                this.setBeginPosition(this.tempNode);
                this.appendChild((TreeComment)this.tempNode);
            }
            catch (TreeException exc) {
                throw new XNIException((Exception)exc);
            }
        }

        public void comment(XMLString text) {
            this.comment(text, null);
        }

        public void processingInstruction(String target, XMLString data, Augmentations a) {
            this.trace("processingInstruction(" + target + ")");
            try {
                this.tempNode = new TreeProcessingInstruction(target, data.toString());
                this.setBeginPosition(this.tempNode);
                this.appendChild((TreeProcessingInstruction)this.tempNode);
            }
            catch (TreeException exc) {
                throw new XNIException((Exception)exc);
            }
        }

        public void processingInstruction(String target, XMLString data) {
            this.processingInstruction(target, data, null);
        }

        public void endExternalSubset(Augmentations a) {
            this.endEntity("[dtd]", a);
        }

        public void endParameterEntity(String name, Augmentations a) {
            String pname = name;
            if (!name.startsWith("%")) {
                pname = "%" + name;
            }
            this.endEntity(pname, a);
        }

        public void endGeneralEntity(String name, Augmentations a) {
            this.endEntity(name, a);
        }

        private void endEntity(String name, Augmentations a) {
            this.trace("endEntity(" + name + ")");
            if ("[xml]".equals(name)) {
                return;
            }
            if (!this.isXMLDocument && "[dtd]".equals(name)) {
                return;
            }
            this.exitEntity();
            if (this.inCharacterRef) {
                this.inCharacterRef = false;
                return;
            }
            if (this.isXMLDocument && "[dtd]".equals(name)) {
                this.popParentObjectList();
            } else {
                this.popParentNode();
            }
        }

        public void endEntity(String name) {
            this.endEntity(name, null);
        }

        public XMLDTDSource getDTDSource() {
            return this.xmldtdSource;
        }

        public void setDTDSource(XMLDTDSource src) {
            this.xmldtdSource = src;
        }

        public void startDTD(XMLLocator locator, Augmentations a) {
            this.startDTD(locator);
        }

        public void startDTD(XMLLocator locator) {
            this.trace("startDTD()");
            try {
                this.inDTD = true;
                if (this.isXMLDocument) {
                    this.pushParentNode(this.doctype);
                } else {
                    this.returnDocument = this.document = new TreeDTD(null, null);
                    this.pushParentNode((TreeDTD)this.document);
                }
            }
            catch (TreeException exc) {
                throw new XNIException((Exception)exc);
            }
        }

        public void elementDecl(String name, String contentModel, Augmentations a) {
            this.elementDecl(name, contentModel);
        }

        public void elementDecl(String name, String cM) {
            this.trace("elementDecl(" + name + ")");
            try {
                this.appendChild(new TreeElementDecl(name, this.contentModel));
                this.contentModel = null;
            }
            catch (TreeException exc) {
                throw new XNIException((Exception)exc);
            }
        }

        public void startAttlist(String elementName, Augmentations a) {
            this.startAttlist(elementName);
        }

        public void startAttlist(String elementName) {
            this.trace("startAttlist(" + elementName + ")");
            try {
                this.tempNode = new TreeAttlistDecl(elementName);
                this.attlistDecl = (TreeAttlistDecl)this.tempNode;
                this.appendChild(this.attlistDecl);
            }
            catch (TreeException exc) {
                throw new XNIException((Exception)exc);
            }
        }

        public void attributeDecl(String elementName, String attributeName, String type, String[] enumeration, String defaultType, XMLString defaultValue, XMLString nonNormalizedDefaultValue, Augmentations a) {
            this.attributeDecl(elementName, attributeName, type, enumeration, defaultType, defaultValue);
        }

        public void attributeDecl(String elementName, String attributeName, String type, String[] enumeration, String defaultType, XMLString defaultValue) {
            this.trace("attributeDecl(" + attributeName + ")");
            try {
                TreeAttlistDecl list = this.attlistDecl != null ? this.attlistDecl : new TreeAttlistDecl(elementName);
                if (type.equals("ENUMERATION")) {
                    type = null;
                }
                short shortDefaultType = TreeAttlistDeclAttributeDef.findDefaultType(defaultType);
                String newDefaultValue = null;
                if (shortDefaultType == 0 || shortDefaultType == 3) {
                    newDefaultValue = defaultValue.toString();
                }
                TreeAttlistDeclAttributeDef decl = new TreeAttlistDeclAttributeDef(attributeName, TreeAttlistDeclAttributeDef.findType(type), enumeration, shortDefaultType, newDefaultValue);
                list.setAttributeDef(decl);
            }
            catch (TreeException exc) {
                throw new XNIException((Exception)exc);
            }
        }

        public void endAttlist(Augmentations a) {
            this.endAttlist();
        }

        public void endAttlist() {
            this.trace("endAttlist()");
            this.attlistDecl = null;
        }

        public void internalEntityDecl(String name, XMLString text, XMLString nonNormalizedText, Augmentations a) {
            this.internalEntityDecl(name, text, nonNormalizedText);
        }

        public void internalEntityDecl(String name, XMLString text, XMLString nonNormalizedText) {
            this.trace("internalEntityDecl(" + name + ")");
            try {
                boolean par = name.startsWith("%");
                if (par) {
                    name = name.substring(1);
                }
                this.appendChild(new TreeEntityDecl(par, name, text.toString()));
            }
            catch (TreeException exc) {
                throw new XNIException((Exception)exc);
            }
        }

        public void externalEntityDecl(String name, String publicId, String systemId, String baseSystemId, Augmentations a) {
            this.externalEntityDecl(name, publicId, systemId, baseSystemId);
        }

        public void externalEntityDecl(String name, String publicId, String systemId, String baseSystemId) {
            this.trace("externalEntityDecl(" + name + ")");
            try {
                boolean par = name.startsWith("%");
                if (par) {
                    name = name.substring(1);
                }
                this.appendChild(new TreeEntityDecl(par, name, publicId, systemId));
            }
            catch (TreeException exc) {
                throw new XNIException((Exception)exc);
            }
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notation, Augmentations a) {
            this.unparsedEntityDecl(name, publicId, systemId, notation);
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notation) {
            this.trace("unparsedEntityDecl(" + name + ")");
            try {
                this.appendChild(new TreeEntityDecl(name, publicId, systemId, notation));
            }
            catch (TreeException exc) {
                throw new XNIException((Exception)exc);
            }
        }

        public void notationDecl(String name, String publicId, String systemId, Augmentations a) {
            this.notationDecl(name, publicId, systemId);
        }

        public void notationDecl(String name, String publicId, String systemId) {
            this.trace("notationDecl(" + name + ")");
            try {
                this.appendChild(new TreeNotationDecl(name, publicId, systemId));
            }
            catch (TreeException exc) {
                throw new XNIException((Exception)exc);
            }
        }

        public void startConditional(short type, Augmentations a) {
            this.startConditional(type);
        }

        public void startConditional(short type) {
            this.trace("startConditional(" + type + ")");
            this.tempNode = type == 0 ? new TreeConditionalSection(true) : new TreeConditionalSection(false);
            this.appendChild((TreeConditionalSection)this.tempNode);
            this.setBeginPosition(this.tempNode);
            this.pushParentNode((TreeConditionalSection)this.tempNode);
        }

        public void endConditional(Augmentations a) {
            this.endConditional();
        }

        public void endConditional() {
            this.trace("endConditional()");
            this.popParentNode();
        }

        public void endDTD(Augmentations a) {
            this.endDTD();
        }

        public void endDTD() {
            this.trace("endDTD()");
            if (!this.isXMLDocument) {
                this.popParentNode();
                this.isCorrect = this.errors == 0;
                throw new DTDStopException();
            }
            this.popParentNode();
            this.inDTD = false;
        }

        public XMLDTDContentModelSource getDTDContentModelSource() {
            return this.xmldtdContentModelSource;
        }

        public void setDTDContentModelSource(XMLDTDContentModelSource src) {
            this.xmldtdContentModelSource = src;
        }

        public void startContentModel(String elementName, Augmentations a) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("startContentModel(" + elementName + ")");
            }
            this.lastType = null;
            this.contentModelMembersStack = new Stack();
        }

        public void any(Augmentations a) {
            this.contentModel = new ANYType();
        }

        public void empty(Augmentations a) {
            this.contentModel = new EMPTYType();
        }

        public void pcdata(Augmentations a) {
            this.setMembersType(new MixedType());
        }

        public void startGroup(Augmentations a) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("startGroup()");
            }
            this.startMembers();
        }

        public void element(String elementName, Augmentations a) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("element(" + elementName + ")");
            }
            this.lastType = new NameType(elementName);
            this.addMember(this.lastType);
        }

        public void separator(short separator, Augmentations a) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("childrenSeparator()");
            }
            switch (separator) {
                case 1: {
                    this.setMembersType(new SequenceType());
                    break;
                }
                case 0: {
                    this.setMembersType(new ChoiceType());
                    break;
                }
                default: {
                    this.doAssert(false);
                }
            }
        }

        public void occurrence(short occurrence, Augmentations a) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("childrenOccurrence()");
            }
            switch (occurrence) {
                case 2: {
                    this.lastType.setMultiplicity('?');
                    break;
                }
                case 3: {
                    this.lastType.setMultiplicity('*');
                    break;
                }
                case 4: {
                    this.lastType.setMultiplicity('+');
                    break;
                }
                default: {
                    this.doAssert(false);
                }
            }
        }

        public void endGroup(Augmentations a) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("childrenEndGroup()");
            }
            ChildrenType group = this.getMembersType();
            group.addTypes(this.endMembers());
            this.lastType = group;
            this.addMember(this.lastType);
        }

        public void endContentModel(Augmentations a) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("endContentModel()");
            }
            if (this.contentModel == null && this.lastType == null) {
                this.contentModel = new MixedType();
            } else if (this.contentModel == null) {
                this.contentModel = this.lastType;
                if (this.contentModel instanceof MixedType) {
                    this.contentModel.setMultiplicity('*');
                }
            }
        }

        private void startMembers() {
            this.contentModelMembersStack.push(new Members(13));
        }

        private void addMember(TreeElementDecl.ContentType child) {
            if (this.contentModelMembersStack.isEmpty()) {
                return;
            }
            Collection members = (Collection)this.contentModelMembersStack.peek();
            members.add(child);
        }

        private Collection endMembers() {
            return (Collection)this.contentModelMembersStack.pop();
        }

        private void setMembersType(ChildrenType group) {
            if (this.contentModelMembersStack.isEmpty()) {
                return;
            }
            Members members = (Members)this.contentModelMembersStack.peek();
            if (members.group == null) {
                members.group = group;
            }
        }

        private ChildrenType getMembersType() {
            Members members = (Members)this.contentModelMembersStack.peek();
            if (members.group == null) {
                return new ChoiceType();
            }
            return members.group;
        }

        public void error(SAXParseException e) {
            this.trace(e.getMessage());
            XNIBuilder.this.errorHandler.message(1, e);
        }

        public void warning(SAXParseException e) {
            this.trace(e.getMessage());
            XNIBuilder.this.errorHandler.message(0, e);
        }

        public void fatalError(SAXParseException e) {
            this.trace(e.getMessage());
            ++this.errors;
            XNIBuilder.this.errorHandler.message(2, e);
        }

        private void setReadOnly(TreeObject treeObject) {
            this.setReadOnly(treeObject, true);
        }

        private void setReadOnly(TreeObject treeObject, boolean value) {
            try {
                Method setReadOnlyMethod = (class$org$netbeans$tax$TreeObject == null ? (class$org$netbeans$tax$TreeObject = XNIBuilder.class$("org.netbeans.tax.TreeObject")) : class$org$netbeans$tax$TreeObject).getDeclaredMethod("setReadOnly", Boolean.TYPE);
                setReadOnlyMethod.setAccessible(true);
                setReadOnlyMethod.invoke((Object)treeObject, value ? Boolean.TRUE : Boolean.FALSE);
            }
            catch (NoSuchMethodException exc) {
            }
            catch (IllegalAccessException exc) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }

        private void setBeginPosition(TreeNode n) {
        }

        private TreeDocumentRoot getDocumentRoot() {
            TreeDocumentRoot doc;
            TreeDocumentRoot treeDocumentRoot = doc = this.errors > 0 ? null : this.returnDocument;
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("TreeStreamBuilderXercesImpl returns: " + doc);
            }
            return doc;
        }

        private void pushParentNode(TreeParentNode parent) {
            this.parentNodeStack.push(parent);
            this.pushParentObjectList(parent.getChildNodes());
        }

        private void pushParentObjectList(TreeObjectList parentList) {
            this.parentObjectListStack.push(this.parentObjectList);
            this.parentObjectList = this.parentObjectList != null || this.parentObjectListStack.size() == 1 ? parentList : null;
        }

        private void popParentObjectList() {
            this.parentObjectList = (TreeObjectList)this.parentObjectListStack.pop();
        }

        private void popParentNode() {
            this.popParentObjectList();
            TreeParentNode parentNode = (TreeParentNode)this.parentNodeStack.pop();
            if (parentNode instanceof TreeGeneralEntityReference) {
                this.setReadOnly(parentNode.getChildNodes());
            } else if (parentNode instanceof TreeDTD) {
                this.setReadOnly(parentNode);
            } else if (parentNode instanceof TreeDocumentType) {
                this.setReadOnly(parentNode.getChildNodes());
                TreeObjectList externalDTD = ((TreeDocumentType)parentNode).getExternalDTD();
                if (externalDTD != null) {
                    this.setReadOnly(externalDTD);
                }
            }
        }

        private TreeParentNode currentParentNode() {
            return (TreeParentNode)this.parentNodeStack.peek();
        }

        private void appendChild(TreeObject child) {
            if (this.parentObjectList != null) {
                this.parentObjectList.add(child);
            }
        }

        private void enterEntity() {
            ++this.entityCounter;
        }

        private void exitEntity() {
            --this.entityCounter;
        }

        private boolean inEntity() {
            return this.entityCounter > 0;
        }

        private void trace(String msg) {
            if (Util.THIS.isLoggable()) {
                String location = "";
                if (this.locator != null) {
                    String entity;
                    int index = (entity = this.locator.getExpandedSystemId()).lastIndexOf(47);
                    entity = entity.substring(index > 0 ? index : 0);
                    location = entity + "/" + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber();
                }
                Util.THIS.debug("X2T " + location + " " + msg);
            }
        }

        private void doAssert(boolean asrt) {
            if (!asrt) {
                throw new IllegalStateException("ASSERT");
            }
        }

        private class Members
        extends ArrayList {
            private ChildrenType group;
            private static final long serialVersionUID = 4614355994187952965L;

            public Members(int initSize) {
                super(initSize);
                this.group = null;
            }
        }
    }
}

