/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lexer.editorbridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.MarkFactory;
import org.netbeans.modules.lexer.editorbridge.LexerEditorKit;
import org.openide.util.Lookup;

final class LexerLayer
extends DrawLayer.AbstractLayer {
    public static final String NAME = "lexer-layer";
    public static final int VISIBILITY = 1050;
    private static final Coloring NULL_COLORING = new Coloring();
    private final JTextComponent component;
    private Listener listener;
    private TokenHierarchy listenerHierarchy;
    private Stack<TokenSequence> pastSequences;
    private TokenSequence tokenSequence;
    private boolean moveNext = true;
    private boolean goToEmbed = true;
    private int tokenEndOffset;
    private Coloring coloring;
    private boolean active;

    public LexerLayer(JTextComponent component) {
        super(NAME);
        assert (component != null);
        this.component = component;
        Document doc = component.getDocument();
        component.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("document".equals(evt.getPropertyName()) && LexerLayer.this.listenerHierarchy != null) {
                    LexerLayer.this.listenerHierarchy.removeTokenHierarchyListener((TokenHierarchyListener)LexerLayer.this.listener);
                    LexerLayer.this.listenerHierarchy = null;
                }
            }
        });
    }

    public boolean extendsEOL() {
        return true;
    }

    public void init(DrawContext ctx) {
        this.coloring = null;
        this.tokenEndOffset = 0;
        int startOffset = ctx.getStartOffset();
        TokenHierarchy hi = this.tokenHierarchy();
        boolean bl = this.active = hi != null;
        if (this.active) {
            this.pastSequences = new Stack();
            this.tokenSequence = hi.tokenSequence();
            this.tokenSequence.move(startOffset);
            if (this.tokenSequence.moveNext()) {
                this.updateTokenEndOffsetAndColoring(startOffset);
            } else {
                this.active = false;
            }
        }
    }

    public boolean isActive(DrawContext ctx, MarkFactory.DrawMark mark) {
        return this.active;
    }

    public void updateContext(DrawContext ctx) {
        if (this.coloring != null) {
            this.coloring.apply(ctx);
        }
        int fragEndOffset = ctx.getFragmentOffset() + ctx.getFragmentLength();
        while (this.active && fragEndOffset >= this.tokenEndOffset) {
            if (!this.moveNext || this.tokenSequence.moveNext()) {
                this.updateTokenEndOffsetAndColoring(-1);
                continue;
            }
            if (this.pastSequences.isEmpty()) {
                this.active = false;
                continue;
            }
            this.tokenSequence = this.pastSequences.pop();
            if (this.tokenSequence.offset() + this.tokenSequence.token().length() <= this.tokenEndOffset) continue;
            this.goToEmbed = false;
            this.moveNext = false;
        }
    }

    private TokenHierarchy tokenHierarchy() {
        TokenHierarchy hi = TokenHierarchy.get((Document)this.component.getDocument());
        if (hi != null && this.listenerHierarchy == null) {
            if (this.listener == null) {
                this.listener = new Listener();
            }
            this.listenerHierarchy = hi;
            this.listenerHierarchy.addTokenHierarchyListener((TokenHierarchyListener)this.listener);
        }
        return hi;
    }

    private void updateTokenEndOffsetAndColoring(int offset) {
        LanguagePath path;
        Token token;
        TokenSequence embed;
        int origOffset = this.tokenSequence.offset();
        boolean isInside = this.tokenSequence.offset() < offset;
        Token origToken = this.tokenSequence.token();
        LanguagePath origPath = this.tokenSequence.languagePath();
        boolean wasEmbedd = false;
        while (origOffset == this.tokenSequence.offset() && this.goToEmbed && (embed = this.tokenSequence.embedded()) != null) {
            wasEmbedd = true;
            if (offset == -1) {
                if (!embed.moveNext()) break;
                this.pastSequences.push(this.tokenSequence);
                this.tokenSequence = embed;
                continue;
            }
            embed.move(offset);
            if (!embed.moveNext()) break;
            this.pastSequences.push(this.tokenSequence);
            this.tokenSequence = embed;
        }
        this.goToEmbed = true;
        if (origOffset == this.tokenSequence.offset() || isInside) {
            token = this.tokenSequence.token();
            this.tokenEndOffset = this.tokenSequence.offset() + token.length();
            path = this.tokenSequence.languagePath();
            this.moveNext = true;
        } else {
            token = origToken;
            this.tokenEndOffset = this.tokenSequence.offset();
            path = origPath;
            this.moveNext = !wasEmbedd;
        }
        this.setNextActivityChangeOffset(this.tokenEndOffset);
        this.coloring = this.findColoring(token.id(), path);
    }

    private Coloring findColoring(TokenId tokenId, LanguagePath languagePath) {
        MimePath mimePath = this.languagePathToMimePathHack(languagePath);
        Lookup lookup = MimeLookup.getLookup((MimePath)mimePath);
        FontColorSettings fcs = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        AttributeSet attribs = this.findFontAndColors(fcs, tokenId, languagePath.innerLanguage());
        return attribs == null ? NULL_COLORING : Coloring.fromAttributeSet((AttributeSet)attribs);
    }

    private void dumpAttribs(AttributeSet attribs, String token, String lang) {
        StringBuilder sb = new StringBuilder();
        sb.append("Attribs for token '");
        sb.append(token);
        sb.append("', language '");
        sb.append(lang);
        sb.append("' = {");
        if (attribs != null) {
            Enumeration<?> keys = attribs.getAttributeNames();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = attribs.getAttribute(key);
                sb.append("'" + key + "' = '" + value + "'");
                if (!keys.hasMoreElements()) continue;
                sb.append(", ");
            }
        }
        sb.append("} LexerLayer.this = ");
        sb.append(this.toString());
        System.out.println(sb.toString());
    }

    private MimePath languagePathToMimePathHack(LanguagePath languagePath) {
        String mimeType = this.getMimeType(this.component);
        if (languagePath.size() == 1) {
            return MimePath.parse((String)mimeType);
        }
        if (languagePath.size() > 1) {
            return MimePath.parse((String)(mimeType + "/" + languagePath.subPath(1).mimePath()));
        }
        throw new IllegalStateException("LanguagePath should not be empty.");
    }

    private String getMimeType(JTextComponent c) {
        Object mimeTypeProp = c.getDocument().getProperty("mimeType");
        if (mimeTypeProp instanceof String) {
            return (String)mimeTypeProp;
        }
        return c.getUI().getEditorKit(c).getContentType();
    }

    private String updateColoringName(String coloringName) {
        String updatedName;
        EditorKit kit = this.component.getUI().getEditorKit(this.component);
        if (kit instanceof LexerEditorKit && (updatedName = ((LexerEditorKit)((Object)kit)).updateColoringName(coloringName)) != null) {
            coloringName = updatedName;
        }
        return coloringName;
    }

    private AttributeSet findFontAndColors(FontColorSettings fcs, TokenId tokenId, Language lang) {
        AttributeSet attribs;
        block2: {
            String c;
            String primary;
            String name = tokenId.name();
            attribs = fcs.getTokenFontColors(this.updateColoringName(name));
            if (attribs == null && (primary = tokenId.primaryCategory()) != null) {
                attribs = fcs.getTokenFontColors(this.updateColoringName(primary));
            }
            if (attribs != null) break block2;
            List categories = lang.nonPrimaryTokenCategories(tokenId);
            Iterator i$ = categories.iterator();
            while (i$.hasNext() && (attribs = fcs.getTokenFontColors(this.updateColoringName(c = (String)i$.next()))) == null) {
            }
        }
        return attribs;
    }

    private final class Listener
    implements TokenHierarchyListener {
        private Listener() {
        }

        public void tokenHierarchyChanged(TokenHierarchyEvent evt) {
            TextUI ui = LexerLayer.this.component.getUI();
            int startRepaintOffset = evt.affectedStartOffset();
            int endRepaintOffset = Math.max(evt.affectedEndOffset(), startRepaintOffset + 1);
            ui.damageRange(LexerLayer.this.component, startRepaintOffset, endRepaintOffset);
        }
    }
}

