/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub;

import bdsup2sub.cli.CommandLineParser;
import bdsup2sub.core.CaptionMoveModeX;
import bdsup2sub.core.CaptionMoveModeY;
import bdsup2sub.core.Configuration;
import bdsup2sub.core.Constants;
import bdsup2sub.core.Core;
import bdsup2sub.core.CoreException;
import bdsup2sub.core.Framerate;
import bdsup2sub.core.Logger;
import bdsup2sub.core.OutputMode;
import bdsup2sub.core.StreamID;
import bdsup2sub.gui.main.MainFrame;
import bdsup2sub.gui.support.GuiUtils;
import bdsup2sub.tools.Props;
import bdsup2sub.utils.FilenameUtils;
import bdsup2sub.utils.PlatformUtils;
import bdsup2sub.utils.StreamUtils;
import bdsup2sub.utils.SubtitleUtils;
import bdsup2sub.utils.ToolBox;
import java.awt.Color;
import java.io.File;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.cli.ParseException;
import org.simplericity.macify.eawt.DefaultApplication;

public class BDSup2Sub {
    private static final Configuration configuration = Configuration.getInstance();
    private static final Logger logger = Logger.getInstance();
    private CommandLineParser options;

    public static void main(String[] args) {
        try {
            new BDSup2Sub().run(args);
        }
        catch (Exception e) {
            BDSup2Sub.fatalError(e.getMessage());
            System.exit(1);
        }
    }

    private void run(String[] args) {
        this.parseOptions(args);
        this.processOptions();
        this.execute();
    }

    private void parseOptions(String[] args) {
        this.options = new CommandLineParser();
        try {
            this.options.parse(args);
        }
        catch (ParseException e) {
            BDSup2Sub.fatalError(e.getMessage());
            this.options.printHelp();
            System.exit(1);
        }
    }

    private void processOptions() {
        if (this.options.isLoadSettings()) {
            configuration.load();
        }
        if (this.options.getOutputMode().isPresent()) {
            configuration.setOutputMode(this.options.getOutputMode().get());
        }
        if (this.options.getResolution().isPresent()) {
            configuration.setConvertResolution(true);
            configuration.setOutputResolution(this.options.getResolution().get());
        }
        this.processFrameRate();
        if (this.options.getDelay().isPresent()) {
            configuration.setDelayPTS((int)SubtitleUtils.syncTimePTS((long)(this.options.getDelay().get() * 90.0), configuration.getFpsTrg(), configuration.getFpsTrg()));
        }
        if (this.options.getScalingFilter().isPresent()) {
            configuration.setScalingFilter(this.options.getScalingFilter().get());
        }
        if (this.options.getPaletteMode().isPresent()) {
            configuration.setPaletteMode(this.options.getPaletteMode().get());
        }
        this.processMinimumDisplayTime();
        if (this.options.getMaximumTimeDifference().isPresent()) {
            configuration.setMergePTSdiff((int)(this.options.getMaximumTimeDifference().get() * 90.0 + 0.5));
        }
        this.processMoveMode();
        if (this.options.getCropLines().isPresent()) {
            configuration.setCropOffsetY(this.options.getCropLines().get());
        }
        if (this.options.getAlphaCropThreshold().isPresent()) {
            configuration.setAlphaCrop(this.options.getAlphaCropThreshold().get());
        }
        if (this.options.getScaleX().isPresent() && this.options.getScaleY().isPresent()) {
            configuration.setApplyFreeScale(true);
            configuration.setFreeScaleFactor(this.options.getScaleX().get(), this.options.getScaleY().get());
        }
        if (this.options.isExportPalette().isPresent()) {
            configuration.setWritePGCEditPalette(this.options.isExportPalette().get());
        }
        if (this.options.isExportForcedSubtitlesOnly().isPresent()) {
            configuration.setExportForced(this.options.isExportForcedSubtitlesOnly().get());
        }
        if (this.options.getForcedFlagState().isPresent()) {
            configuration.setForceAll(this.options.getForcedFlagState().get());
        }
        if (this.options.isSwapCrCb().isPresent()) {
            configuration.setSwapCrCb(this.options.isSwapCrCb().get());
        }
        if (this.options.isFixInvisibleFrames().isPresent()) {
            configuration.setFixZeroAlpha(this.options.isFixInvisibleFrames().get());
        }
        if (this.options.isVerbose().isPresent()) {
            configuration.setVerbose(this.options.isVerbose().get());
        }
        if (this.options.getAlphaThreshold().isPresent()) {
            configuration.setAlphaThreshold(this.options.getAlphaThreshold().get());
        }
        this.processLuminanceThreshold();
        if (this.options.getLanguageIndex().isPresent()) {
            configuration.setLanguageIdx(this.options.getLanguageIndex().get());
        }
        this.processPaletteFile();
    }

    private void processFrameRate() {
        boolean targetFramerateDefined = false;
        if (this.options.isConvertFpsMode()) {
            if (this.options.getSourceFrameRate().isPresent()) {
                configuration.setFpsSrc(this.options.getSourceFrameRate().get());
                configuration.setFpsTrg(this.options.getTargetFrameRate().get());
            }
            configuration.setConvertFPS(true);
            targetFramerateDefined = true;
        } else if (this.options.isSynchronizeFpsMode()) {
            if (!this.options.getTargetFrameRate().isPresent()) {
                configuration.setKeepFps(true);
            } else {
                configuration.setFpsTrg(this.options.getTargetFrameRate().get());
                targetFramerateDefined = true;
            }
        }
        if (!targetFramerateDefined && this.options.getResolution().isPresent()) {
            switch (this.options.getResolution().get()) {
                case PAL: {
                    configuration.setFpsTrg(Framerate.PAL.getValue());
                    break;
                }
                case NTSC: {
                    configuration.setFpsTrg(Framerate.NTSC.getValue());
                    break;
                }
                case HD_720: {
                    configuration.setFpsTrg(Framerate.FPS_23_976.getValue());
                    break;
                }
                case HD_1440x1080: {
                    configuration.setFpsTrg(Framerate.FPS_23_976.getValue());
                    break;
                }
                case HD_1080: {
                    configuration.setFpsTrg(Framerate.FPS_23_976.getValue());
                }
            }
        }
        if (!configuration.isKeepFps() && !targetFramerateDefined) {
            configuration.setFpsTrg(SubtitleUtils.getDefaultFramerateForResolution(configuration.getOutputResolution()));
        }
    }

    private void processMinimumDisplayTime() {
        if (this.options.getMinimumDisplayTime().isPresent()) {
            int tMin = (int)SubtitleUtils.syncTimePTS((long)(this.options.getMinimumDisplayTime().get() * 90.0), configuration.getFpsTrg(), configuration.getFpsTrg());
            configuration.setMinTimePTS(tMin);
            configuration.setFixShortFrames(true);
        }
    }

    private void processMoveMode() {
        if (this.options.getMoveModeY().isPresent()) {
            configuration.setMoveModeY(this.options.getMoveModeY().get());
            configuration.setMoveOffsetY(this.options.getMoveYOffset());
        }
        if (this.options.getMoveModeX().isPresent()) {
            configuration.setMoveModeX(this.options.getMoveModeX().get());
            if (this.options.getMoveXOffset().isPresent()) {
                configuration.setMoveOffsetX(this.options.getMoveXOffset().get());
            }
        }
    }

    private void processLuminanceThreshold() {
        int[] lt = configuration.getLuminanceThreshold();
        if (this.options.getLumLowMedThreshold().isPresent()) {
            lt[1] = this.options.getLumLowMedThreshold().get();
        }
        if (this.options.getLumMedHighThreshold().isPresent()) {
            lt[0] = this.options.getLumMedHighThreshold().get();
        }
        configuration.setLuminanceThreshold(lt);
    }

    private void processPaletteFile() {
        if (this.options.getPaletteFile() != null) {
            Props colProps = new Props();
            colProps.load(this.options.getPaletteFile().getAbsolutePath());
            for (int c = 0; c < 15; ++c) {
                String s = colProps.get("Color_" + c, "0,0,0");
                String[] sp = s.split(",");
                if (sp.length < 3) continue;
                int red = Integer.valueOf(sp[0].trim()) & 0xFF;
                int green = Integer.valueOf(sp[1].trim()) & 0xFF;
                int blue = Integer.valueOf(sp[2].trim()) & 0xFF;
                Core.getCurrentDVDPalette().setColor(c + 1, new Color(red, green, blue));
            }
        }
    }

    private void execute() {
        if (this.options.isPrintHelpMode()) {
            this.options.printHelp();
        } else if (this.options.isPrintVersionMode()) {
            System.out.println(Constants.APP_NAME + " " + Constants.APP_VERSION);
        } else if (!this.options.isCliMode()) {
            BDSup2Sub.setupGUI();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    configuration.setCliMode(false);
                    DefaultApplication app = new DefaultApplication();
                    MainFrame mainFrame = new MainFrame(BDSup2Sub.this.options.getInputFile());
                    app.addApplicationListener(mainFrame.getApplicationListener());
                    mainFrame.setVisible(true);
                }
            });
        } else {
            this.runCliLoop();
        }
    }

    private static void setupGUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (PlatformUtils.isLinux()) {
            GuiUtils.applyGtkThemeWorkarounds();
        }
        if (PlatformUtils.isMac()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", Constants.APP_NAME);
        }
    }

    private void runCliLoop() {
        String inputFile = this.options.getInputFile().getAbsolutePath();
        String outputFile = this.options.getOutputFile().getAbsolutePath();
        try {
            File subtitleFile;
            File indexFile;
            StreamID sid;
            boolean xml = FilenameUtils.getExtension(inputFile).equalsIgnoreCase("xml");
            boolean idx = FilenameUtils.getExtension(inputFile).equalsIgnoreCase("idx");
            boolean ifo = FilenameUtils.getExtension(inputFile).equalsIgnoreCase("ifo");
            byte[] id = ToolBox.getFileID(inputFile, 4);
            StreamID streamID = sid = id == null ? StreamID.UNKNOWN : StreamUtils.getStreamID(id);
            if (!(idx || xml || ifo || sid != StreamID.UNKNOWN)) {
                throw new CoreException("File '" + inputFile + "' is not a supported subtitle stream.");
            }
            configuration.setCurrentStreamID(sid);
            if (configuration.getOutputMode() == OutputMode.VOBSUB) {
                indexFile = new File(FilenameUtils.removeExtension(outputFile) + ".idx");
                subtitleFile = new File(FilenameUtils.removeExtension(outputFile) + ".sub");
            } else {
                subtitleFile = new File(FilenameUtils.removeExtension(outputFile) + ".sup");
                indexFile = null;
            }
            if (indexFile != null && indexFile.exists() && !indexFile.canWrite() || subtitleFile.exists() && !subtitleFile.canWrite()) {
                throw new CoreException("Target file '" + outputFile + "' is write protected.");
            }
            if (xml || sid == StreamID.XML) {
                Core.readXml(inputFile);
            } else if (idx || sid == StreamID.DVDSUB || sid == StreamID.IDX) {
                Core.readVobSub(inputFile);
            } else if (ifo || sid == StreamID.IFO) {
                Core.readSupIfo(inputFile);
            } else {
                Core.readSup(inputFile);
            }
            Core.scanSubtitles();
            logger.printWarningsAndErrorsAndResetCounters();
            if (configuration.getMoveModeX() != CaptionMoveModeX.KEEP_POSITION || configuration.getMoveModeY() != CaptionMoveModeY.KEEP_POSITION) {
                configuration.setCineBarFactor((1.0 - 1.7777777777777777 / this.options.getScreenRatio()) / 2.0);
                Core.moveAllToBounds();
            }
            if (configuration.isExportForced() && Core.getNumForcedFrames() == 0) {
                throw new CoreException("No forced subtitles found.");
            }
            Core.writeSub(outputFile);
        }
        catch (CoreException ex) {
            logger.error(ex.getMessage());
        }
        catch (Exception ex) {
            ToolBox.showException(ex);
            logger.error(ex.getMessage());
        }
        logger.printWarningsAndErrorsAndResetCounters();
        Core.exit();
        System.out.println("\nConversion finished.");
        System.exit(0);
    }

    private static void fatalError(String message) {
        Core.exit();
        System.out.println("ERROR: " + message);
        System.exit(1);
    }
}

