/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.bitmap;

import bdsup2sub.bitmap.BitmapBounds;
import bdsup2sub.bitmap.BitmapWithPalette;
import bdsup2sub.bitmap.ColorSpaceUtils;
import bdsup2sub.bitmap.FilterOp;
import bdsup2sub.bitmap.Palette;
import bdsup2sub.core.Logger;
import bdsup2sub.tools.QuantizeFilter;
import com.mortennobel.imagescaling.ResampleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.HashMap;

public class Bitmap {
    private static final Logger logger = Logger.getInstance();
    private final int width;
    private final int height;
    private final byte[] buffer;

    public Bitmap(int width, int height) {
        this.width = width;
        this.height = height;
        this.buffer = new byte[width * height];
    }

    public Bitmap(int width, int height, byte fillerColorIndex) {
        this(width, height);
        this.fillWithColorIndexValue(fillerColorIndex);
    }

    public Bitmap(int width, int height, byte[] buffer) {
        this.width = width;
        this.height = height;
        this.buffer = buffer;
    }

    public Bitmap(Bitmap bitmap) {
        this.width = bitmap.width;
        this.height = bitmap.height;
        this.buffer = Arrays.copyOf(bitmap.buffer, bitmap.buffer.length);
    }

    private void fillWithColorIndexValue(byte colorIndex) {
        for (int i = 0; i < this.width * this.height; ++i) {
            this.buffer[i] = colorIndex;
        }
    }

    public void fillRectangularWithColorIndex(int rectX, int rectY, int rectWidth, int rectHeight, byte colorIndex) {
        int yMax;
        int xMax = rectX + rectWidth;
        if (xMax > this.width) {
            xMax = this.width;
        }
        if ((yMax = rectY + rectHeight) > this.height) {
            yMax = this.height;
        }
        for (int y = rectY; y < yMax; ++y) {
            int yOfs = y * this.width;
            for (int x = rectX; x < xMax; ++x) {
                this.buffer[yOfs + x] = colorIndex;
            }
        }
    }

    public BufferedImage getImage(ColorModel colorModel) {
        DataBufferByte dataBuffer = new DataBufferByte(this.buffer, this.width * this.height);
        SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(0, this.width, this.height, new int[]{255});
        WritableRaster raster = Raster.createWritableRaster(sampleModel, dataBuffer, null);
        return new BufferedImage(colorModel, raster, false, null);
    }

    public int getPrimaryColorIndex(byte[] alpha, int alphaThreshold, byte[] luma) {
        int colorIndexCount = alpha.length;
        int[] histogram = this.createHistogram(colorIndexCount);
        this.weightHistogramWithAlphaAndLumaValues(histogram, alpha, alphaThreshold, luma);
        return this.getColorIndexWithTheHighestValue(histogram);
    }

    private int[] createHistogram(int colorIndexCount) {
        int[] histogram = new int[colorIndexCount];
        Arrays.fill(histogram, 0);
        for (byte b : this.buffer) {
            int n = b & 0xFF;
            histogram[n] = histogram[n] + 1;
        }
        return histogram;
    }

    private void weightHistogramWithAlphaAndLumaValues(int[] histogram, byte[] alphaValues, int alphaThreshold, byte[] lumaValues) {
        for (int i = 0; i < histogram.length; ++i) {
            int alpha = alphaValues[i] & 0xFF;
            if (alpha < alphaThreshold) {
                alpha = 0;
            }
            histogram[i] = (histogram[i] * alpha + 128) / 256;
            int luma = lumaValues[i] & 0xFF;
            histogram[i] = (histogram[i] * luma + 128) / 256;
        }
    }

    private int getColorIndexWithTheHighestValue(int[] histogram) {
        int maxValue = 0;
        int colorIndex = 0;
        for (int i = 0; i < histogram.length; ++i) {
            if (histogram[i] <= maxValue) continue;
            maxValue = histogram[i];
            colorIndex = i;
        }
        return colorIndex;
    }

    public int getHighestVisibleColorIndex(byte[] alphaValues) {
        byte b;
        int colorIndex;
        int maxColorIndex = 0;
        byte[] arr$ = this.buffer;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && ((alphaValues[colorIndex = (b = arr$[i$]) & 0xFF] & 0xFF) <= 0 || colorIndex <= maxColorIndex || (maxColorIndex = colorIndex) != 255); ++i$) {
        }
        return maxColorIndex;
    }

    public Bitmap getBitmapWithNormalizedPalette(byte[] alphaValues, int alphaThreshold, byte[] lumaValues, int[] lumaThreshold) {
        Bitmap bm = new Bitmap(this.width, this.height);
        HashMap<Integer, Integer> p = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.buffer.length; ++i) {
            int newColorIndex;
            int colorIndex = this.buffer[i] & 0xFF;
            int alpha = alphaValues[colorIndex] & 0xFF;
            int luma = lumaValues[colorIndex] & 0xFF;
            Integer existingColorIndex = (Integer)p.get(alpha << 8 | luma);
            if (existingColorIndex != null) {
                newColorIndex = existingColorIndex;
            } else {
                if (alpha < alphaThreshold) {
                    newColorIndex = 0;
                } else {
                    newColorIndex = 1;
                    for (int threshold : lumaThreshold) {
                        if (luma > threshold) break;
                        ++newColorIndex;
                    }
                }
                p.put(alpha << 8 | luma, newColorIndex);
            }
            bm.buffer[i] = (byte)newColorIndex;
        }
        return bm;
    }

    public Bitmap scaleBilinearLm(int sizeX, int sizeY, Palette pal, int alphaThr, int[] lumThr) {
        byte[] cy = pal.getY();
        byte[] a = pal.getAlpha();
        double scaleX = (double)(this.width - 1) / (double)(sizeX - 1);
        double scaleY = (double)(this.height - 1) / (double)(sizeY - 1);
        int lastCY = 0;
        int lastA = 0;
        int lastColIdx = 0;
        Bitmap trg = new Bitmap(sizeX, sizeY);
        for (int yt = 0; yt < sizeY; ++yt) {
            double ys = (double)yt * scaleY;
            int ysi = (int)ys;
            double wy = ys - (double)ysi;
            double wy1 = 1.0 - wy;
            for (int xt = 0; xt < sizeX; ++xt) {
                double xs = (double)xt * scaleX;
                int xsi = (int)xs;
                double wx = xs - (double)xsi;
                double wx1 = 1.0 - wx;
                double w = wx1 * wy1;
                int idx = this.getPixel(xsi, ysi) & 0xFF;
                double at = (double)(a[idx] & 0xFF) * w;
                double cyt = (double)(cy[idx] & 0xFF) * w;
                if (xsi < this.width - 1) {
                    w = wx * wy1;
                    idx = this.getPixel(xsi + 1, ysi) & 0xFF;
                    at += (double)(a[idx] & 0xFF) * w;
                    cyt += (double)(cy[idx] & 0xFF) * w;
                }
                if (ysi < this.height - 1) {
                    w = wx1 * wy;
                    idx = this.getPixel(xsi, ysi + 1) & 0xFF;
                    at += (double)(a[idx] & 0xFF) * w;
                    cyt += (double)(cy[idx] & 0xFF) * w;
                }
                if (ysi < this.height - 1 && xsi < this.width - 1) {
                    w = wx * wy;
                    idx = this.getPixel(xsi + 1, ysi + 1) & 0xFF;
                    at += (double)(a[idx] & 0xFF) * w;
                    cyt += (double)(cy[idx] & 0xFF) * w;
                }
                int ati = (int)at;
                int cyti = (int)cyt;
                int colIdx = lastColIdx;
                if (ati != lastA || cyti != lastCY) {
                    if (ati < alphaThr) {
                        colIdx = 0;
                    } else {
                        colIdx = 1;
                        for (int threshold : lumThr) {
                            if (cyti > threshold) break;
                            ++colIdx;
                        }
                    }
                    lastA = ati;
                    lastCY = cyti;
                    lastColIdx = colIdx;
                }
                trg.setPixel(xt, yt, (byte)colIdx);
            }
        }
        return trg;
    }

    public Bitmap scaleFilterLm(int sizeX, int sizeY, Palette pal, int alphaThr, int[] lumThr, ResampleFilter f) {
        int[] trg = new FilterOp(f, sizeX, sizeY).filter(this, pal);
        Bitmap bm = new Bitmap(sizeX, sizeY);
        HashMap<Integer, Integer> p = new HashMap<Integer, Integer>();
        for (int i = 0; i < trg.length; ++i) {
            int colIdx;
            int color = trg[i];
            Integer idxEx = (Integer)p.get(color);
            if (idxEx != null) {
                colIdx = idxEx;
            } else {
                int alpha = color >> 24 & 0xFF;
                int red = color >> 16 & 0xFF;
                int green = color >> 8 & 0xFF;
                int blue = color & 0xFF;
                int cyp = ColorSpaceUtils.RGB2YCbCr(red, green, blue, false)[0];
                if (alpha < alphaThr) {
                    colIdx = 0;
                } else {
                    colIdx = 1;
                    for (int threshold : lumThr) {
                        if (cyp > threshold) break;
                        ++colIdx;
                    }
                }
                p.put(color, colIdx);
            }
            bm.buffer[i] = (byte)colIdx;
        }
        return bm;
    }

    public Bitmap scaleBilinear(int sizeX, int sizeY, Palette pal) {
        byte[] r = pal.getR();
        byte[] g = pal.getG();
        byte[] b = pal.getB();
        byte[] a = pal.getAlpha();
        double scaleX = (double)(this.width - 1) / (double)(sizeX - 1);
        double scaleY = (double)(this.height - 1) / (double)(sizeY - 1);
        int lastR = 0;
        int lastG = 0;
        int lastB = 0;
        int lastA = 0;
        int lastColIdx = pal.getIndexOfMostTransparentPaletteEntry();
        Bitmap trg = new Bitmap(sizeX, sizeY);
        for (int yt = 0; yt < sizeY; ++yt) {
            double ys = (double)yt * scaleY;
            int ysi = (int)ys;
            double wy = ys - (double)ysi;
            double wy1 = 1.0 - wy;
            for (int xt = 0; xt < sizeX; ++xt) {
                double xs = (double)xt * scaleX;
                int xsi = (int)xs;
                double wx = xs - (double)xsi;
                double wx1 = 1.0 - wx;
                double w = wx1 * wy1;
                int idx = this.getPixel(xsi, ysi) & 0xFF;
                double at = (double)(a[idx] & 0xFF) * w;
                double rt = (double)(r[idx] & 0xFF) * w;
                double gt = (double)(g[idx] & 0xFF) * w;
                double bt = (double)(b[idx] & 0xFF) * w;
                if (xsi < this.width - 1) {
                    w = wx * wy1;
                    idx = this.getPixel(xsi + 1, ysi) & 0xFF;
                    at += (double)(a[idx] & 0xFF) * w;
                    rt += (double)(r[idx] & 0xFF) * w;
                    gt += (double)(g[idx] & 0xFF) * w;
                    bt += (double)(b[idx] & 0xFF) * w;
                }
                if (ysi < this.height - 1) {
                    w = wx1 * wy;
                    idx = this.getPixel(xsi, ysi + 1) & 0xFF;
                    at += (double)(a[idx] & 0xFF) * w;
                    rt += (double)(r[idx] & 0xFF) * w;
                    gt += (double)(g[idx] & 0xFF) * w;
                    bt += (double)(b[idx] & 0xFF) * w;
                }
                if (ysi < this.height - 1 && xsi < this.width - 1) {
                    w = wx * wy;
                    idx = this.getPixel(xsi + 1, ysi + 1) & 0xFF;
                    at += (double)(a[idx] & 0xFF) * w;
                    rt += (double)(r[idx] & 0xFF) * w;
                    gt += (double)(g[idx] & 0xFF) * w;
                    bt += (double)(b[idx] & 0xFF) * w;
                }
                int ati = (int)(at + 0.5);
                int rti = (int)(rt + 0.5);
                int gti = (int)(gt + 0.5);
                int bti = (int)(bt + 0.5);
                int colIdx = lastColIdx;
                if (ati != lastA || rti != lastR || gti != lastG || bti != lastB) {
                    int minDistance = 0xFFFFFF;
                    for (idx = 0; idx < pal.getSize(); ++idx) {
                        int rd = rti - (r[idx] & 0xFF);
                        int gd = gti - (g[idx] & 0xFF);
                        int bd = bti - (b[idx] & 0xFF);
                        int ad = ati - (a[idx] & 0xFF);
                        int distance = rd * rd + gd * gd + bd * bd + ad * ad;
                        if (distance >= minDistance) continue;
                        colIdx = idx;
                        minDistance = distance;
                        if (minDistance == 0) break;
                    }
                    lastA = ati;
                    lastR = rti;
                    lastG = gti;
                    lastB = bti;
                    lastColIdx = colIdx;
                }
                trg.setPixel(xt, yt, (byte)colIdx);
            }
        }
        return trg;
    }

    public BitmapWithPalette scaleBilinear(int sizeX, int sizeY, Palette pal, boolean dither) {
        byte[] r = pal.getR();
        byte[] g = pal.getG();
        byte[] b = pal.getB();
        byte[] a = pal.getAlpha();
        double scaleX = (double)(this.width - 1) / (double)(sizeX - 1);
        double scaleY = (double)(this.height - 1) / (double)(sizeY - 1);
        int[] trg = new int[sizeX * sizeY];
        for (int yt = 0; yt < sizeY; ++yt) {
            double ys = (double)yt * scaleY;
            int ysi = (int)ys;
            double wy = ys - (double)ysi;
            double wy1 = 1.0 - wy;
            int ofsY = yt * sizeX;
            for (int xt = 0; xt < sizeX; ++xt) {
                int y;
                double xs = (double)xt * scaleX;
                int xsi = (int)xs;
                double wx = xs - (double)xsi;
                double wx1 = 1.0 - wx;
                double w = wx1 * wy1;
                int idx = this.getPixel(xsi, ysi) & 0xFF;
                double at = (double)(a[idx] & 0xFF) * w;
                double rt = (double)(r[idx] & 0xFF) * w;
                double gt = (double)(g[idx] & 0xFF) * w;
                double bt = (double)(b[idx] & 0xFF) * w;
                int x = xsi + 1;
                if (x < this.width) {
                    w = wx * wy1;
                    idx = this.getPixel(x, ysi) & 0xFF;
                    at += (double)(a[idx] & 0xFF) * w;
                    rt += (double)(r[idx] & 0xFF) * w;
                    gt += (double)(g[idx] & 0xFF) * w;
                    bt += (double)(b[idx] & 0xFF) * w;
                }
                if ((y = ysi + 1) < this.height) {
                    w = wx1 * wy;
                    idx = this.getPixel(xsi, y) & 0xFF;
                    at += (double)(a[idx] & 0xFF) * w;
                    rt += (double)(r[idx] & 0xFF) * w;
                    gt += (double)(g[idx] & 0xFF) * w;
                    bt += (double)(b[idx] & 0xFF) * w;
                }
                x = xsi + 1;
                y = ysi + 1;
                if (x < this.width && y < this.height) {
                    w = wx * wy;
                    idx = this.getPixel(x, y) & 0xFF;
                    at += (double)(a[idx] & 0xFF) * w;
                    rt += (double)(r[idx] & 0xFF) * w;
                    gt += (double)(g[idx] & 0xFF) * w;
                    bt += (double)(b[idx] & 0xFF) * w;
                }
                int ati = (int)at;
                int rti = (int)rt;
                int gti = (int)gt;
                int bti = (int)bt;
                trg[xt + ofsY] = ati << 24 | rti << 16 | gti << 8 | bti;
            }
        }
        QuantizeFilter qf = new QuantizeFilter();
        Bitmap bm = new Bitmap(sizeX, sizeY);
        int[] ct = qf.quantize(trg, bm.buffer, sizeX, sizeY, 255, dither, dither);
        int size = ct.length;
        if (size > 255) {
            size = 255;
            logger.warn("Quantizer failed.\n");
        }
        Palette trgPal = new Palette(256);
        for (int i = 0; i < size; ++i) {
            trgPal.setARGB(i, ct[i]);
        }
        return new BitmapWithPalette(bm, trgPal);
    }

    public Bitmap scaleFilter(int sizeX, int sizeY, Palette pal, ResampleFilter f) {
        byte[] r = pal.getR();
        byte[] g = pal.getG();
        byte[] b = pal.getB();
        byte[] a = pal.getAlpha();
        int[] trg = new FilterOp(f, sizeX, sizeY).filter(this, pal);
        Bitmap bm = new Bitmap(sizeX, sizeY);
        HashMap<Integer, Integer> p = new HashMap<Integer, Integer>();
        for (int i = 0; i < trg.length; ++i) {
            int colIdx;
            int color = trg[i];
            Integer idxEx = (Integer)p.get(color);
            if (idxEx != null) {
                colIdx = idxEx;
            } else {
                colIdx = 0;
                int minDistance = 0xFFFFFF;
                int alpha = color >> 24 & 0xFF;
                int red = color >> 16 & 0xFF;
                int green = color >> 8 & 0xFF;
                int blue = color & 0xFF;
                for (int idx = 0; idx < pal.getSize(); ++idx) {
                    int rd = red - (r[idx] & 0xFF);
                    int gd = green - (g[idx] & 0xFF);
                    int bd = blue - (b[idx] & 0xFF);
                    int ad = alpha - (a[idx] & 0xFF);
                    int distance = rd * rd + gd * gd + bd * bd + ad * ad;
                    if (distance >= minDistance) continue;
                    colIdx = idx;
                    minDistance = distance;
                    if (minDistance == 0) break;
                }
                p.put(color, colIdx);
            }
            bm.buffer[i] = (byte)colIdx;
        }
        return bm;
    }

    public BitmapWithPalette scaleFilter(int sizeX, int sizeY, Palette pal, ResampleFilter f, boolean dither) {
        int[] trg = new FilterOp(f, sizeX, sizeY).filter(this, pal);
        QuantizeFilter qf = new QuantizeFilter();
        Bitmap bm = new Bitmap(sizeX, sizeY);
        int[] ct = qf.quantize(trg, bm.buffer, sizeX, sizeY, 255, dither, dither);
        int size = ct.length;
        if (size > 255) {
            size = 255;
            logger.warn("Quantizer failed.\n");
        }
        Palette trgPal = new Palette(256);
        for (int i = 0; i < size; ++i) {
            trgPal.setARGB(i, ct[i]);
        }
        return new BitmapWithPalette(bm, trgPal);
    }

    public int[] toARGB(Palette pal) {
        int[] argbValues = new int[this.buffer.length];
        for (int i = 0; i < argbValues.length; ++i) {
            argbValues[i] = pal.getARGB(this.buffer[i] & 0xFF);
        }
        return argbValues;
    }

    public Bitmap crop(int xOffset, int yOffset, int croppedBitmapWidth, int croppedBitmapHeight) {
        Bitmap bitmap = new Bitmap(croppedBitmapWidth, croppedBitmapHeight);
        int yOfsSrc = yOffset * this.width;
        int yOfsTrg = 0;
        int i = 0;
        while (i < croppedBitmapHeight) {
            for (int xTrg = 0; xTrg < croppedBitmapWidth; ++xTrg) {
                bitmap.buffer[xTrg + yOfsTrg] = this.buffer[xOffset + xTrg + yOfsSrc];
            }
            ++i;
            yOfsSrc += this.width;
            yOfsTrg += croppedBitmapWidth;
        }
        return bitmap;
    }

    public BitmapBounds getCroppingBounds(byte[] alpha, int alphaThreshold) {
        int x;
        int yMax = this.height - 1;
        int yOfs = yMax * this.width;
        int y = this.height - 1;
        while (y > 0) {
            yMax = y--;
            if (this.isRowWithColorAboveAlphaThreshold(yOfs, alpha, alphaThreshold)) break;
            yOfs -= this.width;
        }
        int yMin = 0;
        yOfs = 0;
        y = 0;
        while (y < yMax) {
            yMin = y++;
            if (this.isRowWithColorAboveAlphaThreshold(yOfs, alpha, alphaThreshold)) break;
            yOfs += this.width;
        }
        int xMax = this.width - 1;
        for (x = this.width - 1; x > 0; --x) {
            xMax = x;
            if (this.isColumnWithColorAboveAlphaThreshold(x, yMin, yMax, alpha, alphaThreshold)) break;
        }
        int xMin = 0;
        for (x = 0; x < xMax; ++x) {
            xMin = x;
            if (this.isColumnWithColorAboveAlphaThreshold(x, yMin, yMax, alpha, alphaThreshold)) break;
        }
        return new BitmapBounds(xMin, xMax, yMin, yMax);
    }

    private boolean isRowWithColorAboveAlphaThreshold(int yOfs, byte[] alpha, int alphaThreshold) {
        for (int x = 0; x < this.width; ++x) {
            if (!this.isColorAboveAlphaThreshold(yOfs + x, alpha, alphaThreshold)) continue;
            return true;
        }
        return false;
    }

    private boolean isColumnWithColorAboveAlphaThreshold(int x, int yMin, int yMax, byte[] alpha, int alphaThreshold) {
        int yOfs = yMin * this.width;
        int i = yMin;
        while (i < yMax) {
            if (this.isColorAboveAlphaThreshold(yOfs + x, alpha, alphaThreshold)) {
                return true;
            }
            ++i;
            yOfs += this.width;
        }
        return false;
    }

    private boolean isColorAboveAlphaThreshold(int bufferIndex, byte[] alpha, int alphaThreshold) {
        int idx = this.buffer[bufferIndex] & 0xFF;
        return (alpha[idx] & 0xFF) >= alphaThreshold;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getInternalBuffer() {
        return this.buffer;
    }

    private byte getPixel(int x, int y) {
        return this.buffer[x + this.width * y];
    }

    private void setPixel(int x, int y, byte color) {
        this.buffer[x + this.width * y] = color;
    }
}

