/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.cli;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class CommandLineOptions {
    static final String HELP = "h";
    static final String VERSION = "V";
    static final String OUTPUT_FILE = "o";
    static final String VERBOSE = "v";
    static final String LOAD_SETTINGS = "L";
    static final String RESOLUTION = "r";
    static final String TARGET_FRAMERATE = "T";
    static final String CONVERT_FRAMERATE = "C";
    static final String DELAY = "d";
    static final String SCALING_FILTER = "f";
    static final String PALETTE_MODE = "p";
    static final String MIN_DISPLAY_TIME = "m";
    static final String MAX_TIME_DIFF = "x";
    static final String MOVE_IN = "I";
    static final String MOVE_OUT = "O";
    static final String MOVE_X = "X";
    static final String CROP_LINES = "c";
    static final String ALPHA_CROP_THRESHOLD = "a";
    static final String SCALE = "S";
    static final String EXPORT_PALETTE = "P";
    static final String EXPORT_FORCED_SUBTITLES_ONLY = "D";
    static final String FORCED_FLAG = "F";
    static final String SWAP_CR_CB = "w";
    static final String FIX_INVISIBLE_FRAMES = "i";
    static final String ALPHA_THRESHOLD = "A";
    static final String LUM_LOW_MED_THRESHOLD = "M";
    static final String LUM_MED_HIGH_THRESHOLD = "H";
    static final String LANGUAGE_CODE = "l";
    static final String PALETTE_FILE = "t";
    static final List<String> OPTION_ORDER = Arrays.asList("h", "L", "r", "T", "C", "d", "f", "p", "m", "x", "I", "O", "X", "c", "a", "S", "P", "D", "F", "w", "i", "A", "M", "H", "l", "t", "o", "v", "V");
    private final Options options = new Options();

    public CommandLineOptions() {
        this.createAndAddOptions();
    }

    public Options getOptions() {
        return this.options;
    }

    private void createAndAddOptions() {
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Show usage information and exit.");
        OptionBuilder.hasArg((boolean)false);
        Option help = OptionBuilder.create((String)HELP);
        this.options.addOption(help);
        OptionBuilder.withLongOpt((String)"version");
        OptionBuilder.withDescription((String)"Show version information and exit.");
        OptionBuilder.hasArg((boolean)false);
        Option version = OptionBuilder.create((String)VERSION);
        this.options.addOption(version);
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.withDescription((String)"Specify output file.");
        OptionBuilder.hasArg();
        Option output = OptionBuilder.create((String)OUTPUT_FILE);
        this.options.addOption(output);
        OptionBuilder.withLongOpt((String)"verbose");
        OptionBuilder.withDescription((String)"Verbose console output mode.");
        OptionBuilder.hasArg((boolean)false);
        Option verbose = OptionBuilder.create((String)VERBOSE);
        this.options.addOption(verbose);
        OptionBuilder.withLongOpt((String)"load-settings");
        OptionBuilder.withDescription((String)"Load settings stored in configuration file even if running in command-line mode.");
        OptionBuilder.hasArg((boolean)false);
        Option loadSettings = OptionBuilder.create((String)LOAD_SETTINGS);
        this.options.addOption(loadSettings);
        OptionBuilder.withArgName((String)"resolution");
        OptionBuilder.withLongOpt((String)"resolution");
        OptionBuilder.withDescription((String)"Set resolution to: keep, ntsc=480, pal=576, 720p=720, 1080p=1080, 1440x1080\nDefault: keep");
        OptionBuilder.hasArg();
        Option resolution = OptionBuilder.create((String)RESOLUTION);
        this.options.addOption(resolution);
        OptionGroup framerateGroup = new OptionGroup();
        OptionBuilder.withArgName((String)"fps");
        OptionBuilder.withLongOpt((String)"fps-target");
        OptionBuilder.withDescription((String)"Synchronize target frame rate to <fps>.\nPredefined values: 24p=23.976, pal or 25p=25, ntsc or 30p=29.967, keep (preserves the source fps for BD&XML, else default)\nDefault: automatic (dumb!).");
        OptionBuilder.hasArg();
        Option targetFrameRate = OptionBuilder.create((String)TARGET_FRAMERATE);
        framerateGroup.addOption(targetFrameRate);
        OptionBuilder.withArgName((String)"src>, <trg");
        OptionBuilder.withLongOpt((String)"convert-fps");
        OptionBuilder.withDescription((String)"Convert frame rate from <src> to <trg>\nSupported values: 24p=23.976, 25p=25, 30p=29.970\nauto,<trg> detects source frame rate.");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.hasArgs((int)2);
        Option convertFrameRate = OptionBuilder.create((String)CONVERT_FRAMERATE);
        framerateGroup.addOption(convertFrameRate);
        this.options.addOptionGroup(framerateGroup);
        OptionBuilder.withArgName((String)"delay");
        OptionBuilder.withLongOpt((String)"delay");
        OptionBuilder.withDescription((String)"Set delay in ms\nDefault: 0.0");
        OptionBuilder.hasArg();
        Option delay = OptionBuilder.create((String)DELAY);
        this.options.addOption(delay);
        OptionBuilder.withArgName((String)"filter");
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.withDescription((String)"Set the filter to use for scaling.\nSupported values: bilinear, triangle, bicubic, bell, b-spline, hermite, lanczos3, mitchell\nDefault: bilinear");
        OptionBuilder.hasArg();
        Option filter = OptionBuilder.create((String)SCALING_FILTER);
        this.options.addOption(filter);
        OptionBuilder.withArgName((String)"mode");
        OptionBuilder.withLongOpt((String)"palette-mode");
        OptionBuilder.withDescription((String)"Set palette mode.\nSupported values: keep, create, dither\nDefault: create");
        OptionBuilder.hasArg();
        Option paletteMode = OptionBuilder.create((String)PALETTE_MODE);
        this.options.addOption(paletteMode);
        OptionBuilder.withArgName((String)"time");
        OptionBuilder.withLongOpt((String)"minimum-time");
        OptionBuilder.withDescription((String)"Set minimum display time in ms.\nDefault: 500");
        OptionBuilder.hasArg();
        Option minDisplayTime = OptionBuilder.create((String)MIN_DISPLAY_TIME);
        this.options.addOption(minDisplayTime);
        OptionBuilder.withArgName((String)"time");
        OptionBuilder.withLongOpt((String)"merge-time");
        OptionBuilder.withDescription((String)"Set maximum time difference for merging subtitles in ms.\nDefault: 200");
        OptionBuilder.hasArg();
        Option maxTimeDiff = OptionBuilder.create((String)MAX_TIME_DIFF);
        this.options.addOption(maxTimeDiff);
        OptionGroup moveGroup = new OptionGroup();
        OptionBuilder.withArgName((String)"ratio, offset");
        OptionBuilder.withLongOpt((String)"move-in");
        OptionBuilder.withDescription((String)"Move captions inside screen ratio <ratio>, +/- offset <offset>");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.hasArgs((int)2);
        Option moveIn = OptionBuilder.create((String)MOVE_IN);
        moveGroup.addOption(moveIn);
        OptionBuilder.withArgName((String)"ratio, offset");
        OptionBuilder.withLongOpt((String)"move-out");
        OptionBuilder.withDescription((String)"Move captions outside screen ratio <ratio>, +/- offset <offset>");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.hasArgs((int)2);
        Option moveOut = OptionBuilder.create((String)MOVE_OUT);
        moveGroup.addOption(moveOut);
        this.options.addOptionGroup(moveGroup);
        OptionBuilder.withArgName((String)"pos[, offset]");
        OptionBuilder.withLongOpt((String)"move-x");
        OptionBuilder.withDescription((String)"Move captions horizontally from specified position. <pos> may be left, right, center\n+/- optional offset <offset> (only if moving left or right)");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.hasOptionalArgs((int)2);
        Option moveX = OptionBuilder.create((String)MOVE_X);
        this.options.addOption(moveX);
        OptionBuilder.withArgName((String)"n");
        OptionBuilder.withLongOpt((String)"crop-y");
        OptionBuilder.withDescription((String)"Crop the upper/lower n lines.\nDefault: 0");
        OptionBuilder.hasArg();
        Option cropLines = OptionBuilder.create((String)CROP_LINES);
        this.options.addOption(cropLines);
        OptionBuilder.withArgName((String)"n");
        OptionBuilder.withLongOpt((String)"alpha-crop");
        OptionBuilder.withDescription((String)"Set the alpha cropping threshold.\nDefault: 10");
        OptionBuilder.hasArg();
        Option alphaCropThreshold = OptionBuilder.create((String)ALPHA_CROP_THRESHOLD);
        this.options.addOption(alphaCropThreshold);
        OptionBuilder.withArgName((String)"x, y");
        OptionBuilder.withLongOpt((String)"scale");
        OptionBuilder.withDescription((String)"Scale captions horizontally and vertically.\nDefault: 1.0,1.0");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.hasArgs((int)2);
        Option scale = OptionBuilder.create((String)SCALE);
        this.options.addOption(scale);
        OptionBuilder.withLongOpt((String)"export-palette");
        OptionBuilder.withDescription((String)"Export target palette in PGCEdit format.");
        OptionBuilder.hasArg((boolean)false);
        Option exportPalette = OptionBuilder.create((String)EXPORT_PALETTE);
        this.options.addOption(exportPalette);
        OptionBuilder.withLongOpt((String)"forced-only");
        OptionBuilder.withDescription((String)"Export only forced subtitles (when converting from BD-SUP).");
        OptionBuilder.hasArg((boolean)false);
        Option exportForcedSubtitlesOnly = OptionBuilder.create((String)EXPORT_FORCED_SUBTITLES_ONLY);
        this.options.addOption(exportForcedSubtitlesOnly);
        OptionBuilder.withArgName((String)"state");
        OptionBuilder.withLongOpt((String)"force-all");
        OptionBuilder.withDescription((String)"Set or clear the forced flag for all subtitles.\nSupported values: set, clear");
        OptionBuilder.hasArg();
        Option setForcedFlag = OptionBuilder.create((String)FORCED_FLAG);
        this.options.addOption(setForcedFlag);
        OptionBuilder.withLongOpt((String)"swap");
        OptionBuilder.withDescription((String)"Swap Cr/Cb components when loading a BD/HD-DVD sup file.");
        OptionBuilder.hasArg((boolean)false);
        Option swapCrCb = OptionBuilder.create((String)SWAP_CR_CB);
        this.options.addOption(swapCrCb);
        OptionBuilder.withLongOpt((String)"fix-invisible");
        OptionBuilder.withDescription((String)"Fix zero alpha frame palette for SUB/IDX and SUP/IFO.");
        OptionBuilder.hasArg((boolean)false);
        Option fixInvisibleFrames = OptionBuilder.create((String)FIX_INVISIBLE_FRAMES);
        this.options.addOption(fixInvisibleFrames);
        OptionBuilder.withArgName((String)"n");
        OptionBuilder.withLongOpt((String)"alpha-thr");
        OptionBuilder.withDescription((String)"Set alpha threshold 0..255 for SUB/IDX conversion.\nDefault: 80");
        OptionBuilder.hasArg();
        Option alphaThreshold = OptionBuilder.create((String)ALPHA_THRESHOLD);
        this.options.addOption(alphaThreshold);
        OptionBuilder.withArgName((String)"n");
        OptionBuilder.withLongOpt((String)"lum-low-med-thr");
        OptionBuilder.withDescription((String)"Set luminance lo/med threshold 0..255 for SUB/IDX conversion.\nDefault: auto");
        OptionBuilder.hasArg();
        Option luminanceLowMedThreshold = OptionBuilder.create((String)LUM_LOW_MED_THRESHOLD);
        this.options.addOption(luminanceLowMedThreshold);
        OptionBuilder.withArgName((String)"n");
        OptionBuilder.withLongOpt((String)"lum-med-hi-thr");
        OptionBuilder.withDescription((String)"Set luminance med/hi threshold 0..255 for SUB/IDX conversion.\nDefault: auto");
        OptionBuilder.hasArg();
        Option luminanceMedHighThreshold = OptionBuilder.create((String)LUM_MED_HIGH_THRESHOLD);
        this.options.addOption(luminanceMedHighThreshold);
        OptionBuilder.withArgName((String)"language");
        OptionBuilder.withLongOpt((String)"language");
        OptionBuilder.withDescription((String)"Set language for SUB/IDX export.\nDefault: en");
        OptionBuilder.hasArg();
        Option languageCode = OptionBuilder.create((String)LANGUAGE_CODE);
        this.options.addOption(languageCode);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.withLongOpt((String)"palette-file");
        OptionBuilder.withDescription((String)"Load palette file for SUB/IDX conversion. Overrides default palette.");
        OptionBuilder.hasArg();
        Option paletteFile = OptionBuilder.create((String)PALETTE_FILE);
        this.options.addOption(paletteFile);
    }
}

