/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.conversion;

import bdsup2sub.core.Configuration;
import bdsup2sub.core.ForcedFlagState;
import bdsup2sub.core.Resolution;
import bdsup2sub.gui.conversion.ConversionDialogModel;
import bdsup2sub.gui.conversion.ConversionDialogView;
import bdsup2sub.utils.SubtitleUtils;
import bdsup2sub.utils.ToolBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class ConversionDialogController {
    private final ConversionDialogModel model;
    private final ConversionDialogView view;

    public ConversionDialogController(ConversionDialogModel model, ConversionDialogView view) {
        this.model = model;
        this.view = view;
        view.addWindowListener(new ConversionDialogListener());
        view.addResolutionComboBoxItemListener(new ResolutionComboBoxItemListener());
        view.addFrameRateCheckBoxActionListener(new FrameRateCheckBoxActionListener());
        view.addResolutionCheckBoxActionListener(new ResolutionCheckBoxActionListener());
        view.addMoveCheckBoxActionListener(new MoveCheckBoxActionListener());
        view.addFpsSrcComboBoxActionListener(new FpsSrcComboBoxActionListener());
        view.addFpsSrcComboBoxDocumentListener(new FpsSrcComboBoxDocumentListener());
        view.addFpsTrgComboBoxActionListener(new FpsTrgComboBoxActionListener());
        view.addFpsTrgComboBoxDocumentListener(new FpsTrgComboBoxDocumentListener());
        view.addDelayTextFieldActionListener(new DelayTextFieldActionListener());
        view.addDelayTextFieldDocumentListener(new DelayTextFieldDocumentListener());
        view.addCancelButtonActionListener(new CancelButtonActionListener());
        view.addStoreButtonActionListener(new StoreButtonActionListener());
        view.addRestoreButtonActionListener(new RestoreButtonActionListener());
        view.addResetButtonActionListener(new ResetButtonActionListener());
        view.addScaleCheckBoxItemListener(new ScaleCheckBoxItemListener());
        view.addFixMinTimeCheckBoxItemListener(new FixMinTimeCheckBoxItemListener());
        view.addMinTimeTextFieldActionListener(new MinTimeTextFieldActionListener());
        view.addMinTimeTextFieldDocumentListener(new MinTimeTextFieldDocumentListener());
        view.addOkButtonActionListener(new OkButtonActionListener());
        view.addScaleXTextFieldActionListener(new ScaleXTextFieldActionListener());
        view.addScaleXTextFieldDocumentListener(new ScaleXTextFieldDocumentListener());
        view.addScaleYTextFieldActionListener(new ScaleYTextFieldActionListener());
        view.addScaleYTextFieldDocumentListener(new ScaleYTextFieldDocumentListener());
        view.addForcedComboBoxItemListener(new ForcedComboBoxItemListener());
    }

    private class ForcedComboBoxItemListener
    implements ItemListener {
        private ForcedComboBoxItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (ConversionDialogController.this.model.isReady()) {
                int idx = ConversionDialogController.this.view.getForcedComboBoxSelectedIndex();
                for (ForcedFlagState forcedFlagState : ForcedFlagState.values()) {
                    if (idx != forcedFlagState.ordinal()) continue;
                    ConversionDialogController.this.model.setForcedState(forcedFlagState);
                    break;
                }
            }
        }
    }

    private class ScaleYTextFieldDocumentListener
    implements DocumentListener {
        private ScaleYTextFieldDocumentListener() {
        }

        private void check() {
            if (ConversionDialogController.this.model.isReady()) {
                double scaleY = ToolBox.getDouble(ConversionDialogController.this.view.getScaleYTextFieldText());
                if (scaleY >= 0.5 && scaleY <= 2.0) {
                    ConversionDialogController.this.model.setFreeScaleFactorY(scaleY);
                    ConversionDialogController.this.view.setScaleYTextFieldBackground(Configuration.OK_BACKGROUND);
                } else {
                    ConversionDialogController.this.view.setScaleYTextFieldBackground(Configuration.ERROR_BACKGROUND);
                }
            }
        }

        public void insertUpdate(DocumentEvent e) {
            this.check();
        }

        public void changedUpdate(DocumentEvent e) {
            this.check();
        }

        public void removeUpdate(DocumentEvent e) {
            this.check();
        }
    }

    private class ScaleYTextFieldActionListener
    implements ActionListener {
        private ScaleYTextFieldActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ConversionDialogController.this.model.isReady()) {
                double scaleY = ToolBox.getDouble(ConversionDialogController.this.view.getScaleYTextFieldText());
                if (scaleY > 0.0) {
                    if (scaleY > 2.0) {
                        scaleY = 2.0;
                    } else if (scaleY < 0.5) {
                        scaleY = 0.5;
                    }
                    ConversionDialogController.this.model.setFreeScaleFactorY(scaleY);
                }
                ConversionDialogController.this.view.setScaleYTextFieldText(ToolBox.formatDouble(ConversionDialogController.this.model.getFreeScaleFactorY()));
            }
        }
    }

    private class ScaleXTextFieldDocumentListener
    implements DocumentListener {
        private ScaleXTextFieldDocumentListener() {
        }

        private void check() {
            if (ConversionDialogController.this.model.isReady()) {
                double scaleX = ToolBox.getDouble(ConversionDialogController.this.view.getScaleXTextFieldText());
                if (scaleX >= 0.5 && scaleX <= 2.0) {
                    ConversionDialogController.this.model.setFreeScaleFactorX(scaleX);
                    ConversionDialogController.this.view.setScaleXTextFieldBackground(Configuration.OK_BACKGROUND);
                } else {
                    ConversionDialogController.this.view.setScaleXTextFieldBackground(Configuration.ERROR_BACKGROUND);
                }
            }
        }

        public void insertUpdate(DocumentEvent e) {
            this.check();
        }

        public void changedUpdate(DocumentEvent e) {
            this.check();
        }

        public void removeUpdate(DocumentEvent e) {
            this.check();
        }
    }

    private class ScaleXTextFieldActionListener
    implements ActionListener {
        private ScaleXTextFieldActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ConversionDialogController.this.model.isReady()) {
                double scaleX = ToolBox.getDouble(ConversionDialogController.this.view.getScaleXTextFieldText());
                if (scaleX > 0.0) {
                    if (scaleX > 2.0) {
                        scaleX = 2.0;
                    } else if (scaleX < 0.5) {
                        scaleX = 0.5;
                    }
                    ConversionDialogController.this.model.setFreeScaleFactorX(scaleX);
                }
                ConversionDialogController.this.view.setScaleXTextFieldText(ToolBox.formatDouble(ConversionDialogController.this.model.getFreeScaleFactorX()));
                ConversionDialogController.this.view.setScaleXTextFieldBackground(Configuration.OK_BACKGROUND);
            }
        }
    }

    private class OkButtonActionListener
    implements ActionListener {
        private OkButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ConversionDialogController.this.model.isReady()) {
                double scaleY;
                double scaleX;
                double fpsTrg;
                double fpsSrc;
                ConversionDialogController.this.model.setConvertFPSConf(ConversionDialogController.this.model.getConvertFPS());
                if (ConversionDialogController.this.model.getConvertFPS() && (fpsSrc = SubtitleUtils.getFps(ConversionDialogController.this.view.getFpsSrcComboBoxSelectedItem())) > 0.0) {
                    ConversionDialogController.this.model.setFpsSrc(fpsSrc);
                    ConversionDialogController.this.model.setFPSSrcConf(fpsSrc);
                }
                if ((fpsTrg = SubtitleUtils.getFps(ConversionDialogController.this.view.getFpsTrgComboBoxSelectedItem())) > 0.0) {
                    ConversionDialogController.this.model.setFpsTrg(fpsTrg);
                    ConversionDialogController.this.model.setFpsTrgConf(fpsTrg);
                }
                try {
                    ConversionDialogController.this.model.setDelayPTS((int)SubtitleUtils.syncTimePTS((long)(Double.parseDouble(ConversionDialogController.this.view.getDelayTextFieldText()) * 90.0), ConversionDialogController.this.model.getFpsTrg(), ConversionDialogController.this.model.getFpsTrgConf()));
                    ConversionDialogController.this.model.setDelayPTSConf(ConversionDialogController.this.model.getDelayPTS());
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                ConversionDialogController.this.model.setFixShortFramesConf(ConversionDialogController.this.model.getFixShortFrames());
                try {
                    ConversionDialogController.this.model.setMinTimePTS((int)SubtitleUtils.syncTimePTS((long)(Double.parseDouble(ConversionDialogController.this.view.getMinTimeTextFieldText()) * 90.0), ConversionDialogController.this.model.getFpsTrg(), ConversionDialogController.this.model.getFpsTrgConf()));
                    ConversionDialogController.this.model.setMinTimePTSConf(ConversionDialogController.this.model.getMinTimePTS());
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                boolean convertResolution = ConversionDialogController.this.model.getConvertResolution();
                ConversionDialogController.this.model.setConvertResolutionConf(convertResolution);
                if (convertResolution) {
                    ConversionDialogController.this.model.setOutputResolutionConf(ConversionDialogController.this.model.getOutputResolution());
                }
                if ((scaleX = ToolBox.getDouble(ConversionDialogController.this.view.getScaleXTextFieldText())) > 0.0) {
                    if (scaleX > 2.0) {
                        scaleX = 2.0;
                    } else if (scaleX < 0.5) {
                        scaleX = 0.5;
                    }
                    ConversionDialogController.this.model.setFreeScaleFactorX(scaleX);
                }
                if ((scaleY = ToolBox.getDouble(ConversionDialogController.this.view.getScaleYTextFieldText())) > 0.0) {
                    if (scaleY > 2.0) {
                        scaleY = 2.0;
                    } else if (scaleY < 0.5) {
                        scaleY = 0.5;
                    }
                    ConversionDialogController.this.model.setFreeScaleFactorY(scaleY);
                }
                ConversionDialogController.this.model.setApplyFreeScaleConf(ConversionDialogController.this.model.getApplyFreeScale());
                if (ConversionDialogController.this.model.getApplyFreeScale()) {
                    ConversionDialogController.this.model.setFreeScaleFactorConf(ConversionDialogController.this.model.getFreeScaleFactorX(), ConversionDialogController.this.model.getFreeScaleFactorY());
                }
                ConversionDialogController.this.model.setCancel(false);
                ConversionDialogController.this.model.setForcedStateConf(ConversionDialogController.this.model.getForcedState());
                if (ConversionDialogController.this.view.isMoveCheckBoxEnabled()) {
                    ConversionDialogController.this.model.storeMoveCaptions();
                }
                ConversionDialogController.this.view.dispose();
            }
        }
    }

    private class MinTimeTextFieldDocumentListener
    implements DocumentListener {
        private MinTimeTextFieldDocumentListener() {
        }

        private void check() {
            if (ConversionDialogController.this.model.isReady()) {
                String minTimeTextFieldText = ConversionDialogController.this.view.getMinTimeTextFieldText();
                try {
                    ConversionDialogController.this.model.setMinTimePTS((int)SubtitleUtils.syncTimePTS((long)(Double.parseDouble(minTimeTextFieldText) * 90.0), ConversionDialogController.this.model.getFpsTrg(), ConversionDialogController.this.model.getFpsTrgConf()));
                    if (!minTimeTextFieldText.equalsIgnoreCase(ToolBox.formatDouble((double)ConversionDialogController.this.model.getMinTimePTS() / 90.0))) {
                        ConversionDialogController.this.view.setMinTimeTextFieldBackground(Configuration.WARN_BACKGROUND);
                    } else {
                        ConversionDialogController.this.view.setMinTimeTextFieldBackground(Configuration.OK_BACKGROUND);
                    }
                }
                catch (NumberFormatException ex) {
                    ConversionDialogController.this.view.setMinTimeTextFieldBackground(Configuration.ERROR_BACKGROUND);
                }
            }
        }

        public void insertUpdate(DocumentEvent e) {
            this.check();
        }

        public void changedUpdate(DocumentEvent e) {
            this.check();
        }

        public void removeUpdate(DocumentEvent e) {
            this.check();
        }
    }

    private class MinTimeTextFieldActionListener
    implements ActionListener {
        private MinTimeTextFieldActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ConversionDialogController.this.model.isReady()) {
                try {
                    ConversionDialogController.this.model.setMinTimePTS((int)SubtitleUtils.syncTimePTS((long)(Double.parseDouble(ConversionDialogController.this.view.getMinTimeTextFieldText()) * 90.0), ConversionDialogController.this.model.getFpsTrg(), ConversionDialogController.this.model.getFpsTrgConf()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ConversionDialogController.this.view.setMinTimeTextFieldBackground(Configuration.OK_BACKGROUND);
                ConversionDialogController.this.view.setMinTimeTextFieldText(ToolBox.formatDouble((double)ConversionDialogController.this.model.getMinTimePTS() / 90.0));
            }
        }
    }

    private class FixMinTimeCheckBoxItemListener
    implements ItemListener {
        private FixMinTimeCheckBoxItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (ConversionDialogController.this.model.isReady()) {
                boolean fixShortFrames = ConversionDialogController.this.view.isFixMinTimeCheckBoxSelected();
                ConversionDialogController.this.model.setFixShortFrames(fixShortFrames);
                ConversionDialogController.this.view.enableMinTimeTextField(fixShortFrames);
            }
        }
    }

    private class ScaleCheckBoxItemListener
    implements ItemListener {
        private ScaleCheckBoxItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (ConversionDialogController.this.model.isReady()) {
                boolean changeScale = ConversionDialogController.this.view.isScaleCheckBoxSelected();
                ConversionDialogController.this.model.setApplyFreeScale(changeScale);
                ConversionDialogController.this.view.enableScaleXTextField(changeScale);
                ConversionDialogController.this.view.enableScaleYTextField(changeScale);
            }
        }
    }

    private class ResetButtonActionListener
    implements ActionListener {
        private ResetButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean convertResolution = false;
            ConversionDialogController.this.model.setConvertResolution(convertResolution);
            if (convertResolution) {
                ConversionDialogController.this.model.setOutputResolution(Configuration.DEFAULT_TARGET_RESOLUTION);
            }
            ConversionDialogController.this.model.setConvertFPS(false);
            if (ConversionDialogController.this.model.getConvertFPS()) {
                if (!ConversionDialogController.this.model.isFpsSrcCertain()) {
                    ConversionDialogController.this.model.setFpsSrc(Configuration.DEFAULT_SOURCE_FRAMERATE);
                }
                ConversionDialogController.this.model.setFpsTrg(Configuration.DEFAULT_TARGET_FRAMERATE);
            } else {
                ConversionDialogController.this.model.setFpsTrg(ConversionDialogController.this.model.getFpsSrc());
            }
            ConversionDialogController.this.model.setDelayPTS(0);
            ConversionDialogController.this.model.setFixShortFrames(false);
            ConversionDialogController.this.model.setMinTimePTS(45000);
            ConversionDialogController.this.model.setApplyFreeScale(false);
            if (ConversionDialogController.this.model.getApplyFreeScale()) {
                ConversionDialogController.this.model.setFreeScaleFactorX(1.0);
                ConversionDialogController.this.model.setFreeScaleFactorY(1.0);
            }
            ConversionDialogController.this.model.setForcedState(Configuration.DEFAULT_FORCED_FLAG_STATE);
            ConversionDialogController.this.view.fillDialog();
        }
    }

    private class RestoreButtonActionListener
    implements ActionListener {
        private RestoreButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ConversionDialogController.this.model.loadConvertResolution();
            if (ConversionDialogController.this.model.getConvertResolution()) {
                ConversionDialogController.this.model.loadOutputResolution();
            }
            ConversionDialogController.this.model.loadConvertFPS();
            if (ConversionDialogController.this.model.getConvertFPS() && !ConversionDialogController.this.model.isFpsSrcCertain()) {
                ConversionDialogController.this.model.loadFpsSrc();
            }
            ConversionDialogController.this.model.loadFpsTrg();
            ConversionDialogController.this.model.loadDelayPTS();
            ConversionDialogController.this.model.loadFixShortFrames();
            ConversionDialogController.this.model.loadMinTimePTS();
            ConversionDialogController.this.model.loadApplyFreeScale();
            if (ConversionDialogController.this.model.getApplyFreeScale()) {
                ConversionDialogController.this.model.loadFreeScaleFactorX();
                ConversionDialogController.this.model.loadFreeScaleFactorY();
            }
            ConversionDialogController.this.model.loadForcedState();
            ConversionDialogController.this.view.fillDialog();
        }
    }

    private class StoreButtonActionListener
    implements ActionListener {
        private StoreButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ConversionDialogController.this.model.isReady()) {
                double scaleY;
                double scaleX;
                double fpsTrg;
                double fpsSrc;
                ConversionDialogController.this.model.storeConvertFPS();
                if (ConversionDialogController.this.model.getConvertFPS() && (fpsSrc = SubtitleUtils.getFps(ConversionDialogController.this.view.getFpsSrcComboBoxSelectedItem())) > 0.0) {
                    ConversionDialogController.this.model.setFpsSrc(fpsSrc);
                    ConversionDialogController.this.model.storeFPSSrc();
                }
                if ((fpsTrg = SubtitleUtils.getFps(ConversionDialogController.this.view.getFpsTrgComboBoxSelectedItem())) > 0.0) {
                    ConversionDialogController.this.model.setFpsTrg(fpsTrg);
                    ConversionDialogController.this.model.storeFpsTrg();
                }
                try {
                    ConversionDialogController.this.model.setDelayPTS((int)SubtitleUtils.syncTimePTS((long)(Double.parseDouble(ConversionDialogController.this.view.getDelayTextFieldText()) * 90.0), ConversionDialogController.this.model.getFpsTrg(), ConversionDialogController.this.model.getFpsTrgConf()));
                    ConversionDialogController.this.model.storeDelayPTS();
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                ConversionDialogController.this.model.storeFixShortFrames();
                try {
                    ConversionDialogController.this.model.setMinTimePTS((int)SubtitleUtils.syncTimePTS((long)(Double.parseDouble(ConversionDialogController.this.view.getMinTimeTextFieldText()) * 90.0), ConversionDialogController.this.model.getFpsTrg(), ConversionDialogController.this.model.getFpsTrgConf()));
                    ConversionDialogController.this.model.storeMinTimePTS();
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                ConversionDialogController.this.model.storeConvertResolution();
                if (ConversionDialogController.this.model.getConvertResolution()) {
                    ConversionDialogController.this.model.storeOutputResolution();
                }
                if ((scaleX = ToolBox.getDouble(ConversionDialogController.this.view.getScaleXTextFieldText())) > 0.0) {
                    if (scaleX > 2.0) {
                        scaleX = 2.0;
                    } else if (scaleX < 0.5) {
                        scaleX = 0.5;
                    }
                    ConversionDialogController.this.model.setFreeScaleFactorX(scaleX);
                }
                if ((scaleY = ToolBox.getDouble(ConversionDialogController.this.view.getScaleYTextFieldText())) > 0.0) {
                    if (scaleY > 2.0) {
                        scaleY = 2.0;
                    } else if (scaleY < 0.5) {
                        scaleY = 0.5;
                    }
                    ConversionDialogController.this.model.setFreeScaleFactorY(scaleY);
                }
                ConversionDialogController.this.model.storeApplyFreeScale();
                if (ConversionDialogController.this.model.getApplyFreeScale()) {
                    ConversionDialogController.this.model.storeFreeScaleFactor();
                }
                ConversionDialogController.this.model.storeForcedState();
                ConversionDialogController.this.model.storeConfig();
            }
        }
    }

    private class CancelButtonActionListener
    implements ActionListener {
        private CancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ConversionDialogController.this.model.setCancel(true);
            ConversionDialogController.this.view.dispose();
        }
    }

    private class DelayTextFieldDocumentListener
    implements DocumentListener {
        private DelayTextFieldDocumentListener() {
        }

        private void check() {
            if (ConversionDialogController.this.model.isReady()) {
                String delayTextFieldText = ConversionDialogController.this.view.getDelayTextFieldText();
                try {
                    ConversionDialogController.this.model.setDelayPTS((int)SubtitleUtils.syncTimePTS((long)(Double.parseDouble(delayTextFieldText) * 90.0), ConversionDialogController.this.model.getFpsTrg(), ConversionDialogController.this.model.getFpsTrgConf()));
                    if (!delayTextFieldText.equalsIgnoreCase(ToolBox.formatDouble((double)ConversionDialogController.this.model.getDelayPTS() / 90.0))) {
                        ConversionDialogController.this.view.setDelayTextFieldBoxBackground(Configuration.WARN_BACKGROUND);
                    } else {
                        ConversionDialogController.this.view.setDelayTextFieldBoxBackground(Configuration.OK_BACKGROUND);
                    }
                }
                catch (NumberFormatException ex) {
                    ConversionDialogController.this.view.setDelayTextFieldBoxBackground(Configuration.ERROR_BACKGROUND);
                }
            }
        }

        public void insertUpdate(DocumentEvent e) {
            this.check();
        }

        public void changedUpdate(DocumentEvent e) {
            this.check();
        }

        public void removeUpdate(DocumentEvent e) {
            this.check();
        }
    }

    private class DelayTextFieldActionListener
    implements ActionListener {
        private DelayTextFieldActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ConversionDialogController.this.model.isReady()) {
                String s = ConversionDialogController.this.view.getDelayTextFieldText();
                try {
                    ConversionDialogController.this.model.setDelayPTS((int)SubtitleUtils.syncTimePTS((long)(Double.parseDouble(s) * 90.0), ConversionDialogController.this.model.getFpsTrg(), ConversionDialogController.this.model.getFpsTrgConf()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ConversionDialogController.this.view.setDelayTextFieldBoxBackground(Configuration.OK_BACKGROUND);
                ConversionDialogController.this.view.setDelayTextFieldText(ToolBox.formatDouble((double)ConversionDialogController.this.model.getDelayPTS() / 90.0));
            }
        }
    }

    private class FpsTrgComboBoxDocumentListener
    implements DocumentListener {
        private FpsTrgComboBoxDocumentListener() {
        }

        private void check() {
            if (ConversionDialogController.this.model.isReady()) {
                Color color;
                double fpsTrg = SubtitleUtils.getFps(ConversionDialogController.this.view.getFpsTrgComboBoxText());
                if (fpsTrg > 0.0) {
                    color = (int)SubtitleUtils.syncTimePTS(ConversionDialogController.this.model.getDelayPTS(), ConversionDialogController.this.model.getFpsTrg(), ConversionDialogController.this.model.getFpsTrgConf()) != ConversionDialogController.this.model.getDelayPTS() || ConversionDialogController.this.model.getMinTimePTS() != (int)SubtitleUtils.syncTimePTS(ConversionDialogController.this.model.getMinTimePTS(), ConversionDialogController.this.model.getFpsTrg(), ConversionDialogController.this.model.getFpsTrgConf()) ? Configuration.WARN_BACKGROUND : Configuration.OK_BACKGROUND;
                    ConversionDialogController.this.model.setFpsTrg(fpsTrg);
                } else {
                    color = Configuration.ERROR_BACKGROUND;
                }
                ConversionDialogController.this.view.setFpsTrgComboBoxBackground(color);
            }
        }

        public void insertUpdate(DocumentEvent e) {
            this.check();
        }

        public void changedUpdate(DocumentEvent e) {
            this.check();
        }

        public void removeUpdate(DocumentEvent e) {
            this.check();
        }
    }

    private class FpsTrgComboBoxActionListener
    implements ActionListener {
        private FpsTrgComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ConversionDialogController.this.model.isReady()) {
                double d = SubtitleUtils.getFps(ConversionDialogController.this.view.getFpsTrgComboBoxSelectedItem());
                if (d > 0.0) {
                    ConversionDialogController.this.model.setFpsTrg(d);
                }
                ConversionDialogController.this.view.setFpsTrgComboBoxSelectedItem(ToolBox.formatDouble(ConversionDialogController.this.model.getFpsTrg()));
                ConversionDialogController.this.view.setFpsTrgComboBoxBackground(Configuration.OK_BACKGROUND);
                ConversionDialogController.this.model.setDelayPTS((int)SubtitleUtils.syncTimePTS(ConversionDialogController.this.model.getDelayPTS(), ConversionDialogController.this.model.getFpsTrg(), ConversionDialogController.this.model.getFpsTrgConf()));
                ConversionDialogController.this.view.setDelayTextFieldText(ToolBox.formatDouble((double)ConversionDialogController.this.model.getDelayPTS() / 90.0));
                ConversionDialogController.this.model.setMinTimePTS((int)SubtitleUtils.syncTimePTS(ConversionDialogController.this.model.getMinTimePTS(), ConversionDialogController.this.model.getFpsTrg(), ConversionDialogController.this.model.getFpsTrgConf()));
                ConversionDialogController.this.view.setMinTimeTextFieldText(ToolBox.formatDouble((double)ConversionDialogController.this.model.getMinTimePTS() / 90.0));
            }
        }
    }

    private class FpsSrcComboBoxDocumentListener
    implements DocumentListener {
        private FpsSrcComboBoxDocumentListener() {
        }

        private void check() {
            if (ConversionDialogController.this.model.isReady()) {
                Color color;
                double fpsSrc = SubtitleUtils.getFps(ConversionDialogController.this.view.getFpsSrcComboBoxText());
                if (fpsSrc > 0.0) {
                    color = Configuration.OK_BACKGROUND;
                    ConversionDialogController.this.model.setFpsSrc(fpsSrc);
                } else {
                    color = Configuration.ERROR_BACKGROUND;
                }
                ConversionDialogController.this.view.setFpsSrcComboBoxBackground(color);
                ConversionDialogController.this.model.setFpsSrcCertain(false);
            }
        }

        public void insertUpdate(DocumentEvent e) {
            this.check();
        }

        public void changedUpdate(DocumentEvent e) {
            this.check();
        }

        public void removeUpdate(DocumentEvent e) {
            this.check();
        }
    }

    private class FpsSrcComboBoxActionListener
    implements ActionListener {
        private FpsSrcComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ConversionDialogController.this.model.isReady()) {
                double fpsSrc = SubtitleUtils.getFps(ConversionDialogController.this.view.getFpsSrcComboBoxSelectedItem());
                if (fpsSrc > 0.0) {
                    ConversionDialogController.this.model.setFpsSrc(fpsSrc);
                }
                ConversionDialogController.this.view.setFpsSrcComboBoxSelectedItem(ToolBox.formatDouble(ConversionDialogController.this.model.getFpsSrc()));
                ConversionDialogController.this.view.setFpsSrcComboBoxBackground(Configuration.OK_BACKGROUND);
                ConversionDialogController.this.model.setFpsSrcCertain(false);
            }
        }
    }

    private class MoveCheckBoxActionListener
    implements ActionListener {
        private MoveCheckBoxActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ConversionDialogController.this.model.isReady()) {
                ConversionDialogController.this.model.setMoveCaptions(ConversionDialogController.this.view.isMoveCheckBoxSelected());
            }
        }
    }

    private class ResolutionCheckBoxActionListener
    implements ActionListener {
        private ResolutionCheckBoxActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ConversionDialogController.this.model.isReady()) {
                boolean changeResolution = ConversionDialogController.this.view.isResolutionCheckBoxSelected();
                ConversionDialogController.this.model.setConvertResolution(changeResolution);
                ConversionDialogController.this.view.setResolutionComboBoxEnabled(changeResolution);
            }
        }
    }

    private class FrameRateCheckBoxActionListener
    implements ActionListener {
        private FrameRateCheckBoxActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ConversionDialogController.this.model.isReady()) {
                boolean changeFPS = ConversionDialogController.this.view.isFrameRateCheckBoxSelected();
                ConversionDialogController.this.model.setConvertFPS(changeFPS);
                ConversionDialogController.this.view.setFpsSrcComboBoxEnabled(changeFPS);
            }
        }
    }

    private class ResolutionComboBoxItemListener
    implements ItemListener {
        private ResolutionComboBoxItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (ConversionDialogController.this.model.isReady()) {
                int idx = ConversionDialogController.this.view.getResolutionComboBoxSelectedIndex();
                for (Resolution resolution : Resolution.values()) {
                    if (idx != resolution.ordinal()) continue;
                    ConversionDialogController.this.model.setOutputResolution(resolution);
                    if (!ConversionDialogController.this.model.isKeepFps()) {
                        ConversionDialogController.this.model.setFpsTrg(SubtitleUtils.getDefaultFramerateForResolution(resolution));
                    }
                    ConversionDialogController.this.view.setFpsTrgComboBoxSelectedItem(ToolBox.formatDouble(ConversionDialogController.this.model.getFpsTrg()));
                    break;
                }
            }
        }
    }

    private class ConversionDialogListener
    extends WindowAdapter {
        private ConversionDialogListener() {
        }

        public void windowClosing(WindowEvent event) {
            ConversionDialogController.this.model.setCancel(true);
            ConversionDialogController.this.view.dispose();
        }
    }
}

