/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.conversion;

import bdsup2sub.core.Configuration;
import bdsup2sub.core.Core;
import bdsup2sub.core.ForcedFlagState;
import bdsup2sub.core.Resolution;
import bdsup2sub.utils.SubtitleUtils;

class ConversionDialogModel {
    private final Configuration configuration = Configuration.getInstance();
    private Resolution outputResolution;
    private int delayPTS;
    private int minTimePTS;
    private boolean convertFPS;
    private boolean convertResolution = this.configuration.getConvertResolution();
    private boolean fixShortFrames;
    private double fpsSrc;
    private double fpsTrg;
    private boolean applyFreeScale;
    private double freeScaleFactorX;
    private double freeScaleFactorY;
    private boolean fpsSrcCertain;
    private ForcedFlagState forcedState;
    private boolean moveCaptions;
    private boolean cancel;
    private volatile boolean isReady;

    public ConversionDialogModel() {
        this.outputResolution = !this.convertResolution && Core.getNumFrames() > 0 ? SubtitleUtils.getResolutionForDimension(Core.getSubPictureSrc(0).getWidth(), Core.getSubPictureSrc(0).getHeight()) : this.configuration.getOutputResolution();
        this.moveCaptions = this.configuration.getMoveCaptions();
        this.delayPTS = this.configuration.getDelayPTS();
        this.minTimePTS = (int)SubtitleUtils.syncTimePTS(this.configuration.getMinTimePTS(), this.configuration.getFpsTrg(), this.configuration.getFpsTrg());
        this.convertFPS = this.configuration.getConvertFPS();
        this.applyFreeScale = this.configuration.getApplyFreeScale();
        this.fixShortFrames = this.configuration.getFixShortFrames();
        this.fpsSrc = this.configuration.getFPSSrc();
        this.fpsTrg = this.configuration.getFpsTrg();
        this.freeScaleFactorX = this.configuration.getFreeScaleFactorX();
        this.freeScaleFactorY = this.configuration.getFreeScaleFactorY();
        this.fpsSrcCertain = this.configuration.isFpsSrcCertain();
        this.forcedState = this.configuration.getForceAll();
    }

    public void storeConfig() {
        this.configuration.storeConfig();
    }

    public Resolution getOutputResolution() {
        return this.outputResolution;
    }

    public void setOutputResolution(Resolution outputResolution) {
        this.outputResolution = outputResolution;
    }

    public void setOutputResolutionConf(Resolution outputResolution) {
        this.configuration.setOutputResolution(outputResolution);
    }

    public void loadOutputResolution() {
        this.outputResolution = this.configuration.loadOutputResolution();
    }

    public void storeOutputResolution() {
        this.configuration.storeOutputResolution(this.outputResolution);
    }

    public int getDelayPTS() {
        return this.delayPTS;
    }

    public void setDelayPTS(int delayPTS) {
        this.delayPTS = delayPTS;
    }

    public void setDelayPTSConf(int delayPTS) {
        this.configuration.setDelayPTS(delayPTS);
    }

    public void loadDelayPTS() {
        this.delayPTS = this.configuration.loadDelayPTS();
    }

    public void storeDelayPTS() {
        this.configuration.storeDelayPTS(this.delayPTS);
    }

    public int getMinTimePTS() {
        return this.minTimePTS;
    }

    public void setMinTimePTS(int minTimePTS) {
        this.minTimePTS = minTimePTS;
    }

    public void setMinTimePTSConf(int minTimePTS) {
        this.configuration.setMinTimePTS(minTimePTS);
    }

    public void loadMinTimePTS() {
        this.minTimePTS = this.configuration.loadMinTimePTS();
    }

    public void storeMinTimePTS() {
        this.configuration.storeMinTimePTS(this.minTimePTS);
    }

    public boolean getConvertFPS() {
        return this.convertFPS;
    }

    public void setConvertFPS(boolean convertFPS) {
        this.convertFPS = convertFPS;
    }

    public void setConvertFPSConf(boolean convertFPS) {
        this.configuration.setConvertFPS(convertFPS);
    }

    public void loadConvertFPS() {
        this.convertFPS = this.configuration.loadConvertFPS();
    }

    public void storeConvertFPS() {
        this.configuration.storeConvertFPS(this.convertFPS);
    }

    public boolean getConvertResolution() {
        return this.convertResolution;
    }

    public void setConvertResolution(boolean convertResolution) {
        this.convertResolution = convertResolution;
    }

    public void setConvertResolutionConf(boolean convertResolution) {
        this.configuration.setConvertResolution(convertResolution);
    }

    public void loadConvertResolution() {
        this.convertResolution = this.configuration.loadConvertResolution();
    }

    public void storeConvertResolution() {
        this.configuration.storeConvertResolution(this.convertResolution);
    }

    public boolean getFixShortFrames() {
        return this.fixShortFrames;
    }

    public void setFixShortFrames(boolean fixShortFrames) {
        this.fixShortFrames = fixShortFrames;
    }

    public void setFixShortFramesConf(boolean fixShortFrames) {
        this.configuration.setFixShortFrames(fixShortFrames);
    }

    public void loadFixShortFrames() {
        this.fixShortFrames = this.configuration.loadFixShortFrames();
    }

    public void storeFixShortFrames() {
        this.configuration.storeFixShortFrames(this.fixShortFrames);
    }

    public double getFpsSrc() {
        return this.fpsSrc;
    }

    public void setFpsSrc(double fpsSrc) {
        this.fpsSrc = fpsSrc;
    }

    public void setFPSSrcConf(double fpsSrc) {
        this.configuration.setFpsSrc(fpsSrc);
    }

    public void loadFpsSrc() {
        this.fpsSrc = this.configuration.loadFpsSrc();
    }

    public void storeFPSSrc() {
        this.configuration.storeFPSSrc(this.fpsSrc);
    }

    public double getFpsTrg() {
        return this.fpsTrg;
    }

    public void setFpsTrg(double fpsTrg) {
        this.fpsTrg = fpsTrg;
    }

    public double getFpsTrgConf() {
        return this.configuration.getFpsTrg();
    }

    public void setFpsTrgConf(double fpsTrg) {
        this.configuration.setFpsTrg(fpsTrg);
    }

    public void loadFpsTrg() {
        this.fpsTrg = this.configuration.loadFpsTrg();
    }

    public void storeFpsTrg() {
        this.configuration.storeFpsTrg(this.fpsTrg);
    }

    public boolean getApplyFreeScale() {
        return this.applyFreeScale;
    }

    public void setApplyFreeScale(boolean applyFreeScale) {
        this.applyFreeScale = applyFreeScale;
    }

    public void setApplyFreeScaleConf(boolean applyFreeScale) {
        this.configuration.setApplyFreeScale(applyFreeScale);
    }

    public void loadApplyFreeScale() {
        this.applyFreeScale = this.configuration.loadApplyFreeScale();
    }

    public void storeApplyFreeScale() {
        this.configuration.storeApplyFreeScale(this.applyFreeScale);
    }

    public double getFreeScaleFactorX() {
        return this.freeScaleFactorX;
    }

    public double getFreeScaleFactorY() {
        return this.freeScaleFactorY;
    }

    public void setFreeScaleFactorX(double freeScaleFactorX) {
        this.freeScaleFactorX = freeScaleFactorX;
    }

    public void setFreeScaleFactorY(double freeScaleFactorY) {
        this.freeScaleFactorY = freeScaleFactorY;
    }

    public void setFreeScaleFactorConf(double x, double y) {
        this.configuration.setFreeScaleFactor(x, y);
    }

    public void loadFreeScaleFactorX() {
        this.freeScaleFactorX = this.configuration.loadFreeScaleFactorX();
    }

    public void loadFreeScaleFactorY() {
        this.freeScaleFactorY = this.configuration.loadFreeScaleFactorY();
    }

    public void storeFreeScaleFactor() {
        this.configuration.storeFreeScaleFactor(this.freeScaleFactorX, this.freeScaleFactorY);
    }

    public boolean isFpsSrcCertain() {
        return this.fpsSrcCertain;
    }

    public void setFpsSrcCertain(boolean fpsSrcCertain) {
        this.fpsSrcCertain = fpsSrcCertain;
    }

    public ForcedFlagState getForcedState() {
        return this.forcedState;
    }

    public void setForcedState(ForcedFlagState forcedState) {
        this.forcedState = forcedState;
    }

    public void loadForcedState() {
        this.forcedState = this.configuration.loadForceAll();
    }

    public void setForcedStateConf(ForcedFlagState forcedState) {
        this.configuration.setForceAll(forcedState);
    }

    public void storeForcedState() {
        this.configuration.storeForceAll(this.forcedState);
    }

    public boolean getMoveCaptions() {
        return this.moveCaptions;
    }

    public void setMoveCaptions(boolean moveCaptions) {
        this.moveCaptions = moveCaptions;
    }

    public void storeMoveCaptions() {
        this.configuration.setMoveCaptions(this.moveCaptions);
    }

    public boolean wasCanceled() {
        return this.cancel;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void setReady(boolean ready) {
        this.isReady = ready;
    }

    public boolean isKeepFps() {
        return this.configuration.isKeepFps();
    }
}

