/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.export;

import bdsup2sub.core.Constants;
import bdsup2sub.core.Core;
import bdsup2sub.core.OutputMode;
import bdsup2sub.gui.export.ExportDialogModel;
import bdsup2sub.gui.support.GuiUtils;
import bdsup2sub.gui.support.RequestFocusListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class ExportDialogView
extends JDialog {
    private JPanel jContentPane;
    private JTextField jTextFieldFilename;
    private JButton jButtonFileName;
    private JComboBox jComboBoxLanguage;
    private JCheckBox jCheckBoxForced;
    private JCheckBox jCheckBoxWritePGCPalette;
    private JButton jButtonCancel;
    private JButton jButtonSave;
    private final ExportDialogModel model;

    public ExportDialogView(ExportDialogModel model, Frame owner) {
        super(owner, true);
        this.model = model;
        this.initialize();
    }

    private void initialize() {
        this.setPreferredSize(new Dimension(350, 180));
        this.setBounds(new Rectangle(0, 0, 350, 180));
        this.setMaximumSize(new Dimension(350, 180));
        this.setMinimumSize(new Dimension(350, 180));
        this.setResizable(false);
        this.setContentPane(this.getJContentPane());
        GuiUtils.centerRelativeToOwner(this);
        this.setTitle(this.model.getDialogTitle());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridy = 4;
            GridBagConstraints gridBagButtonSave = new GridBagConstraints();
            gridBagButtonSave.gridx = 2;
            gridBagButtonSave.insets = new Insets(2, 4, 2, 0);
            gridBagButtonSave.gridy = 7;
            GridBagConstraints gridBagButtonCancel = new GridBagConstraints();
            gridBagButtonCancel.gridx = 0;
            gridBagButtonCancel.insets = new Insets(2, 4, 2, 0);
            gridBagButtonCancel.gridy = 7;
            GridBagConstraints gridBagCheckBoxForced = new GridBagConstraints();
            gridBagCheckBoxForced.gridx = 0;
            gridBagCheckBoxForced.insets = new Insets(0, 0, 0, 0);
            gridBagCheckBoxForced.gridwidth = 2;
            gridBagCheckBoxForced.anchor = 18;
            gridBagCheckBoxForced.gridy = 3;
            GridBagConstraints gridBagComboLanguage = new GridBagConstraints();
            gridBagComboLanguage.fill = 0;
            gridBagComboLanguage.gridy = 1;
            gridBagComboLanguage.weightx = 1.0;
            gridBagComboLanguage.anchor = 17;
            gridBagComboLanguage.insets = new Insets(2, 4, 2, 4);
            gridBagComboLanguage.gridx = 1;
            GridBagConstraints gridBagLabelLanguage = new GridBagConstraints();
            gridBagLabelLanguage.gridx = 0;
            gridBagLabelLanguage.anchor = 17;
            gridBagLabelLanguage.insets = new Insets(2, 6, 2, 0);
            gridBagLabelLanguage.gridy = 1;
            JLabel jLabelLanguage = new JLabel();
            jLabelLanguage.setText("Language");
            GridBagConstraints gridBagButtonFileName = new GridBagConstraints();
            gridBagButtonFileName.gridx = 2;
            gridBagButtonFileName.anchor = 13;
            gridBagButtonFileName.insets = new Insets(2, 0, 2, 4);
            gridBagButtonFileName.gridy = 0;
            GridBagConstraints gridBagTextFileName = new GridBagConstraints();
            gridBagTextFileName.fill = 0;
            gridBagTextFileName.gridy = 0;
            gridBagTextFileName.weightx = 1.0;
            gridBagTextFileName.anchor = 17;
            gridBagTextFileName.insets = new Insets(2, 4, 2, 4);
            gridBagTextFileName.ipadx = 200;
            gridBagTextFileName.gridx = 1;
            GridBagConstraints gridBagLabelFilename = new GridBagConstraints();
            gridBagLabelFilename.gridx = 0;
            gridBagLabelFilename.anchor = 17;
            gridBagLabelFilename.insets = new Insets(2, 6, 2, 0);
            gridBagLabelFilename.gridy = 0;
            JLabel jLabelFilename = new JLabel();
            jLabelFilename.setText("Filename");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)jLabelFilename, gridBagLabelFilename);
            this.jContentPane.add((Component)this.getJTextFieldFilename(), gridBagTextFileName);
            this.jContentPane.add((Component)this.getJButtonFilename(), gridBagButtonFileName);
            this.jContentPane.add((Component)jLabelLanguage, gridBagLabelLanguage);
            this.jContentPane.add((Component)this.getJComboBoxLanguage(), gridBagComboLanguage);
            this.jContentPane.add((Component)this.getJButtonCancel(), gridBagButtonCancel);
            this.jContentPane.add((Component)this.getJButtonSave(), gridBagButtonSave);
            this.jContentPane.add((Component)this.getJCheckBoxForced(), gridBagCheckBoxForced);
            this.jContentPane.add((Component)this.getJCheckBoxWritePGCPalette(), gridBagConstraints);
        }
        return this.jContentPane;
    }

    private JTextField getJTextFieldFilename() {
        if (this.jTextFieldFilename == null) {
            this.jTextFieldFilename = new JTextField();
            this.jTextFieldFilename.setPreferredSize(new Dimension(200, 20));
            this.jTextFieldFilename.setHorizontalAlignment(10);
            this.jTextFieldFilename.setToolTipText("Set file name for export");
            this.jTextFieldFilename.setText(this.model.getFilename());
        }
        return this.jTextFieldFilename;
    }

    void addFilenameTextFieldActionListener(ActionListener actionListener) {
        this.jTextFieldFilename.addActionListener(actionListener);
    }

    String getFilenameTextFieldText() {
        return this.jTextFieldFilename.getText();
    }

    void setFilenameTextFieldText(String text) {
        this.jTextFieldFilename.setText(text);
    }

    private JButton getJButtonFilename() {
        if (this.jButtonFileName == null) {
            this.jButtonFileName = new JButton();
            this.jButtonFileName.setText("Browse");
            this.jButtonFileName.setMnemonic('b');
            this.jButtonFileName.setToolTipText("Open file dialog to select file name for export");
        }
        return this.jButtonFileName;
    }

    void addFilenameButtonActionListener(ActionListener actionListener) {
        this.jButtonFileName.addActionListener(actionListener);
    }

    private JComboBox getJComboBoxLanguage() {
        if (this.jComboBoxLanguage == null) {
            this.jComboBoxLanguage = new JComboBox();
            this.jComboBoxLanguage.setPreferredSize(new Dimension(200, 20));
            this.jComboBoxLanguage.setEditable(false);
            this.jComboBoxLanguage.setToolTipText("Set language identifier");
            this.jComboBoxLanguage.setEnabled(this.model.getOutputMode() != OutputMode.BDSUP);
            int n = this.model.getOutputMode() == OutputMode.XML ? 2 : 1;
            for (String[] language : Constants.LANGUAGES) {
                this.jComboBoxLanguage.addItem(language[0] + " (" + language[n] + ")");
            }
            this.jComboBoxLanguage.setSelectedIndex(this.model.getLanguageIdx());
        }
        return this.jComboBoxLanguage;
    }

    void addLanguageComboBoxItemListener(ItemListener itemListener) {
        this.jComboBoxLanguage.addItemListener(itemListener);
    }

    int getLanguageComboBoxSelectedItem() {
        return this.jComboBoxLanguage.getSelectedIndex();
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.setToolTipText("Cancel export and return");
            this.jButtonCancel.setMnemonic('c');
        }
        return this.jButtonCancel;
    }

    void addCancelButtonActionListener(ActionListener actionListener) {
        this.jButtonCancel.addActionListener(actionListener);
    }

    private JButton getJButtonSave() {
        if (this.jButtonSave == null) {
            this.jButtonSave = new JButton();
            this.jButtonSave.setText("Save");
            this.jButtonSave.setToolTipText("Start creation of export stream");
            this.jButtonSave.setMnemonic('s');
            this.jButtonSave.addAncestorListener(new RequestFocusListener());
        }
        return this.jButtonSave;
    }

    void addSaveButtonActionListener(ActionListener actionListener) {
        this.jButtonSave.addActionListener(actionListener);
    }

    private JCheckBox getJCheckBoxForced() {
        if (this.jCheckBoxForced == null) {
            this.jCheckBoxForced = new JCheckBox();
            this.jCheckBoxForced.setToolTipText("Export only subpictures marked as 'forced'");
            this.jCheckBoxForced.setText("Export only forced");
            this.jCheckBoxForced.setMnemonic('f');
            if (Core.getNumForcedFrames() == 0) {
                this.jCheckBoxForced.setEnabled(false);
                this.model.setExportForced(false);
            }
            this.jCheckBoxForced.setSelected(this.model.getExportForced());
        }
        return this.jCheckBoxForced;
    }

    void addForcedCheckBoxItemListener(ItemListener itemListener) {
        this.jCheckBoxForced.addItemListener(itemListener);
    }

    boolean isForcedCheckBoxSelected() {
        return this.jCheckBoxForced.isSelected();
    }

    private JCheckBox getJCheckBoxWritePGCPalette() {
        if (this.jCheckBoxWritePGCPalette == null) {
            this.jCheckBoxWritePGCPalette = new JCheckBox();
            this.jCheckBoxWritePGCPalette.setToolTipText("Export palette in PGCEdit text format (RGB, 0..255)");
            String text = "Export palette in PGCEdit text format";
            this.jCheckBoxWritePGCPalette.setText(text);
            this.jCheckBoxWritePGCPalette.setMnemonic('p');
            this.jCheckBoxWritePGCPalette.setDisplayedMnemonicIndex(text.indexOf("PGCEdit"));
            if (this.model.getOutputMode() == OutputMode.VOBSUB || this.model.getOutputMode() == OutputMode.SUPIFO) {
                this.jCheckBoxWritePGCPalette.setEnabled(true);
                this.jCheckBoxWritePGCPalette.setSelected(this.model.getWritePGCPalette());
            } else {
                this.jCheckBoxWritePGCPalette.setEnabled(false);
            }
        }
        return this.jCheckBoxWritePGCPalette;
    }

    void addWritePGCPaletteCheckBoxItemListener(ItemListener itemListener) {
        this.jCheckBoxWritePGCPalette.addItemListener(itemListener);
    }

    public boolean isWritePGCPalCheckBoxSelected() {
        return this.jCheckBoxWritePGCPalette.isSelected();
    }
}

