/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.palette;

import bdsup2sub.bitmap.Palette;
import bdsup2sub.core.Core;
import bdsup2sub.gui.palette.FramePaletteDialogModel;
import bdsup2sub.gui.support.GuiUtils;
import bdsup2sub.gui.support.RequestFocusListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

class FramePaletteDialogView
extends JDialog {
    private JPanel jContentPane;
    private JComboBox jComboBoxColor1;
    private JComboBox jComboBoxColor2;
    private JComboBox jComboBoxColor3;
    private JComboBox jComboBoxColor4;
    private JComboBox jComboBoxAlpha1;
    private JComboBox jComboBoxAlpha2;
    private JComboBox jComboBoxAlpha3;
    private JComboBox jComboBoxAlpha4;
    private JButton jButtonOk;
    private JButton jButtonCancel;
    private JButton jButtonSetAll;
    private JButton jButtonResetAll;
    private JButton jButtonReset;
    private final FramePaletteDialogModel model;

    public FramePaletteDialogView(FramePaletteDialogModel model, Frame frame) {
        super(frame, "Edit Frame Palette", true);
        this.model = model;
        this.initialize();
    }

    private void initialize() {
        this.setSize(294, 209);
        this.setContentPane(this.getJContentPane());
        GuiUtils.centerRelativeToOwner(this);
        this.setResizable(false);
        this.initComboBoxColorPreviewIcons(this.model);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            JLabel jLabelAlpha1 = new JLabel();
            jLabelAlpha1.setBounds(new Rectangle(155, 10, 41, 16));
            jLabelAlpha1.setText("Alpha 1");
            JLabel jLabelAlpha2 = new JLabel();
            jLabelAlpha2.setBounds(new Rectangle(155, 35, 41, 16));
            jLabelAlpha2.setText("Alpha 2");
            JLabel jLabelAlpha3 = new JLabel();
            jLabelAlpha3.setBounds(new Rectangle(155, 60, 41, 16));
            jLabelAlpha3.setText("Alpha 3");
            JLabel jLabelAlpha4 = new JLabel();
            jLabelAlpha4.setBounds(new Rectangle(155, 85, 41, 16));
            jLabelAlpha4.setText("Alpha 4");
            JLabel jLabelColor1 = new JLabel();
            jLabelColor1.setBounds(new Rectangle(15, 10, 46, 16));
            jLabelColor1.setText("Color 1");
            JLabel jLabelColor2 = new JLabel();
            jLabelColor2.setBounds(new Rectangle(15, 35, 46, 16));
            jLabelColor2.setText("Color 2");
            JLabel jLabelColor3 = new JLabel();
            jLabelColor3.setBounds(new Rectangle(15, 60, 46, 16));
            jLabelColor3.setText("Color 3");
            JLabel jLabelColor4 = new JLabel();
            jLabelColor4.setBounds(new Rectangle(15, 85, 45, 16));
            jLabelColor4.setText("Color 4");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getJButtonOk(), null);
            this.jContentPane.add((Component)this.getJButtonCancel(), null);
            this.jContentPane.add((Component)jLabelColor1, null);
            this.jContentPane.add((Component)jLabelColor2, null);
            this.jContentPane.add((Component)jLabelColor3, null);
            this.jContentPane.add((Component)jLabelColor4, null);
            this.jContentPane.add((Component)jLabelAlpha1, null);
            this.jContentPane.add((Component)jLabelAlpha2, null);
            this.jContentPane.add((Component)jLabelAlpha3, null);
            this.jContentPane.add((Component)jLabelAlpha4, null);
            this.jContentPane.add((Component)this.getJComboBoxColor1(), null);
            this.jContentPane.add((Component)this.getJComboBoxColor2(), null);
            this.jContentPane.add((Component)this.getJComboBoxColor3(), null);
            this.jContentPane.add((Component)this.getJComboBoxColor4(), null);
            this.jContentPane.add((Component)this.getJComboBoxAlpha1(), null);
            this.jContentPane.add((Component)this.getJComboBoxAlpha2(), null);
            this.jContentPane.add((Component)this.getJComboBoxAlpha3(), null);
            this.jContentPane.add((Component)this.getJComboBoxAlpha4(), null);
            this.jContentPane.add((Component)this.getJButtonSetAll(), null);
            this.jContentPane.add((Component)this.getJButtonResetAll(), null);
            this.jContentPane.add((Component)this.getJButtonReset(), null);
        }
        return this.jContentPane;
    }

    private JComboBox getJComboBoxColor1() {
        if (this.jComboBoxColor1 == null) {
            this.jComboBoxColor1 = new JComboBox();
            this.jComboBoxColor1.setBounds(new Rectangle(70, 10, 61, 16));
            this.jComboBoxColor1.setEditable(false);
            this.jComboBoxColor1.setToolTipText("Set palette index of frame color 1");
        }
        return this.jComboBoxColor1;
    }

    void addColor1ComboBoxActionListener(ActionListener actionListener) {
        this.jComboBoxColor1.addActionListener(actionListener);
    }

    private JComboBox getJComboBoxColor2() {
        if (this.jComboBoxColor2 == null) {
            this.jComboBoxColor2 = new JComboBox();
            this.jComboBoxColor2.setBounds(new Rectangle(70, 35, 61, 16));
            this.jComboBoxColor2.setEditable(false);
            this.jComboBoxColor2.setToolTipText("Set palette index of frame color 2");
        }
        return this.jComboBoxColor2;
    }

    void addColor2ComboBoxActionListener(ActionListener actionListener) {
        this.jComboBoxColor2.addActionListener(actionListener);
    }

    private JComboBox getJComboBoxColor3() {
        if (this.jComboBoxColor3 == null) {
            this.jComboBoxColor3 = new JComboBox();
            this.jComboBoxColor3.setBounds(new Rectangle(70, 60, 61, 16));
            this.jComboBoxColor3.setEditable(false);
            this.jComboBoxColor3.setToolTipText("Set palette index of frame color 3");
        }
        return this.jComboBoxColor3;
    }

    void addColor3ComboBoxActionListener(ActionListener actionListener) {
        this.jComboBoxColor3.addActionListener(actionListener);
    }

    private JComboBox getJComboBoxColor4() {
        if (this.jComboBoxColor4 == null) {
            this.jComboBoxColor4 = new JComboBox();
            this.jComboBoxColor4.setBounds(new Rectangle(70, 85, 61, 16));
            this.jComboBoxColor4.setEditable(false);
            this.jComboBoxColor4.setToolTipText("Set palette index of frame color 4");
        }
        return this.jComboBoxColor4;
    }

    void addColor4ComboBoxActionListener(ActionListener actionListener) {
        this.jComboBoxColor4.addActionListener(actionListener);
    }

    private JComboBox getJComboBoxAlpha1() {
        if (this.jComboBoxAlpha1 == null) {
            this.jComboBoxAlpha1 = new JComboBox();
            this.jComboBoxAlpha1.setBounds(new Rectangle(215, 10, 56, 16));
            this.jComboBoxAlpha1.setEditable(false);
            this.jComboBoxAlpha1.setToolTipText("Set alpha value of frame color 1");
        }
        return this.jComboBoxAlpha1;
    }

    void addAlpha1ComboBoxActionListener(ActionListener actionListener) {
        this.jComboBoxAlpha1.addActionListener(actionListener);
    }

    private JComboBox getJComboBoxAlpha2() {
        if (this.jComboBoxAlpha2 == null) {
            this.jComboBoxAlpha2 = new JComboBox();
            this.jComboBoxAlpha2.setBounds(new Rectangle(215, 35, 56, 16));
            this.jComboBoxAlpha2.setEditable(false);
            this.jComboBoxAlpha2.setToolTipText("Set alpha value of frame color 2");
        }
        return this.jComboBoxAlpha2;
    }

    void addAlpha2ComboBoxActionListener(ActionListener actionListener) {
        this.jComboBoxAlpha2.addActionListener(actionListener);
    }

    private JComboBox getJComboBoxAlpha3() {
        if (this.jComboBoxAlpha3 == null) {
            this.jComboBoxAlpha3 = new JComboBox();
            this.jComboBoxAlpha3.setBounds(new Rectangle(215, 60, 56, 16));
            this.jComboBoxAlpha3.setEditable(false);
            this.jComboBoxAlpha3.setToolTipText("Set alpha value of frame color 3");
        }
        return this.jComboBoxAlpha3;
    }

    void addAlpha3ComboBoxActionListener(ActionListener actionListener) {
        this.jComboBoxAlpha3.addActionListener(actionListener);
    }

    private JComboBox getJComboBoxAlpha4() {
        if (this.jComboBoxAlpha4 == null) {
            this.jComboBoxAlpha4 = new JComboBox();
            this.jComboBoxAlpha4.setBounds(new Rectangle(215, 85, 56, 16));
            this.jComboBoxAlpha4.setEditable(false);
            this.jComboBoxAlpha4.setToolTipText("Set alpha value of frame color 4");
        }
        return this.jComboBoxAlpha4;
    }

    void addAlpha4ComboBoxActionListener(ActionListener actionListener) {
        this.jComboBoxAlpha4.addActionListener(actionListener);
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setName("jButtonCancel");
            this.jButtonCancel.setBounds(new Rectangle(10, 145, 75, 21));
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.setToolTipText("Lose changes and return");
            this.jButtonCancel.setMnemonic('c');
        }
        return this.jButtonCancel;
    }

    void addCancelButtonActionListener(ActionListener actionListener) {
        this.jButtonCancel.addActionListener(actionListener);
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setName("jButtonOk");
            this.jButtonOk.setBounds(new Rectangle(200, 145, 75, 21));
            this.jButtonOk.setText("Ok");
            this.jButtonOk.setToolTipText("Use current settings and return");
            this.jButtonOk.setMnemonic('o');
            this.jButtonOk.addAncestorListener(new RequestFocusListener());
        }
        return this.jButtonOk;
    }

    void addOkButtonActionListener(ActionListener actionListener) {
        this.jButtonOk.addActionListener(actionListener);
    }

    private JButton getJButtonSetAll() {
        if (this.jButtonSetAll == null) {
            this.jButtonSetAll = new JButton();
            this.jButtonSetAll.setBounds(new Rectangle(200, 115, 75, 21));
            this.jButtonSetAll.setText("Set All");
            this.jButtonSetAll.setToolTipText("Apply these settings for whole stream and return");
            this.jButtonSetAll.setMnemonic('s');
        }
        return this.jButtonSetAll;
    }

    void addSetAllButtonActionListener(ActionListener actionListener) {
        this.jButtonSetAll.addActionListener(actionListener);
    }

    private JButton getJButtonResetAll() {
        if (this.jButtonResetAll == null) {
            this.jButtonResetAll = new JButton();
            this.jButtonResetAll.setBounds(new Rectangle(105, 115, 75, 23));
            this.jButtonResetAll.setText("Reset All");
            this.jButtonResetAll.setToolTipText("Revert to original frame palettes for whole stream and return");
            this.jButtonResetAll.setMnemonic('a');
        }
        return this.jButtonResetAll;
    }

    void addResetAllButtonActionListener(ActionListener actionListener) {
        this.jButtonResetAll.addActionListener(actionListener);
    }

    private JButton getJButtonReset() {
        if (this.jButtonReset == null) {
            this.jButtonReset = new JButton();
            this.jButtonReset.setBounds(new Rectangle(105, 145, 75, 23));
            this.jButtonReset.setText("Reset");
            this.jButtonReset.setToolTipText("Revert to original frame palette");
            this.jButtonReset.setMnemonic('r');
        }
        return this.jButtonReset;
    }

    void addResetButtonActionListener(ActionListener actionListener) {
        this.jButtonReset.addActionListener(actionListener);
    }

    private void initComboBoxColorPreviewIcons(FramePaletteDialogModel model) {
        Palette palette = Core.getCurSrcDVDPalette();
        model.setColorPreviewIcon(new ImageIcon[16]);
        for (int i = 0; i < palette.getSize(); ++i) {
            model.getColorPreviewIcon()[i] = new ImageIcon(new BufferedImage(12, 12, 1));
            Color c = new Color(palette.getARGB(i) | 0xFF000000);
            this.paintIcon(model.getColorPreviewIcon()[i], c);
            this.jComboBoxColor1.addItem(FramePaletteDialogModel.COLOR_NAME[i]);
            this.jComboBoxColor2.addItem(FramePaletteDialogModel.COLOR_NAME[i]);
            this.jComboBoxColor3.addItem(FramePaletteDialogModel.COLOR_NAME[i]);
            this.jComboBoxColor4.addItem(FramePaletteDialogModel.COLOR_NAME[i]);
            this.jComboBoxAlpha1.addItem(FramePaletteDialogModel.COLOR_NAME[i]);
            this.jComboBoxAlpha2.addItem(FramePaletteDialogModel.COLOR_NAME[i]);
            this.jComboBoxAlpha3.addItem(FramePaletteDialogModel.COLOR_NAME[i]);
            this.jComboBoxAlpha4.addItem(FramePaletteDialogModel.COLOR_NAME[i]);
        }
    }

    private void paintIcon(ImageIcon icon, Color color) {
        Graphics graphics = icon.getImage().getGraphics();
        graphics.setColor(color);
        graphics.setPaintMode();
        graphics.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
    }

    void addComboBoxCellRenderers(ListCellRenderer listCellRenderer) {
        this.jComboBoxColor1.setRenderer(listCellRenderer);
        this.jComboBoxColor2.setRenderer(listCellRenderer);
        this.jComboBoxColor3.setRenderer(listCellRenderer);
        this.jComboBoxColor4.setRenderer(listCellRenderer);
        this.jComboBoxColor1.repaint();
        this.jComboBoxColor2.repaint();
        this.jComboBoxColor3.repaint();
        this.jComboBoxColor4.repaint();
    }

    void updateComboBoxSelections() {
        int[] alpha = this.model.getAlpha();
        this.jComboBoxAlpha1.setSelectedIndex(alpha[0]);
        this.jComboBoxAlpha2.setSelectedIndex(alpha[1]);
        this.jComboBoxAlpha3.setSelectedIndex(alpha[2]);
        this.jComboBoxAlpha4.setSelectedIndex(alpha[3]);
        int[] palette = this.model.getPalette();
        this.jComboBoxColor1.setSelectedIndex(palette[0]);
        this.jComboBoxColor2.setSelectedIndex(palette[1]);
        this.jComboBoxColor3.setSelectedIndex(palette[2]);
        this.jComboBoxColor4.setSelectedIndex(palette[3]);
    }
}

