/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.gui.support;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class EditPane
extends JPanel {
    private static final double SCREEN_ASPECT_RATIO = 1.7777777777777777;
    private BufferedImage image;
    private int screenWidth = 1920;
    private int screenHeight = 1080;
    private int offsetX;
    private int offsetY;
    private int subtitleImageWidth;
    private int subtitleImageHeight;
    private double cinemascopeBarFactor = 0.11904761904761904;
    private int cropOffsetY;
    private static final int INSET = 2;
    private int selectionStartX = -1;
    private int selectionEndX;
    private int selectionStartY;
    private int selectionEndY;
    private boolean selectionAllowed;
    private boolean selectionValid;
    private boolean leftButtonPressed;
    private boolean excluded;
    private int yCrop;
    private double xScaleCaption;
    private double yScaleCaption;
    private final boolean layoutPane;
    private SelectListener selectListener;

    public EditPane(boolean isLayoutPane) {
        this.layoutPane = isLayoutPane;
        this.addMouseListener(new EditPaneMouseListener());
        this.addMouseMotionListener(new EditPaneMouseMotionListener());
    }

    public EditPane() {
        this(false);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.draw(graphics);
    }

    public void update(Graphics graphics) {
        super.update(graphics);
        this.draw(graphics);
    }

    void draw(Graphics graphics) {
        int xl;
        int yl;
        int hl;
        int wl;
        Graphics2D graphics2D = (Graphics2D)graphics;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.layoutPane) {
            graphics2D.setColor(UIManager.getColor("Panel.background"));
            graphics2D.fillRect(0, 0, width, height);
            wl = width - 4;
            hl = (wl * 9 + 8) / 16;
            if (hl > height) {
                hl = height - 2;
                wl = (hl * 32 + 8) / 18;
            }
            yl = (height - hl + 1) / 2;
            xl = (width - wl + 1) / 2;
        } else {
            wl = width;
            hl = height;
            xl = 0;
            yl = 0;
        }
        int cinemascopeBarHeight = (int)((double)hl * this.cinemascopeBarFactor + 0.5);
        graphics2D.setPaint(new GradientPaint(xl, yl, Color.BLUE, wl, hl, Color.BLACK));
        graphics2D.fillRect(xl, yl + cinemascopeBarHeight, wl, hl - cinemascopeBarHeight);
        graphics2D.setPaint(Color.BLACK);
        graphics2D.fillRect(xl, yl, wl, cinemascopeBarHeight);
        graphics2D.fillRect(xl, yl + hl - cinemascopeBarHeight, wl, cinemascopeBarHeight);
        this.yCrop = this.offsetY;
        if (this.yCrop < this.cropOffsetY) {
            this.yCrop = this.cropOffsetY;
        } else {
            int yMax = this.screenHeight - this.subtitleImageHeight - this.cropOffsetY;
            if (this.yCrop > yMax) {
                this.yCrop = yMax;
            }
        }
        double sx = (double)wl / (double)this.screenWidth;
        double sy = (double)hl / (double)this.screenHeight;
        this.xScaleCaption = sx;
        this.yScaleCaption = sy;
        if (this.subtitleImageWidth > 0 && this.image != null) {
            int wi = (int)((double)this.subtitleImageWidth * sx + 0.5);
            int hi = (int)((double)this.subtitleImageHeight * sy + 0.5);
            int xi = xl + (int)((double)this.offsetX * sx + 0.5);
            int yi = yl + (int)((double)this.yCrop * sy + 0.5);
            graphics2D.setColor(Color.GREEN);
            graphics2D.drawRect(xi, yi, wi - 1, hi - 1);
            graphics2D.drawImage(this.image, xi, yi, wi, hi, this);
            if (this.selectionValid && !this.leftButtonPressed) {
                if (this.selectionStartX >= this.subtitleImageWidth + this.offsetX || this.selectionEndX <= this.offsetX || this.selectionStartY >= this.subtitleImageHeight + this.yCrop || this.selectionEndY < this.yCrop) {
                    this.selectionValid = false;
                } else {
                    if (this.selectionStartX < this.offsetX) {
                        this.selectionStartX = this.offsetX;
                    }
                    if (this.selectionEndX >= this.subtitleImageWidth + this.offsetX) {
                        this.selectionEndX = this.subtitleImageWidth + this.offsetX - 1;
                    }
                    if (this.selectionStartY < this.yCrop) {
                        this.selectionStartY = this.yCrop;
                    }
                    if (this.selectionEndY >= this.subtitleImageHeight + this.yCrop) {
                        this.selectionEndY = this.subtitleImageHeight + this.yCrop - 1;
                    }
                }
            }
        }
        if (this.cropOffsetY > 0) {
            graphics2D.setPaint(Color.RED);
            int y = yl + (int)((double)this.cropOffsetY * sy + 0.5);
            graphics2D.drawLine(xl, y, wl - 1, y);
            y = yl + hl - (int)((double)this.cropOffsetY * sy + 0.5) - 1;
            graphics2D.drawLine(xl, y, wl - 1, y);
        }
        if (this.selectionValid) {
            graphics2D.setPaint(Color.YELLOW);
            graphics2D.drawRect((int)((double)this.selectionStartX * sx + 0.5), (int)((double)this.selectionStartY * sy + 0.5), (int)((double)(this.selectionEndX - this.selectionStartX) * sx + 0.5), (int)((double)(this.selectionEndY - this.selectionStartY) * sy + 0.5));
        }
        if (this.excluded) {
            graphics2D.setPaint(Color.RED);
            graphics2D.drawLine(xl, yl, xl + wl - 1, yl + hl - 1);
            graphics2D.drawLine(xl + wl, yl, xl - 1, yl + hl - 1);
        }
    }

    public void setImage(BufferedImage image, int width, int height) {
        this.image = image;
        this.subtitleImageWidth = width;
        this.subtitleImageHeight = height;
    }

    public void setScreenDimension(int width, int height) {
        this.screenWidth = width;
        this.screenHeight = height;
    }

    public void setSubtitleOffsets(int x, int y) {
        this.offsetX = x;
        this.offsetY = y < this.cropOffsetY ? this.cropOffsetY : y;
    }

    public void setAspectRatio(double aspectRatio) {
        this.cinemascopeBarFactor = (1.0 - 1.7777777777777777 / aspectRatio) / 2.0;
    }

    public void setCropOffsetY(int offset) {
        this.cropOffsetY = offset;
    }

    public void setSelectionAllowed(boolean selectionAllowed) {
        this.selectionAllowed = selectionAllowed;
    }

    public void setExcluded(boolean excluded) {
        this.excluded = excluded;
    }

    public int[] getSelection() {
        if (!this.selectionAllowed || !this.selectionValid) {
            return null;
        }
        int[] ret = new int[]{this.selectionStartX - this.offsetX, this.selectionStartY - this.yCrop, this.selectionEndX - this.offsetX, this.selectionEndY - this.yCrop};
        return ret;
    }

    public void removeSelection() {
        if (this.selectionAllowed && this.selectionValid) {
            this.selectionValid = false;
        }
    }

    public void addSelectListener(SelectListener selectListener) {
        this.selectListener = selectListener;
    }

    public static interface SelectListener {
        public void selectionPerformed(boolean var1);
    }

    private class EditPaneMouseMotionListener
    extends MouseMotionAdapter {
        private EditPaneMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent e) {
            if (EditPane.this.leftButtonPressed) {
                EditPane.this.selectionEndX = (int)((double)e.getX() / EditPane.this.xScaleCaption + 0.5);
                EditPane.this.selectionEndY = (int)((double)e.getY() / EditPane.this.yScaleCaption + 0.5);
                if (EditPane.this.selectionStartX >= 0 && EditPane.this.selectionEndX > EditPane.this.selectionStartX && EditPane.this.selectionEndY > EditPane.this.selectionStartY) {
                    EditPane.this.selectionValid = true;
                }
                EditPane.this.repaint();
            }
        }
    }

    private class EditPaneMouseListener
    extends MouseAdapter {
        private EditPaneMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (EditPane.this.selectionAllowed && e.getButton() == 1) {
                EditPane.this.selectionStartX = (int)((double)e.getX() / EditPane.this.xScaleCaption + 0.5);
                EditPane.this.selectionStartY = (int)((double)e.getY() / EditPane.this.yScaleCaption + 0.5);
                EditPane.this.leftButtonPressed = true;
                EditPane.this.selectionValid = false;
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (EditPane.this.selectionAllowed && e.getButton() == 1) {
                EditPane.this.selectionEndX = (int)((double)e.getX() / EditPane.this.xScaleCaption + 0.5);
                EditPane.this.selectionEndY = (int)((double)e.getY() / EditPane.this.yScaleCaption + 0.5);
                EditPane.this.leftButtonPressed = false;
                if (EditPane.this.selectionStartX >= 0 && EditPane.this.selectionEndX > EditPane.this.selectionStartX && EditPane.this.selectionEndY > EditPane.this.selectionStartY) {
                    EditPane.this.selectionValid = true;
                }
                EditPane.this.repaint();
                EditPane.this.selectListener.selectionPerformed(EditPane.this.selectionValid);
            }
        }
    }
}

