/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.supstream.dvd;

import bdsup2sub.bitmap.Palette;
import bdsup2sub.core.Constants;
import bdsup2sub.core.CoreException;
import bdsup2sub.core.Logger;
import bdsup2sub.tools.FileBuffer;
import bdsup2sub.tools.FileBufferException;
import bdsup2sub.utils.ToolBox;
import java.util.Arrays;

public class IfoParser {
    private static final Logger logger = Logger.getInstance();
    private static final byte[] IFO_HEADER = "DVDVIDEO-VTS".getBytes();
    private final FileBuffer fileBuffer;
    private int screenWidth;
    private int screenHeight;
    private int languageIdx;
    private Palette srcPalette = new Palette(Constants.DEFAULT_DVD_PALETTE);

    public IfoParser(String filename) throws CoreException {
        try {
            this.fileBuffer = new FileBuffer(filename);
            this.processIFO();
        }
        catch (FileBufferException e) {
            throw new CoreException(e.getMessage());
        }
    }

    private void processIFO() throws CoreException {
        try {
            this.validateIfoHeader();
            this.readVideoAttributes();
            this.readFirstLanguageIndex();
            this.readFirstPalette();
        }
        catch (FileBufferException e) {
            throw new CoreException(e.getMessage());
        }
    }

    private void validateIfoHeader() throws FileBufferException, CoreException {
        byte[] header = new byte[IFO_HEADER.length];
        this.fileBuffer.getBytes(0L, header, IFO_HEADER.length);
        if (!Arrays.equals(header, IFO_HEADER)) {
            throw new CoreException("Not a valid IFO file.");
        }
    }

    private void readVideoAttributes() throws FileBufferException {
        int vidAttr = this.fileBuffer.getWord(512L);
        if ((vidAttr & 0x3000) != 0) {
            switch (vidAttr >> 3 & 3) {
                case 0: {
                    this.screenWidth = 720;
                    this.screenHeight = 576;
                    break;
                }
                case 1: {
                    this.screenWidth = 704;
                    this.screenHeight = 576;
                    break;
                }
                case 2: {
                    this.screenWidth = 352;
                    this.screenHeight = 576;
                    break;
                }
                case 3: {
                    this.screenWidth = 352;
                    this.screenHeight = 288;
                }
            }
        } else {
            switch (vidAttr >> 3 & 3) {
                case 0: {
                    this.screenWidth = 720;
                    this.screenHeight = 480;
                    break;
                }
                case 1: {
                    this.screenWidth = 704;
                    this.screenHeight = 480;
                    break;
                }
                case 2: {
                    this.screenWidth = 352;
                    this.screenHeight = 480;
                    break;
                }
                case 3: {
                    this.screenWidth = 352;
                    this.screenHeight = 240;
                }
            }
        }
        logger.trace("Resolution: " + this.screenWidth + "x" + this.screenHeight + "\n");
    }

    private void readFirstLanguageIndex() throws FileBufferException {
        if (this.fileBuffer.getWord(596L) > 0 && this.fileBuffer.getByte(598L) == 1) {
            StringBuilder langSB = new StringBuilder(2);
            boolean found = false;
            langSB.append((char)this.fileBuffer.getByte(600L));
            langSB.append((char)this.fileBuffer.getByte(601L));
            String lang = langSB.toString();
            for (int i = 0; i < Constants.LANGUAGES.length; ++i) {
                if (!lang.equalsIgnoreCase(Constants.LANGUAGES[i][1])) continue;
                this.languageIdx = i;
                found = true;
                break;
            }
            if (!found) {
                logger.warn("Illegal language id: " + lang + "\n");
            } else {
                logger.trace("Set language to: " + lang + "\n");
            }
        } else {
            logger.warn("Missing language id.\n");
        }
    }

    private void readFirstPalette() throws FileBufferException {
        long VTS_PGCITI_ofs = this.fileBuffer.getDWord(204L) * 2048;
        VTS_PGCITI_ofs += (long)this.fileBuffer.getDWord(VTS_PGCITI_ofs + 12L);
        logger.trace("Reading palette from offset: " + ToolBox.toHexLeftZeroPadded(VTS_PGCITI_ofs, 8) + "\n");
        long index = VTS_PGCITI_ofs;
        for (int i = 0; i < 16; ++i) {
            int y = this.fileBuffer.getByte(index + 164L + (long)(4 * i) + 1L) & 0xFF;
            int cb = this.fileBuffer.getByte(index + 164L + (long)(4 * i) + 2L) & 0xFF;
            int cr = this.fileBuffer.getByte(index + 164L + (long)(4 * i) + 3L) & 0xFF;
            this.srcPalette.setYCbCr(i, y, cb, cr);
        }
    }

    public Palette getSrcPalette() {
        return this.srcPalette;
    }

    public int getLanguageIdx() {
        return this.languageIdx;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }
}

