/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.supstream.dvd;

import bdsup2sub.bitmap.Bitmap;
import bdsup2sub.bitmap.BitmapBounds;
import bdsup2sub.bitmap.Palette;
import bdsup2sub.core.Configuration;
import bdsup2sub.core.Constants;
import bdsup2sub.core.Core;
import bdsup2sub.core.CoreException;
import bdsup2sub.core.Logger;
import bdsup2sub.supstream.ImageObjectFragment;
import bdsup2sub.supstream.SubPicture;
import bdsup2sub.supstream.dvd.DvdSubtitleStream;
import bdsup2sub.supstream.dvd.SubPictureDVD;
import bdsup2sub.supstream.dvd.SupDvdUtil;
import bdsup2sub.tools.FileBuffer;
import bdsup2sub.tools.FileBufferException;
import bdsup2sub.utils.ByteUtils;
import bdsup2sub.utils.TimeUtils;
import bdsup2sub.utils.ToolBox;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SubDvd
implements DvdSubtitleStream {
    private static final Configuration configuration = Configuration.getInstance();
    private static final Logger logger = Logger.getInstance();
    private final List<SubPictureDVD> subPictures = new ArrayList<SubPictureDVD>();
    private Palette srcPalette = new Palette(Constants.DEFAULT_DVD_PALETTE);
    private Palette palette;
    private Bitmap bitmap;
    private int screenWidth = 720;
    private int screenHeight = 576;
    private int globalXOffset;
    private int globalYOffset;
    private int globalDelay;
    private int languageIndex;
    private int streamID;
    private final FileBuffer buffer;
    private int primaryColorIndex;
    private int forcedFrameCount;
    private static int[] lastAlpha = new int[]{0, 15, 15, 15};

    public SubDvd(String subFile, String idxFile) throws CoreException {
        this.readIdx(idxFile);
        Core.setProgressMax(this.subPictures.size());
        try {
            this.buffer = new FileBuffer(subFile);
        }
        catch (FileBufferException e) {
            throw new CoreException(e.getMessage());
        }
        for (int i = 0; i < this.subPictures.size(); ++i) {
            Core.setProgress(i);
            logger.info("# " + (i + 1) + "\n");
            logger.trace("Offset: " + ToolBox.toHexLeftZeroPadded(this.subPictures.get(i).getOffset(), 8) + "\n");
            long nextOfs = i < this.subPictures.size() - 1 ? this.subPictures.get(i + 1).getOffset() : this.buffer.getSize();
            this.readSubFrame(this.subPictures.get(i), nextOfs, this.buffer);
        }
        logger.info("\nDetected " + this.forcedFrameCount + " forced captions.\n");
    }

    private void readIdx(String idxFile) throws CoreException {
        BufferedReader in = null;
        try {
            String s;
            in = new BufferedReader(new FileReader(idxFile));
            int langIdx = 0;
            boolean ignore = false;
            while ((s = in.readLine()) != null) {
                int v;
                if ((s = s.trim()).length() < 1 || s.charAt(0) == '#') continue;
                int pos = s.indexOf(58);
                if (pos == -1 || s.length() - pos <= 1) {
                    logger.error("Illegal key: " + s + "\n");
                    continue;
                }
                String key = s.substring(0, pos).trim();
                String val = s.substring(pos + 1).trim();
                if (key.equalsIgnoreCase("size")) {
                    pos = val.indexOf(120);
                    if (pos == -1 || val.length() - pos <= 1) {
                        throw new CoreException("Illegal size: " + val);
                    }
                    v = ToolBox.getInt(val.substring(0, pos));
                    if (v < 2) {
                        throw new CoreException("Illegal screen width: " + v);
                    }
                    this.screenWidth = v;
                    v = ToolBox.getInt(val.substring(pos + 1));
                    if (v < 2) {
                        throw new CoreException("Illegal screen height: " + v);
                    }
                    this.screenHeight = v;
                    continue;
                }
                if (key.equalsIgnoreCase("org")) {
                    pos = val.indexOf(44);
                    if (pos == -1 || val.length() - pos <= 1) {
                        throw new CoreException("Illegal origin: " + val);
                    }
                    v = ToolBox.getInt(val.substring(0, pos));
                    if (v < 0) {
                        throw new CoreException("Illegal x origin: " + v);
                    }
                    this.globalXOffset = v;
                    v = ToolBox.getInt(val.substring(pos + 1));
                    if (v < 0) {
                        throw new CoreException("Illegal y origin: " + v);
                    }
                    this.globalYOffset = v;
                    continue;
                }
                if (key.equalsIgnoreCase("scale") || key.equalsIgnoreCase("alpha") || key.equalsIgnoreCase("smooth") || key.equalsIgnoreCase("fadein/out") || key.equalsIgnoreCase("align")) continue;
                if (key.equalsIgnoreCase("time offset")) {
                    v = ToolBox.getInt(val);
                    if (v < 0) {
                        v = (int)TimeUtils.timeStrToPTS(val);
                    }
                    if (v < 0) {
                        throw new CoreException("Illegal time offset: " + v);
                    }
                    this.globalDelay = v * 90;
                    continue;
                }
                if (key.equalsIgnoreCase("align")) continue;
                if (key.equalsIgnoreCase("palette")) {
                    String[] vals = val.split(",");
                    if (vals == null || vals.length < 1 || vals.length > 16) {
                        throw new CoreException("Illegal palette definition: " + val);
                    }
                    for (int i = 0; i < vals.length; ++i) {
                        int color = -1;
                        try {
                            color = Integer.parseInt(vals[i].trim(), 16);
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                        if (color == -1) {
                            throw new CoreException("Illegal palette entry: " + vals[i]);
                        }
                        this.srcPalette.setARGB(i, color);
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("custom colors")) continue;
                if (key.equalsIgnoreCase("langidx")) {
                    v = ToolBox.getInt(val);
                    if (v < 0) {
                        throw new CoreException("Illegal language idx: " + v);
                    }
                    langIdx = v;
                    continue;
                }
                if (key.equalsIgnoreCase("id")) {
                    pos = val.indexOf(44);
                    String id = pos > 0 ? val.substring(0, pos).trim() : val;
                    if (id.length() != 2) {
                        logger.warn("Illegal language id: " + id + "\n");
                        continue;
                    }
                    boolean found = false;
                    for (int i = 0; i < Constants.LANGUAGES.length; ++i) {
                        if (!id.equalsIgnoreCase(Constants.LANGUAGES[i][1])) continue;
                        this.languageIndex = i;
                        found = true;
                        break;
                    }
                    if (!found) {
                        logger.warn("Illegal language id: " + id + "\n");
                    }
                    if ((pos = val.indexOf(58)) == -1 || s.length() - pos <= 1) {
                        logger.error("Missing index key: " + val + "\n");
                        continue;
                    }
                    key = val.substring(0, pos).trim();
                    val = val.substring(pos + 1).trim();
                    if (key.equalsIgnoreCase("index")) {
                        logger.error("Missing index key: " + s + "\n");
                        continue;
                    }
                    v = ToolBox.getInt(val);
                    if (v < 0) {
                        throw new CoreException("Illegal language index: " + v);
                    }
                    if (v != langIdx) {
                        ignore = true;
                        logger.warn("Language id " + id + "(index:" + v + ") inactive -> ignored\n");
                        continue;
                    }
                    this.streamID = v;
                    ignore = false;
                    continue;
                }
                if (ignore || !key.equalsIgnoreCase("timestamp")) continue;
                pos = val.indexOf(44);
                if (pos == -1 || val.length() - pos <= 1) {
                    throw new CoreException("Illegal timestamp entry: " + val);
                }
                String vs = val.substring(0, pos);
                long t = TimeUtils.timeStrToPTS(vs);
                if (t < 0L) {
                    throw new CoreException("Illegal timestamp: " + vs);
                }
                vs = val.substring(pos + 1).toLowerCase();
                if ((pos = vs.indexOf("filepos:")) == -1 || vs.length() - pos <= 1) {
                    throw new CoreException("Missing filepos: " + val);
                }
                long l = Long.parseLong(vs.substring(pos + 8).trim(), 16);
                if (l == -1L) {
                    throw new CoreException("Illegal filepos: " + vs.substring(pos + 8));
                }
                SubPictureDVD pic = new SubPictureDVD();
                pic.setOffset(l);
                pic.setWidth(this.screenWidth);
                pic.setHeight(this.screenHeight);
                pic.setStartTime(t + (long)this.globalDelay);
                this.subPictures.add(pic);
            }
        }
        catch (IOException ex) {
            throw new CoreException(ex.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    private void readSubFrame(SubPictureDVD pic, long endOfs, FileBuffer buffer) throws CoreException {
        int i;
        long ofs = pic.getOffset();
        long ctrlOfs = -1L;
        int ctrlOfsRel = 0;
        int rleSize = 0;
        int rleBufferFound = 0;
        int ctrlSize = -1;
        int ctrlHeaderCopied = 0;
        byte[] ctrlHeader = null;
        boolean firstPackFound = false;
        try {
            do {
                int packetStreamID;
                int stuffOfs;
                long startOfs = ofs;
                if (buffer.getDWord(ofs) != 442) {
                    throw new CoreException("Missing packet identifier at ofs " + ToolBox.toHexLeftZeroPadded(ofs, 8));
                }
                ofs += 13L;
                if (buffer.getDWord(ofs += (long)(1 + (stuffOfs = buffer.getByte(ofs) & 7))) != 445) {
                    throw new CoreException("Missing packet identifier at ofs " + ToolBox.toHexLeftZeroPadded(ofs, 8));
                }
                int length = buffer.getWord(ofs += 4L);
                long nextOfs = ofs + 2L + (long)length;
                int packHeaderSize = (int)((ofs += 2L) - startOfs);
                boolean firstPack = (buffer.getByte(++ofs) & 0x80) == 128;
                int ptsLength = buffer.getByte(++ofs);
                ofs += (long)(1 + ptsLength);
                if ((packetStreamID = buffer.getByte(ofs++) - 32) != this.streamID) {
                    if (nextOfs % 2048L != 0L) {
                        ofs = (nextOfs / 2048L + 1L) * 2048L;
                        logger.warn("Offset to next fragment is invalid. Fixed to:" + ToolBox.toHexLeftZeroPadded(ofs, 8) + "\n");
                    } else {
                        ofs = nextOfs;
                    }
                    ctrlOfs += 2048L;
                    continue;
                }
                int headerSize = (int)(ofs - startOfs);
                if (firstPack && ptsLength >= 5) {
                    int size = buffer.getWord(ofs);
                    ctrlOfsRel = buffer.getWord(ofs += 2L);
                    rleSize = ctrlOfsRel - 2;
                    ctrlSize = size - ctrlOfsRel - 2;
                    if (ctrlSize < 0) {
                        throw new CoreException("Invalid control buffer size");
                    }
                    ctrlHeader = new byte[ctrlSize];
                    ctrlOfs = (long)ctrlOfsRel + ofs;
                    headerSize = (int)((ofs += 2L) - startOfs);
                    pic.setRleFragments(new ArrayList<ImageObjectFragment>());
                    firstPackFound = true;
                } else if (firstPackFound) {
                    ctrlOfs += (long)headerSize;
                } else {
                    logger.warn("Invalid fragment skipped at ofs " + ToolBox.toHexLeftZeroPadded(startOfs, 8) + "\n");
                }
                int diff = (int)(nextOfs - ctrlOfs - (long)ctrlHeaderCopied);
                if (diff < 0) {
                    diff = 0;
                }
                int copied = ctrlHeaderCopied;
                try {
                    for (i = 0; i < diff && ctrlHeaderCopied < ctrlSize; ++ctrlHeaderCopied, ++i) {
                        ctrlHeader[ctrlHeaderCopied] = (byte)buffer.getByte(ctrlOfs + (long)i + (long)copied);
                    }
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    throw new CoreException("Inconsistent control buffer access (" + ex.getMessage() + ")");
                }
                ImageObjectFragment rleFrag = new ImageObjectFragment(ofs, length - headerSize - diff + packHeaderSize);
                pic.getRleFragments().add(rleFrag);
                rleBufferFound += rleFrag.getImagePacketSize();
                if (ctrlHeaderCopied != ctrlSize && nextOfs % 2048L != 0L) {
                    ofs = (nextOfs / 2048L + 1L) * 2048L;
                    logger.warn("Offset to next fragment is invalid. Fixed to:" + ToolBox.toHexLeftZeroPadded(ofs, 8) + "\n");
                    rleBufferFound = (int)((long)rleBufferFound + (ofs - nextOfs));
                    continue;
                }
                ofs = nextOfs;
            } while (ofs < endOfs && ctrlHeaderCopied < ctrlSize);
            if (ctrlHeaderCopied != ctrlSize) {
                logger.warn("Control buffer size inconsistent.\n");
                for (int i2 = ctrlHeaderCopied; i2 < ctrlSize; ++i2) {
                    ctrlHeader[i2] = -1;
                }
            }
            if (rleBufferFound != rleSize) {
                logger.warn("RLE buffer size inconsistent.\n");
            }
            pic.setRleSize(rleBufferFound);
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
        pic.setPal(new int[4]);
        pic.setAlpha(new int[4]);
        int alphaSum = 0;
        int[] alphaUpdate = new int[4];
        int delay = -1;
        boolean ColAlphaUpdate = false;
        logger.trace("SP_DCSQT at ofs: " + ToolBox.toHexLeftZeroPadded(ctrlOfs, 8) + "\n");
        try {
            int index = 0;
            int endSeqOfs = ByteUtils.getWord(ctrlHeader, index) - ctrlOfsRel - 2;
            if (endSeqOfs < 0 || endSeqOfs > ctrlSize) {
                logger.warn("Invalid end sequence offset -> no end time\n");
                endSeqOfs = ctrlSize;
            }
            index += 2;
            block19: while (index < endSeqOfs) {
                int cmd = ByteUtils.getByte(ctrlHeader, index++);
                switch (cmd) {
                    case 0: {
                        pic.setForced(true);
                        ++this.forcedFrameCount;
                        continue block19;
                    }
                    case 1: {
                        continue block19;
                    }
                    case 3: {
                        int b = ByteUtils.getByte(ctrlHeader, index++);
                        pic.getPal()[3] = b >> 4;
                        pic.getPal()[2] = b & 0xF;
                        b = ByteUtils.getByte(ctrlHeader, index++);
                        pic.getPal()[1] = b >> 4;
                        pic.getPal()[0] = b & 0xF;
                        logger.trace("Palette:   " + pic.getPal()[0] + ", " + pic.getPal()[1] + ", " + pic.getPal()[2] + ", " + pic.getPal()[3] + "\n");
                        continue block19;
                    }
                    case 4: {
                        int b = ByteUtils.getByte(ctrlHeader, index++);
                        pic.getAlpha()[3] = b >> 4;
                        pic.getAlpha()[2] = b & 0xF;
                        b = ByteUtils.getByte(ctrlHeader, index++);
                        pic.getAlpha()[1] = b >> 4;
                        pic.getAlpha()[0] = b & 0xF;
                        for (i = 0; i < 4; ++i) {
                            alphaSum += pic.getAlpha()[i] & 0xFF;
                        }
                        logger.trace("Alpha:     " + pic.getAlpha()[0] + ", " + pic.getAlpha()[1] + ", " + pic.getAlpha()[2] + ", " + pic.getAlpha()[3] + "\n");
                        continue block19;
                    }
                    case 5: {
                        int xOfs = ByteUtils.getByte(ctrlHeader, index) << 4 | ByteUtils.getByte(ctrlHeader, index + 1) >> 4;
                        pic.setOfsX(this.globalXOffset + xOfs);
                        pic.setImageWidth(((ByteUtils.getByte(ctrlHeader, index + 1) & 0xF) << 8 | ByteUtils.getByte(ctrlHeader, index + 2)) - xOfs + 1);
                        int yOfs = ByteUtils.getByte(ctrlHeader, index + 3) << 4 | ByteUtils.getByte(ctrlHeader, index + 4) >> 4;
                        pic.setOfsY(this.globalYOffset + yOfs);
                        pic.setImageHeight(((ByteUtils.getByte(ctrlHeader, index + 4) & 0xF) << 8 | ByteUtils.getByte(ctrlHeader, index + 5)) - yOfs + 1);
                        logger.trace("Area info: (" + pic.getXOffset() + ", " + pic.getYOffset() + ") - (" + (pic.getXOffset() + pic.getImageWidth() - 1) + ", " + (pic.getYOffset() + pic.getImageHeight() - 1) + ")\n");
                        index += 6;
                        continue block19;
                    }
                    case 6: {
                        pic.setEvenOffset(ByteUtils.getWord(ctrlHeader, index) - 4);
                        pic.setOddOffset(ByteUtils.getWord(ctrlHeader, index + 2) - 4);
                        index += 4;
                        logger.trace("RLE ofs:   " + ToolBox.toHexLeftZeroPadded(pic.getEvenOffset(), 4) + ", " + ToolBox.toHexLeftZeroPadded(pic.getOddOffset(), 4) + "\n");
                        continue block19;
                    }
                    case 7: {
                        ColAlphaUpdate = true;
                        int alphaUpdateSum = 0;
                        int b = ByteUtils.getByte(ctrlHeader, index + 10);
                        alphaUpdate[3] = b >> 4;
                        alphaUpdate[2] = b & 0xF;
                        b = ByteUtils.getByte(ctrlHeader, index + 11);
                        alphaUpdate[1] = b >> 4;
                        alphaUpdate[0] = b & 0xF;
                        for (int i3 = 0; i3 < 4; ++i3) {
                            alphaUpdateSum += alphaUpdate[i3] & 0xFF;
                        }
                        if (alphaUpdateSum > alphaSum) {
                            alphaSum = alphaUpdateSum;
                            System.arraycopy(alphaUpdate, 0, pic.getAlpha(), 0, 4);
                            b = ByteUtils.getByte(ctrlHeader, index + 8);
                            pic.getPal()[3] = b >> 4;
                            pic.getPal()[2] = b & 0xF;
                            b = ByteUtils.getByte(ctrlHeader, index + 9);
                            pic.getPal()[1] = b >> 4;
                            pic.getPal()[0] = b & 0xF;
                        }
                        index = endSeqOfs;
                        delay = ByteUtils.getWord(ctrlHeader, index) * 1024;
                        endSeqOfs = ByteUtils.getWord(ctrlHeader, index + 2) - ctrlOfsRel - 2;
                        if (endSeqOfs < 0 || endSeqOfs > ctrlSize) {
                            logger.warn("Invalid end sequence offset -> no end time\n");
                            endSeqOfs = ctrlSize;
                        }
                        index += 4;
                        continue block19;
                    }
                    case 255: {
                        break block19;
                    }
                    default: {
                        logger.warn("Unknown control sequence " + ToolBox.toHexLeftZeroPadded(cmd, 2) + " skipped\n");
                        continue block19;
                    }
                }
            }
            if (endSeqOfs != ctrlSize) {
                int ctrlSeqCount = 1;
                index = -1;
                int nextIndex = endSeqOfs;
                while (nextIndex != index) {
                    index = nextIndex;
                    delay = ByteUtils.getWord(ctrlHeader, index) * 1024;
                    nextIndex = ByteUtils.getWord(ctrlHeader, index + 2) - ctrlOfsRel - 2;
                    ++ctrlSeqCount;
                }
                if (ctrlSeqCount > 2) {
                    logger.warn("Control sequence(s) ignored - result may be erratic.");
                }
                pic.setEndTime(pic.getStartTime() + (long)delay);
            } else {
                pic.setEndTime(pic.getStartTime());
            }
            if (ColAlphaUpdate) {
                logger.warn("Palette update/alpha fading detected - result may be erratic.\n");
            }
            if (alphaSum == 0) {
                if (configuration.getFixZeroAlpha()) {
                    System.arraycopy(lastAlpha, 0, pic.getAlpha(), 0, 4);
                    logger.warn("Invisible caption due to zero alpha - used alpha info of last caption.\n");
                } else {
                    logger.warn("Invisible caption due to zero alpha (not fixed due to user setting).\n");
                }
            }
            lastAlpha = pic.getAlpha();
            pic.storeOriginal();
        }
        catch (IndexOutOfBoundsException ex) {
            throw new CoreException("Index " + ex.getMessage() + " out of bounds in control header.");
        }
    }

    public void decode(int index) throws CoreException {
        if (index >= this.subPictures.size()) {
            throw new CoreException("Index " + index + " out of bounds\n");
        }
        this.decode(this.subPictures.get(index));
    }

    private void decode(SubPictureDVD pic) throws CoreException {
        this.palette = SupDvdUtil.decodePalette(pic, this.srcPalette);
        this.bitmap = SupDvdUtil.decodeImage(pic, this.buffer, this.palette.getIndexOfMostTransparentPaletteEntry());
        BitmapBounds bounds = this.bitmap.getCroppingBounds(this.palette.getAlpha(), configuration.getAlphaCrop());
        if (bounds.yMin > 0 || bounds.xMin > 0 || bounds.xMax < this.bitmap.getWidth() - 1 || bounds.yMax < this.bitmap.getHeight() - 1) {
            int w = bounds.xMax - bounds.xMin + 1;
            int h = bounds.yMax - bounds.yMin + 1;
            if (w < 2) {
                w = 2;
            }
            if (h < 2) {
                h = 2;
            }
            this.bitmap = this.bitmap.crop(bounds.xMin, bounds.yMin, w, h);
            pic.setImageWidth(w);
            pic.setImageHeight(h);
            pic.setOfsX(pic.getOriginalX() + bounds.xMin);
            pic.setOfsY(pic.getOriginalY() + bounds.yMin);
        }
        this.primaryColorIndex = this.bitmap.getPrimaryColorIndex(this.palette.getAlpha(), configuration.getAlphaThreshold(), this.palette.getY());
    }

    public int[] getFramePalette(int index) {
        return this.subPictures.get(index).getPal();
    }

    public int[] getOriginalFramePalette(int index) {
        return this.subPictures.get(index).getOriginalPal();
    }

    public int[] getFrameAlpha(int index) {
        return this.subPictures.get(index).getAlpha();
    }

    public int[] getOriginalFrameAlpha(int index) {
        return this.subPictures.get(index).getOriginalAlpha();
    }

    public BufferedImage getImage(Bitmap bm) {
        return bm.getImage(this.palette.getColorModel());
    }

    public Palette getPalette() {
        return this.palette;
    }

    public Bitmap getBitmap() {
        return this.bitmap;
    }

    public BufferedImage getImage() {
        return this.bitmap.getImage(this.palette.getColorModel());
    }

    public int getPrimaryColorIndex() {
        return this.primaryColorIndex;
    }

    public SubPicture getSubPicture(int index) {
        return this.subPictures.get(index);
    }

    public int getFrameCount() {
        return this.subPictures.size();
    }

    public int getForcedFrameCount() {
        return this.forcedFrameCount;
    }

    public boolean isForced(int index) {
        return this.subPictures.get(index).isForced();
    }

    public void close() {
        if (this.buffer != null) {
            this.buffer.close();
        }
    }

    public long getEndTime(int index) {
        return this.subPictures.get(index).getEndTime();
    }

    public long getStartTime(int index) {
        return this.subPictures.get(index).getStartTime();
    }

    public long getStartOffset(int index) {
        return this.subPictures.get(index).getOffset();
    }

    public int getLanguageIndex() {
        return this.languageIndex;
    }

    public Palette getSrcPalette() {
        return this.srcPalette;
    }

    public void setSrcPalette(Palette pal) {
        this.srcPalette = pal;
    }
}

