/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.supstream.hd;

import bdsup2sub.bitmap.Bitmap;
import bdsup2sub.bitmap.Palette;
import bdsup2sub.core.Configuration;
import bdsup2sub.core.Core;
import bdsup2sub.core.CoreException;
import bdsup2sub.core.Logger;
import bdsup2sub.supstream.SubPicture;
import bdsup2sub.supstream.SubtitleStream;
import bdsup2sub.supstream.hd.SubPictureHD;
import bdsup2sub.tools.BitStream;
import bdsup2sub.tools.FileBuffer;
import bdsup2sub.tools.FileBufferException;
import bdsup2sub.utils.TimeUtils;
import bdsup2sub.utils.ToolBox;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class SupHD
implements SubtitleStream {
    private static final Configuration configuration = Configuration.getInstance();
    private static final Logger logger = Logger.getInstance();
    private ArrayList<SubPictureHD> subPictures = new ArrayList();
    private Palette palette;
    private Bitmap bitmap;
    private FileBuffer buffer;
    private int primaryColorIndex;

    public SupHD(String supFile) throws CoreException {
        try {
            this.buffer = new FileBuffer(supFile);
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
        int bufsize = (int)this.buffer.getSize();
        int index = 0;
        try {
            while (index < bufsize) {
                if (Core.isCanceled()) {
                    throw new CoreException("Canceled by user!");
                }
                Core.setProgress(index);
                if (this.buffer.getWord(index) != 21328) {
                    throw new CoreException("ID 'SP' missing at index " + ToolBox.toHexLeftZeroPadded(index, 8) + "\n");
                }
                int masterIndex = index + 10;
                SubPictureHD pic = new SubPictureHD();
                pic.setWidth(1920);
                pic.setHeight(1080);
                logger.info("#" + (this.subPictures.size() + 1) + "\n");
                pic.setStartTime(this.buffer.getDWordLE(index += 2));
                int packetSize = this.buffer.getDWord(index += 10);
                int ofsCmd = this.buffer.getDWord(index += 4) + masterIndex;
                pic.setImageBufferSize(ofsCmd - (index + 4));
                index = ofsCmd;
                int dcsq = this.buffer.getWord(index);
                pic.setStartTime(pic.getStartTime() + (long)(dcsq * 1024));
                logger.info("DCSQ start    ofs: " + ToolBox.toHexLeftZeroPadded(index, 8) + "  (" + TimeUtils.ptsToTimeStr(pic.getStartTime()) + ")\n");
                int nextIndex = this.buffer.getDWord(index += 2) + masterIndex;
                index += 5;
                boolean stopDisplay = false;
                boolean stopCommand = false;
                int minAlphaSum = 65536;
                block15: while (!stopDisplay) {
                    int cmd = this.buffer.getByte(index++);
                    switch (cmd) {
                        case 1: {
                            logger.info("DCSQ start    ofs: " + ToolBox.toHexLeftZeroPadded(index, 8) + "  (" + TimeUtils.ptsToTimeStr(pic.getStartTime() + (long)(dcsq * 1024)) + ")\n");
                            logger.warn("DCSQ start ignored due to missing DCSQ stop\n");
                            continue block15;
                        }
                        case 2: {
                            stopDisplay = true;
                            pic.setEndTime(pic.getStartTime() + (long)(dcsq * 1024));
                            logger.info("DCSQ stop     ofs: " + ToolBox.toHexLeftZeroPadded(index, 8) + "  (" + TimeUtils.ptsToTimeStr(pic.getEndTime()) + ")\n");
                            continue block15;
                        }
                        case 131: {
                            logger.trace("Palette info  ofs: " + ToolBox.toHexLeftZeroPadded(index, 8) + "\n");
                            pic.setPaletteOffset(index);
                            index += 768;
                            continue block15;
                        }
                        case 132: {
                            logger.trace("Alpha info    ofs: " + ToolBox.toHexLeftZeroPadded(index, 8) + "\n");
                            int alphaSum = 0;
                            for (int i = index; i < index + 256; ++i) {
                                alphaSum += this.buffer.getByte(i);
                            }
                            if (alphaSum < minAlphaSum) {
                                pic.setAlphaOffset(index);
                                minAlphaSum = alphaSum;
                            } else {
                                logger.warn("Found faded alpha buffer -> alpha buffer skipped\n");
                            }
                            index += 256;
                            continue block15;
                        }
                        case 133: {
                            pic.setOfsX(this.buffer.getByte(index) << 4 | this.buffer.getByte(index + 1) >> 4);
                            pic.setImageWidth(((this.buffer.getByte(index + 1) & 0xF) << 8 | this.buffer.getByte(index + 2)) - pic.getXOffset() + 1);
                            pic.setOfsY(this.buffer.getByte(index + 3) << 4 | this.buffer.getByte(index + 4) >> 4);
                            pic.setImageHeight(((this.buffer.getByte(index + 4) & 0xF) << 8 | this.buffer.getByte(index + 5)) - pic.getYOffset() + 1);
                            logger.trace("Area info     ofs: " + ToolBox.toHexLeftZeroPadded(index, 8) + "  (" + pic.getXOffset() + ", " + pic.getYOffset() + ") - (" + (pic.getXOffset() + pic.getImageWidth()) + ", " + (pic.getYOffset() + pic.getImageHeight()) + ")\n");
                            index += 6;
                            continue block15;
                        }
                        case 134: {
                            pic.setImageBufferOffsetEven(this.buffer.getDWord(index) + masterIndex);
                            pic.setImageBufferOffsetOdd(this.buffer.getDWord(index + 4) + masterIndex);
                            logger.trace("RLE buffers   ofs: " + ToolBox.toHexLeftZeroPadded(index, 8) + "  (even: " + ToolBox.toHexLeftZeroPadded(pic.getImageBufferOffsetEven(), 8) + ", odd: " + ToolBox.toHexLeftZeroPadded(pic.getImageBufferOffsetOdd(), 8) + "\n");
                            index += 8;
                            continue block15;
                        }
                        case 255: {
                            int d;
                            if (stopCommand) {
                                logger.warn("DCSQ stop missing.\n");
                                ++index;
                                while (index < bufsize) {
                                    if (this.buffer.getByte(index++) != 255) {
                                        --index;
                                        break;
                                    }
                                    ++index;
                                }
                                stopDisplay = true;
                                continue block15;
                            }
                            index = nextIndex;
                            dcsq = d = this.buffer.getWord(index);
                            nextIndex = this.buffer.getDWord(index + 2) + masterIndex;
                            stopCommand = index == nextIndex;
                            logger.trace("DCSQ          ofs: " + ToolBox.toHexLeftZeroPadded(index, 8) + "  (" + d * 1024 / 90 + "ms),    next DCSQ at ofs: " + ToolBox.toHexLeftZeroPadded(nextIndex, 8) + "\n");
                            index += 6;
                            continue block15;
                        }
                    }
                    throw new CoreException("Unexpected command " + cmd + " at index " + ToolBox.toHexLeftZeroPadded(index, 8));
                }
                index = masterIndex + packetSize;
                this.subPictures.add(pic);
            }
        }
        catch (CoreException ex) {
            if (this.subPictures.size() == 0) {
                throw ex;
            }
            logger.error(ex.getMessage() + "\n");
            logger.trace("Probably not all caption imported due to error.\n");
        }
        catch (FileBufferException ex) {
            if (this.subPictures.size() == 0) {
                throw new CoreException(ex.getMessage());
            }
            logger.error(ex.getMessage() + "\n");
            logger.trace("Probably not all caption imported due to error.\n");
        }
    }

    public void close() {
        if (this.buffer != null) {
            this.buffer.close();
        }
    }

    private static void decodeLine(byte[] trg, int trgOfs, int width, int maxPixels, BitStream src) {
        int x = 0;
        int sumPixels = 0;
        boolean lf = false;
        while (src.bitsLeft() > 0 && sumPixels < maxPixels) {
            int i;
            int pixelsLeft;
            int numPixels;
            int rleType = src.readBits(1);
            int colorType = src.readBits(1);
            int color = colorType == 1 ? src.readBits(8) : src.readBits(2);
            if (rleType == 1) {
                int rleSize = src.readBits(1);
                if (rleSize == 1) {
                    numPixels = src.readBits(7) + 9;
                    if (numPixels == 9) {
                        numPixels = width - x;
                    }
                } else {
                    numPixels = src.readBits(3) + 2;
                }
            } else {
                numPixels = 1;
            }
            if (x + numPixels == width) {
                src.syncToByte();
                lf = true;
            }
            sumPixels += numPixels;
            if (x + numPixels > width) {
                pixelsLeft = x + numPixels - width;
                numPixels = width - x;
                lf = true;
            } else {
                pixelsLeft = 0;
            }
            for (i = 0; i < numPixels; ++i) {
                trg[trgOfs + x + i] = (byte)color;
            }
            if (lf) {
                trgOfs += x + numPixels + width;
                x = pixelsLeft;
                lf = false;
            } else {
                x += numPixels;
            }
            for (i = 0; i < pixelsLeft; ++i) {
                trg[trgOfs + i] = (byte)color;
            }
        }
    }

    private Bitmap decodeImage(SubPictureHD pic, int transIdx) throws CoreException {
        int w = pic.getImageWidth();
        int h = pic.getImageHeight();
        int warnings = 0;
        if (w > pic.getWidth() || h > pic.getHeight()) {
            throw new CoreException("Subpicture too large: " + w + "x" + h + " at offset " + ToolBox.toHexLeftZeroPadded(pic.getImageBufferOffsetEven(), 8));
        }
        Bitmap bm = new Bitmap(w, h, (byte)transIdx);
        int sizeEven = pic.getImageBufferOffsetOdd() - pic.getImageBufferOffsetEven();
        int sizeOdd = pic.getImageBufferSize() + pic.getImageBufferOffsetEven() - pic.getImageBufferOffsetOdd();
        if (sizeEven <= 0 || sizeOdd <= 0) {
            throw new CoreException("Corrupt buffer offset information");
        }
        byte[] evenBuf = new byte[sizeEven];
        byte[] oddBuf = new byte[sizeOdd];
        try {
            int i;
            try {
                for (i = 0; i < evenBuf.length; ++i) {
                    evenBuf[i] = (byte)this.buffer.getByte(pic.getImageBufferOffsetEven() + i);
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ++warnings;
            }
            try {
                for (i = 0; i < oddBuf.length; ++i) {
                    oddBuf[i] = (byte)this.buffer.getByte(pic.getImageBufferOffsetOdd() + i);
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ++warnings;
            }
            try {
                BitStream even = new BitStream(evenBuf);
                SupHD.decodeLine(bm.getInternalBuffer(), 0, w, w * (h / 2 + (h & 1)), even);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ++warnings;
            }
            try {
                BitStream odd = new BitStream(oddBuf);
                SupHD.decodeLine(bm.getInternalBuffer(), w, w, h / 2 * w, odd);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ++warnings;
            }
            if (warnings > 0) {
                logger.warn("problems during RLE decoding of picture at offset " + ToolBox.toHexLeftZeroPadded(pic.getImageBufferOffsetEven(), 8) + "\n");
            }
            return bm;
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
    }

    private Palette decodePalette(SubPictureHD pic) throws CoreException {
        int ofs = pic.getPaletteOffset();
        int alphaOfs = pic.getAlphaOffset();
        Palette palette = new Palette(256);
        try {
            for (int i = 0; i < palette.getSize(); ++i) {
                int cr;
                int cb;
                int y = this.buffer.getByte(ofs++);
                if (configuration.isSwapCrCb()) {
                    cb = this.buffer.getByte(ofs++);
                    cr = this.buffer.getByte(ofs++);
                } else {
                    cr = this.buffer.getByte(ofs++);
                    cb = this.buffer.getByte(ofs++);
                }
                int alpha = 255 - this.buffer.getByte(alphaOfs++);
                if (alpha < configuration.getAlphaCrop()) {
                    palette.setRGB(i, 0, 0, 0);
                } else {
                    palette.setYCbCr(i, y, cb, cr);
                }
                palette.setAlpha(i, alpha);
            }
            return palette;
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
    }

    private void decode(SubPictureHD pic) throws CoreException {
        this.palette = this.decodePalette(pic);
        this.bitmap = this.decodeImage(pic, this.palette.getIndexOfMostTransparentPaletteEntry());
        this.primaryColorIndex = this.bitmap.getPrimaryColorIndex(this.palette.getAlpha(), configuration.getAlphaThreshold(), this.palette.getY());
    }

    public void decode(int index) throws CoreException {
        if (index >= this.subPictures.size()) {
            throw new CoreException("Index " + index + " out of bounds\n");
        }
        this.decode(this.subPictures.get(index));
    }

    public Palette getPalette() {
        return this.palette;
    }

    public Bitmap getBitmap() {
        return this.bitmap;
    }

    public BufferedImage getImage() {
        return this.bitmap.getImage(this.palette.getColorModel());
    }

    public BufferedImage getImage(Bitmap bm) {
        return bm.getImage(this.palette.getColorModel());
    }

    public int getPrimaryColorIndex() {
        return this.primaryColorIndex;
    }

    public SubPicture getSubPicture(int index) {
        return this.subPictures.get(index);
    }

    public int getFrameCount() {
        return this.subPictures.size();
    }

    public int getForcedFrameCount() {
        return 0;
    }

    public boolean isForced(int index) {
        return false;
    }

    public long getEndTime(int index) {
        return this.subPictures.get(index).getEndTime();
    }

    public long getStartTime(int index) {
        return this.subPictures.get(index).getStartTime();
    }

    public long getStartOffset(int index) {
        return this.subPictures.get(index).getImageBufferOffsetEven();
    }
}

