/*
 * Decompiled with CFR 0.152.
 */
package bdsup2sub.tools;

import bdsup2sub.tools.OctTreeQuantizer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class QuantizeFilter {
    private static final int[] FS_MATRIX = new int[]{0, 0, 0, 0, 0, 7, 3, 5, 1};
    private static final int SUM = 16;
    private boolean dither;
    private int numColors = 255;
    private boolean serpentine = true;

    public void setNumColors(int numColors) {
        this.numColors = Math.min(Math.max(numColors, 8), 256);
    }

    private static int clamp(int c) {
        if (c < 0) {
            return 0;
        }
        if (c > 255) {
            return 255;
        }
        return c;
    }

    public int getNumColors() {
        return this.numColors;
    }

    public void setDither(boolean dither) {
        this.dither = dither;
    }

    public boolean getDither() {
        return this.dither;
    }

    public void setSerpentine(boolean serpentine) {
        this.serpentine = serpentine;
    }

    public boolean getSerpentine() {
        return this.serpentine;
    }

    public int[] quantize(int[] inPixels, byte[] outPixels, int width, int height, int numColors, boolean dither, boolean serpentine) {
        int count = width * height;
        OctTreeQuantizer quantizer = new OctTreeQuantizer();
        quantizer.setup(numColors);
        quantizer.addPixels(inPixels, 0, count);
        int[] table = quantizer.buildColorTable();
        if (dither) {
            for (int y = 0; y < height; ++y) {
                int direction;
                int index;
                boolean reverse;
                boolean bl = reverse = serpentine && (y & 1) == 1;
                if (reverse) {
                    index = y * width + width - 1;
                    direction = -1;
                } else {
                    index = y * width;
                    direction = 1;
                }
                for (int x = 0; x < width; ++x) {
                    int rgb1 = inPixels[index];
                    int idx = quantizer.getIndexForColor(rgb1);
                    int rgb2 = table[idx];
                    outPixels[index] = (byte)(idx & 0xFF);
                    int a1 = rgb1 >> 24 & 0xFF;
                    int r1 = rgb1 >> 16 & 0xFF;
                    int g1 = rgb1 >> 8 & 0xFF;
                    int b1 = rgb1 & 0xFF;
                    int a2 = rgb2 >> 24 & 0xFF;
                    int r2 = rgb2 >> 16 & 0xFF;
                    int g2 = rgb2 >> 8 & 0xFF;
                    int b2 = rgb2 & 0xFF;
                    int ea = a1 - a2;
                    int er = r1 - r2;
                    int eg = g1 - g2;
                    int eb = b1 - b2;
                    for (int i = -1; i <= 1; ++i) {
                        int iy = i + y;
                        if (0 > iy || iy >= height) continue;
                        for (int j = -1; j <= 1; ++j) {
                            int w;
                            int jx = j + x;
                            if (0 > jx || jx >= width || (w = reverse ? FS_MATRIX[(i + 1) * 3 - j + 1] : FS_MATRIX[(i + 1) * 3 + j + 1]) == 0) continue;
                            int k = reverse ? index - j : index + j;
                            rgb1 = inPixels[k];
                            a1 = rgb1 >> 24 & 0xFF;
                            r1 = rgb1 >> 16 & 0xFF;
                            g1 = rgb1 >> 8 & 0xFF;
                            b1 = rgb1 & 0xFF;
                            inPixels[k] = QuantizeFilter.clamp(a1 += ea * w / 16) << 24 | QuantizeFilter.clamp(r1 += er * w / 16) << 16 | QuantizeFilter.clamp(g1 += eg * w / 16) << 8 | QuantizeFilter.clamp(b1 += eb * w / 16);
                        }
                    }
                    index += direction;
                }
            }
        }
        HashMap<Integer, Integer> p = new HashMap<Integer, Integer>();
        for (int i = 0; i < count; ++i) {
            int color = dither ? table[outPixels[i] & 0xFF] : table[quantizer.getIndexForColor(inPixels[i])];
            int idx = p.size();
            Integer idxEx = (Integer)p.get(color);
            if (idxEx == null) {
                p.put(color, idx);
            } else {
                idx = idxEx;
            }
            outPixels[i] = (byte)idx;
        }
        Set keys = p.keySet();
        int[] pal = new int[p.size()];
        Iterator i$ = keys.iterator();
        while (i$.hasNext()) {
            int k;
            pal[((Integer)p.get((Object)Integer.valueOf((int)k))).intValue()] = k = ((Integer)i$.next()).intValue();
        }
        return pal;
    }
}

